/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.sql;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractUntypedSearchConditionVisitor;

public class SQLPrinterVisitor<T>
extends AbstractUntypedSearchConditionVisitor<T, String> {
    private String primaryTable;
    private String tableAlias;
    private List<String> columns;
    private StringBuilder topBuilder = new StringBuilder();
    private volatile boolean joinDone;

    public SQLPrinterVisitor() {
        this(null, null, Collections.emptyList());
    }

    public SQLPrinterVisitor(String table, String ... columns) {
        this(null, table, Arrays.asList(columns));
    }

    public SQLPrinterVisitor(Map<String, String> fieldMap, String table, List<String> columns) {
        this(fieldMap, table, null, columns);
    }

    public SQLPrinterVisitor(Map<String, String> fieldMap, String table, String tableAlias, List<String> columns) {
        super(fieldMap);
        this.columns = columns;
        this.primaryTable = table;
        this.tableAlias = tableAlias;
        this.prepareTopStringBuilder();
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        StringBuilder sb = this.getStringBuilder();
        PrimitiveStatement statement = sc.getStatement();
        if (statement != null) {
            if (statement.getProperty() != null) {
                String property = statement.getProperty();
                String[] properties = property.split("\\.");
                if (properties.length > 2) {
                    throw new SearchParseException("SQL Visitor supports only a single JOIN");
                }
                if (properties.length == 2) {
                    if (this.joinDone) {
                        throw new SearchParseException("SQL Visitor has already created JOIN");
                    }
                    this.joinDone = true;
                    String joinTable = this.getRealPropertyName(properties[0]);
                    String joiningKey = this.primaryTable;
                    if (joiningKey.endsWith("s")) {
                        joiningKey = joiningKey.substring(0, joiningKey.length() - 1);
                    }
                    joiningKey = joiningKey + "_id";
                    this.topBuilder.append(" left join " + joinTable);
                    this.topBuilder.append(" on " + this.primaryTable + ".id" + " = " + joinTable + "." + joiningKey);
                    property = joinTable + "." + this.getRealPropertyName(properties[1]);
                }
                String name = this.getRealPropertyName(property);
                String originalValue = this.getPropertyValue(name, statement.getValue());
                this.validatePropertyValue(name, originalValue);
                String value = SearchUtils.toSqlWildcardString(originalValue, this.isWildcardStringMatch());
                value = SearchUtils.duplicateSingleQuoteIfNeeded(value);
                if (this.tableAlias != null) {
                    name = this.tableAlias + "." + name;
                }
                sb.append(name).append(" ").append(SearchUtils.conditionTypeToSqlOperator(sc.getConditionType(), value, originalValue)).append(" ").append("'").append(value).append("'");
            }
        } else {
            boolean first = true;
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                if (!first) {
                    sb.append(" ").append(sc.getConditionType().toString()).append(" ");
                } else {
                    first = false;
                }
                sb.append("(");
                this.saveStringBuilder(sb);
                condition.accept(this);
                sb = this.getStringBuilder();
                sb.append(")");
            }
        }
        this.saveStringBuilder(sb);
    }

    @Override
    protected StringBuilder getStringBuilder() {
        StringBuilder sb = super.getStringBuilder();
        if (sb == null) {
            sb = new StringBuilder();
        }
        return sb;
    }

    @Override
    public String getQuery() {
        StringBuilder sb = this.removeStringBuilder();
        return sb == null ? null : this.topBuilder.toString() + " WHERE " + sb.toString();
    }

    private void prepareTopStringBuilder() {
        if (this.primaryTable != null) {
            SearchUtils.startSqlQuery(this.topBuilder, this.primaryTable, this.tableAlias, this.columns);
        }
    }
}

