/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import javax.ws.rs.core.Response;

public enum ClientExceptionType {
    AssociatedAnys(Response.Status.BAD_REQUEST),
    AssociatedResources(Response.Status.BAD_REQUEST),
    Composite(Response.Status.BAD_REQUEST),
    ConcurrentModification(Response.Status.PRECONDITION_FAILED),
    ConnectorException(Response.Status.BAD_REQUEST),
    DataIntegrityViolation(Response.Status.CONFLICT),
    EntityExists(Response.Status.CONFLICT),
    GenericPersistence(Response.Status.BAD_REQUEST),
    HasChildren(Response.Status.BAD_REQUEST),
    InvalidSecurityAnswer(Response.Status.BAD_REQUEST),
    InvalidEntity(Response.Status.BAD_REQUEST),
    InvalidLogger(Response.Status.BAD_REQUEST),
    InvalidConnInstance(Response.Status.BAD_REQUEST),
    InvalidConnIdConf(Response.Status.BAD_REQUEST),
    InvalidPolicy(Response.Status.BAD_REQUEST),
    InvalidConf(Response.Status.BAD_REQUEST),
    InvalidPath(Response.Status.BAD_REQUEST),
    InvalidProvision(Response.Status.BAD_REQUEST),
    InvalidOrgUnit(Response.Status.BAD_REQUEST),
    InvalidReport(Response.Status.BAD_REQUEST),
    InvalidReportExec(Response.Status.BAD_REQUEST),
    InvalidRelationship(Response.Status.BAD_REQUEST),
    InvalidRelationshipType(Response.Status.BAD_REQUEST),
    InvalidAnyType(Response.Status.BAD_REQUEST),
    InvalidAnyObject(Response.Status.BAD_REQUEST),
    InvalidGroup(Response.Status.BAD_REQUEST),
    InvalidSchemaDefinition(Response.Status.BAD_REQUEST),
    InvalidSearchExpression(Response.Status.BAD_REQUEST),
    InvalidPageOrSize(Response.Status.BAD_REQUEST),
    InvalidPropagationTaskExecReport(Response.Status.BAD_REQUEST),
    InvalidPlainSchema(Response.Status.BAD_REQUEST),
    InvalidDerSchema(Response.Status.BAD_REQUEST),
    InvalidVirSchema(Response.Status.BAD_REQUEST),
    InvalidMapping(Response.Status.BAD_REQUEST),
    InvalidMembership(Response.Status.BAD_REQUEST),
    InvalidRealm(Response.Status.BAD_REQUEST),
    InvalidDynRealm(Response.Status.BAD_REQUEST),
    InvalidRole(Response.Status.BAD_REQUEST),
    InvalidUser(Response.Status.BAD_REQUEST),
    InvalidExternalResource(Response.Status.BAD_REQUEST),
    InvalidPullTask(Response.Status.BAD_REQUEST),
    InvalidRequest(Response.Status.BAD_REQUEST),
    InvalidValues(Response.Status.BAD_REQUEST),
    NotFound(Response.Status.NOT_FOUND),
    RequiredValuesMissing(Response.Status.BAD_REQUEST),
    RESTValidation(Response.Status.BAD_REQUEST),
    GroupOwnership(Response.Status.BAD_REQUEST),
    InUseByNotifications(Response.Status.BAD_REQUEST),
    Scheduling(Response.Status.BAD_REQUEST),
    DelegatedAdministration(Response.Status.FORBIDDEN),
    Unknown(Response.Status.BAD_REQUEST),
    Workflow(Response.Status.BAD_REQUEST);

    private final Response.Status responseStatus;

    private ClientExceptionType(Response.Status responseStatus) {
        this.responseStatus = responseStatus;
    }

    public static ClientExceptionType fromHeaderValue(String exceptionTypeHeaderValue) {
        ClientExceptionType result = null;
        for (ClientExceptionType type : ClientExceptionType.values()) {
            if (!exceptionTypeHeaderValue.equals(type.name())) continue;
            result = type;
        }
        if (result == null) {
            throw new IllegalArgumentException("Unexpected header value: " + exceptionTypeHeaderValue);
        }
        return result;
    }

    public String getInfoHeaderValue(String value) {
        return (this.name() + ":" + value).replaceAll("(\\r|\\n)", " ");
    }

    public Response.Status getResponseStatus() {
        return this.responseStatus;
    }
}

