/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.self;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.self.WorkflowExportDefinition;
import org.apache.syncope.client.cli.commands.self.WorkflowExportDiagram;
import org.apache.syncope.client.cli.commands.self.WorkflowResultManager;

@Command(name="workflow")
public class WorkflowCommand
extends AbstractCommand {
    private final WorkflowResultManager workflowResultManager = new WorkflowResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(UserWorkflowOptions.HELP.getOptionName());
        }
        switch (UserWorkflowOptions.fromName(input.getOption())) {
            case EXPORT_DIAGRAM: {
                new WorkflowExportDiagram(input).export();
                break;
            }
            case EXPORT_DEFINITION: {
                new WorkflowExportDefinition(input).export();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.workflowResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.workflowResultManager.commandHelpMessage(this.getClass());
    }

    private static enum UserWorkflowOptions {
        HELP("--help"),
        EXPORT_DIAGRAM("--export-diagram"),
        EXPORT_DEFINITION("--export-definition");

        private final String optionName;

        private UserWorkflowOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static UserWorkflowOptions fromName(String name) {
            UserWorkflowOptions optionToReturn = HELP;
            for (UserWorkflowOptions option : UserWorkflowOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (UserWorkflowOptions value : UserWorkflowOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

