/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.policy;

import java.util.List;
import java.util.Map;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.common.lib.policy.AccountPolicyTO;
import org.apache.syncope.common.lib.policy.PasswordPolicyTO;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.policy.PullPolicyTO;
import org.apache.syncope.common.lib.types.PolicyType;

public class PolicyResultManager
extends CommonsResultManager {
    public void printPolicies(List<PolicyTO> policyTOs) {
        System.out.println("");
        for (PolicyTO policyTO : policyTOs) {
            if (policyTO instanceof AccountPolicyTO) {
                this.printAccountPolicy((AccountPolicyTO)policyTO);
                continue;
            }
            if (policyTO instanceof PasswordPolicyTO) {
                this.printPasswordPolicy((PasswordPolicyTO)policyTO);
                continue;
            }
            if (!(policyTO instanceof PullPolicyTO)) continue;
            this.printPullPolicy((PullPolicyTO)policyTO);
        }
    }

    public void printPoliciesByType(String policyTypeString, List<PolicyTO> policyTOs) {
        System.out.println("");
        PolicyType policyType = PolicyType.valueOf((String)policyTypeString);
        switch (policyType) {
            case ACCOUNT: {
                for (PolicyTO policyTO : policyTOs) {
                    this.printAccountPolicy((AccountPolicyTO)policyTO);
                }
                break;
            }
            case PASSWORD: {
                for (PolicyTO policyTO : policyTOs) {
                    this.printPasswordPolicy((PasswordPolicyTO)policyTO);
                }
                break;
            }
            case PUSH: {
                for (PolicyTO policyTO : policyTOs) {
                    System.out.println(policyTO);
                }
                break;
            }
            case PULL: {
                for (PolicyTO policyTO : policyTOs) {
                    this.printPullPolicy((PullPolicyTO)policyTO);
                }
                break;
            }
        }
    }

    public void printAccountPolicy(AccountPolicyTO policyTO) {
        System.out.println(" > KEY: " + policyTO.getKey());
        System.out.println("    type: " + policyTO.getClass().getSimpleName());
        System.out.println("    description: " + policyTO.getDescription());
        System.out.println("    resources : " + policyTO.getUsedByResources().toString());
        System.out.println("    realms : " + policyTO.getUsedByRealms().toString());
        System.out.println("    max authentication attempts : " + policyTO.getMaxAuthenticationAttempts());
        System.out.println("    propagation suspension : " + policyTO.isPropagateSuspension());
        System.out.println("    RULES : ");
        System.out.println("       > class : " + policyTO.getRuleConfs());
        System.out.println("");
    }

    public void printPasswordPolicy(PasswordPolicyTO policyTO) {
        System.out.println(" > KEY: " + policyTO.getKey());
        System.out.println("    type: " + policyTO.getClass().getSimpleName());
        System.out.println("    description: " + policyTO.getDescription());
        System.out.println("    resources : " + policyTO.getUsedByResources().toString());
        System.out.println("    realms : " + policyTO.getUsedByRealms().toString());
        System.out.println("    history lenght : " + policyTO.getHistoryLength());
        System.out.println("    allow null password : " + policyTO.isAllowNullPassword());
        System.out.println("    RULES : ");
        System.out.println("       > class : " + policyTO.getRuleConfs());
        System.out.println("");
    }

    public void printPullPolicy(PullPolicyTO policyTO) {
        System.out.println(" > KEY: " + policyTO.getKey());
        System.out.println("    type: " + policyTO.getClass().getSimpleName());
        System.out.println("    description: " + policyTO.getDescription());
        System.out.println("    resources : " + policyTO.getUsedByResources().toString());
        System.out.println("    realms : " + policyTO.getUsedByRealms().toString());
        if (policyTO.getSpecification() != null) {
            System.out.println("    conflict resolution action: " + policyTO.getSpecification().getConflictResolutionAction().name());
            System.out.println("    correlation rule : " + policyTO.getSpecification().getCorrelationRules().toString());
        }
        System.out.println("");
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("policies details", details);
    }
}

