/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.group;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.group.AbstractGroupCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupReadAttributeBySchemaTypeAndSchemaKey
extends AbstractGroupCommand {
    private static final Logger LOG = LoggerFactory.getLogger(GroupReadAttributeBySchemaTypeAndSchemaKey.class);
    private static final String READ_HELP_MESSAGE = "group --read-attr-by-schema {GROUP-KEY} {SCHEMA-TYPE} {SCHEMA-KEY}\n   Schema type: PLAIN / DERIVED / VIRTUAL";
    private final Input input;

    public GroupReadAttributeBySchemaTypeAndSchemaKey(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.parameterNumber() == 3) {
            try {
                this.groupResultManager.printAttribute(this.groupSyncopeOperations.readAttribute(this.input.firstParameter(), this.input.secondParameter(), this.input.thirdParameter()));
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading group", (Throwable)ex);
                this.groupResultManager.genericError(ex.getMessage());
            }
            catch (NumberFormatException ex) {
                this.groupResultManager.numberFormatException("group", this.input.firstParameter());
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Error reading schema", (Throwable)ex);
                this.groupResultManager.typeNotValidError("schema", this.input.secondParameter(), CommandUtils.fromEnumToArray(SchemaType.class));
            }
        } else {
            this.groupResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

