/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.connector;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.common.lib.to.ConnBundleTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.syncope.common.lib.types.ConnConfPropSchema;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;

public class ConnectorResultManager
extends CommonsResultManager {
    public void printConnectors(List<ConnInstanceTO> connInstanceTOs) {
        System.out.println("");
        for (ConnInstanceTO connInstanceTO : connInstanceTOs) {
            this.printConnector(connInstanceTO);
        }
    }

    public void printConnector(ConnInstanceTO connInstanceTO) {
        System.out.println(" > CONNECTOR KEY: " + connInstanceTO.getKey());
        System.out.println("    bundle name: " + connInstanceTO.getBundleName());
        System.out.println("    connector name: " + connInstanceTO.getConnectorName());
        System.out.println("    display name: " + connInstanceTO.getDisplayName());
        System.out.println("    location: " + connInstanceTO.getLocation());
        System.out.println("    version: " + connInstanceTO.getVersion());
        System.out.println("    timeout: " + connInstanceTO.getConnRequestTimeout());
        System.out.println("    CAPABILITIES:");
        this.printCapabilities(connInstanceTO.getCapabilities());
        System.out.println("    CONFIGURATION:");
        this.printConfiguration(connInstanceTO.getConf());
        System.out.println("    POOL CONFIGURATION:");
        this.printConfPool(connInstanceTO.getPoolConf());
        System.out.println("");
    }

    private void printCapabilities(Set<ConnectorCapability> capabilities) {
        for (ConnectorCapability capability : capabilities) {
            System.out.println("       - " + capability.name());
        }
    }

    private void printConfPool(ConnPoolConfTO connPoolConfTO) {
        System.out.println("       min idle: " + connPoolConfTO.getMinIdle());
        System.out.println("       min evictlable idle: " + connPoolConfTO.getMinEvictableIdleTimeMillis());
        System.out.println("       max idle: " + connPoolConfTO.getMaxIdle());
        System.out.println("       max objects: " + connPoolConfTO.getMaxObjects());
        System.out.println("       max wait: " + connPoolConfTO.getMaxWait());
    }

    public void printBundles(List<ConnBundleTO> connBundleTOs) {
        for (ConnBundleTO connBundleTO : connBundleTOs) {
            System.out.println(" > BUNDLE NAME: " + connBundleTO.getBundleName());
            System.out.println("    connector name: " + connBundleTO.getConnectorName());
            System.out.println("    display name: " + connBundleTO.getDisplayName());
            System.out.println("    location: " + connBundleTO.getLocation());
            System.out.println("    version: " + connBundleTO.getVersion());
        }
    }

    private void printConfPropSchema(List<ConnConfPropSchema> connConfPropSchemas) {
        for (ConnConfPropSchema connConfPropSchema : connConfPropSchemas) {
            System.out.println("       name: " + connConfPropSchema.getName());
            System.out.println("       display name: " + connConfPropSchema.getDisplayName());
            System.out.println("       help message: " + connConfPropSchema.getHelpMessage());
            System.out.println("       type: " + connConfPropSchema.getType());
            System.out.println("       order: " + connConfPropSchema.getOrder());
            System.out.println("       default value: " + connConfPropSchema.getDefaultValues().toString());
            System.out.println("");
        }
    }

    public void printConfigurationProperties(Collection<ConnConfProperty> connConfPropertys) {
        this.printConfiguration(connConfPropertys);
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("connectors details", details);
    }
}

