/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.BulkAction;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.rest.api.beans.TaskQuery;
import org.apache.syncope.common.rest.api.service.ExecutableService;

@Api(tags={"Tasks"}, authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
@Path(value="tasks")
public interface TaskService
extends ExecutableService {
    @GET
    @Path(value="{type}/{key}")
    @Produces(value={"application/json", "application/xml"})
    public <T extends TaskTO> T read(@NotNull @PathParam(value="type") TaskType var1, @NotNull @PathParam(value="key") String var2, @QueryParam(value="details") @DefaultValue(value="true") boolean var3);

    @GET
    @Path(value="{type}")
    @Produces(value={"application/json", "application/xml"})
    public <T extends TaskTO> PagedResult<T> list(@BeanParam TaskQuery var1);

    @ApiResponses(value={@ApiResponse(code=201, message="Task successfully created", responseHeaders={@ResponseHeader(name="X-Syncope-Key", response=String.class, description="UUID generated for the entity created"), @ResponseHeader(name="Location", response=String.class, description="URL of the entity created")})})
    @POST
    @Path(value="{type}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response create(@NotNull @PathParam(value="type") TaskType var1, @NotNull SchedTaskTO var2);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @PUT
    @Path(value="{type}/{key}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public void update(@NotNull @PathParam(value="type") TaskType var1, @NotNull SchedTaskTO var2);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{type}/{key}")
    @Produces(value={"application/json", "application/xml"})
    public void delete(@NotNull @PathParam(value="type") TaskType var1, @NotNull @PathParam(value="key") String var2);

    @POST
    @Path(value="bulk")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public BulkActionResult bulk(@NotNull BulkAction var1);
}

