/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.schema;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.schema.AbstractSchemaCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaList
extends AbstractSchemaCommand {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaList.class);
    private static final String LIST_HELP_MESSAGE = "schema --list {SCHEMA-TYPE}\n   Schema type: PLAIN / DERIVED / VIRTUAL";
    private final Input input;

    public SchemaList(Input input) {
        this.input = input;
    }

    public void list() {
        if (this.input.parameterNumber() == 1) {
            try {
                this.schemaResultManager.toView(this.input.firstParameter(), this.schemaSyncopeOperations.list(this.input.firstParameter()));
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error listing schema", (Throwable)ex);
                this.schemaResultManager.genericError(ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Error listing schema", (Throwable)ex);
                this.schemaResultManager.typeNotValidError("schema", this.input.firstParameter(), CommandUtils.fromEnumToArray(SchemaType.class));
            }
        } else {
            this.schemaResultManager.commandOptionError(LIST_HELP_MESSAGE);
        }
    }
}

