/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.resource;

import java.util.List;
import java.util.Map;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.MappingTO;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.to.ResourceTO;

public class ResourceResultManager
extends CommonsResultManager {
    public void printResources(List<ResourceTO> resourceTOs) {
        System.out.println("");
        for (ResourceTO resourceTO : resourceTOs) {
            this.printResource(resourceTO);
        }
    }

    private void printResource(ResourceTO resourceTO) {
        System.out.println(" > RESOURCE KEY: " + resourceTO.getKey());
        System.out.println("    connector dispaly name: " + resourceTO.getConnectorDisplayName());
        System.out.println("    connector key: " + resourceTO.getConnector());
        System.out.println("    account policy key: " + resourceTO.getAccountPolicy());
        System.out.println("    password policy key: " + resourceTO.getPasswordPolicy());
        System.out.println("    pull policy key: " + resourceTO.getPullPolicy());
        System.out.println("    propagation actions class: " + resourceTO.getPropagationActionsClassNames());
        System.out.println("    propagation priority: " + resourceTO.getPropagationPriority());
        System.out.println("    PROVISIONS:");
        this.printProvision(resourceTO.getProvisions());
        System.out.println("    create trace level: " + resourceTO.getCreateTraceLevel());
        System.out.println("    delete trace level: " + resourceTO.getDeleteTraceLevel());
        System.out.println("    update trace level: " + resourceTO.getUpdateTraceLevel());
        System.out.println("    pull trace level: " + resourceTO.getProvisioningTraceLevel());
        System.out.println("    enforce mandatory condition: " + resourceTO.isEnforceMandatoryCondition());
        System.out.println("    override capabilities: " + resourceTO.isOverrideCapabilities());
        System.out.println("    random password if not provided: " + resourceTO.isRandomPwdIfNotProvided());
        System.out.println("");
    }

    private void printProvision(List<ProvisionTO> provisionTOs) {
        for (ProvisionTO provisionTO : provisionTOs) {
            System.out.println("       provision key: " + provisionTO.getKey());
            System.out.println("       any type: " + provisionTO.getAnyType());
            System.out.println("       object class: " + provisionTO.getObjectClass());
            System.out.println("       sync token: " + provisionTO.getSyncToken());
            System.out.println("       virtual schema: " + provisionTO.getVirSchemas());
            System.out.println("       MAPPING: ");
            this.printMapping(provisionTO.getMapping());
        }
    }

    private void printMapping(MappingTO mappingTO) {
        System.out.println("          ConnObjectLink: " + mappingTO.getConnObjectLink());
        System.out.println("          MAPPING ITEM: ");
        this.printMappingItem(mappingTO.getItems());
    }

    private void printMappingItem(List<ItemTO> mappingItemTOs) {
        for (ItemTO mappingItemTO : mappingItemTOs) {
            System.out.println("             mapping key: " + mappingItemTO.getKey());
            System.out.println("             internal attribute name: " + mappingItemTO.getIntAttrName());
            System.out.println("             external attribute name: " + mappingItemTO.getExtAttrName());
            System.out.println("             mandatory condition: " + mappingItemTO.getMandatoryCondition());
            System.out.println("             JEXL propagation transformer: " + mappingItemTO.getPropagationJEXLTransformer());
            System.out.println("             JEXL pull transformer: " + mappingItemTO.getPullJEXLTransformer());
            System.out.println("             transformers classes: " + mappingItemTO.getTransformerClassNames());
            System.out.println("             purpose: " + mappingItemTO.getPurpose());
            System.out.println("             connector object key: " + mappingItemTO.isConnObjectKey());
            System.out.println("             password: " + mappingItemTO.isPassword());
            System.out.println("");
        }
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("resources details", details);
    }
}

