/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import java.util.List;
import java.util.Map;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.common.lib.report.AbstractReportletConf;
import org.apache.syncope.common.lib.report.UserReportletConf;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;

public class ReportResultManager
extends CommonsResultManager {
    public void printReports(List<ReportTO> reportTOs) {
        System.out.println("");
        for (ReportTO reportTO : reportTOs) {
            this.printReport(reportTO);
        }
    }

    private void printReport(ReportTO reportTO) {
        System.out.println(" > REPORT KEY: " + reportTO.getKey());
        System.out.println("    name: " + reportTO.getName());
        System.out.println("    cron expression: " + reportTO.getCronExpression());
        System.out.println("    latest execution status: " + reportTO.getLatestExecStatus());
        System.out.println("    start date: " + reportTO.getStart());
        System.out.println("    end date: " + reportTO.getEnd());
        System.out.println("    CONF:");
        for (AbstractReportletConf reportletConf : reportTO.getReportletConfs()) {
            this.printReportletConf(reportletConf);
        }
        System.out.println("    EXECUTIONS:");
        this.printReportExecutions(reportTO.getExecutions());
        System.out.println("");
    }

    private void printReportletConf(AbstractReportletConf reportletConf) {
        if (reportletConf instanceof UserReportletConf) {
            UserReportletConf userReportletConf = (UserReportletConf)reportletConf;
            System.out.println("       name: " + userReportletConf.getName());
            System.out.println("       features: " + userReportletConf.getFeatures());
            System.out.println("       plain attributes: " + userReportletConf.getPlainAttrs());
            System.out.println("       derived attributes: " + userReportletConf.getDerAttrs());
            System.out.println("       virtual attributes: " + userReportletConf.getVirAttrs());
            System.out.println("       matching condition: " + userReportletConf.getMatchingCond());
        }
    }

    public void printReportExecutions(List<ExecTO> reportExecTOs) {
        for (ExecTO reportExecTO : reportExecTOs) {
            System.out.println("       REPORT EXEC KEY: " + reportExecTO.getKey());
            System.out.println("       status: " + reportExecTO.getStatus());
            System.out.println("       message: " + reportExecTO.getMessage());
            System.out.println("       start date: " + reportExecTO.getStart());
            System.out.println("       end date: " + reportExecTO.getEnd());
            System.out.println("       report: " + reportExecTO.getRefDesc());
        }
    }

    public void printJobs(List<JobTO> jobTOs) {
        for (JobTO jobTO : jobTOs) {
            System.out.println("       REPORT: " + jobTO.getRefDesc());
            System.out.println("       start date: " + jobTO.getStart());
            System.out.println("       running: " + jobTO.isRunning());
            System.out.println("       scheduled: " + jobTO.isScheduled());
        }
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("reports details", details);
    }
}

