/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.help;

import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.help.HelpResultManager;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Help {
    private static final Logger LOG = LoggerFactory.getLogger(Help.class);
    private final HelpResultManager helpResultManager = new HelpResultManager();

    public void help() {
        StringBuilder generalHelpBuilder = new StringBuilder("General help\n");
        try {
            for (AbstractCommand command : CommandUtils.commands()) {
                generalHelpBuilder.append("Command: ").append(command.getClass().getAnnotation(Command.class).name()).append("\n").append(command.getHelpMessage()).append("\n").append(" \n");
            }
            this.helpResultManager.toView(generalHelpBuilder.toString());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            LOG.error("Error helping", (Throwable)e);
            this.helpResultManager.genericMessage(e.getMessage());
        }
    }
}

