/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.domain;

import java.util.Map;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.domain.AbstractDomainCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainDetails
extends AbstractDomainCommand {
    private static final Logger LOG = LoggerFactory.getLogger(DomainDetails.class);
    private static final String LIST_HELP_MESSAGE = "domain --details";
    private final Input input;

    public DomainDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedMap details = new LinkedMap();
                details.put("Total number", String.valueOf(this.domainSyncopeOperations.list().size()));
                this.domainResultManager.printDetails((Map<String, String>)details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about domain", (Throwable)ex);
                this.domainResultManager.genericError(ex.getMessage());
            }
        } else {
            this.domainResultManager.unnecessaryParameters(this.input.listParameters(), LIST_HELP_MESSAGE);
        }
    }
}

