/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.connector;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.connector.AbstractConnectorCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorDetails
extends AbstractConnectorCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorDetails.class);
    private static final String DETAILS_HELP_MESSAGE = "connector --details";
    private final Input input;

    public ConnectorDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedMap details = new LinkedMap();
                List<ConnInstanceTO> connInstanceTOs = this.connectorSyncopeOperations.list();
                int withCreateCapability = 0;
                int withDeleteCapability = 0;
                int withSearchCapability = 0;
                int withSyncCapability = 0;
                int withUpdateCapability = 0;
                for (ConnInstanceTO connInstanceTO : connInstanceTOs) {
                    if (connInstanceTO.getCapabilities().contains(ConnectorCapability.CREATE)) {
                        ++withCreateCapability;
                    }
                    if (connInstanceTO.getCapabilities().contains(ConnectorCapability.DELETE)) {
                        ++withDeleteCapability;
                    }
                    if (connInstanceTO.getCapabilities().contains(ConnectorCapability.SEARCH)) {
                        ++withSearchCapability;
                    }
                    if (connInstanceTO.getCapabilities().contains(ConnectorCapability.SYNC)) {
                        ++withSyncCapability;
                    }
                    if (!connInstanceTO.getCapabilities().contains(ConnectorCapability.UPDATE)) continue;
                    ++withUpdateCapability;
                }
                details.put("Total number", String.valueOf(connInstanceTOs.size()));
                details.put("With create capability", String.valueOf(withCreateCapability));
                details.put("With delete capability", String.valueOf(withDeleteCapability));
                details.put("With search capability", String.valueOf(withSearchCapability));
                details.put("With sync capability", String.valueOf(withSyncCapability));
                details.put("With update capability", String.valueOf(withUpdateCapability));
                details.put("Bundles number", String.valueOf(this.connectorSyncopeOperations.getBundles().size()));
                this.connectorResultManager.printDetails((Map<String, String>)details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about connector", (Throwable)ex);
                this.connectorResultManager.genericError(ex.getMessage());
            }
        } else {
            this.connectorResultManager.unnecessaryParameters(this.input.listParameters(), DETAILS_HELP_MESSAGE);
        }
    }
}

