/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.utilities;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.apache.maven.shared.invoker.PrintStreamLogger;
import org.apache.syncope.installer.utilities.FileSystemUtils;
import org.apache.syncope.installer.utilities.InstallLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

public class MavenUtils {
    private static final String MAVEN_HOME_PROPERTY = "maven.home";
    private final AbstractUIProcessHandler handler;

    public MavenUtils(String mavenHomeDirectory, AbstractUIProcessHandler handler) {
        if (System.getProperty(MAVEN_HOME_PROPERTY) == null || System.getProperty(MAVEN_HOME_PROPERTY).isEmpty()) {
            System.setProperty(MAVEN_HOME_PROPERTY, mavenHomeDirectory);
        }
        this.handler = handler;
    }

    public void archetypeGenerate(String archetypeVersion, String groupId, String artifactId, String secretKey, String anonymousKey, String jwsKey, String adminPassword, String installPath, File customSettingsFile) {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Collections.singletonList(archetypeVersion.contains("SNAPSHOT") ? "org.apache.maven.plugins:maven-archetype-plugin:2.4:generate" : "archetype:generate"));
        request.setBatchMode(true);
        Properties properties = this.archetypeProperties(archetypeVersion, groupId, artifactId, secretKey, anonymousKey, jwsKey, adminPassword);
        request.setProperties(properties);
        if (customSettingsFile != null && FileUtils.sizeOf(customSettingsFile) > 0L) {
            request.setUserSettingsFile(customSettingsFile);
        }
        this.logToHandler(request.getGoals(), properties);
        this.logToFile(request.getGoals(), properties);
        this.invoke(request, installPath);
    }

    private Properties archetypeProperties(String archetypeVersion, String groupId, String artifactId, String secretKey, String anonymousKey, String jwsKey, String adminPassword) {
        Properties properties = new Properties();
        properties.setProperty("archetypeGroupId", "org.apache.syncope");
        properties.setProperty("archetypeArtifactId", "syncope-archetype");
        properties.setProperty("archetypeRepository", archetypeVersion.contains("SNAPSHOT") ? "https://repository.apache.org/content/repositories/snapshots" : "https://repo1.maven.org/maven2");
        properties.setProperty("archetypeVersion", archetypeVersion);
        properties.setProperty("groupId", groupId);
        properties.setProperty("artifactId", artifactId);
        properties.setProperty("secretKey", secretKey);
        properties.setProperty("anonymousKey", anonymousKey);
        properties.setProperty("jwsKey", jwsKey);
        if (adminPassword != null) {
            try {
                MessageDigest cript = MessageDigest.getInstance("SHA-1");
                String encodedPassword = new String(Hex.encodeHex(cript.digest(adminPassword.getBytes(StandardCharsets.UTF_8))));
                properties.setProperty("adminPassword", encodedPassword);
            }
            catch (NoSuchAlgorithmException ex) {
                Logger.getLogger(MavenUtils.class.getName()).log(Level.SEVERE, "NoSuchAlgorithmException", ex);
            }
        }
        properties.setProperty("version", "1.0-SNAPSHOT");
        return properties;
    }

    public void mvnCleanPackageWithProperties(String path, Properties properties, File customSettingsFile) {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setProperties(properties);
        if (customSettingsFile != null && FileUtils.sizeOf(customSettingsFile) > 0L) {
            request.setUserSettingsFile(customSettingsFile);
        }
        ArrayList<String> mavenGoals = new ArrayList<String>();
        mavenGoals.add("clean");
        mavenGoals.add("package");
        request.setGoals(mavenGoals);
        this.logToHandler(request.getGoals(), properties);
        this.logToFile(request.getGoals(), properties);
        this.invoke(request, path);
    }

    private void logToHandler(List<String> goals, Properties properties) {
        this.handler.logOutput("Executing maven command:", true);
        StringBuilder mavenCommand = new StringBuilder("mvn ");
        for (String goal : goals) {
            mavenCommand.append(goal).append(" ");
        }
        this.handler.logOutput(mavenCommand.toString(), true);
        for (String propertyName : properties.stringPropertyNames()) {
            this.handler.logOutput("-D " + propertyName + "=" + properties.getProperty(propertyName), true);
        }
    }

    private void logToFile(List<String> goals, Properties properties) {
        InstallLog.getInstance().info("Executing maven command:");
        StringBuilder mavenCommand = new StringBuilder("mvn ");
        for (String goal : goals) {
            mavenCommand.append(goal).append(" ");
        }
        InstallLog.getInstance().info(mavenCommand.toString());
        for (String propertyName : properties.stringPropertyNames()) {
            InstallLog.getInstance().info("-D " + propertyName + "=" + properties.getProperty(propertyName));
        }
    }

    private InvocationResult invoke(InvocationRequest request, String path) {
        InvocationResult result = null;
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            invoker.setLogger(new PrintStreamLogger(new PrintStream(InstallLog.getInstance().getFileAbsolutePath()), 1000));
            invoker.setOutputHandler(new PrintStreamHandler(new PrintStream(InstallLog.getInstance().getFileAbsolutePath()), true));
            invoker.setWorkingDirectory(new File(path));
            result = invoker.execute(request);
        }
        catch (FileNotFoundException | MavenInvocationException ex) {
            String messageError = "Maven exception: " + ex.getMessage();
            this.handler.emitError(messageError, messageError);
            InstallLog.getInstance().info(messageError);
        }
        return result;
    }

    public static File createSettingsWithProxy(String path, String proxyHost, String proxyPort, String proxyUser, String proxyPassword) throws Exception {
        File settingsXML = new File(System.getProperty(MAVEN_HOME_PROPERTY) + (System.getProperty(MAVEN_HOME_PROPERTY).endsWith("/") ? "conf/settings.xml" : "/conf/settings.xml"));
        File tempSettingsXML = new File(path + (path.endsWith("/") ? "settings_temp.xml" : "/settings_temp.xml"));
        if (settingsXML.canRead() && !tempSettingsXML.exists()) {
            tempSettingsXML.createNewFile();
            DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImpl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
            LSInput lsinput = domImpl.createLSInput();
            lsinput.setByteStream(new FileInputStream(settingsXML));
            LSParser parser = domImpl.createLSParser((short)1, null);
            Document settings = parser.parse(lsinput);
            Element proxies = (Element)settings.getDocumentElement().getElementsByTagName("proxies").item(0);
            Element proxy = settings.createElement("proxy");
            Element id = settings.createElement("id");
            Element active = settings.createElement("active");
            Element protocol = settings.createElement("protocol");
            Element host = settings.createElement("host");
            Element port = settings.createElement("port");
            Element nonProxyHosts = settings.createElement("nonProxyHosts");
            id.appendChild(settings.createTextNode("optional"));
            active.appendChild(settings.createTextNode("true"));
            protocol.appendChild(settings.createTextNode("http"));
            host.appendChild(settings.createTextNode(proxyHost));
            port.appendChild(settings.createTextNode(proxyPort));
            proxy.appendChild(id);
            proxy.appendChild(active);
            proxy.appendChild(protocol);
            if (proxyUser != null && !proxyUser.isEmpty() && proxyPassword != null) {
                Element username = settings.createElement("username");
                Element password = settings.createElement("password");
                username.appendChild(settings.createTextNode(proxyUser));
                password.appendChild(settings.createTextNode(proxyPassword));
                proxy.appendChild(username);
                proxy.appendChild(password);
            }
            proxy.appendChild(host);
            proxy.appendChild(port);
            proxy.appendChild(nonProxyHosts);
            proxies.appendChild(proxy);
            FileSystemUtils.writeXML(settings, Files.newOutputStream(tempSettingsXML.toPath(), new OpenOption[0]));
        }
        return tempSettingsXML;
    }
}

