/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDelete
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserDelete.class);
    private static final String DELETE_HELP_MESSAGE = "user --delete {USER-KEY} {USER-KEY} [...]";
    private final Input input;

    public UserDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.userSyncopeOperations.delete(parameter);
                    this.userResultManager.deletedMessage("User", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting user", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.userResultManager.notFoundError("User", parameter);
                        continue;
                    }
                    this.userResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error deleting user", (Throwable)ex);
                    this.userResultManager.numberFormatException("user", parameter);
                }
            }
        } else {
            this.userResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

