/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.notification;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.notification.AbstractNotificationCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationRead
extends AbstractNotificationCommand {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationRead.class);
    private static final String READ_HELP_MESSAGE = "notification --read {NOTIFICATION-KEY} {NOTIFICATION-KEY} [...]";
    private final Input input;

    public NotificationRead(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.notificationResultManager.printNotification(this.notificationSyncopeOperations.read(parameter));
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error reading notification", (Throwable)ex);
                    this.notificationResultManager.notBooleanDeletedError("notification", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading notification", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.notificationResultManager.notFoundError("Notification", parameter);
                        continue;
                    }
                    this.notificationResultManager.genericError(ex.getMessage());
                }
            }
        } else {
            this.notificationResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

