/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli;

import javax.ws.rs.ProcessingException;
import org.apache.syncope.client.cli.ArgsManager;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.ResultManager;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncopeAdm {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeAdm.class);
    private static final ResultManager RESULT_MANAGER = new ResultManager();

    public static void main(String[] args) {
        LOG.debug("Starting with args \n");
        try {
            ArgsManager.validator(args);
            Input input = new Input(args);
            AbstractCommand command = input.getCommand();
            LOG.debug("Command: {}", (Object)command.getClass().getAnnotation(Command.class).name());
            LOG.debug("Option: {}", (Object)input.getOption());
            LOG.debug("Parameters:");
            for (String parameter : input.getParameters()) {
                LOG.debug("   > " + parameter);
            }
            System.out.println("");
            System.out.println("You are running: " + input.printCommandFields());
            command.execute(input);
        }
        catch (IllegalAccessException | InstantiationException e) {
            System.out.println(SyncopeAdm.helpMessage());
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Error in main", (Throwable)ex);
            if (!ex.getMessage().startsWith("It seems you")) {
                System.out.println("");
                System.out.println(SyncopeAdm.helpMessage());
            } else {
                RESULT_MANAGER.genericError(ex.getMessage());
            }
        }
        catch (ProcessingException e) {
            LOG.error("Error in main", (Throwable)e);
            RESULT_MANAGER.genericError("Syncope server offline");
            RESULT_MANAGER.genericError(e.getCause().getMessage());
        }
    }

    private static String helpMessage() {
        StringBuilder helpMessageBuilder = new StringBuilder("Usage: Main [options]\n");
        helpMessageBuilder.append("  Options:\n");
        try {
            for (AbstractCommand command : CommandUtils.commands()) {
                String commandName = command.getClass().getAnnotation(Command.class).name();
                helpMessageBuilder.append("    ").append(commandName);
                if (!"help".equalsIgnoreCase(commandName)) {
                    helpMessageBuilder.append(" --help");
                }
                helpMessageBuilder.append("\n");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
            LOG.error("Error in main", (Throwable)ex);
            RESULT_MANAGER.genericError(ex.getMessage());
        }
        return helpMessageBuilder.toString();
    }

    private SyncopeAdm() {
    }
}

