/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.provisioning.java;

import static org.junit.Assert.assertEquals;

import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional("Master")
public class ConnectorManagerTest extends AbstractTest {

    private ConnectorManager connManager;

    @Autowired
    private ConnIdBundleManager connIdBundleManager;

    @Autowired
    private ExternalResourceDAO resourceDAO;

    @Before
    public void before() {
        connManager = new ConnectorManager();
        ReflectionTestUtils.setField(connManager, "connIdBundleManager", connIdBundleManager);
        ReflectionTestUtils.setField(connManager, "resourceDAO", resourceDAO);

        // Remove any other connector instance bean set up by standard ConnectorManager.load()
        connManager.unload();
    }

    @Test
    public void load() {
        connManager.load();

        // only consider local connector bundles
        long expected = IterableUtils.countMatches(resourceDAO.findAll(), new Predicate<ExternalResource>() {

            @Override
            public boolean evaluate(final ExternalResource resource) {
                return resource.getConnector().getLocation().startsWith("file");
            }
        });

        assertEquals(expected,
                ApplicationContextProvider.getBeanFactory().
                        getBeanNamesForType(Connector.class, false, true).length);
    }
}
