/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.task;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.task.AbstractTaskCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.NotificationTaskTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDetails
extends AbstractTaskCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDetails.class);
    private static final String DETAILS_HELP_MESSAGE = "task --details";
    private final Input input;

    public TaskDetails(Input input) {
        this.input = input;
    }

    /*
     * WARNING - void declaration
     */
    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                void var18_28;
                void var17_23;
                LinkedMap details = new LinkedMap();
                List<TaskTO> notificationTaskTOs = this.taskSyncopeOperations.list(TaskType.NOTIFICATION.name());
                List<TaskTO> propagationTaskTOs = this.taskSyncopeOperations.list(TaskType.PROPAGATION.name());
                List<TaskTO> pushTaskTOs = this.taskSyncopeOperations.list(TaskType.PUSH.name());
                List<TaskTO> scheduledTaskTOs = this.taskSyncopeOperations.list(TaskType.SCHEDULED.name());
                List<TaskTO> pullTaskTOs = this.taskSyncopeOperations.list(TaskType.PULL.name());
                List<JobTO> jobTOs = this.taskSyncopeOperations.listJobs();
                int notificationTaskSize = notificationTaskTOs.size();
                int propagationTaskSize = propagationTaskTOs.size();
                int pushTaskSize = pushTaskTOs.size();
                int scheduledTaskSize = scheduledTaskTOs.size();
                int scheduledNotExecuted = 0;
                int pullTaskSize = pullTaskTOs.size();
                int jobsSize = jobTOs.size();
                int notificationNotExecuted = 0;
                for (TaskTO taskTO : notificationTaskTOs) {
                    if (((NotificationTaskTO)taskTO).isExecuted()) continue;
                    ++notificationNotExecuted;
                }
                int propagationNotExecuted = 0;
                for (TaskTO taskTO : propagationTaskTOs) {
                    if (((PropagationTaskTO)taskTO).getExecutions() != null && !((PropagationTaskTO)taskTO).getExecutions().isEmpty()) continue;
                    ++propagationNotExecuted;
                }
                boolean bl = false;
                for (TaskTO pushTaskTO : pushTaskTOs) {
                    if (((PushTaskTO)pushTaskTO).getExecutions() != null && !((PushTaskTO)pushTaskTO).getExecutions().isEmpty()) continue;
                    ++var17_23;
                }
                for (TaskTO scheduledTaskTO : scheduledTaskTOs) {
                    if (((ProvisioningTaskTO)scheduledTaskTO).getExecutions() != null && !((ProvisioningTaskTO)scheduledTaskTO).getExecutions().isEmpty()) continue;
                    ++scheduledNotExecuted;
                }
                boolean bl2 = false;
                int pullFull = 0;
                for (TaskTO pullTaskTO : pullTaskTOs) {
                    if (((PullTaskTO)pullTaskTO).getExecutions() == null || ((PullTaskTO)pullTaskTO).getExecutions().isEmpty()) {
                        ++var18_28;
                    }
                    if (((PullTaskTO)pullTaskTO).getPullMode() != PullMode.FULL_RECONCILIATION) continue;
                    ++pullFull;
                }
                details.put("total number", String.valueOf(notificationTaskSize + propagationTaskSize + pushTaskSize + scheduledTaskSize + pullTaskSize));
                details.put("notification tasks", String.valueOf(notificationTaskSize));
                details.put("notification tasks not executed", String.valueOf(notificationNotExecuted));
                details.put("propagation tasks", String.valueOf(propagationTaskSize));
                details.put("propagation tasks not executed", String.valueOf(propagationNotExecuted));
                details.put("push tasks", String.valueOf(pushTaskSize));
                details.put("push tasks not executed", String.valueOf((int)var17_23));
                details.put("scheduled tasks", String.valueOf(scheduledTaskSize));
                details.put("scheduled tasks not executed", String.valueOf(scheduledNotExecuted));
                details.put("pull tasks", String.valueOf(pullTaskSize));
                details.put("pull tasks not executed", String.valueOf((int)var18_28));
                details.put("pull tasks with full reconciliation", String.valueOf(pullFull));
                details.put("jobs", String.valueOf(jobsSize));
                this.taskResultManager.printDetails((Map<String, String>)details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about task", (Throwable)ex);
                this.taskResultManager.genericError(ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Error reading details about task", (Throwable)ex);
                this.taskResultManager.typeNotValidError("task", this.input.firstParameter(), CommandUtils.fromEnumToArray(TaskType.class));
            }
        } else {
            this.taskResultManager.commandOptionError(DETAILS_HELP_MESSAGE);
        }
    }
}

