/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.role;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.role.AbstractRoleCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.RoleTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleDetails
extends AbstractRoleCommand {
    private static final Logger LOG = LoggerFactory.getLogger(RoleDetails.class);
    private static final String DETAILS_HELP_MESSAGE = "role --details";
    private final Input input;

    public RoleDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedMap details = new LinkedMap();
                List<RoleTO> roleTOs = this.roleSyncopeOperations.list();
                int withoutEntitlements = 0;
                for (RoleTO roleTO : roleTOs) {
                    if (roleTO.getEntitlements() != null && !roleTO.getEntitlements().isEmpty()) continue;
                    ++withoutEntitlements;
                }
                details.put("Total number", String.valueOf(roleTOs.size()));
                details.put("Without entitlements", String.valueOf(withoutEntitlements));
                this.roleResultManager.printDetails((Map<String, String>)details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about role", (Throwable)ex);
                this.roleResultManager.genericError(ex.getMessage());
            }
        } else {
            this.roleResultManager.unnecessaryParameters(this.input.listParameters(), DETAILS_HELP_MESSAGE);
        }
    }
}

