/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.report.AbstractReportCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ReportTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDetails
extends AbstractReportCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDetails.class);
    private static final String LIST_HELP_MESSAGE = "report --details";
    private final Input input;

    public ReportDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedMap details = new LinkedMap();
                List<ReportTO> reportTOs = this.reportSyncopeOperations.list();
                int withoutExecutions = 0;
                for (ReportTO reportTO : reportTOs) {
                    if (!reportTO.getExecutions().isEmpty()) continue;
                    ++withoutExecutions;
                }
                details.put("Total numbers", String.valueOf(reportTOs.size()));
                details.put("Never executed", String.valueOf(withoutExecutions));
                this.reportResultManager.printDetails((Map<String, String>)details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about report", (Throwable)ex);
                this.reportResultManager.genericError(ex.getMessage());
            }
        } else {
            this.reportResultManager.unnecessaryParameters(this.input.listParameters(), LIST_HELP_MESSAGE);
        }
    }
}

