-- Licensed to the Apache Software Foundation (ASF) under one
-- or more contributor license agreements.  See the NOTICE file
-- distributed with this work for additional information
-- regarding copyright ownership.  The ASF licenses this file
-- to you under the Apache License, Version 2.0 (the
-- "License"); you may not use this file except in compliance
-- with the License.  You may obtain a copy of the License at
--
--   http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing,
-- software distributed under the License is distributed on an
-- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
-- KIND, either express or implied.  See the License for the
-- specific language governing permissions and limitations
-- under the License.

ALTER USER sa SET PASSWORD 'sa';

CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_F3B35AED_8769_4646_B8AE_26CC68FB1209 START WITH 1 BELONGS_TO_TABLE;     
CREATE MEMORY TABLE PUBLIC.SYNCOPEAUDIT(
    EVENT_DATE TIMESTAMP,
    LOGGER_LEVEL VARCHAR(255) NOT NULL,
    LOGGER VARCHAR(255) NOT NULL,
    MESSAGE TEXT NOT NULL,
    THROWABLE TEXT
);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEAUDIT;             
CREATE MEMORY TABLE PUBLIC.ACT_GE_PROPERTY(
    NAME_ VARCHAR(64) NOT NULL,
    VALUE_ VARCHAR(300),
    REV_ INTEGER
);       
ALTER TABLE PUBLIC.ACT_GE_PROPERTY ADD CONSTRAINT PUBLIC.CONSTRAINT_2 PRIMARY KEY(NAME_);      
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.ACT_GE_PROPERTY;          
INSERT INTO PUBLIC.ACT_GE_PROPERTY(NAME_, VALUE_, REV_) VALUES
('schema.version', '5.16.4.0', 1),
('schema.history', 'create(5.16.4.0)', 1),
('next.dbid', '5001', 3);         
CREATE MEMORY TABLE PUBLIC.ACT_GE_BYTEARRAY(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(64),
    BYTES_ LONGVARBINARY,
    GENERATED_ BIT
);           
ALTER TABLE PUBLIC.ACT_GE_BYTEARRAY ADD CONSTRAINT PUBLIC.CONSTRAINT_8 PRIMARY KEY(ID_);       
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.ACT_GE_BYTEARRAY;         
INSERT INTO PUBLIC.ACT_GE_BYTEARRAY(ID_, REV_, NAME_, DEPLOYMENT_ID_, BYTES_, GENERATED_) VALUES
('2', 1, 'userWorkflow.bpmn20.xml', '1', X'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', FALSE);             
INSERT INTO PUBLIC.ACT_GE_BYTEARRAY(ID_, REV_, NAME_, DEPLOYMENT_ID_, BYTES_, GENERATED_) VALUES
('3', 1, 'userWorkflow.userWorkflow.png', '1', X'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', TRUE);  
INSERT INTO PUBLIC.ACT_GE_BYTEARRAY(ID_, REV_, NAME_, DEPLOYMENT_ID_, BYTES_, GENERATED_) VALUES
('6', 1, 'source', NULL, X'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', NULL);          
CREATE MEMORY TABLE PUBLIC.ACT_RE_DEPLOYMENT(
    ID_ VARCHAR(64) NOT NULL,
    NAME_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    DEPLOY_TIME_ TIMESTAMP
);          
ALTER TABLE PUBLIC.ACT_RE_DEPLOYMENT ADD CONSTRAINT PUBLIC.CONSTRAINT_1 PRIMARY KEY(ID_);      
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RE_DEPLOYMENT;        
INSERT INTO PUBLIC.ACT_RE_DEPLOYMENT(ID_, NAME_, CATEGORY_, TENANT_ID_, DEPLOY_TIME_) VALUES
('1', NULL, NULL, '', TIMESTAMP '2016-05-02 13:08:01.325');       
CREATE MEMORY TABLE PUBLIC.ACT_RE_MODEL(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    CREATE_TIME_ TIMESTAMP,
    LAST_UPDATE_TIME_ TIMESTAMP,
    VERSION_ INTEGER,
    META_INFO_ VARCHAR(4000),
    DEPLOYMENT_ID_ VARCHAR(64),
    EDITOR_SOURCE_VALUE_ID_ VARCHAR(64),
    EDITOR_SOURCE_EXTRA_VALUE_ID_ VARCHAR(64),
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);         
ALTER TABLE PUBLIC.ACT_RE_MODEL ADD CONSTRAINT PUBLIC.CONSTRAINT_4 PRIMARY KEY(ID_);           
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RE_MODEL;             
INSERT INTO PUBLIC.ACT_RE_MODEL(ID_, REV_, NAME_, KEY_, CATEGORY_, CREATE_TIME_, LAST_UPDATE_TIME_, VERSION_, META_INFO_, DEPLOYMENT_ID_, EDITOR_SOURCE_VALUE_ID_, EDITOR_SOURCE_EXTRA_VALUE_ID_, TENANT_ID_) VALUES
('5', 2, 'User Workflow', NULL, NULL, TIMESTAMP '2016-05-02 13:08:03.206', TIMESTAMP '2016-05-02 13:08:03.211', 1, '{"name":"User Workflow","revision":1,"description":null}', '1', '6', NULL, '');       
CREATE MEMORY TABLE PUBLIC.ACT_RU_EXECUTION(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    PROC_INST_ID_ VARCHAR(64),
    BUSINESS_KEY_ VARCHAR(255),
    PARENT_ID_ VARCHAR(64),
    PROC_DEF_ID_ VARCHAR(64),
    SUPER_EXEC_ VARCHAR(64),
    ACT_ID_ VARCHAR(255),
    IS_ACTIVE_ BIT,
    IS_CONCURRENT_ BIT,
    IS_SCOPE_ BIT,
    IS_EVENT_SCOPE_ BIT,
    SUSPENSION_STATE_ INTEGER,
    CACHED_ENT_STATE_ INTEGER,
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    NAME_ VARCHAR(255)
);           
ALTER TABLE PUBLIC.ACT_RU_EXECUTION ADD CONSTRAINT PUBLIC.CONSTRAINT_5 PRIMARY KEY(ID_);       
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_EXECUTION;         
INSERT INTO PUBLIC.ACT_RU_EXECUTION(ID_, REV_, PROC_INST_ID_, BUSINESS_KEY_, PARENT_ID_, PROC_DEF_ID_, SUPER_EXEC_, ACT_ID_, IS_ACTIVE_, IS_CONCURRENT_, IS_SCOPE_, IS_EVENT_SCOPE_, SUSPENSION_STATE_, CACHED_ENT_STATE_, TENANT_ID_, NAME_) VALUES
('4', 2, '4', NULL, NULL, 'userWorkflow:1:4', NULL, 'active', TRUE, FALSE, TRUE, FALSE, 1, NULL, '', NULL),
('6', 2, '6', NULL, NULL, 'userWorkflow:1:4', NULL, 'active', TRUE, FALSE, TRUE, FALSE, 1, NULL, '', NULL),
('8', 2, '8', NULL, NULL, 'userWorkflow:1:4', NULL, 'active', TRUE, FALSE, TRUE, FALSE, 1, NULL, '', NULL),
('10', 2, '10', NULL, NULL, 'userWorkflow:1:4', NULL, 'active', TRUE, FALSE, TRUE, FALSE, 1, NULL, '', NULL),
('12', 2, '12', NULL, NULL, 'userWorkflow:1:4', NULL, 'active', TRUE, FALSE, TRUE, FALSE, 1, NULL, '', NULL);           
CREATE INDEX PUBLIC.ACT_IDX_EXEC_BUSKEY ON PUBLIC.ACT_RU_EXECUTION(BUSINESS_KEY_);             
CREATE MEMORY TABLE PUBLIC.ACT_RU_JOB(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    TYPE_ VARCHAR(255) NOT NULL,
    LOCK_EXP_TIME_ TIMESTAMP,
    LOCK_OWNER_ VARCHAR(255),
    EXCLUSIVE_ BOOLEAN,
    EXECUTION_ID_ VARCHAR(64),
    PROCESS_INSTANCE_ID_ VARCHAR(64),
    PROC_DEF_ID_ VARCHAR(64),
    RETRIES_ INTEGER,
    EXCEPTION_STACK_ID_ VARCHAR(64),
    EXCEPTION_MSG_ VARCHAR(4000),
    DUEDATE_ TIMESTAMP,
    REPEAT_ VARCHAR(255),
    HANDLER_TYPE_ VARCHAR(255),
    HANDLER_CFG_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);        
ALTER TABLE PUBLIC.ACT_RU_JOB ADD CONSTRAINT PUBLIC.CONSTRAINT_1C PRIMARY KEY(ID_);            
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_JOB;               
CREATE MEMORY TABLE PUBLIC.ACT_RE_PROCDEF(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    CATEGORY_ VARCHAR(255),
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255) NOT NULL,
    VERSION_ INTEGER NOT NULL,
    DEPLOYMENT_ID_ VARCHAR(64),
    RESOURCE_NAME_ VARCHAR(4000),
    DGRM_RESOURCE_NAME_ VARCHAR(4000),
    DESCRIPTION_ VARCHAR(4000),
    HAS_START_FORM_KEY_ BIT,
    SUSPENSION_STATE_ INTEGER,
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);   
ALTER TABLE PUBLIC.ACT_RE_PROCDEF ADD CONSTRAINT PUBLIC.CONSTRAINT_6 PRIMARY KEY(ID_);         
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RE_PROCDEF;           
INSERT INTO PUBLIC.ACT_RE_PROCDEF(ID_, REV_, CATEGORY_, NAME_, KEY_, VERSION_, DEPLOYMENT_ID_, RESOURCE_NAME_, DGRM_RESOURCE_NAME_, DESCRIPTION_, HAS_START_FORM_KEY_, SUSPENSION_STATE_, TENANT_ID_) VALUES
('userWorkflow:1:4', 1, 'http://activiti.org/bpmn20', 'User Workflow', 'userWorkflow', 1, '1', 'userWorkflow.bpmn20.xml', 'userWorkflow.userWorkflow.png', NULL, FALSE, 1, '');   
CREATE MEMORY TABLE PUBLIC.ACT_RU_TASK(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    EXECUTION_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    PROC_DEF_ID_ VARCHAR(64),
    NAME_ VARCHAR(255),
    PARENT_TASK_ID_ VARCHAR(64),
    DESCRIPTION_ VARCHAR(4000),
    TASK_DEF_KEY_ VARCHAR(255),
    OWNER_ VARCHAR(255),
    ASSIGNEE_ VARCHAR(255),
    DELEGATION_ VARCHAR(64),
    PRIORITY_ INTEGER,
    CREATE_TIME_ TIMESTAMP,
    DUE_DATE_ TIMESTAMP,
    CATEGORY_ VARCHAR(255),
    SUSPENSION_STATE_ INTEGER,
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    FORM_KEY_ VARCHAR(255)
);    
ALTER TABLE PUBLIC.ACT_RU_TASK ADD CONSTRAINT PUBLIC.CONSTRAINT_7 PRIMARY KEY(ID_);            
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_TASK;              
INSERT INTO PUBLIC.ACT_RU_TASK(ID_, REV_, EXECUTION_ID_, PROC_INST_ID_, PROC_DEF_ID_, NAME_, PARENT_TASK_ID_, DESCRIPTION_, TASK_DEF_KEY_, OWNER_, ASSIGNEE_, DELEGATION_, PRIORITY_, CREATE_TIME_, DUE_DATE_, CATEGORY_, SUSPENSION_STATE_, TENANT_ID_, FORM_KEY_) VALUES
('5', 2, '4', '4', 'userWorkflow:1:4', 'Active', NULL, NULL, 'active', NULL, NULL, NULL, 50, TIMESTAMP '2013-02-25 17:19:03.0', NULL, NULL, NULL, '', NULL),
('7', 2, '6', '6', 'userWorkflow:1:4', 'Active', NULL, NULL, 'active', NULL, NULL, NULL, 50, TIMESTAMP '2013-02-25 17:19:03.0', NULL, NULL, NULL, '', NULL),
('9', 2, '8', '8', 'userWorkflow:1:4', 'Active', NULL, NULL, 'active', NULL, NULL, NULL, 50, TIMESTAMP '2013-02-25 17:19:03.0', NULL, NULL, NULL, '', NULL),
('11', 2, '10', '10', 'userWorkflow:1:4', 'Active', NULL, NULL, 'active', NULL, NULL, NULL, 50, TIMESTAMP '2013-02-25 17:19:03.0', NULL, NULL, NULL, '', NULL),
('13', 2, '12', '12', 'userWorkflow:1:4', 'Active', NULL, NULL, 'active', NULL, NULL, NULL, 50, TIMESTAMP '2013-02-25 17:19:03.0', NULL, NULL, NULL, '', NULL);              
CREATE INDEX PUBLIC.ACT_IDX_TASK_CREATE ON PUBLIC.ACT_RU_TASK(CREATE_TIME_);   
CREATE INDEX PUBLIC.ACT_RU_TASK_PARENT_TASK_ID_ ON PUBLIC.ACT_RU_TASK(PARENT_TASK_ID_);        
CREATE MEMORY TABLE PUBLIC.ACT_RU_IDENTITYLINK(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    GROUP_ID_ VARCHAR(255),
    TYPE_ VARCHAR(255),
    USER_ID_ VARCHAR(255),
    TASK_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    PROC_DEF_ID_ VARCHAR(64)
);        
ALTER TABLE PUBLIC.ACT_RU_IDENTITYLINK ADD CONSTRAINT PUBLIC.CONSTRAINT_A PRIMARY KEY(ID_);    
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_IDENTITYLINK;      
CREATE INDEX PUBLIC.ACT_IDX_IDENT_LNK_USER ON PUBLIC.ACT_RU_IDENTITYLINK(USER_ID_);            
CREATE INDEX PUBLIC.ACT_IDX_IDENT_LNK_GROUP ON PUBLIC.ACT_RU_IDENTITYLINK(GROUP_ID_);          
CREATE INDEX PUBLIC.ACT_IDX_ATHRZ_PROCEDEF ON PUBLIC.ACT_RU_IDENTITYLINK(PROC_DEF_ID_);        
CREATE MEMORY TABLE PUBLIC.ACT_RU_VARIABLE(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    TYPE_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    EXECUTION_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    TASK_ID_ VARCHAR(64),
    BYTEARRAY_ID_ VARCHAR(64),
    DOUBLE_ DOUBLE,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    TEXT2_ VARCHAR(4000)
);
ALTER TABLE PUBLIC.ACT_RU_VARIABLE ADD CONSTRAINT PUBLIC.CONSTRAINT_C PRIMARY KEY(ID_);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_VARIABLE;          
CREATE INDEX PUBLIC.ACT_IDX_VARIABLE_TASK_ID ON PUBLIC.ACT_RU_VARIABLE(TASK_ID_);              
CREATE MEMORY TABLE PUBLIC.ACT_RU_EVENT_SUBSCR(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    EVENT_TYPE_ VARCHAR(255) NOT NULL,
    EVENT_NAME_ VARCHAR(255),
    EXECUTION_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    ACTIVITY_ID_ VARCHAR(64),
    CONFIGURATION_ VARCHAR(255),
    CREATED_ TIMESTAMP NOT NULL,
    PROC_DEF_ID_ VARCHAR(64),
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);     
ALTER TABLE PUBLIC.ACT_RU_EVENT_SUBSCR ADD CONSTRAINT PUBLIC.CONSTRAINT_86 PRIMARY KEY(ID_);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_EVENT_SUBSCR;      
CREATE INDEX PUBLIC.ACT_IDX_EVENT_SUBSCR_CONFIG_ ON PUBLIC.ACT_RU_EVENT_SUBSCR(CONFIGURATION_);
CREATE MEMORY TABLE PUBLIC.ACT_EVT_LOG(
    LOG_NR_ BIGINT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_F3B35AED_8769_4646_B8AE_26CC68FB1209) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_F3B35AED_8769_4646_B8AE_26CC68FB1209,
    TYPE_ VARCHAR(64),
    PROC_DEF_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    EXECUTION_ID_ VARCHAR(64),
    TASK_ID_ VARCHAR(64),
    TIME_STAMP_ TIMESTAMP NOT NULL,
    USER_ID_ VARCHAR(255),
    DATA_ LONGVARBINARY,
    LOCK_OWNER_ VARCHAR(255),
    LOCK_TIME_ TIMESTAMP,
    IS_PROCESSED_ BIT DEFAULT 0
); 
ALTER TABLE PUBLIC.ACT_EVT_LOG ADD CONSTRAINT PUBLIC.CONSTRAINT_C9 PRIMARY KEY(LOG_NR_);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_EVT_LOG;              
CREATE MEMORY TABLE PUBLIC.ACT_HI_PROCINST(
    ID_ VARCHAR(64) NOT NULL,
    PROC_INST_ID_ VARCHAR(64) NOT NULL,
    BUSINESS_KEY_ VARCHAR(255),
    PROC_DEF_ID_ VARCHAR(64) NOT NULL,
    START_TIME_ TIMESTAMP NOT NULL,
    END_TIME_ TIMESTAMP,
    DURATION_ BIGINT,
    START_USER_ID_ VARCHAR(255),
    START_ACT_ID_ VARCHAR(255),
    END_ACT_ID_ VARCHAR(255),
    SUPER_PROCESS_INSTANCE_ID_ VARCHAR(64),
    DELETE_REASON_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    NAME_ VARCHAR(255)
);     
ALTER TABLE PUBLIC.ACT_HI_PROCINST ADD CONSTRAINT PUBLIC.CONSTRAINT_8D PRIMARY KEY(ID_);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_PROCINST;          
CREATE INDEX PUBLIC.ACT_IDX_HI_PRO_INST_END ON PUBLIC.ACT_HI_PROCINST(END_TIME_);              
CREATE INDEX PUBLIC.ACT_IDX_HI_PRO_I_BUSKEY ON PUBLIC.ACT_HI_PROCINST(BUSINESS_KEY_);          
CREATE MEMORY TABLE PUBLIC.ACT_HI_ACTINST(
    ID_ VARCHAR(64) NOT NULL,
    PROC_DEF_ID_ VARCHAR(64) NOT NULL,
    PROC_INST_ID_ VARCHAR(64) NOT NULL,
    EXECUTION_ID_ VARCHAR(64) NOT NULL,
    ACT_ID_ VARCHAR(255) NOT NULL,
    TASK_ID_ VARCHAR(64),
    CALL_PROC_INST_ID_ VARCHAR(64),
    ACT_NAME_ VARCHAR(255),
    ACT_TYPE_ VARCHAR(255) NOT NULL,
    ASSIGNEE_ VARCHAR(255),
    START_TIME_ TIMESTAMP NOT NULL,
    END_TIME_ TIMESTAMP,
    DURATION_ BIGINT,
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);     
ALTER TABLE PUBLIC.ACT_HI_ACTINST ADD CONSTRAINT PUBLIC.CONSTRAINT_F PRIMARY KEY(ID_);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_ACTINST;           
CREATE INDEX PUBLIC.ACT_IDX_HI_ACT_INST_START ON PUBLIC.ACT_HI_ACTINST(START_TIME_);           
CREATE INDEX PUBLIC.ACT_IDX_HI_ACT_INST_END ON PUBLIC.ACT_HI_ACTINST(END_TIME_);               
CREATE INDEX PUBLIC.ACT_IDX_HI_ACT_INST_PROCINST ON PUBLIC.ACT_HI_ACTINST(PROC_INST_ID_, ACT_ID_);             
CREATE INDEX PUBLIC.ACT_IDX_HI_ACT_INST_EXEC ON PUBLIC.ACT_HI_ACTINST(EXECUTION_ID_, ACT_ID_); 
CREATE MEMORY TABLE PUBLIC.ACT_HI_TASKINST(
    ID_ VARCHAR(64) NOT NULL,
    PROC_DEF_ID_ VARCHAR(64),
    TASK_DEF_KEY_ VARCHAR(255),
    PROC_INST_ID_ VARCHAR(64),
    EXECUTION_ID_ VARCHAR(64),
    NAME_ VARCHAR(255),
    PARENT_TASK_ID_ VARCHAR(64),
    DESCRIPTION_ VARCHAR(4000),
    OWNER_ VARCHAR(255),
    ASSIGNEE_ VARCHAR(255),
    START_TIME_ TIMESTAMP NOT NULL,
    CLAIM_TIME_ TIMESTAMP,
    END_TIME_ TIMESTAMP,
    DURATION_ BIGINT,
    DELETE_REASON_ VARCHAR(4000),
    PRIORITY_ INTEGER,
    DUE_DATE_ TIMESTAMP,
    FORM_KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);          
ALTER TABLE PUBLIC.ACT_HI_TASKINST ADD CONSTRAINT PUBLIC.CONSTRAINT_B PRIMARY KEY(ID_);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_TASKINST;          
CREATE MEMORY TABLE PUBLIC.ACT_HI_VARINST(
    ID_ VARCHAR(64) NOT NULL,
    PROC_INST_ID_ VARCHAR(64),
    EXECUTION_ID_ VARCHAR(64),
    TASK_ID_ VARCHAR(64),
    NAME_ VARCHAR(255) NOT NULL,
    VAR_TYPE_ VARCHAR(100),
    REV_ INTEGER,
    BYTEARRAY_ID_ VARCHAR(64),
    DOUBLE_ DOUBLE,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    TEXT2_ VARCHAR(4000),
    CREATE_TIME_ TIMESTAMP,
    LAST_UPDATED_TIME_ TIMESTAMP
);        
ALTER TABLE PUBLIC.ACT_HI_VARINST ADD CONSTRAINT PUBLIC.CONSTRAINT_4E PRIMARY KEY(ID_);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_VARINST;           
CREATE INDEX PUBLIC.ACT_IDX_HI_PROCVAR_PROC_INST ON PUBLIC.ACT_HI_VARINST(PROC_INST_ID_);      
CREATE INDEX PUBLIC.ACT_IDX_HI_PROCVAR_NAME_TYPE ON PUBLIC.ACT_HI_VARINST(NAME_, VAR_TYPE_);   
CREATE INDEX PUBLIC.ACT_IDX_HI_PROCVAR_TASK_ID ON PUBLIC.ACT_HI_VARINST(TASK_ID_);             
CREATE MEMORY TABLE PUBLIC.ACT_HI_DETAIL(
    ID_ VARCHAR(64) NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    TIME_ TIMESTAMP NOT NULL,
    NAME_ VARCHAR(255),
    PROC_INST_ID_ VARCHAR(64),
    EXECUTION_ID_ VARCHAR(64),
    TASK_ID_ VARCHAR(64),
    ACT_INST_ID_ VARCHAR(64),
    VAR_TYPE_ VARCHAR(255),
    REV_ INTEGER,
    BYTEARRAY_ID_ VARCHAR(64),
    DOUBLE_ DOUBLE,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    TEXT2_ VARCHAR(4000)
);   
ALTER TABLE PUBLIC.ACT_HI_DETAIL ADD CONSTRAINT PUBLIC.CONSTRAINT_80 PRIMARY KEY(ID_);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_DETAIL;            
CREATE INDEX PUBLIC.ACT_IDX_HI_DETAIL_PROC_INST ON PUBLIC.ACT_HI_DETAIL(PROC_INST_ID_);        
CREATE INDEX PUBLIC.ACT_IDX_HI_DETAIL_ACT_INST ON PUBLIC.ACT_HI_DETAIL(ACT_INST_ID_);          
CREATE INDEX PUBLIC.ACT_IDX_HI_DETAIL_TIME ON PUBLIC.ACT_HI_DETAIL(TIME_);     
CREATE INDEX PUBLIC.ACT_IDX_HI_DETAIL_NAME ON PUBLIC.ACT_HI_DETAIL(NAME_);     
CREATE INDEX PUBLIC.ACT_IDX_HI_DETAIL_TASK_ID ON PUBLIC.ACT_HI_DETAIL(TASK_ID_);               
CREATE MEMORY TABLE PUBLIC.ACT_HI_COMMENT(
    ID_ VARCHAR(64) NOT NULL,
    TYPE_ VARCHAR(255),
    TIME_ TIMESTAMP NOT NULL,
    USER_ID_ VARCHAR(255),
    TASK_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    ACTION_ VARCHAR(255),
    MESSAGE_ VARCHAR(4000),
    FULL_MSG_ LONGVARBINARY
);        
ALTER TABLE PUBLIC.ACT_HI_COMMENT ADD CONSTRAINT PUBLIC.CONSTRAINT_78 PRIMARY KEY(ID_);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_COMMENT;           
CREATE MEMORY TABLE PUBLIC.ACT_HI_ATTACHMENT(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    USER_ID_ VARCHAR(255),
    NAME_ VARCHAR(255),
    DESCRIPTION_ VARCHAR(4000),
    TYPE_ VARCHAR(255),
    TASK_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    URL_ VARCHAR(4000),
    CONTENT_ID_ VARCHAR(64)
);       
ALTER TABLE PUBLIC.ACT_HI_ATTACHMENT ADD CONSTRAINT PUBLIC.CONSTRAINT_D PRIMARY KEY(ID_);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_ATTACHMENT;        
CREATE MEMORY TABLE PUBLIC.ACT_HI_IDENTITYLINK(
    ID_ VARCHAR(64) NOT NULL,
    GROUP_ID_ VARCHAR(255),
    TYPE_ VARCHAR(255),
    USER_ID_ VARCHAR(255),
    TASK_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64)
);        
ALTER TABLE PUBLIC.ACT_HI_IDENTITYLINK ADD CONSTRAINT PUBLIC.CONSTRAINT_8A PRIMARY KEY(ID_);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_IDENTITYLINK;      
CREATE INDEX PUBLIC.ACT_IDX_HI_IDENT_LNK_USER ON PUBLIC.ACT_HI_IDENTITYLINK(USER_ID_);         
CREATE INDEX PUBLIC.ACT_IDX_HI_IDENT_LNK_TASK ON PUBLIC.ACT_HI_IDENTITYLINK(TASK_ID_);         
CREATE INDEX PUBLIC.ACT_IDX_HI_IDENT_LNK_PROCINST ON PUBLIC.ACT_HI_IDENTITYLINK(PROC_INST_ID_);
CREATE MEMORY TABLE PUBLIC.ACT_ID_GROUP(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    NAME_ VARCHAR(255),
    TYPE_ VARCHAR(255)
);     
ALTER TABLE PUBLIC.ACT_ID_GROUP ADD CONSTRAINT PUBLIC.CONSTRAINT_6B PRIMARY KEY(ID_);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_ID_GROUP;             
CREATE MEMORY TABLE PUBLIC.ACT_ID_MEMBERSHIP(
    USER_ID_ VARCHAR(64) NOT NULL,
    GROUP_ID_ VARCHAR(64) NOT NULL
);         
ALTER TABLE PUBLIC.ACT_ID_MEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_E PRIMARY KEY(USER_ID_, GROUP_ID_);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_ID_MEMBERSHIP;        
CREATE MEMORY TABLE PUBLIC.ACT_ID_USER(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    FIRST_ VARCHAR(255),
    LAST_ VARCHAR(255),
    EMAIL_ VARCHAR(255),
    PWD_ VARCHAR(255),
    PICTURE_ID_ VARCHAR(64)
);        
ALTER TABLE PUBLIC.ACT_ID_USER ADD CONSTRAINT PUBLIC.CONSTRAINT_7F PRIMARY KEY(ID_);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_ID_USER;              
CREATE MEMORY TABLE PUBLIC.ACT_ID_INFO(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    USER_ID_ VARCHAR(64),
    TYPE_ VARCHAR(64),
    KEY_ VARCHAR(255),
    VALUE_ VARCHAR(255),
    PASSWORD_ LONGVARBINARY,
    PARENT_ID_ VARCHAR(255)
);           
ALTER TABLE PUBLIC.ACT_ID_INFO ADD CONSTRAINT PUBLIC.CONSTRAINT_7F5 PRIMARY KEY(ID_);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_ID_INFO;              
CREATE MEMORY TABLE PUBLIC.QRTZ_CALENDARS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    CALENDAR_NAME VARCHAR(200) NOT NULL,
    CALENDAR IMAGE NOT NULL
);       
ALTER TABLE PUBLIC.QRTZ_CALENDARS ADD CONSTRAINT PUBLIC.PK_QRTZ_CALENDARS PRIMARY KEY(SCHED_NAME, CALENDAR_NAME);              
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_CALENDARS;           
CREATE MEMORY TABLE PUBLIC.QRTZ_CRON_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    CRON_EXPRESSION VARCHAR(120) NOT NULL,
    TIME_ZONE_ID VARCHAR(80)
);               
ALTER TABLE PUBLIC.QRTZ_CRON_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_CRON_TRIGGERS PRIMARY KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);        
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_CRON_TRIGGERS;       
INSERT INTO PUBLIC.QRTZ_CRON_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID) VALUES
('scheduler', 'Trigger_taskJob5', 'DEFAULT', '0 0 0 1 * ?', 'Europe/Rome');               
CREATE MEMORY TABLE PUBLIC.QRTZ_FIRED_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    ENTRY_ID VARCHAR(95) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    INSTANCE_NAME VARCHAR(200) NOT NULL,
    FIRED_TIME BIGINT NOT NULL,
    SCHED_TIME BIGINT NOT NULL,
    PRIORITY INTEGER NOT NULL,
    STATE VARCHAR(16) NOT NULL,
    JOB_NAME VARCHAR(200),
    JOB_GROUP VARCHAR(200),
    IS_NONCONCURRENT BOOLEAN,
    REQUESTS_RECOVERY BOOLEAN
);        
ALTER TABLE PUBLIC.QRTZ_FIRED_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_FIRED_TRIGGERS PRIMARY KEY(SCHED_NAME, ENTRY_ID);         
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_FIRED_TRIGGERS;      
CREATE MEMORY TABLE PUBLIC.QRTZ_PAUSED_TRIGGER_GRPS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL
);          
ALTER TABLE PUBLIC.QRTZ_PAUSED_TRIGGER_GRPS ADD CONSTRAINT PUBLIC.PK_QRTZ_PAUSED_TRIGGER_GRPS PRIMARY KEY(SCHED_NAME, TRIGGER_GROUP);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_PAUSED_TRIGGER_GRPS; 
CREATE MEMORY TABLE PUBLIC.QRTZ_SCHEDULER_STATE(
    SCHED_NAME VARCHAR(120) NOT NULL,
    INSTANCE_NAME VARCHAR(200) NOT NULL,
    LAST_CHECKIN_TIME BIGINT NOT NULL,
    CHECKIN_INTERVAL BIGINT NOT NULL
); 
ALTER TABLE PUBLIC.QRTZ_SCHEDULER_STATE ADD CONSTRAINT PUBLIC.PK_QRTZ_SCHEDULER_STATE PRIMARY KEY(SCHED_NAME, INSTANCE_NAME);  
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_SCHEDULER_STATE;     
INSERT INTO PUBLIC.QRTZ_SCHEDULER_STATE(SCHED_NAME, INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL) VALUES
('scheduler', 'sequoia1462187279169', 1462188085982, 20000);    
CREATE MEMORY TABLE PUBLIC.QRTZ_LOCKS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    LOCK_NAME VARCHAR(40) NOT NULL
);             
ALTER TABLE PUBLIC.QRTZ_LOCKS ADD CONSTRAINT PUBLIC.PK_QRTZ_LOCKS PRIMARY KEY(SCHED_NAME, LOCK_NAME);          
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_LOCKS;               
INSERT INTO PUBLIC.QRTZ_LOCKS(SCHED_NAME, LOCK_NAME) VALUES
('scheduler', 'TRIGGER_ACCESS'),
('scheduler', 'STATE_ACCESS');    
CREATE MEMORY TABLE PUBLIC.QRTZ_JOB_DETAILS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    JOB_NAME VARCHAR(200) NOT NULL,
    JOB_GROUP VARCHAR(200) NOT NULL,
    DESCRIPTION VARCHAR(250),
    JOB_CLASS_NAME VARCHAR(250) NOT NULL,
    IS_DURABLE BOOLEAN NOT NULL,
    IS_NONCONCURRENT BOOLEAN NOT NULL,
    IS_UPDATE_DATA BOOLEAN NOT NULL,
    REQUESTS_RECOVERY BOOLEAN NOT NULL,
    JOB_DATA IMAGE
); 
ALTER TABLE PUBLIC.QRTZ_JOB_DETAILS ADD CONSTRAINT PUBLIC.PK_QRTZ_JOB_DETAILS PRIMARY KEY(SCHED_NAME, JOB_NAME, JOB_GROUP);    
-- 22 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_JOB_DETAILS;        
INSERT INTO PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA) VALUES
('scheduler', 'taskJob25', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.SyncJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob20', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob26', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.SyncJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob23', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob22', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob15', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');          
INSERT INTO PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA) VALUES
('scheduler', 'taskJob4', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.SyncJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob16', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob7', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.SyncJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob24', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.SyncJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob11', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.SyncJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob9', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.SyncJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');             
INSERT INTO PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA) VALUES
('scheduler', 'taskJob13', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob5', 'DEFAULT', NULL, 'org.apache.syncope.core.quartz.SampleJob', FALSE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob12', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.SyncJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob10', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.SyncJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob21', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob19', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');           
INSERT INTO PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA) VALUES
('scheduler', 'taskJob17', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob18', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'taskJob14', 'DEFAULT', NULL, 'org.apache.syncope.core.sync.impl.PushJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800'),
('scheduler', 'reportJob1', 'DEFAULT', NULL, 'org.apache.syncope.core.report.ReportJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
CREATE MEMORY TABLE PUBLIC.QRTZ_SIMPLE_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    REPEAT_COUNT BIGINT NOT NULL,
    REPEAT_INTERVAL BIGINT NOT NULL,
    TIMES_TRIGGERED BIGINT NOT NULL
);          
ALTER TABLE PUBLIC.QRTZ_SIMPLE_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_SIMPLE_TRIGGERS PRIMARY KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);    
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_SIMPLE_TRIGGERS;     
CREATE MEMORY TABLE PUBLIC.QRTZ_SIMPROP_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    STR_PROP_1 VARCHAR(512),
    STR_PROP_2 VARCHAR(512),
    STR_PROP_3 VARCHAR(512),
    INT_PROP_1 INTEGER,
    INT_PROP_2 INTEGER,
    LONG_PROP_1 BIGINT,
    LONG_PROP_2 BIGINT,
    DEC_PROP_1 NUMERIC(13, 4),
    DEC_PROP_2 NUMERIC(13, 4),
    BOOL_PROP_1 BOOLEAN,
    BOOL_PROP_2 BOOLEAN
);              
ALTER TABLE PUBLIC.QRTZ_SIMPROP_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_SIMPROP_TRIGGERS PRIMARY KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_SIMPROP_TRIGGERS;    
CREATE MEMORY TABLE PUBLIC.QRTZ_BLOB_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    BLOB_DATA IMAGE
);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_BLOB_TRIGGERS;       
CREATE MEMORY TABLE PUBLIC.QRTZ_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    JOB_NAME VARCHAR(200) NOT NULL,
    JOB_GROUP VARCHAR(200) NOT NULL,
    DESCRIPTION VARCHAR(250),
    NEXT_FIRE_TIME BIGINT,
    PREV_FIRE_TIME BIGINT,
    PRIORITY INTEGER,
    TRIGGER_STATE VARCHAR(16) NOT NULL,
    TRIGGER_TYPE VARCHAR(8) NOT NULL,
    START_TIME BIGINT NOT NULL,
    END_TIME BIGINT,
    CALENDAR_NAME VARCHAR(200),
    MISFIRE_INSTR SMALLINT,
    JOB_DATA IMAGE
);       
ALTER TABLE PUBLIC.QRTZ_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_TRIGGERS PRIMARY KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);  
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_TRIGGERS;            
INSERT INTO PUBLIC.QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA) VALUES
('scheduler', 'Trigger_taskJob5', 'DEFAULT', 'taskJob5', 'DEFAULT', NULL, 1464732000000, -1, 5, 'WAITING', 'CRON', 1462187285000, 0, NULL, 0, X'');    
CREATE MEMORY TABLE PUBLIC.CATTR(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
); 
ALTER TABLE PUBLIC.CATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_3 PRIMARY KEY(ID);   
-- 11 +/- SELECT COUNT(*) FROM PUBLIC.CATTR;   
INSERT INTO PUBLIC.CATTR(ID, OWNER_ID, SCHEMA_NAME) VALUES
(1, 1, 'password.cipher.algorithm'),
(2, 1, 'notificationjob.cronExpression'),
(3, 1, 'notification.maxRetries'),
(4, 1, 'token.length'),
(5, 1, 'token.expireTime'),
(6, 1, 'selfRegistration.allowed'),
(7, 1, 'passwordReset.allowed'),
(8, 1, 'passwordReset.securityQuestion'),
(9, 1, 'authentication.statuses'),
(11, 1, 'log.lastlogindate'),
(12, 1, 'tasks.interruptMaxRetries');         
CREATE MEMORY TABLE PUBLIC.CATTRUNIQUEVALUE(
    ID BIGINT NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
);             
ALTER TABLE PUBLIC.CATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_BF PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CATTRUNIQUEVALUE;         
CREATE MEMORY TABLE PUBLIC.CATTRVALUE(
    ID BIGINT NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID BIGINT
); 
ALTER TABLE PUBLIC.CATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_9 PRIMARY KEY(ID);              
-- 12 +/- SELECT COUNT(*) FROM PUBLIC.CATTRVALUE;              
INSERT INTO PUBLIC.CATTRVALUE(ID, BINARYVALUE, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE, ATTRIBUTE_ID) VALUES
(1, NULL, NULL, NULL, NULL, NULL, 'SHA1', 1),
(2, NULL, NULL, NULL, NULL, NULL, '', 2),
(3, NULL, NULL, NULL, NULL, 3, NULL, 3),
(4, NULL, NULL, NULL, NULL, 256, NULL, 4),
(5, NULL, NULL, NULL, NULL, 60, NULL, 5),
(6, NULL, 1, NULL, NULL, NULL, NULL, 6),
(7, NULL, 1, NULL, NULL, NULL, NULL, 7),
(8, NULL, 1, NULL, NULL, NULL, NULL, 8),
(9, NULL, NULL, NULL, NULL, NULL, 'created', 9),
(10, NULL, NULL, NULL, NULL, NULL, 'active', 9),
(11, NULL, 1, NULL, NULL, NULL, NULL, 11),
(12, NULL, NULL, NULL, NULL, 20, NULL, 12);    
CREATE INDEX PUBLIC.CATTRVALUE_ATTRIBUTE_IDINDEX ON PUBLIC.CATTRVALUE(ATTRIBUTE_ID);           
CREATE MEMORY TABLE PUBLIC.CONNINSTANCE(
    ID BIGINT NOT NULL,
    BUNDLENAME VARCHAR(255) NOT NULL,
    CONNREQUESTTIMEOUT INTEGER,
    CONNECTORNAME VARCHAR(255) NOT NULL,
    DISPLAYNAME VARCHAR(255),
    JSONCONF CLOB,
    LOCATION VARCHAR(255) NOT NULL,
    VERSION VARCHAR(255) NOT NULL,
    MAXIDLE INTEGER,
    MAXOBJECTS INTEGER,
    MAXWAIT BIGINT,
    MINEVICTABLEIDLETIMEMILLIS BIGINT,
    MINIDLE INTEGER
);         
ALTER TABLE PUBLIC.CONNINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_E1 PRIMARY KEY(ID);           
-- 8 +/- SELECT COUNT(*) FROM PUBLIC.CONNINSTANCE;             
INSERT INTO PUBLIC.CONNINSTANCE(ID, BUNDLENAME, CONNREQUESTTIMEOUT, CONNECTORNAME, DISPLAYNAME, JSONCONF, LOCATION, VERSION, MAXIDLE, MAXOBJECTS, MAXWAIT, MINEVICTABLEIDLETIMEMILLIS, MINIDLE) VALUES
(100, 'net.tirasa.connid.bundles.soap', NULL, 'net.tirasa.connid.bundles.soap.WebServiceConnector', 'ConnInstance100', '[{"schema":{"name":"endpoint","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["http://localhost:9080/wssample/services/provisioning"]},{"schema":{"name":"servicename","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning"]}]', 'file:/home/ilgrosso/work/syncope/syncope1/core/target/bundles/', '1.3.0', NULL, NULL, NULL, NULL, NULL),
(101, 'net.tirasa.connid.bundles.db.table', NULL, 'net.tirasa.connid.bundles.db.table.DatabaseTableConnector', 'H2', '[{"schema":{"name":"disabledStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"user","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"keyColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["id"]},{"schema":{"name":"retrievePassword","displayName":null,"helpMessage":null,"type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"cipherAlgorithm","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["SHA1"]},{"schema":{"name":"enabledStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"passwordColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["password"]},{"schema":{"name":"jdbcDriver","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["org.h2.Driver"]},{"schema":{"name":"defaultStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"table","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["test"]},{"schema":{"name":"password","displayName":null,"helpMessage":null,"type":"org.identityconnectors.common.security.GuardedString","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"statusColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["status"]},{"schema":{"name":"jdbcUrlTemplate","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1"]}]', 'connid://testconnectorserver@localhost:4554', '2.2.2', NULL, NULL, NULL, NULL, NULL),
(102, 'net.tirasa.connid.bundles.soap', 10, 'net.tirasa.connid.bundles.soap.WebServiceConnector', 'ConnInstance102', '[{"schema":{"name":"servicename","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning"]},{"schema":{"name":"endpoint","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":true,"values":["http://localhost:9080/wssample/services/provisioning"]}]', 'file:/home/ilgrosso/work/syncope/syncope1/core/target/bundles/', '1.3.0', NULL, NULL, NULL, NULL, NULL);   
INSERT INTO PUBLIC.CONNINSTANCE(ID, BUNDLENAME, CONNREQUESTTIMEOUT, CONNECTORNAME, DISPLAYNAME, JSONCONF, LOCATION, VERSION, MAXIDLE, MAXOBJECTS, MAXWAIT, MINEVICTABLEIDLETIMEMILLIS, MINIDLE) VALUES
(103, 'net.tirasa.connid.bundles.soap', NULL, 'net.tirasa.connid.bundles.soap.WebServiceConnector', 'ConnInstance103', '[{"schema":{"name":"endpoint","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["http://localhost:9080/wssample/services/provisioning"]},{"schema":{"name":"servicename","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning"]}]', 'file:/home/ilgrosso/work/syncope/syncope1/core/target/bundles/', '1.3.0', NULL, NULL, NULL, NULL, NULL),
(104, 'net.tirasa.connid.bundles.csvdir', NULL, 'net.tirasa.connid.bundles.csvdir.CSVDirConnector', 'CSVDir', '[{"schema":{"name":"fields","displayName":"fields","helpMessage":"Column names separated by comma","type":"[Ljava.lang.String;","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["id","name","surname","email","password","role","membership","status","deleted"]},{"schema":{"name":"keyColumnNames","displayName":"Key column name","helpMessage":"Name of the column used to identify user uniquely","type":"[Ljava.lang.String;","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["name","surname"]},{"schema":{"name":"deleteColumnName","displayName":"Delete column name","helpMessage":"Name of the column used to specify users to be deleted","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["deleted"]},{"schema":{"name":"passwordColumnName","displayName":"Password column name","helpMessage":"Name of the column used to specify user password","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["password"]},{"schema":{"name":"keyseparator","displayName":"Key separator","helpMessage":"Character used to separate keys in a multi-key scenario","type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[","]},{"schema":{"name":"ignoreHeader","displayName":"Ignore header","helpMessage":"Specify it first line file must be ignored","type":"java.lang.Boolean","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[false]},{"schema":{"name":"fieldDelimiter","displayName":"fieldDelimiter","helpMessage":"fieldDelimiter","type":"char","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[","]},{"schema":{"name":"quotationRequired","displayName":"Value quotation required","helpMessage":"Specify if value quotation is required","type":"java.lang.Boolean","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[false]},{"schema":{"name":"statusColumn","displayName":"statusColumn","helpMessage":"Status column","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["status"]},{"schema":{"name":"sourcePath","displayName":"Source path","helpMessage":"Absolute path of a directory where are located CSV files to be processed","type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope1/core/target/test-csvdir"]},{"schema":{"name":"fileMask","displayName":"File mask","helpMessage":"Regular expression describing files to be processed","type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["test.csv"]}]', 'file:/home/ilgrosso/work/syncope/syncope1/core/target/bundles/', '0.8.4', NULL, NULL, NULL, NULL, NULL);           
CREATE TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT NOT NULL, PART INT NOT NULL, CDATA VARCHAR, BDATA BINARY); 
CREATE PRIMARY KEY SYSTEM_LOB_STREAM_PRIMARY_KEY ON SYSTEM_LOB_STREAM(ID, PART);               
CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR "org.h2.command.dml.ScriptCommand.combineClob";             
CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR "org.h2.command.dml.ScriptCommand.combineBlob";             
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 0, '[{"schema":{"name":"synchronizePasswords","displayName":"Enable Password Synchronization","helpMessage":"If true, the connector will synchronize passwords. The Password Capture Plugin needs to be installed for password synchronization to work.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"maintainLdapGroupMembership","displayName":"Maintain LDAP Group Membership","helpMessage":"When enabled and a user is renamed or deleted, update any LDAP groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"host","displayName":"Host","helpMessage":"The name or IP address of the host where the LDAP server is running.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["localhost"]},{"schema":{"name":"passwordHashAlgorithm","displayName":"Password Hash Algorithm","helpMessage":"Indicates the algorithm that the Identity system should use to hash the password. Currently supported values are SSHA, SHA, SSHA1, and SHA1. A blank value indicates that the system will not hash passwords. This will cause cleartext passwords to be stored in LDAP unless the LDAP server performs the hash (Netscape Directory Server and iPlanet Directory Server do).","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["SHA"]},{"schema":{"name":"blockSize","displayName":"Block Size","helpMessage":"The maximum number of accounts that can be in a block when retrieving accounts in blocks.","type":"int","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"useBlocks","displayName":"Use Blocks","helpMessage":"When performing operations on large numbers of accounts, the accounts are processed in blocks to reduce the amount of memory used by the operation. Select this option to process accounts in blocks.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[false]},{"schema":{"name":"usePagedResultControl","displayName":"Use Paged Result Control","helpMessage":"When enabled, the LDAP Paged Results control is preferred over the VLV control when retrieving accounts.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"port","displayName":"TCP Port","helpMessage":"TCP/IP port number used to communicate with the LDAP server.","type":"int","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[1389]},{"schema":{"name":"vlvSortAttribute","displayName":"VLV Sort Attribute","helpMessage":"Specify the sort attribute to use for VLV indexes on the resource.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"statusManagementClass","displayName":"Status management class ","helpMessage":"Class to be used to manage enabled/disabled status. If no class is specified then identity status management wont be possible.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["net.tirasa.connid.bundles.ldap.commons.AttributeStatusManagement"]},{"schema":{"name":"accountObjectClasses","displayName":"Account Object Classes","helpMessage":"The object class or classes that will be used when creating new user objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some object classes may require that you specify all object classes in the class hierarchy.","type":"', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 1, '[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["inetOrgPerson"]},{"schema":{"name":"accountUserNameAttributes","displayName":"Account User Name Attributes","helpMessage":"Attribute or attributes which holds the account user name. They will be used when authenticating to find the LDAP entry for the user name to authenticate.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["uid"]},{"schema":{"name":"baseContextsToSynchronize","displayName":"Base Contexts to Synchronize","helpMessage":"One or more starting points in the LDAP tree that will be used to determine if a change should be synchronized. The base contexts attribute will be used to synchronize a change if this property is not set.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["ou=people,o=isp","ou=groups,o=isp"]},{"schema":{"name":"accountSynchronizationFilter","displayName":"LDAP Filter for Accounts to Synchronize","helpMessage":"An optional LDAP filter for the objects to synchronize. Because the change log is for all objects, this filter updates only objects that match the specified filter. If you specify a filter, an object will be synchronized only if it matches the filter and includes a synchronized object class.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"removeLogEntryObjectClassFromFilter","displayName":"Remove Log Entry Object Class from Filter","helpMessage":"If this property is set (the default), the filter used to fetch change log entries does not contain the \"changeLogEntry\" object class, expecting that there are no entries of other object types in the change log.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"passwordDecryptionKey","displayName":"Password Decryption Key","helpMessage":"The key to decrypt passwords with when performing password synchronization.","type":"org.identityconnectors.common.security.GuardedByteArray","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"readSchema","displayName":"Read Schema","helpMessage":"If true, the connector will read the schema from the server. If false, the connector will provide a default schema based on the object classes in the configuration. This property must be true in order to use extended object classes.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"ssl","displayName":"SSL","helpMessage":"Select the check box to connect to the LDAP server using SSL.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"passwordAttributeToSynchronize","displayName":"Password Attribute to Synchronize","helpMessage":"The name of the password attribute to synchronize when performing password synchronization.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"accountSearchFilter","displayName":"LDAP Filter for Retrieving Accounts","helpMessage":"An optional LDAP filter to control which accounts are returned from the LDAP resource. If no filter is specified, only accounts that include all specified object classes are returned.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["uid=*"]},{"schema":{"name":"passwordDecryptionInitializationVector","displayName":"Password Decryption Initialization Vector","helpMessage":"The initialization vector to decrypt passwords with when performing password synchronization.","type":"org.identityconnectors.common.securit', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 2, 'y.GuardedByteArray","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"groupMemberAttribute","displayName":"Group Member Attribute","helpMessage":"The name of the group attribute that will be updated with the distinguished name of the user when the user is added to the group.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"failover","displayName":"Failover Servers","helpMessage":"List all servers that should be used for failover in case the preferred server fails. If the preferred server fails, JNDI will connect to the next available server in the list. List all servers in the form of \"ldap://ldap.example.com:389/\", which follows the standard LDAP v3 URLs described in RFC 2255. Only the host and port parts of the URL are relevant in this setting.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"modifiersNamesToFilterOut","displayName":"Filter Out Changes By","helpMessage":"The names (DNs) of directory administrators to filter from the changes. Changes with the attribute \"modifiersName\" that match entries in this list will be filtered out. The standard value is the administrator name used by this adapter, to prevent loops. Entries should be of the format \"cn=Directory Manager\".","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"groupNameAttributes","displayName":"Group Name Attributes","helpMessage":"Attribute or attributes which holds the group name.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["cn"]},{"schema":{"name":"uidAttribute","displayName":"Uid Attribute","helpMessage":"The name of the LDAP attribute which is mapped to the Uid attribute.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["cn"]},{"schema":{"name":"respectResourcePasswordPolicyChangeAfterReset","displayName":"Respect Resource Password Policy Change-After-Reset","helpMessage":"When this resource is specified in a Login Module (i.e., this resource is a pass-through authentication target) and the resource password policy is configured for change-after-reset, a user whose resource account password has been administratively reset will be required to change that password after successfully authenticating.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"filterWithOrInsteadOfAnd","displayName":"Filter with Or Instead of And","helpMessage":"Normally the the filter used to fetch change log entries is an and-based filter retrieving an interval of change entries. If this property is set, the filter will or together the required change numbers instead.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"principal","displayName":"Principal","helpMessage":"The distinguished name with which to authenticate to the LDAP server.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["uid=admin,ou=system"]},{"schema":{"name":"changeLogBlockSize","displayName":"Change Log Block Size","helpMessage":"The number of change log entries to fetch per query.","type":"int","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[100]},{"schema":{"name":"baseContexts","displayName":"Base Contexts","helpMessage":"One or more starting points in the LDAP tree that will be used when searching the tree. Searches are performed when discovering users from the LDAP server or when looking for the groups of which a user is a member.","type":"[Ljava.lang.', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 3, 'String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["ou=people,o=isp","ou=groups,o=isp"]},{"schema":{"name":"passwordAttribute","displayName":"Password Attribute","helpMessage":"The name of the LDAP attribute which holds the password. When changing an user password, the new password is set to this attribute.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["userpassword"]},{"schema":{"name":"changeNumberAttribute","displayName":"Change Number Attribute","helpMessage":"The name of the change number attribute in the change log entry.","type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["changeNumber"]},{"schema":{"name":"objectClassesToSynchronize","displayName":"Object Classes to Synchronize","helpMessage":"The object classes to synchronize. The change log is for all objects; this filters updates to just the listed object classes. You should not list the superclasses of an object class unless you intend to synchronize objects with any of the superclass values. For example, if only \"inetOrgPerson\" objects should be synchronized, but the superclasses of \"inetOrgPerson\" (\"person\", \"organizationalperson\" and \"top\") should be filtered out, then list only \"inetOrgPerson\" here. All objects in LDAP are subclassed from \"top\". For this reason, you should never list \"top\", otherwise no object would be filtered.","type":"[Ljava.lang.String;","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["inetOrgPerson","groupOfUniqueNames"]},{"schema":{"name":"credentials","displayName":"Password","helpMessage":"Password for the principal.","type":"org.identityconnectors.common.security.GuardedString","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["secret"]},{"schema":{"name":"attributesToSynchronize","displayName":"Attributes to Synchronize","helpMessage":"The names of the attributes to synchronize. This ignores updates from the change log if they do not update any of the named attributes. For example, if only \"department\" is listed, then only changes that affect \"department\" will be processed. All other updates are ignored. If blank (the default), then all changes are processed.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"maintainPosixGroupMembership","displayName":"Maintain POSIX Group Membership","helpMessage":"When enabled and a user is renamed or deleted, update any POSIX groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["truemaintainLdapGroupMembership"]}]', NULL);        
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 0, '[{"schema":{"name":"changeLogColumn","displayName":"Change Log Column (Sync)","helpMessage":"=<b>Change Log Column</b><br>The change log column store the latest change time. Providing this value the Sync capabilities are activated.","type":"java.lang.String","required":false,"order":21,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"nativeTimestamps","displayName":"Native Timestamps ","helpMessage":"<b>Native Timestamps</b><br>Select to retrieve Timestamp data type of the columns in java.sql.Timestamp format from the database table.","type":"boolean","required":false,"order":18,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"cipherAlgorithm","displayName":"Password cipher algorithm (defaults to CLEARTEXT)","helpMessage":"Cipher algorithm used to encode password before to store it onto the database table.\nSpecify one of the values among CLEARTEXT,AES, MD5, SHA1, SHA256 or a custom implementation identified by its class name.","type":"java.lang.String","required":false,"order":24,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"enabledStatusValue","displayName":"Enabled Status Value","helpMessage":"<b>Enabled Status Value</b><br>Enter the value for enabled status.","type":"java.lang.String","required":false,"order":12,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"retrievePassword","displayName":"Retrieve password","helpMessage":"Specify if password must be retrieved by default.","type":"boolean","required":true,"order":27,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"datasource","displayName":"Datasource Path","helpMessage":"<b>JDBC Data Source Name/Path</b><br>Enter the JDBC Data Source Name/Path to connect to the Oracle server. If specified, connector will only try to connect using Datasource and ignore other resource parameters specified.<br>the example value is: <CODE>jdbc/SampleDataSourceName</CODE>","type":"java.lang.String","required":false,"order":22,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"allNative","displayName":"All native","helpMessage":"<b>All native</b><br>Select to retrieve all data type of the columns in a native format from the database table.","type":"boolean","required":false,"order":19,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"user","displayName":"User","helpMessage":"<b>User</b><br>Enter the name of the mandatory Database user with permission to account table.","type":"java.lang.String","required":false,"order":4,"confidential":false,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"pwdEncodeToLowerCase","displayName":"Force password encoding to lower case","helpMessage":"Force password encoding to lower case.","type":"boolean","required":false,"order":26,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"jdbcUrlTemplate","displayName":"JDBC Connection URL","helpMessage":"<b>JDBC Connection URL</b><br>Specify the JDBC Driver Connection URL.<br> Oracle template is jdbc:oracle:thin:@[host]:[port(1521)]:[DB].<br>  MySQL template is jdbc:mysql://[host]:[port(3306)]/[db], for more info, read the JDBC driver documentation.<br>Could be empty if datasource is provided.","type":"java.lang.String","required":false,"order":15,"confidential":false,"defaultValues":null},"overridable":false,"values":["jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1"]},{"schema":{"name":"keyColumn","displayName":"Key Column","helpMessage":"<b>Key Column</b><br>This mandatory column value will be used as the unique identifier for rows in the table.<br>","type":"java.lang.String","required":true,"order":8,"confidential":false,"defaultValues":null},"overridable":false,"values":["id"]},{"schema":{"name":"validConnectionQuery","displayName":"Validate Connection Query","helpMessage":"<b>Vali', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 1, 'date Connection Query</b><br>There can be specified the check connection alive query. If empty, default implementation will test it using the switch on/off the autocommit. Some select 1 from dummy table could be more efficient.","type":"java.lang.String","required":false,"order":20,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"rethrowAllSQLExceptions","displayName":"Rethrow all SQLExceptions","helpMessage":"If this is not checked, SQL statements which throw SQLExceptions with a 0 ErrorCode will be have the exception caught and suppressed. Check it to have exceptions with 0 ErrorCodes rethrown.","type":"boolean","required":false,"order":17,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"passwordColumn","displayName":"Password Column","helpMessage":"<b>Password Column</b><br>Enter the name of the column in the table that will hold the password values. If empty, no validation on resource and passwords are activated.","type":"java.lang.String","required":false,"order":9,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"jndiProperties","displayName":"Initial JNDI Properties","helpMessage":"<b>Initial JNDI Properties</b><br>Could be empty or enter the JDBC JNDI Initial context factory, context provider in a format: key = value.","type":"[Ljava.lang.String;","required":false,"order":23,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"password","displayName":"User Password","helpMessage":"<b>User Password</b><br>Enter a user account that has permission to access accounts table.","type":"org.identityconnectors.common.security.GuardedString","required":false,"order":5,"confidential":true,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"host","displayName":"Host","helpMessage":"<b>Host</b><br>Enter the name of the host where the database is running.","type":"java.lang.String","required":false,"order":2,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"port","displayName":"Port","helpMessage":"<b>TCP Port</b><br>Enter the port number the database server is listening on.","type":"java.lang.String","required":false,"order":3,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"statusColumn","displayName":"Status Column","helpMessage":"<b>Status Column</b><br>Enter the name of the column in the table that will hold the status values. If empty enabled and disabled operation wont be performed.","type":"java.lang.String","required":false,"order":10,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"pwdEncodeToUpperCase","displayName":"Force password encoding to upper case","helpMessage":"Force password encoding to upper case.","type":"boolean","required":false,"order":25,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"enableEmptyString","displayName":"Enable writing empty string","helpMessage":"<b>Enable writing empty string</b><br>Select to enable support for writing an empty strings, instead of a NULL value, in character based columns defined as not-null in the table schema. This option does not influence the way strings are written for Oracle based tables. By default empty strings are written as a NULL value.","type":"boolean","required":false,"order":16,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"database","displayName":"Database","helpMessage":"<b>Database</b><br>Enter the name of the database on the database server that contains the table.","type":"java.lang.String","required":false,"order":6,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"defaultStatusValue","displayName":"Default Status Value","helpMessage":"<b>Default Status Value</b><br>Enter the value for status in case of status not specified.","type":"java.lang.String","re', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 2, 'quired":false,"order":13,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"table","displayName":"Table","helpMessage":"<b>Table</b><br>Enter the name of the table in the database that contains the accounts.","type":"java.lang.String","required":true,"order":7,"confidential":false,"defaultValues":null},"overridable":false,"values":["testsync"]},{"schema":{"name":"disabledStatusValue","displayName":"Disabled Status Value","helpMessage":"<b>Disabled Status Value</b><br>Enter the value for disabled status.","type":"java.lang.String","required":false,"order":11,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"jdbcDriver","displayName":"JDBC Driver","helpMessage":"<b>JDBC Driver</b><br>Specify the JDBC Driver class name. Oracle is oracle.jdbc.driver.OracleDriver. MySQL is org.gjt.mm.mysql.Driver.<br>Could be empty if datasource is provided.","type":"java.lang.String","required":false,"order":14,"confidential":false,"defaultValues":null},"overridable":false,"values":["org.h2.Driver"]},{"schema":{"name":"quoting","displayName":"Name Quoting","helpMessage":"<b>Name Quoting</b><br>Select whether database column names for this resource should be quoted, and the quoting characters. By default, database column names are not quoted (None). For other selections (Single, Double, Back, or Brackets), column names will appear between single quotes, double quotes, back quotes, or brackets in the SQL generated to access the database.","type":"java.lang.String","required":false,"order":1,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"cipherKey","displayName":"Password cipher key","helpMessage":"Specify key in case of reversible algorithm.","type":"java.lang.String","required":false,"order":25,"confidential":false,"defaultValues":null},"overridable":false,"values":[]}]', NULL);               
INSERT INTO PUBLIC.CONNINSTANCE(ID, BUNDLENAME, CONNREQUESTTIMEOUT, CONNECTORNAME, DISPLAYNAME, JSONCONF, LOCATION, VERSION, MAXIDLE, MAXOBJECTS, MAXWAIT, MINEVICTABLEIDLETIMEMILLIS, MINIDLE) VALUES
(105, 'net.tirasa.connid.bundles.ldap', NULL, 'net.tirasa.connid.bundles.ldap.LdapConnector', 'ApacheDS', SYSTEM_COMBINE_CLOB(0), 'file:/home/ilgrosso/work/syncope/syncope1/core/target/bundles/', '1.4.1', NULL, NULL, NULL, NULL, NULL),
(106, 'net.tirasa.connid.bundles.db.table', NULL, 'net.tirasa.connid.bundles.db.table.DatabaseTableConnector', 'H2-test2', '[{"schema":{"name":"disabledStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"user","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"keyColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["id"]},{"schema":{"name":"cipherAlgorithm","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["SHA1"]},{"schema":{"name":"enabledStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"passwordColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["password"]},{"schema":{"name":"jdbcDriver","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["org.h2.Driver"]},{"schema":{"name":"retrievePassword","displayName":null,"helpMessage":null,"type":"java.lang.Boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"defaultStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"password","displayName":null,"helpMessage":null,"type":"org.identityconnectors.common.security.GuardedString","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"statusColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["status"]},{"schema":{"name":"jdbcUrlTemplate","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1"]},{"schema":{"name":"table","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["test2"]}]', 'connid://testconnectorserver@localhost:4554', '2.2.2', NULL, NULL, NULL, NULL, NULL),
(107, 'net.tirasa.connid.bundles.db.table', NULL, 'net.tirasa.connid.bundles.db.table.DatabaseTableConnector', 'H2-testsync', SYSTEM_COMBINE_CLOB(1), 'connid://testconnectorserver@localhost:4554', '2.2.2', NULL, NULL, NULL, NULL, NULL);          
CREATE MEMORY TABLE PUBLIC.CONNINSTANCE_CAPABILITIES(
    CONNINSTANCE_ID BIGINT,
    CAPABILITIES VARCHAR(20)
);              
-- 46 +/- SELECT COUNT(*) FROM PUBLIC.CONNINSTANCE_CAPABILITIES;               
INSERT INTO PUBLIC.CONNINSTANCE_CAPABILITIES(CONNINSTANCE_ID, CAPABILITIES) VALUES
(100, 'ONE_PHASE_CREATE'),
(100, 'ONE_PHASE_UPDATE'),
(100, 'ONE_PHASE_DELETE'),
(100, 'TWO_PHASES_CREATE'),
(100, 'TWO_PHASES_UPDATE'),
(100, 'TWO_PHASES_DELETE'),
(100, 'SEARCH'),
(101, 'AUTHENTICATE'),
(101, 'ONE_PHASE_CREATE'),
(101, 'ONE_PHASE_UPDATE'),
(101, 'ONE_PHASE_DELETE'),
(101, 'TWO_PHASES_CREATE'),
(101, 'TWO_PHASES_UPDATE'),
(101, 'TWO_PHASES_DELETE'),
(101, 'SEARCH'),
(101, 'SYNC'),
(102, 'ONE_PHASE_CREATE'),
(102, 'ONE_PHASE_UPDATE'),
(102, 'ONE_PHASE_DELETE'),
(102, 'TWO_PHASES_CREATE'),
(102, 'TWO_PHASES_UPDATE'),
(102, 'TWO_PHASES_DELETE'),
(102, 'SEARCH'),
(104, 'ONE_PHASE_CREATE'),
(104, 'ONE_PHASE_UPDATE'),
(104, 'ONE_PHASE_DELETE'),
(104, 'TWO_PHASES_CREATE'),
(104, 'TWO_PHASES_UPDATE'),
(104, 'TWO_PHASES_DELETE'),
(104, 'SEARCH'),
(104, 'SYNC'),
(105, 'ONE_PHASE_CREATE'),
(105, 'ONE_PHASE_UPDATE'),
(105, 'ONE_PHASE_DELETE'),
(105, 'SEARCH'),
(106, 'ONE_PHASE_CREATE'),
(106, 'ONE_PHASE_UPDATE'),
(106, 'SEARCH'),
(106, 'SYNC'),
(107, 'ONE_PHASE_CREATE'),
(107, 'TWO_PHASES_CREATE'),
(107, 'ONE_PHASE_UPDATE'),
(107, 'TWO_PHASES_UPDATE'),
(107, 'ONE_PHASE_DELETE'),
(107, 'TWO_PHASES_DELETE'),
(107, 'SEARCH');  
CREATE MEMORY TABLE PUBLIC.CSCHEMA(
    NAME VARCHAR(255) NOT NULL,
    CIPHERALGORITHM VARCHAR(20),
    CONVERSIONPATTERN VARCHAR(255),
    ENUMERATIONKEYS CLOB,
    ENUMERATIONVALUES CLOB,
    MANDATORYCONDITION VARCHAR(255) NOT NULL,
    MIMETYPE VARCHAR(255),
    MULTIVALUE INTEGER,
    READONLY INTEGER,
    SECRETKEY VARCHAR(255),
    TYPE VARCHAR(20) NOT NULL,
    UNIQUECONSTRAINT INTEGER,
    VALIDATORCLASS VARCHAR(255)
);              
ALTER TABLE PUBLIC.CSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_69 PRIMARY KEY(NAME);              
-- 17 +/- SELECT COUNT(*) FROM PUBLIC.CSCHEMA; 
INSERT INTO PUBLIC.CSCHEMA(NAME, CIPHERALGORITHM, CONVERSIONPATTERN, ENUMERATIONKEYS, ENUMERATIONVALUES, MANDATORYCONDITION, MIMETYPE, MULTIVALUE, READONLY, SECRETKEY, TYPE, UNIQUECONSTRAINT, VALIDATORCLASS) VALUES
('password.cipher.algorithm', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'String', 0, NULL),
('notificationjob.cronExpression', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL),
('notification.maxRetries', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Long', 0, NULL),
('token.length', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Long', 0, NULL),
('token.expireTime', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Long', 0, NULL),
('selfRegistration.allowed', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Boolean', 0, NULL),
('passwordReset.allowed', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Boolean', 0, NULL),
('passwordReset.securityQuestion', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Boolean', 0, NULL),
('authentication.statuses', NULL, NULL, NULL, NULL, 'true', NULL, 1, 0, NULL, 'String', 0, NULL),
('log.lastlogindate', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Boolean', 0, NULL),
('tasks.interruptMaxRetries', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Long', 0, NULL),
('admin.user.layout', NULL, NULL, NULL, NULL, 'false', NULL, 1, 0, NULL, 'String', 0, NULL),
('self.user.layout', NULL, NULL, NULL, NULL, 'false', NULL, 1, 0, NULL, 'String', 0, NULL),
('admin.role.layout', NULL, NULL, NULL, NULL, 'false', NULL, 1, 0, NULL, 'String', 0, NULL),
('self.role.layout', NULL, NULL, NULL, NULL, 'false', NULL, 1, 0, NULL, 'String', 0, NULL),
('admin.membership.layout', NULL, NULL, NULL, NULL, 'false', NULL, 1, 0, NULL, 'String', 0, NULL),
('self.membership.layout', NULL, NULL, NULL, NULL, 'false', NULL, 1, 0, NULL, 'String', 0, NULL);      
CREATE MEMORY TABLE PUBLIC.ENTITLEMENT(
    NAME VARCHAR(255) NOT NULL,
    DESCRIPTION VARCHAR(255)
);        
ALTER TABLE PUBLIC.ENTITLEMENT ADD CONSTRAINT PUBLIC.CONSTRAINT_B6 PRIMARY KEY(NAME);          
-- 86 +/- SELECT COUNT(*) FROM PUBLIC.ENTITLEMENT;             
INSERT INTO PUBLIC.ENTITLEMENT(NAME, DESCRIPTION) VALUES
('base', NULL),
('advanced', 'Advanced entitlement'),
('SCHEMA_LIST', NULL),
('SCHEMA_CREATE', NULL),
('SCHEMA_READ', NULL),
('SCHEMA_UPDATE', NULL),
('SCHEMA_DELETE', NULL),
('USER_LIST', NULL),
('USER_CREATE', NULL),
('USER_READ', NULL),
('USER_UPDATE', NULL),
('USER_DELETE', NULL),
('USER_VIEW', NULL),
('ROLE_LIST', NULL),
('ROLE_CREATE', NULL),
('ROLE_READ', NULL),
('ROLE_UPDATE', NULL),
('ROLE_DELETE', NULL),
('RESOURCE_LIST', NULL),
('RESOURCE_CREATE', NULL),
('RESOURCE_READ', NULL),
('RESOURCE_UPDATE', NULL),
('RESOURCE_DELETE', NULL),
('RESOURCE_GETCONNECTOROBJECT', NULL),
('CONNECTOR_LIST', NULL),
('CONNECTOR_CREATE', NULL),
('CONNECTOR_READ', NULL),
('CONNECTOR_UPDATE', NULL),
('CONNECTOR_DELETE', NULL),
('CONNECTOR_RELOAD', NULL),
('CONFIGURATION_EXPORT', NULL),
('CONFIGURATION_LIST', NULL),
('CONFIGURATION_SET', NULL),
('CONFIGURATION_DELETE', NULL),
('TASK_LIST', NULL),
('TASK_CREATE', NULL),
('TASK_READ', NULL),
('TASK_UPDATE', NULL),
('TASK_DELETE', NULL),
('TASK_EXECUTE', NULL),
('POLICY_LIST', NULL),
('POLICY_CREATE', NULL),
('POLICY_READ', NULL),
('POLICY_UPDATE', NULL),
('POLICY_DELETE', NULL),
('WORKFLOW_DEF_READ', NULL),
('WORKFLOW_DEF_UPDATE', NULL),
('WORKFLOW_TASK_LIST', NULL),
('WORKFLOW_FORM_LIST', NULL),
('WORKFLOW_FORM_READ', NULL),
('WORKFLOW_FORM_CLAIM', NULL),
('WORKFLOW_FORM_SUBMIT', NULL),
('NOTIFICATION_LIST', NULL),
('NOTIFICATION_CREATE', NULL),
('NOTIFICATION_READ', NULL),
('NOTIFICATION_UPDATE', NULL),
('NOTIFICATION_DELETE', NULL),
('REPORT_LIST', NULL),
('REPORT_READ', NULL),
('REPORT_CREATE', NULL),
('REPORT_UPDATE', NULL),
('REPORT_DELETE', NULL),
('REPORT_EXECUTE', NULL),
('LOG_LIST', NULL),
('LOG_SET_LEVEL', NULL),
('LOG_DELETE', NULL),
('AUDIT_LIST', NULL),
('AUDIT_ENABLE', NULL),
('AUDIT_DISABLE', NULL),
('SECURITY_QUESTION_CREATE', NULL),
('SECURITY_QUESTION_UPDATE', NULL),
('SECURITY_QUESTION_DELETE', NULL),
('ROLE_1', NULL),
('ROLE_2', NULL),
('ROLE_3', NULL),
('ROLE_4', NULL),
('ROLE_5', NULL),
('ROLE_6', NULL),
('ROLE_7', NULL),
('ROLE_8', NULL),
('ROLE_9', NULL),
('ROLE_10', NULL),
('ROLE_11', NULL),
('ROLE_12', NULL),
('ROLE_13', NULL),
('ROLE_14', NULL);      
CREATE MEMORY TABLE PUBLIC.EXTERNALRESOURCE(
    NAME VARCHAR(255) NOT NULL,
    CREATIONDATE TIMESTAMP NOT NULL,
    CREATOR VARCHAR(255) NOT NULL,
    LASTCHANGEDATE TIMESTAMP NOT NULL,
    LASTMODIFIER VARCHAR(255) NOT NULL,
    CREATETRACELEVEL VARCHAR(20) NOT NULL,
    DELETETRACELEVEL VARCHAR(20) NOT NULL,
    ENFORCEMANDATORYCONDITION INTEGER NOT NULL,
    JSONCONF CLOB,
    PROPAGATIONMODE VARCHAR(20) NOT NULL,
    PROPAGATIONPRIMARY INTEGER NOT NULL,
    PROPAGATIONPRIORITY INTEGER NOT NULL,
    RANDOMPWDIFNOTPROVIDED INTEGER NOT NULL,
    RSERIALIZEDSYNCTOKEN CLOB,
    SYNCTRACELEVEL VARCHAR(20) NOT NULL,
    UPDATETRACELEVEL VARCHAR(20) NOT NULL,
    USERIALIZEDSYNCTOKEN CLOB,
    ACCOUNTPOLICY_ID BIGINT,
    CONNECTOR_ID BIGINT,
    PASSWORDPOLICY_ID BIGINT,
    SYNCPOLICY_ID BIGINT
);       
ALTER TABLE PUBLIC.EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_FB PRIMARY KEY(NAME);     
-- 18 +/- SELECT COUNT(*) FROM PUBLIC.EXTERNALRESOURCE;        
INSERT INTO PUBLIC.EXTERNALRESOURCE(NAME, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, CREATETRACELEVEL, DELETETRACELEVEL, ENFORCEMANDATORYCONDITION, JSONCONF, PROPAGATIONMODE, PROPAGATIONPRIMARY, PROPAGATIONPRIORITY, RANDOMPWDIFNOTPROVIDED, RSERIALIZEDSYNCTOKEN, SYNCTRACELEVEL, UPDATETRACELEVEL, USERIALIZEDSYNCTOKEN, ACCOUNTPOLICY_ID, CONNECTOR_ID, PASSWORDPOLICY_ID, SYNCPOLICY_ID) VALUES
('ws-target-resource-1', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 0, NULL, 'TWO_PHASES', 1, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 100, NULL, NULL),
('ws-target-resource-2', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'FAILURES', 'NONE', 1, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 100, NULL, 9),
('ws-target-resource-timeout', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'FAILURES', 'NONE', 1, '[{"schema":{"name":"endpoint","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":true,"values":["http://localhost:9080/syncope-build-tools/services/provisioning"]}]', 'TWO_PHASES', 1, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 102, NULL, NULL),
('ws-target-resource-list-mappings-1', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 0, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 100, NULL, NULL),
('ws-target-resource-list-mappings-2', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 1, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 100, NULL, NULL),
('ws-target-resource-delete', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 0, NULL, 'TWO_PHASES', 0, 2, 0, NULL, 'ALL', 'ALL', NULL, NULL, 102, NULL, NULL),
('ws-target-resource-update', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 1, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 100, NULL, NULL),
('resource-testdb', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 1, NULL, 'ONE_PHASE', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 101, NULL, NULL),
('resource-testdb2', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 1, NULL, 'ONE_PHASE', 0, 0, 1, NULL, 'ALL', 'ALL', NULL, NULL, 106, NULL, NULL),
('resource-csv', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 0, NULL, 'ONE_PHASE', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 104, NULL, 3),
('ws-target-resource-update-resetsynctoken', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 1, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', '{"value":null}', NULL, 100, NULL, NULL),
('resource-ldap', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 1, NULL, 'ONE_PHASE', 1, 0, 1, NULL, 'ALL', 'ALL', NULL, NULL, 105, NULL, NULL),
('ws-target-resource-nopropagation', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 1, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 103, 4, NULL),
('ws-target-resource-nopropagation2', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 1, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 103, NULL, NULL),
('ws-target-resource-nopropagation3', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 1, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 103, NULL, NULL),
('ws-target-resource-nopropagation4', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 1, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 103, NULL, NULL);       
INSERT INTO PUBLIC.EXTERNALRESOURCE(NAME, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, CREATETRACELEVEL, DELETETRACELEVEL, ENFORCEMANDATORYCONDITION, JSONCONF, PROPAGATIONMODE, PROPAGATIONPRIMARY, PROPAGATIONPRIORITY, RANDOMPWDIFNOTPROVIDED, RSERIALIZEDSYNCTOKEN, SYNCTRACELEVEL, UPDATETRACELEVEL, USERIALIZEDSYNCTOKEN, ACCOUNTPOLICY_ID, CONNECTOR_ID, PASSWORDPOLICY_ID, SYNCPOLICY_ID) VALUES
('resource-db-sync', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 0, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 107, NULL, NULL),
('resource-db-virattr', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 'ALL', 'ALL', 0, NULL, 'TWO_PHASES', 0, 0, 0, NULL, 'ALL', 'ALL', NULL, NULL, 107, NULL, NULL);  
CREATE MEMORY TABLE PUBLIC.EXTERNALRESOURCE_PROPACTIONS(
    EXTERNALRESOURCE_NAME VARCHAR(255),
    ELEMENT VARCHAR(255)
);   
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.EXTERNALRESOURCE_PROPACTIONS;             
INSERT INTO PUBLIC.EXTERNALRESOURCE_PROPACTIONS(EXTERNALRESOURCE_NAME, ELEMENT) VALUES
('resource-ldap', 'org.apache.syncope.core.propagation.impl.LDAPMembershipPropagationActions');         
CREATE MEMORY TABLE PUBLIC.MATTR(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    TEMPLATE_ID BIGINT NOT NULL
);              
ALTER TABLE PUBLIC.MATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_45 PRIMARY KEY(ID);  
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.MATTR;    
INSERT INTO PUBLIC.MATTR(ID, OWNER_ID, TEMPLATE_ID) VALUES
(100, 4, 100),
(102, 1, 102),
(103, 1, 103);        
CREATE INDEX PUBLIC.MATTR_TEMPLATE_IDINDEX ON PUBLIC.MATTR(TEMPLATE_ID);       
CREATE INDEX PUBLIC.MATTR_OWNER_ID_INDEX ON PUBLIC.MATTR(OWNER_ID);            
CREATE MEMORY TABLE PUBLIC.MATTRTEMPLATE(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
);         
ALTER TABLE PUBLIC.MATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_12 PRIMARY KEY(ID);          
-- 7 +/- SELECT COUNT(*) FROM PUBLIC.MATTRTEMPLATE;            
INSERT INTO PUBLIC.MATTRTEMPLATE(ID, OWNER_ID, SCHEMA_NAME) VALUES
(98, 1, 'mderived_sx'),
(99, 1, 'mderived_dx'),
(100, 7, 'subscriptionDate'),
(101, 8, 'subscriptionDate'),
(102, 1, 'mderived_sx'),
(103, 1, 'mderived_dx'),
(104, 12, 'postalAddress');   
CREATE MEMORY TABLE PUBLIC.MATTRUNIQUEVALUE(
    ID BIGINT NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
);             
ALTER TABLE PUBLIC.MATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_8F PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.MATTRUNIQUEVALUE;         
CREATE MEMORY TABLE PUBLIC.MATTRVALUE(
    ID BIGINT NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID BIGINT
); 
ALTER TABLE PUBLIC.MATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_21 PRIMARY KEY(ID);             
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.MATTRVALUE;               
INSERT INTO PUBLIC.MATTRVALUE(ID, BINARYVALUE, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE, ATTRIBUTE_ID) VALUES
(90, NULL, NULL, TIMESTAMP '2009-05-26 00:00:00.0', NULL, NULL, NULL, 100),
(91, NULL, NULL, TIMESTAMP '2010-05-26 15:40:04.0', NULL, NULL, NULL, 100),
(92, NULL, NULL, NULL, NULL, NULL, 'sx', 102),
(93, NULL, NULL, NULL, NULL, NULL, 'dx', 103);        
CREATE INDEX PUBLIC.MATTRVALUE_STRINGVALUEINDEX ON PUBLIC.MATTRVALUE(STRINGVALUE);             
CREATE INDEX PUBLIC.MATTRVALUE_DOUBLEVALUEINDEX ON PUBLIC.MATTRVALUE(DOUBLEVALUE);             
CREATE INDEX PUBLIC.MATTRVALUE_LONGVALUEINDEX ON PUBLIC.MATTRVALUE(LONGVALUE); 
CREATE INDEX PUBLIC.MATTRVALUE_DATEVALUEINDEX ON PUBLIC.MATTRVALUE(DATEVALUE); 
CREATE INDEX PUBLIC.MATTRVALUE_BOOLEANVALUEINDEX ON PUBLIC.MATTRVALUE(BOOLEANVALUE);           
CREATE INDEX PUBLIC.MATTRVALUE_ATTRIBUTE_IDINDEX ON PUBLIC.MATTRVALUE(ATTRIBUTE_ID);           
CREATE MEMORY TABLE PUBLIC.MDERATTR(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    TEMPLATE_ID BIGINT NOT NULL
);           
ALTER TABLE PUBLIC.MDERATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_C6 PRIMARY KEY(ID);               
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.MDERATTR; 
INSERT INTO PUBLIC.MDERATTR(ID, OWNER_ID, TEMPLATE_ID) VALUES
(99, 1, 99);     
CREATE INDEX PUBLIC.MDERATTR_OWNER_ID_INDEX ON PUBLIC.MDERATTR(OWNER_ID);      
CREATE MEMORY TABLE PUBLIC.MDERATTRTEMPLATE(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
);      
ALTER TABLE PUBLIC.MDERATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_52 PRIMARY KEY(ID);       
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.MDERATTRTEMPLATE;         
INSERT INTO PUBLIC.MDERATTRTEMPLATE(ID, OWNER_ID, SCHEMA_NAME) VALUES
(99, 1, 'mderiveddata'),
(100, 1, 'mderToBePropagated'); 
CREATE MEMORY TABLE PUBLIC.MDERSCHEMA(
    NAME VARCHAR(255) NOT NULL,
    EXPRESSION VARCHAR(255) NOT NULL
); 
ALTER TABLE PUBLIC.MDERSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_5F PRIMARY KEY(NAME);           
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.MDERSCHEMA;               
INSERT INTO PUBLIC.MDERSCHEMA(NAME, EXPRESSION) VALUES
('mderiveddata', 'mderived_sx + ''-'' + mderived_dx'),
('mderToBePropagated', 'mderived_sx + ''-'' + mderived_dx');     
CREATE MEMORY TABLE PUBLIC.MEMBERSHIP(
    ID BIGINT NOT NULL,
    CREATIONDATE TIMESTAMP NOT NULL,
    CREATOR VARCHAR(255) NOT NULL,
    LASTCHANGEDATE TIMESTAMP NOT NULL,
    LASTMODIFIER VARCHAR(255) NOT NULL,
    SYNCOPEUSER_ID BIGINT,
    SYNCOPEROLE_ID BIGINT
);  
ALTER TABLE PUBLIC.MEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_CD PRIMARY KEY(ID);             
-- 7 +/- SELECT COUNT(*) FROM PUBLIC.MEMBERSHIP;               
INSERT INTO PUBLIC.MEMBERSHIP(ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, SYNCOPEUSER_ID, SYNCOPEROLE_ID) VALUES
(1, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 1, 1),
(2, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 2, 1),
(3, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 2, 2),
(4, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 4, 7),
(5, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 1, 8),
(6, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 2, 3),
(7, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 5, 14);            
CREATE INDEX PUBLIC.MEMBERSHIP_SYNCOPEROLEINDEX ON PUBLIC.MEMBERSHIP(SYNCOPEROLE_ID);          
CREATE INDEX PUBLIC.MEMBERSHIP_SYNCOPEUSERINDEX ON PUBLIC.MEMBERSHIP(SYNCOPEUSER_ID);          
CREATE MEMORY TABLE PUBLIC.MSCHEMA(
    NAME VARCHAR(255) NOT NULL,
    CIPHERALGORITHM VARCHAR(20),
    CONVERSIONPATTERN VARCHAR(255),
    ENUMERATIONKEYS CLOB,
    ENUMERATIONVALUES CLOB,
    MANDATORYCONDITION VARCHAR(255) NOT NULL,
    MIMETYPE VARCHAR(255),
    MULTIVALUE INTEGER,
    READONLY INTEGER,
    SECRETKEY VARCHAR(255),
    TYPE VARCHAR(20) NOT NULL,
    UNIQUECONSTRAINT INTEGER,
    VALIDATORCLASS VARCHAR(255)
);              
ALTER TABLE PUBLIC.MSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_7A PRIMARY KEY(NAME);              
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.MSCHEMA;  
INSERT INTO PUBLIC.MSCHEMA(NAME, CIPHERALGORITHM, CONVERSIONPATTERN, ENUMERATIONKEYS, ENUMERATIONVALUES, MANDATORYCONDITION, MIMETYPE, MULTIVALUE, READONLY, SECRETKEY, TYPE, UNIQUECONSTRAINT, VALIDATORCLASS) VALUES
('subscriptionDate', NULL, 'yyyy-MM-dd''T''HH:mm:ss.SSSZ', NULL, NULL, 'false', NULL, 0, 0, NULL, 'Date', 0, NULL),
('mderived_sx', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL),
('mderived_dx', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL),
('postalAddress', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL);              
CREATE MEMORY TABLE PUBLIC.MVIRATTR(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    TEMPLATE_ID BIGINT NOT NULL
);           
ALTER TABLE PUBLIC.MVIRATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_85 PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.MVIRATTR; 
CREATE INDEX PUBLIC.MVIRATTR_OWNER_ID_INDEX ON PUBLIC.MVIRATTR(OWNER_ID);      
CREATE MEMORY TABLE PUBLIC.MVIRATTRTEMPLATE(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
);      
ALTER TABLE PUBLIC.MVIRATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_2B PRIMARY KEY(ID);       
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.MVIRATTRTEMPLATE;         
INSERT INTO PUBLIC.MVIRATTRTEMPLATE(ID, OWNER_ID, SCHEMA_NAME) VALUES
(99, 2, 'mvirtualdata'); 
CREATE MEMORY TABLE PUBLIC.MVIRSCHEMA(
    NAME VARCHAR(255) NOT NULL,
    READONLY INTEGER
); 
ALTER TABLE PUBLIC.MVIRSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_6B7 PRIMARY KEY(NAME);          
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.MVIRSCHEMA;               
INSERT INTO PUBLIC.MVIRSCHEMA(NAME, READONLY) VALUES
('mvirtualdata', NULL);   
CREATE MEMORY TABLE PUBLIC.NOTIFICATION(
    ID BIGINT NOT NULL,
    ACTIVE INTEGER NOT NULL,
    RECIPIENTATTRNAME VARCHAR(255),
    RECIPIENTATTRTYPE VARCHAR(23),
    RECIPIENTS VARCHAR(255),
    ROLEABOUT VARCHAR(255),
    SELFASRECIPIENT INTEGER NOT NULL,
    SENDER VARCHAR(255),
    SUBJECT VARCHAR(255),
    TEMPLATE VARCHAR(255),
    TRACELEVEL VARCHAR(20),
    USERABOUT VARCHAR(255)
);    
ALTER TABLE PUBLIC.NOTIFICATION ADD CONSTRAINT PUBLIC.CONSTRAINT_AD PRIMARY KEY(ID);           
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATION;             
INSERT INTO PUBLIC.NOTIFICATION(ID, ACTIVE, RECIPIENTATTRNAME, RECIPIENTATTRTYPE, RECIPIENTS, ROLEABOUT, SELFASRECIPIENT, SENDER, SUBJECT, TEMPLATE, TRACELEVEL, USERABOUT) VALUES
(1, 1, 'email', 'UserSchema', NULL, NULL, 1, 'admin@syncope.apache.org', 'Password Reset request', 'requestPasswordReset', 'FAILURES', 'token!=$null'),
(2, 1, 'email', 'UserSchema', NULL, NULL, 1, 'admin@syncope.apache.org', 'Password Reset successful', 'confirmPasswordReset', 'FAILURES', 'token!=$null'),
(10, 1, 'email', 'UserSchema', '$roles==7', NULL, 0, 'test@syncope.apache.org', 'Test subject', 'test', 'FAILURES', 'fullname==*o*;fullname==*i*');      
CREATE MEMORY TABLE PUBLIC.NOTIFICATIONTASK_RECIPIENTS(
    NOTIFICATIONTASK_ID BIGINT,
    ADDRESS VARCHAR(255)
);            
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATIONTASK_RECIPIENTS;              
INSERT INTO PUBLIC.NOTIFICATIONTASK_RECIPIENTS(NOTIFICATIONTASK_ID, ADDRESS) VALUES
(8, 'recipient@prova.org');
CREATE MEMORY TABLE PUBLIC.NOTIFICATION_EVENTS(
    NOTIFICATION_ID BIGINT,
    EVENTS VARCHAR(255)
);         
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATION_EVENTS;      
INSERT INTO PUBLIC.NOTIFICATION_EVENTS(NOTIFICATION_ID, EVENTS) VALUES
(1, '[CUSTOM]:[]:[]:[requestPasswordReset]:[SUCCESS]'),
(2, '[CUSTOM]:[]:[]:[confirmPasswordReset]:[SUCCESS]'),
(10, '[CUSTOM]:[]:[]:[unexisting1]:[FAILURE]'),
(10, '[CUSTOM]:[]:[]:[unexisting2]:[SUCCESS]');         
CREATE MEMORY TABLE PUBLIC.NOTIFICATION_STATICRECIPIENTS(
    NOTIFICATION_ID BIGINT,
    STATICRECIPIENTS VARCHAR(255)
);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATION_STATICRECIPIENTS;            
CREATE MEMORY TABLE PUBLIC.OPENJPA_SEQUENCES_TABLE(
    ID VARCHAR(255) NOT NULL,
    SEQUENCE_VALUE BIGINT
); 
ALTER TABLE PUBLIC.OPENJPA_SEQUENCES_TABLE ADD CONSTRAINT PUBLIC.CONSTRAINT_2C PRIMARY KEY(ID);
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OPENJPA_SEQUENCES_TABLE;  
CREATE MEMORY TABLE PUBLIC.OPENJPA_SEQUENCE_TABLE(
    ID TINYINT NOT NULL,
    SEQUENCE_VALUE BIGINT
);       
ALTER TABLE PUBLIC.OPENJPA_SEQUENCE_TABLE ADD CONSTRAINT PUBLIC.CONSTRAINT_B2 PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OPENJPA_SEQUENCE_TABLE;   
CREATE MEMORY TABLE PUBLIC.POLICY(
    ID BIGINT NOT NULL,
    DESCRIPTION VARCHAR(255),
    SPECIFICATION CLOB,
    TYPE VARCHAR(20),
    DTYPE VARCHAR(255)
);               
ALTER TABLE PUBLIC.POLICY ADD CONSTRAINT PUBLIC.CONSTRAINT_8D0 PRIMARY KEY(ID);
-- 9 +/- SELECT COUNT(*) FROM PUBLIC.POLICY;   
INSERT INTO PUBLIC.POLICY(ID, DESCRIPTION, SPECIFICATION, TYPE, DTYPE) VALUES
(1, 'global sync policy', '{"userJavaRule":null,"roleJavaRule":null,"conflictResolutionAction":"IGNORE","userAltSearchSchemas":[],"roleAltSearchSchemas":[]}', 'GLOBAL_SYNC', 'SyncPolicy'),
(2, 'global password policy', '{"historyLength":1,"maxLength":0,"minLength":8,"nonAlphanumericRequired":false,"alphanumericRequired":false,"digitRequired":false,"lowercaseRequired":false,"uppercaseRequired":false,"mustStartWithDigit":false,"mustntStartWithDigit":false,"mustEndWithDigit":false,"mustntEndWithDigit":false,"mustStartWithNonAlpha":false,"mustStartWithAlpha":false,"mustntStartWithNonAlpha":false,"mustntStartWithAlpha":false,"mustEndWithNonAlpha":false,"mustEndWithAlpha":false,"mustntEndWithNonAlpha":false,"mustntEndWithAlpha":false,"wordsNotPermitted":[],"schemasNotPermitted":[],"prefixesNotPermitted":["notpermitted1","notpermitted2"],"suffixesNotPermitted":[],"allowNullPassword":true}', 'GLOBAL_PASSWORD', 'PasswordPolicy'),
(3, 'sync policy 2', '{"userJavaRule":null,"roleJavaRule":null,"conflictResolutionAction":"ALL","userAltSearchSchemas":["username","firstname"],"roleAltSearchSchemas":[]}', 'SYNC', 'SyncPolicy'),
(4, 'sample password policy', '{"historyLength":0,"maxLength":0,"minLength":10,"nonAlphanumericRequired":false,"alphanumericRequired":false,"digitRequired":true,"lowercaseRequired":false,"uppercaseRequired":false,"mustStartWithDigit":false,"mustntStartWithDigit":false,"mustEndWithDigit":false,"mustntEndWithDigit":false,"mustStartWithNonAlpha":false,"mustStartWithAlpha":false,"mustntStartWithNonAlpha":false,"mustntStartWithAlpha":false,"mustEndWithNonAlpha":false,"mustEndWithAlpha":false,"mustntEndWithNonAlpha":false,"mustntEndWithAlpha":false,"wordsNotPermitted":[],"schemasNotPermitted":[],"prefixesNotPermitted":["notpermitted1","notpermitted2"],"suffixesNotPermitted":[], "allowNullPassword":false}', 'PASSWORD', 'PasswordPolicy'),
(5, 'global account policy', '{"maxLength":0,"minLength":0,"pattern":null,"allUpperCase":false,"allLowerCase":false,"propagateSuspension":false,"permittedLoginRetries":0,"wordsNotPermitted":[],"schemasNotPermitted":[],"prefixesNotPermitted":[],"suffixesNotPermitted":[]}', 'GLOBAL_ACCOUNT', 'AccountPolicy'),
(6, 'sample account policy', '{"maxLength":0,"minLength":4,"pattern":null,"allUpperCase":false,"allLowerCase":false,"propagateSuspension":false,"permittedLoginRetries":3,"wordsNotPermitted":[],"schemasNotPermitted":[],"prefixesNotPermitted":["notpermitted1","notpermitted2"],"suffixesNotPermitted":[]}', 'ACCOUNT', 'AccountPolicy'),
(7, 'sync policy 1', '{"userJavaRule":null,"roleJavaRule":null,"conflictResolutionAction":"IGNORE","userAltSearchSchemas":[],"roleAltSearchSchemas":[]}', 'SYNC', 'SyncPolicy'),
(8, 'sample password policy', '{"historyLength":0,"maxLength":0,"minLength":10,"nonAlphanumericRequired":true,"alphanumericRequired":false,"digitRequired":true,"lowercaseRequired":true,"uppercaseRequired":true,"mustStartWithDigit":true,"mustntStartWithDigit":false,"mustEndWithDigit":true,"mustntEndWithDigit":false,"mustStartWithNonAlpha":false,"mustStartWithAlpha":false,"mustntStartWithNonAlpha":false,"mustntStartWithAlpha":false,"mustEndWithNonAlpha":false,"mustEndWithAlpha":false,"mustntEndWithNonAlpha":false,"mustntEndWithAlpha":false,"wordsNotPermitted":[],"schemasNotPermitted":[],"prefixesNotPermitted":["notpermitted1","notpermitted2"],"suffixesNotPermitted":[],"allowNullPassword":false}', 'PASSWORD', 'PasswordPolicy'),
(9, 'sync policy for java rule', '{"userJavaRule":null,"roleJavaRule":null,"conflictResolutionAction":"IGNORE","userAltSearchSchemas":[],"roleAltSearchSchemas":[]}', 'SYNC', 'SyncPolicy');   
CREATE INDEX PUBLIC.I_POLICY_DTYPE ON PUBLIC.POLICY(DTYPE);    
CREATE MEMORY TABLE PUBLIC.POLICY_EXTERNALRESOURCE(
    ACCOUNT_POLICY_ID BIGINT,
    RESOURCE_NAME VARCHAR(255)
);            
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.POLICY_EXTERNALRESOURCE;  
INSERT INTO PUBLIC.POLICY_EXTERNALRESOURCE(ACCOUNT_POLICY_ID, RESOURCE_NAME) VALUES
(5, 'resource-testdb');    
CREATE MEMORY TABLE PUBLIC.PUSHTASK_ACTIONSCLASSNAMES(
    PUSHTASK_ID BIGINT,
    ELEMENT VARCHAR(255)
);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PUSHTASK_ACTIONSCLASSNAMES;               
CREATE MEMORY TABLE PUBLIC.RATTR(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    TEMPLATE_ID BIGINT NOT NULL
);              
ALTER TABLE PUBLIC.RATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_4A PRIMARY KEY(ID);  
-- 9 +/- SELECT COUNT(*) FROM PUBLIC.RATTR;    
INSERT INTO PUBLIC.RATTR(ID, OWNER_ID, TEMPLATE_ID) VALUES
(600, 1, 600),
(700, 2, 700),
(800, 1, 800),
(900, 6, 900),
(950, 4, 950),
(992, 1, 992),
(993, 1, 993),
(994, 12, 994),
(995, 13, 995);            
CREATE INDEX PUBLIC.RATTR_TEMPLATE_IDINDEX ON PUBLIC.RATTR(TEMPLATE_ID);       
CREATE INDEX PUBLIC.RATTR_OWNER_ID_INDEX ON PUBLIC.RATTR(OWNER_ID);            
CREATE MEMORY TABLE PUBLIC.RATTRTEMPLATE(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
);         
ALTER TABLE PUBLIC.RATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_BB PRIMARY KEY(ID);          
-- 9 +/- SELECT COUNT(*) FROM PUBLIC.RATTRTEMPLATE;            
INSERT INTO PUBLIC.RATTRTEMPLATE(ID, OWNER_ID, SCHEMA_NAME) VALUES
(600, 1, 'icon'),
(700, 2, 'icon'),
(800, 1, 'show'),
(900, 6, 'icon'),
(950, 4, 'icon'),
(992, 1, 'rderived_sx'),
(993, 1, 'rderived_dx'),
(994, 12, 'title'),
(995, 13, 'title');         
CREATE MEMORY TABLE PUBLIC.RATTRUNIQUEVALUE(
    ID BIGINT NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
);             
ALTER TABLE PUBLIC.RATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_F7 PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.RATTRUNIQUEVALUE;         
CREATE MEMORY TABLE PUBLIC.RATTRVALUE(
    ID BIGINT NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID BIGINT
); 
ALTER TABLE PUBLIC.RATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_E7 PRIMARY KEY(ID);             
-- 9 +/- SELECT COUNT(*) FROM PUBLIC.RATTRVALUE;               
INSERT INTO PUBLIC.RATTRVALUE(ID, BINARYVALUE, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE, ATTRIBUTE_ID) VALUES
(40, NULL, NULL, NULL, NULL, NULL, 'niceIcon', 600),
(41, NULL, NULL, NULL, NULL, NULL, 'badIcon', 700),
(42, NULL, 1, NULL, NULL, NULL, NULL, 800),
(43, NULL, NULL, NULL, NULL, NULL, 'icon6', 900),
(44, NULL, NULL, NULL, NULL, NULL, 'icon4', 950),
(92, NULL, NULL, NULL, NULL, NULL, 'sx', 992),
(93, NULL, NULL, NULL, NULL, NULL, 'dx', 993),
(94, NULL, NULL, NULL, NULL, NULL, 'r12', 994),
(95, NULL, NULL, NULL, NULL, NULL, 'r13', 995);       
CREATE INDEX PUBLIC.RATTRVALUE_LONGVALUEINDEX ON PUBLIC.RATTRVALUE(LONGVALUE); 
CREATE INDEX PUBLIC.RATTRVALUE_STRINGVALUEINDEX ON PUBLIC.RATTRVALUE(STRINGVALUE);             
CREATE INDEX PUBLIC.RATTRVALUE_DATEVALUEINDEX ON PUBLIC.RATTRVALUE(DATEVALUE); 
CREATE INDEX PUBLIC.RATTRVALUE_DOUBLEVALUEINDEX ON PUBLIC.RATTRVALUE(DOUBLEVALUE);             
CREATE INDEX PUBLIC.RATTRVALUE_BOOLEANVALUEINDEX ON PUBLIC.RATTRVALUE(BOOLEANVALUE);           
CREATE INDEX PUBLIC.RATTRVALUE_ATTRIBUTE_IDINDEX ON PUBLIC.RATTRVALUE(ATTRIBUTE_ID);           
CREATE MEMORY TABLE PUBLIC.RDERATTR(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    TEMPLATE_ID BIGINT NOT NULL
);           
ALTER TABLE PUBLIC.RDERATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_CDA PRIMARY KEY(ID);              
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.RDERATTR; 
INSERT INTO PUBLIC.RDERATTR(ID, OWNER_ID, TEMPLATE_ID) VALUES
(1000, 1, 1000),
(1001, 1, 1001),
(1002, 4, 1002),
(1003, 1, 1003);              
CREATE INDEX PUBLIC.RDERATTR_OWNER_ID_INDEX ON PUBLIC.RDERATTR(OWNER_ID);      
CREATE MEMORY TABLE PUBLIC.RDERATTRTEMPLATE(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
);      
ALTER TABLE PUBLIC.RDERATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_BA PRIMARY KEY(ID);       
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.RDERATTRTEMPLATE;         
INSERT INTO PUBLIC.RDERATTRTEMPLATE(ID, OWNER_ID, SCHEMA_NAME) VALUES
(1000, 1, 'rderiveddata'),
(1001, 1, 'displayProperty'),
(1002, 4, 'displayProperty'),
(1003, 1, 'rderToBePropagated');  
CREATE MEMORY TABLE PUBLIC.RDERSCHEMA(
    NAME VARCHAR(255) NOT NULL,
    EXPRESSION VARCHAR(255) NOT NULL
); 
ALTER TABLE PUBLIC.RDERSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_24 PRIMARY KEY(NAME);           
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.RDERSCHEMA;               
INSERT INTO PUBLIC.RDERSCHEMA(NAME, EXPRESSION) VALUES
('rderiveddata', 'rderived_sx + ''-'' + rderived_dx'),
('displayProperty', 'icon + '': '' + show'),
('rderToBePropagated', 'rderived_sx + ''-'' + rderived_dx'),
('rderivedschema', 'rderived_sx + ''-'' + rderived_dx');               
CREATE MEMORY TABLE PUBLIC.REPORT(
    ID BIGINT NOT NULL,
    CRONEXPRESSION VARCHAR(255),
    NAME VARCHAR(255) NOT NULL
);  
ALTER TABLE PUBLIC.REPORT ADD CONSTRAINT PUBLIC.CONSTRAINT_8FD PRIMARY KEY(ID);
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.REPORT;   
INSERT INTO PUBLIC.REPORT(ID, CRONEXPRESSION, NAME) VALUES
(1, NULL, 'test');  
CREATE MEMORY TABLE PUBLIC.REPORTEXEC(
    ID BIGINT NOT NULL,
    ENDDATE TIMESTAMP,
    MESSAGE CLOB,
    STARTDATE TIMESTAMP,
    STATUS VARCHAR(255) NOT NULL,
    EXECRESULT BLOB,
    REPORT_ID BIGINT
);
ALTER TABLE PUBLIC.REPORTEXEC ADD CONSTRAINT PUBLIC.CONSTRAINT_90 PRIMARY KEY(ID);             
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.REPORTEXEC;               
INSERT INTO PUBLIC.REPORTEXEC(ID, ENDDATE, MESSAGE, STARTDATE, STATUS, EXECRESULT, REPORT_ID) VALUES
(1, TIMESTAMP '2012-02-26 15:41:04.0', NULL, TIMESTAMP '2012-02-26 15:40:04.0', 'SUCCESS', NULL, 1);      
CREATE MEMORY TABLE PUBLIC.REPORTLETCONFINSTANCE(
    ID BIGINT NOT NULL,
    SERIALIZEDINSTANCE CLOB,
    REPORT_ID BIGINT
); 
ALTER TABLE PUBLIC.REPORTLETCONFINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_4F PRIMARY KEY(ID);  
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.REPORTLETCONFINSTANCE;    
INSERT INTO PUBLIC.REPORTLETCONFINSTANCE(ID, SERIALIZEDINSTANCE, REPORT_ID) VALUES
(1, '{"@class":"org.apache.syncope.common.report.UserReportletConf","name":"testUserReportlet","matchingCond":null,"attributes":["fullname","gender"],"derivedAttributes":["cn"],"virtualAttributes":["virtualdata"],"features":["id","username","workflowId","status","creationDate","lastLoginDate","changePwdDate","passwordHistorySize","failedLoginCount","memberships","resources"]}', 1);            
CREATE MEMORY TABLE PUBLIC.RMAPPING(
    ID BIGINT NOT NULL,
    ACCOUNTLINK VARCHAR(255),
    RESOURCE_NAME VARCHAR(255)
);   
ALTER TABLE PUBLIC.RMAPPING ADD CONSTRAINT PUBLIC.CONSTRAINT_A2 PRIMARY KEY(ID);               
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.RMAPPING; 
INSERT INTO PUBLIC.RMAPPING(ID, ACCOUNTLINK, RESOURCE_NAME) VALUES
(1, '''cn='' + name + '',ou=groups,o=isp''', 'resource-ldap');              
CREATE MEMORY TABLE PUBLIC.RMAPPINGITEM(
    ID BIGINT NOT NULL,
    ACCOUNTID INTEGER NOT NULL,
    EXTATTRNAME VARCHAR(255),
    INTATTRNAME VARCHAR(255),
    INTMAPPINGTYPE VARCHAR(23) NOT NULL,
    MANDATORYCONDITION VARCHAR(255) NOT NULL,
    PASSWORD INTEGER NOT NULL,
    PURPOSE VARCHAR(20) NOT NULL,
    MAPPING_ID BIGINT
);  
ALTER TABLE PUBLIC.RMAPPINGITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_B0 PRIMARY KEY(ID);           
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.RMAPPINGITEM;             
INSERT INTO PUBLIC.RMAPPINGITEM(ID, ACCOUNTID, EXTATTRNAME, INTATTRNAME, INTMAPPINGTYPE, MANDATORYCONDITION, PASSWORD, PURPOSE, MAPPING_ID) VALUES
(1, 1, 'cn', 'roleName', 'RoleName', 'true', 0, 'BOTH', 1),
(2, 0, 'owner', 'roleOwnerSchema', 'RoleOwnerSchema', 'false', 0, 'BOTH', 1),
(3, 0, 'description', 'title', 'RoleSchema', 'false', 0, 'BOTH', 1),
(4, 0, 'businessCategory', 'rvirtualdata', 'RoleVirtualSchema', 'false', 0, 'BOTH', 1);      
CREATE MEMORY TABLE PUBLIC.RSCHEMA(
    NAME VARCHAR(255) NOT NULL,
    CIPHERALGORITHM VARCHAR(20),
    CONVERSIONPATTERN VARCHAR(255),
    ENUMERATIONKEYS CLOB,
    ENUMERATIONVALUES CLOB,
    MANDATORYCONDITION VARCHAR(255) NOT NULL,
    MIMETYPE VARCHAR(255),
    MULTIVALUE INTEGER,
    READONLY INTEGER,
    SECRETKEY VARCHAR(255),
    TYPE VARCHAR(20) NOT NULL,
    UNIQUECONSTRAINT INTEGER,
    VALIDATORCLASS VARCHAR(255)
);              
ALTER TABLE PUBLIC.RSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_83 PRIMARY KEY(NAME);              
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.RSCHEMA;  
INSERT INTO PUBLIC.RSCHEMA(NAME, CIPHERALGORITHM, CONVERSIONPATTERN, ENUMERATIONKEYS, ENUMERATIONVALUES, MANDATORYCONDITION, MIMETYPE, MULTIVALUE, READONLY, SECRETKEY, TYPE, UNIQUECONSTRAINT, VALIDATORCLASS) VALUES
('icon', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL),
('show', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'Boolean', 0, NULL),
('rderived_sx', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL),
('rderived_dx', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL),
('title', NULL, NULL, NULL, NULL, 'false', NULL, 1, 0, NULL, 'String', 0, NULL);         
CREATE MEMORY TABLE PUBLIC.RVIRATTR(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    TEMPLATE_ID BIGINT NOT NULL
);           
ALTER TABLE PUBLIC.RVIRATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_8C PRIMARY KEY(ID);               
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.RVIRATTR; 
INSERT INTO PUBLIC.RVIRATTR(ID, OWNER_ID, TEMPLATE_ID) VALUES
(98, 4, 98);     
CREATE INDEX PUBLIC.RVIRATTR_OWNER_ID_INDEX ON PUBLIC.RVIRATTR(OWNER_ID);      
CREATE MEMORY TABLE PUBLIC.RVIRATTRTEMPLATE(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
);      
ALTER TABLE PUBLIC.RVIRATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_93 PRIMARY KEY(ID);       
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.RVIRATTRTEMPLATE;         
INSERT INTO PUBLIC.RVIRATTRTEMPLATE(ID, OWNER_ID, SCHEMA_NAME) VALUES
(98, 4, 'rvirtualdata'),
(99, 3, 'rvirtualdata');        
CREATE MEMORY TABLE PUBLIC.RVIRSCHEMA(
    NAME VARCHAR(255) NOT NULL,
    READONLY INTEGER
); 
ALTER TABLE PUBLIC.RVIRSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_30 PRIMARY KEY(NAME);           
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.RVIRSCHEMA;               
INSERT INTO PUBLIC.RVIRSCHEMA(NAME, READONLY) VALUES
('rvirtualdata', NULL);   
CREATE MEMORY TABLE PUBLIC.SECURITYQUESTION(
    ID BIGINT NOT NULL,
    CONTENT VARCHAR(255)
);               
ALTER TABLE PUBLIC.SECURITYQUESTION ADD CONSTRAINT PUBLIC.CONSTRAINT_32 PRIMARY KEY(ID);       
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.SECURITYQUESTION;         
INSERT INTO PUBLIC.SECURITYQUESTION(ID, CONTENT) VALUES
(1, 'What''s your mother''s maiden name?');            
CREATE MEMORY TABLE PUBLIC.SYNCOPECONF(
    ID BIGINT NOT NULL,
    CREATIONDATE TIMESTAMP NOT NULL,
    CREATOR VARCHAR(255) NOT NULL,
    LASTCHANGEDATE TIMESTAMP NOT NULL,
    LASTMODIFIER VARCHAR(255) NOT NULL
);       
ALTER TABLE PUBLIC.SYNCOPECONF ADD CONSTRAINT PUBLIC.CONSTRAINT_6F PRIMARY KEY(ID);            
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPECONF;              
INSERT INTO PUBLIC.SYNCOPECONF(ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER) VALUES
(1, TIMESTAMP '2014-06-20 11:00:00.0', 'admin', TIMESTAMP '2014-06-20 11:00:00.0', 'admin');    
CREATE MEMORY TABLE PUBLIC.SYNCOPELOGGER(
    LOGNAME VARCHAR(255) NOT NULL,
    LOGLEVEL VARCHAR(20) NOT NULL,
    LOGTYPE VARCHAR(20) NOT NULL
);            
ALTER TABLE PUBLIC.SYNCOPELOGGER ADD CONSTRAINT PUBLIC.CONSTRAINT_4D PRIMARY KEY(LOGNAME);     
-- 19 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPELOGGER;           
INSERT INTO PUBLIC.SYNCOPELOGGER(LOGNAME, LOGLEVEL, LOGTYPE) VALUES
('syncope.audit.[REST]:[EntitlementController]:[]:[getOwn]:[SUCCESS]', 'DEBUG', 'AUDIT'),
('ROOT', 'INFO', 'LOG'),
('org.springframework.orm', 'INFO', 'LOG'),
('org.apache.syncope.core.report', 'INFO', 'LOG'),
('org.apache.syncope.core.persistence', 'INFO', 'LOG'),
('org.apache.cxf', 'ERROR', 'LOG'),
('org.springframework.web', 'INFO', 'LOG'),
('org.apache.syncope.common', 'OFF', 'LOG'),
('org.apache.syncope.core.notification', 'INFO', 'LOG'),
('org.apache.syncope.core.util.ConnIdBundleManager', 'INFO', 'LOG'),
('org.apache.http', 'INFO', 'LOG'),
('org.apache.syncope.core.sync', 'INFO', 'LOG'),
('org.springframework', 'INFO', 'LOG'),
('org.apache.syncope.core.rest', 'INFO', 'LOG'),
('net.tirasa.connid', 'DEBUG', 'LOG'),
('org.apache.syncope.core.connid', 'DEBUG', 'LOG'),
('org.apache.syncope.core.security', 'INFO', 'LOG'),
('org.apache.syncope.core.quartz', 'INFO', 'LOG'),
('org.identityconnectors', 'DEBUG', 'LOG');          
CREATE MEMORY TABLE PUBLIC.SYNCOPEROLE(
    ID BIGINT NOT NULL,
    CREATIONDATE TIMESTAMP NOT NULL,
    CREATOR VARCHAR(255) NOT NULL,
    LASTCHANGEDATE TIMESTAMP NOT NULL,
    LASTMODIFIER VARCHAR(255) NOT NULL,
    INHERITACCOUNTPOLICY INTEGER,
    INHERITATTRS INTEGER,
    INHERITDERATTRS INTEGER,
    INHERITOWNER INTEGER,
    INHERITPASSWORDPOLICY INTEGER,
    INHERITTEMPLATES INTEGER,
    INHERITVIRATTRS INTEGER,
    NAME VARCHAR(255),
    ACCOUNTPOLICY_ID BIGINT,
    PARENT_ID BIGINT,
    PASSWORDPOLICY_ID BIGINT,
    ROLEOWNER_ID BIGINT,
    USEROWNER_ID BIGINT
);            
ALTER TABLE PUBLIC.SYNCOPEROLE ADD CONSTRAINT PUBLIC.CONSTRAINT_6FF PRIMARY KEY(ID);           
-- 14 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEROLE;             
INSERT INTO PUBLIC.SYNCOPEROLE(ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, INHERITACCOUNTPOLICY, INHERITATTRS, INHERITDERATTRS, INHERITOWNER, INHERITPASSWORDPOLICY, INHERITTEMPLATES, INHERITVIRATTRS, NAME, ACCOUNTPOLICY_ID, PARENT_ID, PASSWORDPOLICY_ID, ROLEOWNER_ID, USEROWNER_ID) VALUES
(1, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'root12', NULL, NULL, NULL, NULL, NULL),
(2, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'child12', NULL, 1, NULL, NULL, NULL),
(3, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'citizen12', NULL, NULL, NULL, NULL, NULL),
(4, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'employee12', NULL, 3, NULL, NULL, NULL),
(5, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'secretary12', NULL, 4, NULL, NULL, NULL),
(6, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 0, 1, 1, NULL, 0, NULL, 1, 'director12', 6, 4, 4, NULL, 5),
(7, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 1, 1, 1, 1, 1, NULL, 1, 'managingDirector12', NULL, 6, NULL, NULL, NULL),
(8, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, 1, 'otherchild12', NULL, 1, 4, NULL, NULL),
(9, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'roleForWorkflowApproval12', NULL, 1, NULL, NULL, NULL),
(10, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 1, 1, 1, 0, 1, NULL, 1, 'managingConsultant12', NULL, 6, NULL, NULL, NULL),
(11, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'roleForWorkflowOptIn12', NULL, 1, NULL, NULL, NULL),
(12, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'aRoleForPropagation12', NULL, 1, NULL, NULL, NULL),
(13, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'bRoleForPropagation12', NULL, 1, NULL, NULL, NULL),
(14, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', 0, 1, 1, NULL, 0, NULL, 1, 'artDirector12', 6, 4, 8, NULL, NULL);         
CREATE MEMORY TABLE PUBLIC.SYNCOPEROLE_ENTITLEMENT(
    ROLE_ID BIGINT,
    ENTITLEMENT_NAME VARCHAR(255)
);   
-- 16 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEROLE_ENTITLEMENT; 
INSERT INTO PUBLIC.SYNCOPEROLE_ENTITLEMENT(ROLE_ID, ENTITLEMENT_NAME) VALUES
(1, 'base'),
(1, 'advanced'),
(2, 'base'),
(2, 'USER_READ'),
(2, 'USER_LIST'),
(7, 'USER_READ'),
(7, 'USER_LIST'),
(7, 'ROLE_8'),
(7, 'ROLE_9'),
(7, 'ROLE_7'),
(7, 'ROLE_1'),
(7, 'WORKFLOW_FORM_CLAIM'),
(7, 'WORKFLOW_FORM_SUBMIT'),
(8, 'SCHEMA_READ'),
(8, 'ROLE_READ'),
(8, 'WORKFLOW_FORM_CLAIM');         
CREATE MEMORY TABLE PUBLIC.SYNCOPEROLE_EXTERNALRESOURCE(
    ROLE_ID BIGINT,
    RESOURCE_NAME VARCHAR(255)
); 
-- 7 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEROLE_EXTERNALRESOURCE;             
INSERT INTO PUBLIC.SYNCOPEROLE_EXTERNALRESOURCE(ROLE_ID, RESOURCE_NAME) VALUES
(3, 'ws-target-resource-list-mappings-1'),
(8, 'ws-target-resource-2'),
(3, 'ws-target-resource-list-mappings-2'),
(7, 'ws-target-resource-nopropagation'),
(10, 'ws-target-resource-nopropagation3'),
(12, 'resource-csv'),
(13, 'resource-csv');              
CREATE MEMORY TABLE PUBLIC.SYNCOPEUSER(
    ID BIGINT NOT NULL,
    CREATIONDATE TIMESTAMP NOT NULL,
    CREATOR VARCHAR(255) NOT NULL,
    LASTCHANGEDATE TIMESTAMP NOT NULL,
    LASTMODIFIER VARCHAR(255) NOT NULL,
    CHANGEPWDDATE TIMESTAMP,
    CIPHERALGORITHM VARCHAR(20),
    FAILEDLOGINS INTEGER,
    LASTLOGINDATE TIMESTAMP,
    PASSWORD VARCHAR(255),
    SECURITYANSWER VARCHAR(255),
    STATUS VARCHAR(255),
    SUSPENDED INTEGER,
    TOKEN CLOB,
    TOKENEXPIRETIME TIMESTAMP,
    USERNAME VARCHAR(255),
    WORKFLOWID VARCHAR(255),
    SECURITYQUESTION_ID BIGINT
);               
ALTER TABLE PUBLIC.SYNCOPEUSER ADD CONSTRAINT PUBLIC.CONSTRAINT_6FFB PRIMARY KEY(ID);          
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEUSER;              
INSERT INTO PUBLIC.SYNCOPEUSER(ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, CHANGEPWDDATE, CIPHERALGORITHM, FAILEDLOGINS, LASTLOGINDATE, PASSWORD, SECURITYANSWER, STATUS, SUSPENDED, TOKEN, TOKENEXPIRETIME, USERNAME, WORKFLOWID, SECURITYQUESTION_ID) VALUES
(1, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, 'SHA1', NULL, NULL, '5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8', NULL, 'active', 0, NULL, NULL, 'rossini12', '4', NULL),
(2, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, 'SHA1', NULL, NULL, '5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8', NULL, 'active', 0, NULL, NULL, 'verdi12', '6', NULL),
(3, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, 'SHA1', NULL, NULL, '5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8', NULL, 'active', 0, NULL, NULL, 'vivaldi12', '8', NULL),
(4, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, 'SHA1', NULL, NULL, '5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8', NULL, 'active', 0, NULL, NULL, 'bellini12', '10', NULL),
(5, TIMESTAMP '2010-10-20 11:00:00.0', 'admin', TIMESTAMP '2010-10-20 11:00:00.0', 'admin', NULL, 'SHA1', NULL, NULL, '5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8', NULL, 'active', 0, NULL, NULL, 'puccini12', '12', NULL);            
CREATE MEMORY TABLE PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE(
    USER_ID BIGINT,
    RESOURCE_NAME VARCHAR(255)
); 
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE;             
INSERT INTO PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE(USER_ID, RESOURCE_NAME) VALUES
(1, 'resource-testdb2'),
(3, 'ws-target-resource-delete'),
(3, 'ws-target-resource-2'),
(3, 'ws-target-resource-1'),
(5, 'resource-testdb2');   
CREATE MEMORY TABLE PUBLIC.SYNCOPEUSER_PASSWORDHISTORY(
    SYNCOPEUSER_ID BIGINT,
    ELEMENT VARCHAR(255)
); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEUSER_PASSWORDHISTORY;              
CREATE MEMORY TABLE PUBLIC.SYNCTASK_ACTIONSCLASSNAMES(
    SYNCTASK_ID BIGINT,
    ELEMENT VARCHAR(255)
);     
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.SYNCTASK_ACTIONSCLASSNAMES;               
INSERT INTO PUBLIC.SYNCTASK_ACTIONSCLASSNAMES(SYNCTASK_ID, ELEMENT) VALUES
(11, 'org.apache.syncope.core.sync.impl.LDAPMembershipSyncActions');
CREATE MEMORY TABLE PUBLIC.TASK(
    ID BIGINT NOT NULL,
    DTYPE VARCHAR(31),
    CRONEXPRESSION VARCHAR(255),
    DESCRIPTION VARCHAR(255),
    JOBCLASSNAME VARCHAR(255),
    NAME VARCHAR(255),
    MATCHINGRULE VARCHAR(20),
    PERFORMCREATE INTEGER,
    PERFORMDELETE INTEGER,
    PERFORMUPDATE INTEGER,
    SYNCSTATUS INTEGER,
    UNMATCHINGRULE VARCHAR(20),
    FULLRECONCILIATION INTEGER,
    ROLETEMPLATE CLOB,
    USERTEMPLATE CLOB,
    RESOURCE_NAME VARCHAR(255),
    ROLEFILTER VARCHAR(255),
    USERFILTER VARCHAR(255),
    ACCOUNTID VARCHAR(255),
    OBJECTCLASSNAME VARCHAR(255),
    OLDACCOUNTID VARCHAR(255),
    PROPAGATIONMODE VARCHAR(20),
    PROPAGATIONOPERATION VARCHAR(20),
    SUBJECTID BIGINT,
    SUBJECTTYPE VARCHAR(20),
    XMLATTRIBUTES CLOB,
    EXECUTED INTEGER,
    HTMLBODY CLOB,
    SENDER VARCHAR(255),
    SUBJECT VARCHAR(255),
    TEXTBODY CLOB,
    TRACELEVEL VARCHAR(20)
);
ALTER TABLE PUBLIC.TASK ADD CONSTRAINT PUBLIC.CONSTRAINT_27 PRIMARY KEY(ID);   
-- 26 +/- SELECT COUNT(*) FROM PUBLIC.TASK;    
INSERT INTO PUBLIC.TASK(ID, DTYPE, CRONEXPRESSION, DESCRIPTION, JOBCLASSNAME, NAME, MATCHINGRULE, PERFORMCREATE, PERFORMDELETE, PERFORMUPDATE, SYNCSTATUS, UNMATCHINGRULE, FULLRECONCILIATION, ROLETEMPLATE, USERTEMPLATE, RESOURCE_NAME, ROLEFILTER, USERFILTER, ACCOUNTID, OBJECTCLASSNAME, OLDACCOUNTID, PROPAGATIONMODE, PROPAGATIONOPERATION, SUBJECTID, SUBJECTTYPE, XMLATTRIBUTES, EXECUTED, HTMLBODY, SENDER, SUBJECT, TEXTBODY, TRACELEVEL) VALUES
(1, 'PropagationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ws-target-resource-2', NULL, NULL, NULL, '__ACCOUNT__', NULL, 'TWO_PHASES', 'UPDATE', 1, 'USER', '[{"name":"__PASSWORD__","value":[{"readOnly":false,"disposed":false,"encryptedBytes":"m9nh2US0Sa6m+cXccCq0Xw==","base64SHA1Hash":"GFJ69qfjxEOdrmt+9q+0Cw2uz60="}]},{"name":"__NAME__","value":["userId"],"nameValue":"userId"},{"name":"fullname","value":["fullname"]},{"name":"type","value":["type"]}]', NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'PropagationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ws-target-resource-2', NULL, NULL, NULL, '__ACCOUNT__', NULL, 'ONE_PHASE', 'CREATE', 1, 'USER', '[{"name":"__PASSWORD__","value":[{"readOnly":false,"disposed":false,"encryptedBytes":"m9nh2US0Sa6m+cXccCq0Xw==","base64SHA1Hash":"GFJ69qfjxEOdrmt+9q+0Cw2uz60="}]},{"name":"__NAME__","value":["userId"],"nameValue":"userId"},{"name":"fullname","value":["fullname"]},{"name":"type","value":["type"]}]', NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'PropagationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ws-target-resource-2', NULL, NULL, NULL, '__ACCOUNT__', NULL, 'TWO_PHASES', 'DELETE', 1, 'USER', '[{"name":"__PASSWORD__","value":[{"readOnly":false,"disposed":false,"encryptedBytes":"m9nh2US0Sa6m+cXccCq0Xw==","base64SHA1Hash":"GFJ69qfjxEOdrmt+9q+0Cw2uz60="}]},{"name":"__NAME__","value":["userId"],"nameValue":"userId"},{"name":"type","value":["type"]}]', NULL, NULL, NULL, NULL, NULL, NULL),
(4, 'SyncTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.SyncJob', 'CSV (update matching; assign unmatching)', 'UPDATE', 1, 1, 1, 1, 'ASSIGN', 0, '{"creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"id":0,"name":null,"parent":0,"userOwner":null,"roleOwner":null,"inheritOwner":false,"inheritTemplates":false,"inheritAttrs":false,"inheritDerAttrs":false,"inheritVirAttrs":false,"inheritPasswordPolicy":false,"inheritAccountPolicy":false,"passwordPolicy":null,"accountPolicy":null,"attributes":[],"derivedAttributes":[],"virtualAttributes":[],"resources":[],"propagationStatuses":[],"entitlements":[],"rAttrTemplates":[],"rDerAttrTemplates":[],"rVirAttrTemplates":[],"mAttrTemplates":[],"mDerAttrTemplates":[],"mVirAttrTemplates":[]}', '{"creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"id":0,"password":null,"status":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"attributes":[{"schema":"type","readonly":false,"values":["email == ''test8@syncope.apache.org''? ''TYPE_8'': ''TYPE_OTHER''"]}],"derivedAttributes":[{"schema":"cn","readonly":false,"values":[null]}],"virtualAttributes":[],"resources":["resource-testdb"],"propagationStatuses":[],"memberships":[{"creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"id":0,"roleId":8,"roleName":null,"attributes":[{"schema":"subscriptionDate","readonly":false,"values":["''2009-08-18T16:33:12.203+0200''"]}],"derivedAttributes":[],"virtualAttributes":[]}]}', 'resource-csv', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(5, 'SchedTask', '0 0 0 1 * ?', NULL, 'org.apache.syncope.core.quartz.SampleJob', 'SampleJob Task', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(6, 'PropagationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ws-target-resource-nopropagation', NULL, NULL, NULL, '__ACCOUNT__', NULL, 'TWO_PHASES', 'UPDATE', 1, 'USER', '[{"name":"__PASSWORD__","value":[{"readOnly":false,"disposed":false,"encryptedBytes":"m9nh2US0Sa6m+cXccCq0Xw==","base64SHA1Hash":"GFJ69qfjxEOdrmt+9q+0Cw2uz60="}]},{"name":"__NAME__","value":["userId"],"nameValue":"userId"},{"name":"fullname","value":["fullname"]},{"name":"type","value":["type"]}]', NULL, NULL, NULL, NULL, NULL, NULL); 
INSERT INTO PUBLIC.TASK(ID, DTYPE, CRONEXPRESSION, DESCRIPTION, JOBCLASSNAME, NAME, MATCHINGRULE, PERFORMCREATE, PERFORMDELETE, PERFORMUPDATE, SYNCSTATUS, UNMATCHINGRULE, FULLRECONCILIATION, ROLETEMPLATE, USERTEMPLATE, RESOURCE_NAME, ROLEFILTER, USERFILTER, ACCOUNTID, OBJECTCLASSNAME, OLDACCOUNTID, PROPAGATIONMODE, PROPAGATIONOPERATION, SUBJECTID, SUBJECTTYPE, XMLATTRIBUTES, EXECUTED, HTMLBODY, SENDER, SUBJECT, TEXTBODY, TRACELEVEL) VALUES
(7, 'SyncTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.SyncJob', 'TestDB Task', 'UPDATE', 1, 0, 1, 1, 'PROVISION', 1, '{"creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"id":0,"name":null,"parent":0,"userOwner":null,"roleOwner":null,"inheritOwner":false,"inheritTemplates":false,"inheritAttrs":false,"inheritDerAttrs":false,"inheritVirAttrs":false,"inheritPasswordPolicy":false,"inheritAccountPolicy":false,"passwordPolicy":null,"accountPolicy":null,"attributes":[],"derivedAttributes":[],"virtualAttributes":[],"resources":[],"propagationStatuses":[],"entitlements":[],"rAttrTemplates":[],"rDerAttrTemplates":[],"rVirAttrTemplates":[],"mAttrTemplates":[],"mDerAttrTemplates":[],"mVirAttrTemplates":[]}', '{"creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"id":0,"password":null,"status":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"attributes":[{"schema":"type","readonly":false,"values":["''type a''"]},{"schema":"userId","readonly":false,"values":["''reconciled@syncope.apache.org''"]},{"schema":"fullname","readonly":false,"values":["''reconciled fullname''"]},{"schema":"surname","readonly":false,"values":["''surname''"]}],"derivedAttributes":[],"virtualAttributes":[],"resources":[],"propagationStatuses":[],"memberships":[]}', 'resource-testdb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(8, 'NotificationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'NOTIFICATION-81', 'admin@prova.org', 'Notification for SYNCOPE-81', 'NOTIFICATION-81', 'ALL'),
(9, 'SyncTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.SyncJob', 'TestDB2 Task', 'UPDATE', 1, 0, 1, 1, 'PROVISION', 1, NULL, NULL, 'resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(10, 'SyncTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.SyncJob', 'TestDB Sync Task', 'UPDATE', 1, 1, 1, 0, 'PROVISION', 1, NULL, NULL, 'resource-db-sync', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(11, 'SyncTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.SyncJob', 'LDAP Sync Task', 'UPDATE', 1, 1, 1, 0, 'PROVISION', 1, '{"creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"id":0,"name":null,"parent":8,"userOwner":null,"roleOwner":null,"inheritOwner":false,"inheritTemplates":false,"inheritAttrs":false,"inheritDerAttrs":false,"inheritVirAttrs":false,"inheritPasswordPolicy":false,"inheritAccountPolicy":false,"passwordPolicy":null,"accountPolicy":null,"attributes":[{"schema":"show","readonly":false,"values":["''true''"]}],"derivedAttributes":[],"virtualAttributes":[],"resources":[],"propagationStatuses":[],"entitlements":[],"rAttrTemplates":["show"],"rDerAttrTemplates":[],"rVirAttrTemplates":[],"mAttrTemplates":[],"mDerAttrTemplates":[],"mVirAttrTemplates":[]}', '{"creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"id":0,"password":null,"status":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"attributes":[],"derivedAttributes":[],"virtualAttributes":[{"schema":"virtualReadOnly","readonly":false,"values":[""]}],"resources":["resource-ldap"],"propagationStatuses":[],"memberships":[]}', 'resource-ldap', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(12, 'SyncTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.SyncJob', 'VirAttrCache test', 'UPDATE', 0, 0, 1, 0, 'PROVISION', 1, NULL, NULL, 'resource-csv', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);          
INSERT INTO PUBLIC.TASK(ID, DTYPE, CRONEXPRESSION, DESCRIPTION, JOBCLASSNAME, NAME, MATCHINGRULE, PERFORMCREATE, PERFORMDELETE, PERFORMUPDATE, SYNCSTATUS, UNMATCHINGRULE, FULLRECONCILIATION, ROLETEMPLATE, USERTEMPLATE, RESOURCE_NAME, ROLEFILTER, USERFILTER, ACCOUNTID, OBJECTCLASSNAME, OLDACCOUNTID, PROPAGATIONMODE, PROPAGATIONOPERATION, SUBJECTID, SUBJECTTYPE, XMLATTRIBUTES, EXECUTED, HTMLBODY, SENDER, SUBJECT, TEXTBODY, TRACELEVEL) VALUES
(13, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-testdb2', 'IGNORE', 1, 1, 1, 1, 'ASSIGN', NULL, NULL, NULL, 'resource-testdb2', 'name==_NO_ONE_', 'surname==Vivaldi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(14, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-testdb2', 'IGNORE', 1, 1, 1, 1, 'PROVISION', NULL, NULL, NULL, 'resource-testdb2', 'name==_NO_ONE_', 'surname==Bellini', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(15, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-testdb2', 'IGNORE', 1, 1, 1, 1, 'UNLINK', NULL, NULL, NULL, 'resource-testdb2', 'name==_NO_ONE_', 'surname==Puccini', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(16, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-testdb2', 'IGNORE', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, 'resource-testdb2', 'name==_NO_ONE_', 'surname==Verdi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(17, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-testdb2', 'UPDATE', 1, 1, 1, 1, 'ASSIGN', NULL, NULL, NULL, 'resource-testdb2', 'name==_NO_ONE_', 'username==_NO_ONE_', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(18, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-testdb2', 'DEPROVISION', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, 'resource-testdb2', 'name==_NO_ONE_', 'surname==Verdi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(19, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-testdb2', 'UNASSIGN', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, 'resource-testdb2', 'name==_NO_ONE_', 'surname==Rossini', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(20, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-testdb2', 'LINK', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, 'resource-testdb2', 'name==_NO_ONE_', 'surname==Verdi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(21, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-testdb2', 'UNLINK', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, 'resource-testdb2', 'name==_NO_ONE_', 'surname==Verdi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(22, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-testdb2', 'UPDATE', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, 'resource-testdb2', 'name==_NO_ONE_', 'surname==Verdi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(23, 'PushTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.PushJob', 'Export on resource-ldap', 'UNLINK', 1, 1, 1, 1, 'ASSIGN', NULL, NULL, NULL, 'resource-ldap', 'name==citizen', 'username==_NO_ONE_', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(24, 'SyncTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.SyncJob', 'CSV Task (update matching; provision unmatching)', 'UPDATE', 1, 1, 1, 1, 'PROVISION', 0, '{"creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"id":0,"name":null,"parent":0,"userOwner":null,"roleOwner":null,"inheritOwner":false,"inheritTemplates":false,"inheritAttrs":false,"inheritDerAttrs":false,"inheritVirAttrs":false,"inheritPasswordPolicy":false,"inheritAccountPolicy":false,"passwordPolicy":null,"accountPolicy":null,"attributes":[],"derivedAttributes":[],"virtualAttributes":[],"resources":[],"propagationStatuses":[],"entitlements":[],"rAttrTemplates":[],"rDerAttrTemplates":[],"rVirAttrTemplates":[],"mAttrTemplates":[],"mDerAttrTemplates":[],"mVirAttrTemplates":[]}', '{"creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"id":0,"password":null,"status":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"attributes":[{"schema":"firstname","readonly":false,"values":[""]},{"schema":"userId","readonly":false,"values":["''test''"]},{"schema":"fullname","readonly":false,"values":["''test''"]},{"schema":"surname","readonly":false,"values":["''test''"]}],"derivedAttributes":[],"virtualAttributes":[],"resources":["resource-testdb"],"propagationStatuses":[],"memberships":[]}', 'resource-csv', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.TASK(ID, DTYPE, CRONEXPRESSION, DESCRIPTION, JOBCLASSNAME, NAME, MATCHINGRULE, PERFORMCREATE, PERFORMDELETE, PERFORMUPDATE, SYNCSTATUS, UNMATCHINGRULE, FULLRECONCILIATION, ROLETEMPLATE, USERTEMPLATE, RESOURCE_NAME, ROLEFILTER, USERFILTER, ACCOUNTID, OBJECTCLASSNAME, OLDACCOUNTID, PROPAGATIONMODE, PROPAGATIONOPERATION, SUBJECTID, SUBJECTTYPE, XMLATTRIBUTES, EXECUTED, HTMLBODY, SENDER, SUBJECT, TEXTBODY, TRACELEVEL) VALUES
(25, 'SyncTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.SyncJob', 'CSV (unlink matching; ignore unmatching)', 'UNLINK', 1, 1, 1, 1, 'IGNORE', 0, NULL, NULL, 'resource-csv', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(26, 'SyncTask', NULL, NULL, 'org.apache.syncope.core.sync.impl.SyncJob', 'CSV (ignore matching; assign unmatching)', 'IGNORE', 1, 1, 1, 1, 'ASSIGN', 0, NULL, NULL, 'resource-csv', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);        
CREATE INDEX PUBLIC.I_TASK_DTYPE ON PUBLIC.TASK(DTYPE);        
CREATE INDEX PUBLIC.TASK_EXECUTEDINDEX ON PUBLIC.TASK(EXECUTED);               
CREATE MEMORY TABLE PUBLIC.TASKEXEC(
    ID BIGINT NOT NULL,
    ENDDATE TIMESTAMP,
    MESSAGE CLOB,
    STARTDATE TIMESTAMP,
    STATUS VARCHAR(255) NOT NULL,
    TASK_ID BIGINT
);         
ALTER TABLE PUBLIC.TASKEXEC ADD CONSTRAINT PUBLIC.CONSTRAINT_16 PRIMARY KEY(ID);               
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.TASKEXEC; 
INSERT INTO PUBLIC.TASKEXEC(ID, ENDDATE, MESSAGE, STARTDATE, STATUS, TASK_ID) VALUES
(1, TIMESTAMP '2015-12-17 09:42:00.506', NULL, TIMESTAMP '2015-12-17 09:40:00.506', 'SUCCESS', 1),
(6, TIMESTAMP '2015-12-17 09:42:00.506', NULL, TIMESTAMP '2015-12-17 09:40:00.506', 'SUCCESS', 6);     
CREATE MEMORY TABLE PUBLIC.UATTR(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
); 
ALTER TABLE PUBLIC.UATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_4C PRIMARY KEY(ID);  
-- 28 +/- SELECT COUNT(*) FROM PUBLIC.UATTR;   
INSERT INTO PUBLIC.UATTR(ID, OWNER_ID, SCHEMA_NAME) VALUES
(99, 1, 'type'),
(100, 1, 'fullname'),
(101, 1, 'firstname'),
(102, 1, 'surname'),
(103, 1, 'userId'),
(104, 1, 'loginDate'),
(105, 2, 'fullname'),
(106, 2, 'firstname'),
(107, 2, 'surname'),
(108, 2, 'userId'),
(109, 3, 'firstname'),
(110, 3, 'surname'),
(111, 3, 'fullname'),
(112, 3, 'userId'),
(113, 4, 'firstname'),
(114, 4, 'surname'),
(115, 4, 'fullname'),
(116, 4, 'userId'),
(117, 4, 'loginDate'),
(118, 4, 'cool'),
(119, 4, 'gender'),
(120, 5, 'firstname'),
(121, 5, 'surname'),
(122, 5, 'fullname'),
(123, 5, 'userId'),
(124, 2, 'email'),
(125, 3, 'email'),
(126, 3, 'type');          
CREATE INDEX PUBLIC.UATTR_OWNER_ID_INDEX ON PUBLIC.UATTR(OWNER_ID);            
CREATE MEMORY TABLE PUBLIC.UATTRUNIQUEVALUE(
    ID BIGINT NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID BIGINT,
    SCHEMA_NAME VARCHAR(255)
);             
ALTER TABLE PUBLIC.UATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_9B PRIMARY KEY(ID);       
-- 10 +/- SELECT COUNT(*) FROM PUBLIC.UATTRUNIQUEVALUE;        
INSERT INTO PUBLIC.UATTRUNIQUEVALUE(ID, BINARYVALUE, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE, ATTRIBUTE_ID, SCHEMA_NAME) VALUES
(10, NULL, NULL, NULL, NULL, NULL, 'Gioacchino Rossini', 100, 'fullname'),
(13, NULL, NULL, NULL, NULL, NULL, 'rossini@apache.org', 103, 'userId'),
(16, NULL, NULL, NULL, NULL, NULL, 'Giuseppe Verdi', 105, 'fullname'),
(19, NULL, NULL, NULL, NULL, NULL, 'verdi@apache.org', 108, 'userId'),
(22, NULL, NULL, NULL, NULL, NULL, 'Antonio Vivaldi', 111, 'fullname'),
(23, NULL, NULL, NULL, NULL, NULL, 'vivaldi@apache.org', 112, 'userId'),
(26, NULL, NULL, NULL, NULL, NULL, 'Vincenzo Bellini', 115, 'fullname'),
(27, NULL, NULL, NULL, NULL, NULL, 'bellini@apache.org', 116, 'userId'),
(33, NULL, NULL, NULL, NULL, NULL, 'Giacomo Puccini', 122, 'fullname'),
(34, NULL, NULL, NULL, NULL, NULL, 'puccini@apache.org', 123, 'userId');     
CREATE MEMORY TABLE PUBLIC.UATTRVALUE(
    ID BIGINT NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID BIGINT
); 
ALTER TABLE PUBLIC.UATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_C3 PRIMARY KEY(ID);             
-- 19 +/- SELECT COUNT(*) FROM PUBLIC.UATTRVALUE;              
INSERT INTO PUBLIC.UATTRVALUE(ID, BINARYVALUE, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE, ATTRIBUTE_ID) VALUES
(9, NULL, NULL, NULL, NULL, NULL, 'G', 99),
(11, NULL, NULL, NULL, NULL, NULL, 'Gioacchino', 101),
(12, NULL, NULL, NULL, NULL, NULL, 'Rossini', 102),
(14, NULL, NULL, TIMESTAMP '2009-05-26 00:00:00.0', NULL, NULL, NULL, 104),
(15, NULL, NULL, TIMESTAMP '2010-05-26 15:40:04.0', NULL, NULL, NULL, 104),
(17, NULL, NULL, NULL, NULL, NULL, 'Giuseppe', 106),
(18, NULL, NULL, NULL, NULL, NULL, 'Verdi', 107),
(20, NULL, NULL, NULL, NULL, NULL, 'Antonio', 109),
(21, NULL, NULL, NULL, NULL, NULL, 'Vivaldi', 110),
(24, NULL, NULL, NULL, NULL, NULL, 'Vincenzo', 113),
(25, NULL, NULL, NULL, NULL, NULL, 'Bellini', 114),
(28, NULL, NULL, TIMESTAMP '2009-06-24 00:00:00.0', NULL, NULL, NULL, 117),
(29, NULL, 1, NULL, NULL, NULL, NULL, 118),
(30, NULL, NULL, NULL, NULL, NULL, 'M', 119),
(31, NULL, NULL, NULL, NULL, NULL, 'Giacomo', 120),
(32, NULL, NULL, NULL, NULL, NULL, 'Puccini', 121),
(35, NULL, NULL, NULL, NULL, NULL, 'verdi@syncope.org', 124),
(36, NULL, NULL, NULL, NULL, NULL, 'vivaldi@syncope.org', 125),
(37, NULL, NULL, NULL, NULL, NULL, 'F', 126);             
CREATE INDEX PUBLIC.UATTRVALUE_BOOLEANVALUEINDEX ON PUBLIC.UATTRVALUE(BOOLEANVALUE);           
CREATE INDEX PUBLIC.UATTRVALUE_LONGVALUEINDEX ON PUBLIC.UATTRVALUE(LONGVALUE); 
CREATE INDEX PUBLIC.UATTRVALUE_DATEVALUEINDEX ON PUBLIC.UATTRVALUE(DATEVALUE); 
CREATE INDEX PUBLIC.UATTRVALUE_STRINGVALUEINDEX ON PUBLIC.UATTRVALUE(STRINGVALUE);             
CREATE INDEX PUBLIC.UATTRVALUE_DOUBLEVALUEINDEX ON PUBLIC.UATTRVALUE(DOUBLEVALUE);             
CREATE INDEX PUBLIC.UATTRVALUE_ATTRIBUTE_IDINDEX ON PUBLIC.UATTRVALUE(ATTRIBUTE_ID);           
CREATE MEMORY TABLE PUBLIC.UDERATTR(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    DERSCHEMA_NAME VARCHAR(255)
);           
ALTER TABLE PUBLIC.UDERATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_54 PRIMARY KEY(ID);               
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.UDERATTR; 
INSERT INTO PUBLIC.UDERATTR(ID, OWNER_ID, DERSCHEMA_NAME) VALUES
(100, 3, 'cn'),
(101, 1, 'cn');               
CREATE INDEX PUBLIC.UDERATTR_OWNER_ID_INDEX ON PUBLIC.UDERATTR(OWNER_ID);      
CREATE MEMORY TABLE PUBLIC.UDERSCHEMA(
    NAME VARCHAR(255) NOT NULL,
    EXPRESSION VARCHAR(255) NOT NULL
); 
ALTER TABLE PUBLIC.UDERSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_17 PRIMARY KEY(NAME);           
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.UDERSCHEMA;               
INSERT INTO PUBLIC.UDERSCHEMA(NAME, EXPRESSION) VALUES
('csvuserid', 'firstname + '','' + surname'),
('cn', 'surname + '', '' + firstname'),
('noschema', 'surname + '', '' + notfound');      
CREATE MEMORY TABLE PUBLIC.UMAPPING(
    ID BIGINT NOT NULL,
    ACCOUNTLINK VARCHAR(255),
    RESOURCE_NAME VARCHAR(255)
);   
ALTER TABLE PUBLIC.UMAPPING ADD CONSTRAINT PUBLIC.CONSTRAINT_DA PRIMARY KEY(ID);               
-- 18 +/- SELECT COUNT(*) FROM PUBLIC.UMAPPING;
INSERT INTO PUBLIC.UMAPPING(ID, ACCOUNTLINK, RESOURCE_NAME) VALUES
(1, NULL, 'ws-target-resource-2'),
(2, NULL, 'ws-target-resource-update'),
(3, NULL, 'ws-target-resource-nopropagation'),
(4, NULL, 'ws-target-resource-nopropagation2'),
(5, NULL, 'ws-target-resource-nopropagation3'),
(6, NULL, 'ws-target-resource-nopropagation4'),
(7, NULL, 'resource-testdb'),
(8, NULL, 'resource-testdb2'),
(9, NULL, 'resource-csv'),
(10, NULL, 'ws-target-resource-update-resetsynctoken'),
(11, '''uid='' + username + '',ou=people,o=isp''', 'resource-ldap'),
(12, NULL, 'ws-target-resource-list-mappings-1'),
(13, NULL, 'ws-target-resource-list-mappings-2'),
(15, NULL, 'ws-target-resource-1'),
(16, NULL, 'resource-db-sync'),
(17, NULL, 'resource-db-virattr'),
(18, NULL, 'ws-target-resource-timeout'),
(19, NULL, 'ws-target-resource-delete');
CREATE MEMORY TABLE PUBLIC.UMAPPINGITEM(
    ID BIGINT NOT NULL,
    ACCOUNTID INTEGER NOT NULL,
    EXTATTRNAME VARCHAR(255),
    INTATTRNAME VARCHAR(255),
    INTMAPPINGTYPE VARCHAR(23) NOT NULL,
    MANDATORYCONDITION VARCHAR(255) NOT NULL,
    PASSWORD INTEGER NOT NULL,
    PURPOSE VARCHAR(20) NOT NULL,
    MAPPING_ID BIGINT
);  
ALTER TABLE PUBLIC.UMAPPINGITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_C7 PRIMARY KEY(ID);           
-- 62 +/- SELECT COUNT(*) FROM PUBLIC.UMAPPINGITEM;            
INSERT INTO PUBLIC.UMAPPINGITEM(ID, ACCOUNTID, EXTATTRNAME, INTATTRNAME, INTMAPPINGTYPE, MANDATORYCONDITION, PASSWORD, PURPOSE, MAPPING_ID) VALUES
(99, 1, 'userId', NULL, 'UserId', 'true', 0, 'PROPAGATION', 15),
(100, 0, 'email', 'email', 'UserSchema', 'true', 0, 'PROPAGATION', 15),
(101, 0, 'surname', 'surname', 'UserSchema', 'true', 0, 'PROPAGATION', 15),
(102, 0, '__PASSWORD__', NULL, 'Password', 'true', 1, 'PROPAGATION', 15),
(103, 1, 'email', 'email', 'UserSchema', 'true', 0, 'PROPAGATION', 12),
(104, 0, 'surname', 'surname', 'UserSchema', 'true', 0, 'PROPAGATION', 12),
(105, 1, 'userId', 'userId', 'UserSchema', 'true', 0, 'PROPAGATION', 13),
(106, 1, 'fullname', 'fullname', 'UserSchema', 'true', 0, 'BOTH', 1),
(107, 0, '__PASSWORD__', NULL, 'Password', 'true', 1, 'BOTH', 1),
(108, 0, 'type', 'type', 'UserSchema', 'true', 0, 'BOTH', 1),
(109, 0, 'surname', 'surname', 'UserSchema', 'type == ''F''', 0, 'BOTH', 1),
(110, 0, 'name', 'virtualdata', 'UserVirtualSchema', 'type == ''F''', 0, 'BOTH', 1),
(111, 0, 'fullname', 'cn', 'UserDerivedSchema', 'true', 0, 'BOTH', 1),
(112, 0, 'email', 'email', 'UserSchema', 'false', 0, 'PROPAGATION', 2),
(113, 1, 'userId', 'userId', 'UserSchema', 'false', 0, 'PROPAGATION', 2),
(114, 0, 'test3', 'fullname', 'UserSchema', 'false', 0, 'PROPAGATION', 2),
(115, 1, 'fullname', 'fullname', 'UserSchema', 'true', 0, 'PROPAGATION', 3),
(116, 1, 'fullname', 'fullname', 'UserSchema', 'true', 0, 'PROPAGATION', 4),
(117, 1, 'fullname', 'fullname', 'UserSchema', 'true', 0, 'PROPAGATION', 5),
(118, 1, 'fullname', 'fullname', 'UserSchema', 'true', 0, 'PROPAGATION', 6),
(119, 1, 'id', NULL, 'Username', 'true', 0, 'BOTH', 7),
(120, 0, '__PASSWORD__', NULL, 'Password', 'true', 1, 'BOTH', 7),
(121, 1, 'id', NULL, 'Username', 'true', 0, 'PROPAGATION', 8),
(122, 0, '__PASSWORD__', NULL, 'Password', 'true', 1, 'PROPAGATION', 8),
(200, 0, 'id', NULL, 'Username', 'true', 0, 'BOTH', 9),
(201, 0, 'id', 'fullname', 'UserSchema', 'true', 0, 'BOTH', 9),
(202, 0, '__PASSWORD__', NULL, 'Password', 'true', 1, 'BOTH', 9),
(203, 0, 'name', 'firstname', 'UserSchema', 'false', 0, 'BOTH', 9),
(204, 0, 'surname', 'surname', 'UserSchema', 'false', 0, 'BOTH', 9),
(205, 0, 'email', 'userId', 'UserSchema', 'true', 0, 'SYNCHRONIZATION', 9),
(206, 0, 'email', 'email', 'UserSchema', 'true', 0, 'SYNCHRONIZATION', 9),
(207, 1, '__NAME__', 'csvuserid', 'UserDerivedSchema', 'true', 0, 'BOTH', 9),
(208, 0, 'role', 'rderToBePropagated', 'RoleDerivedSchema', 'false', 0, 'BOTH', 9),
(209, 0, 'membership', 'mderToBePropagated', 'MembershipDerivedSchema', 'false', 0, 'BOTH', 9),
(300, 1, 'userId', 'userId', 'UserSchema', 'false', 0, 'BOTH', 10),
(301, 0, '__PASSWORD__', 'fullname', 'UserSchema', 'false', 1, 'BOTH', 10),
(311, 1, 'cn', 'Username', 'Username', 'true', 0, 'BOTH', 11),
(312, 0, '__PASSWORD__', 'Password', 'Password', 'true', 1, 'BOTH', 11),
(313, 0, 'sn', 'surname', 'UserSchema', 'true', 0, 'BOTH', 11),
(314, 0, 'cn', 'fullname', 'UserSchema', 'true', 0, 'BOTH', 11),
(315, 0, 'mail', 'email', 'UserSchema', 'false', 0, 'BOTH', 11),
(316, 0, 'title', 'title', 'RoleSchema', 'false', 0, 'BOTH', 11),
(317, 0, 'postalAddress', 'postalAddress', 'MembershipSchema', 'false', 0, 'BOTH', 11),
(318, 0, 'mail', 'userId', 'UserSchema', 'false', 0, 'BOTH', 11),
(319, 0, 'givenname', 'virtualReadOnly', 'UserVirtualSchema', 'false', 0, 'BOTH', 11),
(320, 0, 'registeredAddress', 'obscure', 'UserSchema', 'false', 0, 'BOTH', 11),
(321, 0, 'jpegPhoto', 'photo', 'UserSchema', 'false', 0, 'BOTH', 11),
(322, 0, 'EMAIL', 'email', 'UserSchema', 'false', 0, 'BOTH', 16),
(323, 0, 'SURNAME', 'fullname', 'UserSchema', 'false', 0, 'BOTH', 16),
(324, 1, 'ID', 'aLong', 'UserSchema', 'false', 0, 'BOTH', 16),
(325, 0, 'SURNAME', 'surname', 'UserSchema', 'false', 0, 'BOTH', 16),
(326, 0, 'USERNAME', 'Username', 'Username', 'false', 0, 'BOTH', 16),
(327, 0, 'EMAIL', 'userId', 'UserSchema', 'false', 0, 'BOTH', 16),
(331, 1, 'id', NULL, 'UserId', 'true', 0, 'BOTH', 17),
(332, 0, 'USERNAME', 'virtualdata', 'UserVirtualSchema', 'false', 0, 'BOTH', 17),
(333, 1, 'fullname', 'fullname', 'UserSchema', 'true', 0, 'PROPAGATION', 18); 
INSERT INTO PUBLIC.UMAPPINGITEM(ID, ACCOUNTID, EXTATTRNAME, INTATTRNAME, INTMAPPINGTYPE, MANDATORYCONDITION, PASSWORD, PURPOSE, MAPPING_ID) VALUES
(334, 1, 'userId', NULL, 'Username', 'true', 0, 'PROPAGATION', 19),
(335, 0, 'fullname', 'surname', 'UserSchema', 'true', 0, 'PROPAGATION', 15),
(336, 0, 'type', 'type', 'UserSchema', 'true', 0, 'PROPAGATION', 15),
(337, 0, 'name', 'firstname', 'UserSchema', 'false', 0, 'NONE', 15),
(338, 0, 'SURNAME', 'virtualPropagation', 'UserVirtualSchema', 'false', 0, 'BOTH', 17),
(339, 0, 'givenname', 'virtualPropagation', 'UserVirtualSchema', 'false', 0, 'BOTH', 11);               
CREATE MEMORY TABLE PUBLIC.USCHEMA(
    NAME VARCHAR(255) NOT NULL,
    CIPHERALGORITHM VARCHAR(20),
    CONVERSIONPATTERN VARCHAR(255),
    ENUMERATIONKEYS CLOB,
    ENUMERATIONVALUES CLOB,
    MANDATORYCONDITION VARCHAR(255) NOT NULL,
    MIMETYPE VARCHAR(255),
    MULTIVALUE INTEGER,
    READONLY INTEGER,
    SECRETKEY VARCHAR(255),
    TYPE VARCHAR(20) NOT NULL,
    UNIQUECONSTRAINT INTEGER,
    VALIDATORCLASS VARCHAR(255)
);              
ALTER TABLE PUBLIC.USCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_21E PRIMARY KEY(NAME);             
-- 15 +/- SELECT COUNT(*) FROM PUBLIC.USCHEMA; 
INSERT INTO PUBLIC.USCHEMA(NAME, CIPHERALGORITHM, CONVERSIONPATTERN, ENUMERATIONKEYS, ENUMERATIONVALUES, MANDATORYCONDITION, MIMETYPE, MULTIVALUE, READONLY, SECRETKEY, TYPE, UNIQUECONSTRAINT, VALIDATORCLASS) VALUES
('fullname', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'String', 1, NULL),
('userId', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'String', 1, 'org.apache.syncope.core.persistence.validation.attrvalue.EmailAddressValidator'),
('loginDate', NULL, 'yyyy-MM-dd', NULL, NULL, 'false', NULL, 1, 0, NULL, 'Date', 0, NULL),
('firstname', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL),
('surname', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'String', 0, NULL),
('type', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL),
('email', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, 'org.apache.syncope.core.persistence.validation.attrvalue.EmailAddressValidator'),
('activationDate', NULL, 'yyyy-MM-dd''T''HH:mm:ss.SSSZ', NULL, NULL, 'false', NULL, 0, 0, NULL, 'Date', 0, NULL),
('uselessReadonly', NULL, NULL, NULL, NULL, 'false', NULL, 0, 1, NULL, 'String', 0, NULL),
('cool', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'Boolean', 0, NULL),
('gender', NULL, NULL, NULL, 'M;F', 'false', NULL, 0, 0, NULL, 'Enum', 0, NULL),
('aLong', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'Long', 0, NULL),
('makeItDouble', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'Long', 0, NULL),
('obscure', 'SHA', NULL, NULL, NULL, 'false', NULL, 0, 0, '7abcdefghilmnopqrstuvz9#', 'Encrypted', 0, NULL),
('photo', NULL, NULL, NULL, NULL, 'false', 'image/jpeg', 0, 0, NULL, 'Binary', 0, NULL);
CREATE MEMORY TABLE PUBLIC.UVIRATTR(
    ID BIGINT NOT NULL,
    OWNER_ID BIGINT,
    VIRSCHEMA_NAME VARCHAR(255)
);           
ALTER TABLE PUBLIC.UVIRATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_C4 PRIMARY KEY(ID);               
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.UVIRATTR; 
INSERT INTO PUBLIC.UVIRATTR(ID, OWNER_ID, VIRSCHEMA_NAME) VALUES
(1000, 3, 'virtualdata');     
CREATE INDEX PUBLIC.UVIRATTR_OWNER_ID_INDEX ON PUBLIC.UVIRATTR(OWNER_ID);      
CREATE MEMORY TABLE PUBLIC.UVIRSCHEMA(
    NAME VARCHAR(255) NOT NULL,
    READONLY INTEGER
); 
ALTER TABLE PUBLIC.UVIRSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_DC PRIMARY KEY(NAME);           
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.UVIRSCHEMA;               
INSERT INTO PUBLIC.UVIRSCHEMA(NAME, READONLY) VALUES
('virtualdata', NULL),
('virtualPropagation', NULL),
('virtualReadOnly', 1);              
CREATE FORCE VIEW PUBLIC.ROLE_SEARCH_ATTR(SUBJECT_ID, SCHEMA_NAME, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    RA.OWNER_ID AS SUBJECT_ID,
    RAT.SCHEMA_NAME AS SCHEMA_NAME,
    RAV.BOOLEANVALUE AS BOOLEANVALUE,
    RAV.DATEVALUE AS DATEVALUE,
    RAV.DOUBLEVALUE AS DOUBLEVALUE,
    RAV.LONGVALUE AS LONGVALUE,
    RAV.STRINGVALUE AS STRINGVALUE
FROM PUBLIC.RATTRVALUE RAV
    /* PUBLIC.RATTRVALUE.tableScan */
INNER JOIN PUBLIC.RATTR RA
    /* PUBLIC.PRIMARY_KEY_4A: ID = RAV.ATTRIBUTE_ID */
    ON 1=1
    /* WHERE RAV.ATTRIBUTE_ID = RA.ID
    */
INNER JOIN PUBLIC.RATTRTEMPLATE RAT
    /* PUBLIC.PRIMARY_KEY_BB: ID = RA.TEMPLATE_ID */
    ON 1=1
WHERE (RAV.ATTRIBUTE_ID = RA.ID)
    AND (RA.TEMPLATE_ID = RAT.ID);  
CREATE FORCE VIEW PUBLIC.USER_SEARCH(SUBJECT_ID, ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, CHANGEPWDDATE, CIPHERALGORITHM, FAILEDLOGINS, LASTLOGINDATE, PASSWORD, SECURITYANSWER, STATUS, SUSPENDED, TOKEN, TOKENEXPIRETIME, USERNAME, WORKFLOWID, SECURITYQUESTION_ID) AS
SELECT
    U.ID AS SUBJECT_ID,
    U.ID,
    U.CREATIONDATE,
    U.CREATOR,
    U.LASTCHANGEDATE,
    U.LASTMODIFIER,
    U.CHANGEPWDDATE,
    U.CIPHERALGORITHM,
    U.FAILEDLOGINS,
    U.LASTLOGINDATE,
    U.PASSWORD,
    U.SECURITYANSWER,
    U.STATUS,
    U.SUSPENDED,
    U.TOKEN,
    U.TOKENEXPIRETIME,
    U.USERNAME,
    U.WORKFLOWID,
    U.SECURITYQUESTION_ID
FROM PUBLIC.SYNCOPEUSER U
    /* PUBLIC.SYNCOPEUSER.tableScan */;    
CREATE FORCE VIEW PUBLIC.USER_SEARCH_ATTR(SUBJECT_ID, SCHEMA_NAME, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    UA.OWNER_ID AS SUBJECT_ID,
    UA.SCHEMA_NAME AS SCHEMA_NAME,
    UAV.BOOLEANVALUE AS BOOLEANVALUE,
    UAV.DATEVALUE AS DATEVALUE,
    UAV.DOUBLEVALUE AS DOUBLEVALUE,
    UAV.LONGVALUE AS LONGVALUE,
    UAV.STRINGVALUE AS STRINGVALUE
FROM PUBLIC.UATTRVALUE UAV
    /* PUBLIC.UATTRVALUE.tableScan */
INNER JOIN PUBLIC.UATTR UA
    /* PUBLIC.PRIMARY_KEY_4C: ID = UAV.ATTRIBUTE_ID */
    ON 1=1
WHERE UAV.ATTRIBUTE_ID = UA.ID;        
CREATE FORCE VIEW PUBLIC.USER_SEARCH_ROLE_RESOURCE(SUBJECT_ID, RESOURCE_NAME) AS
SELECT
    M.SYNCOPEUSER_ID AS SUBJECT_ID,
    ST.RESOURCE_NAME AS RESOURCE_NAME
FROM PUBLIC.MEMBERSHIP M
    /* PUBLIC.MEMBERSHIP.tableScan */
INNER JOIN PUBLIC.SYNCOPEROLE_EXTERNALRESOURCE ST
    /* PUBLIC.CONSTRAINT_INDEX_EC: ROLE_ID = M.SYNCOPEROLE_ID
        AND ROLE_ID = M.SYNCOPEROLE_ID
     */
    ON 1=1
    /* WHERE ((M.SYNCOPEROLE_ID = ST.ROLE_ID)
        AND (M.SYNCOPEROLE_ID = ST.ROLE_ID))
        AND (ST.ROLE_ID = ST.ROLE_ID)
    */
INNER JOIN PUBLIC.SYNCOPEROLE R
    /* PUBLIC.PRIMARY_KEY_6FF: ID = M.SYNCOPEROLE_ID
        AND ID = ST.ROLE_ID
     */
    ON 1=1
WHERE (M.SYNCOPEROLE_ID = ST.ROLE_ID)
    AND (((M.SYNCOPEROLE_ID = R.ID)
    AND (ST.ROLE_ID = R.ID))
    AND (M.SYNCOPEROLE_ID = ST.ROLE_ID));        
CREATE FORCE VIEW PUBLIC.USER_SEARCH_NULL_ATTR(SUBJECT_ID, SCHEMA_NAME, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    U.ID AS SUBJECT_ID,
    USCHEMA.NAME AS SCHEMA_NAME,
    NULL AS BOOLEANVALUE,
    NULL AS DATEVALUE,
    NULL AS DOUBLEVALUE,
    NULL AS LONGVALUE,
    NULL AS STRINGVALUE
FROM PUBLIC.SYNCOPEUSER U
    /* PUBLIC.SYNCOPEUSER.tableScan */
INNER JOIN PUBLIC.USCHEMA
    /* PUBLIC.USCHEMA.tableScan */
    ON 1=1
LEFT OUTER JOIN PUBLIC.UATTR UA
    /* PUBLIC.CONSTRAINT_INDEX_4C: OWNER_ID = U.ID */
    ON (USCHEMA.NAME = UA.SCHEMA_NAME)
    AND (UA.OWNER_ID = U.ID)
WHERE UA.ID IS NULL;      
CREATE FORCE VIEW PUBLIC.ROLE_SEARCH_NULL_ATTR(SUBJECT_ID, SCHEMA_NAME, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    R.ID AS SUBJECT_ID,
    RSCHEMA.NAME AS SCHEMA_NAME,
    NULL AS BOOLEANVALUE,
    NULL AS DATEVALUE,
    NULL AS DOUBLEVALUE,
    NULL AS LONGVALUE,
    NULL AS STRINGVALUE
FROM PUBLIC.SYNCOPEROLE R
    /* PUBLIC.SYNCOPEROLE.tableScan */
INNER JOIN PUBLIC.RSCHEMA
    /* PUBLIC.RSCHEMA.tableScan */
    ON 1=1
LEFT OUTER JOIN PUBLIC.RATTR RA
    /* PUBLIC.CONSTRAINT_INDEX_4A: OWNER_ID = R.ID */
    ON RA.OWNER_ID = R.ID
LEFT OUTER JOIN PUBLIC.RATTRTEMPLATE RAT
    /* PUBLIC.PRIMARY_KEY_BB: ID = RA.TEMPLATE_ID */
    ON (RSCHEMA.NAME = RAT.SCHEMA_NAME)
    AND (RA.TEMPLATE_ID = RAT.ID)
WHERE RA.ID IS NULL;        
CREATE FORCE VIEW PUBLIC.USER_SEARCH_RESOURCE(SUBJECT_ID, RESOURCE_NAME) AS
SELECT
    ST.USER_ID AS SUBJECT_ID,
    ST.RESOURCE_NAME AS RESOURCE_NAME
FROM PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE ST
    /* PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE.tableScan */;    
CREATE FORCE VIEW PUBLIC.USER_SEARCH_MEMBERSHIP(SUBJECT_ID, ROLE_ID, ROLE_NAME) AS
SELECT
    M.SYNCOPEUSER_ID AS SUBJECT_ID,
    R.ID AS ROLE_ID,
    R.NAME AS ROLE_NAME
FROM PUBLIC.MEMBERSHIP M
    /* PUBLIC.MEMBERSHIP.tableScan */
INNER JOIN PUBLIC.SYNCOPEROLE R
    /* PUBLIC.PRIMARY_KEY_6FF: ID = M.SYNCOPEROLE_ID */
    ON 1=1
WHERE M.SYNCOPEROLE_ID = R.ID;    
CREATE FORCE VIEW PUBLIC.ROLE_SEARCH_UNIQUE_ATTR(SUBJECT_ID, SCHEMA_NAME, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    RA.OWNER_ID AS SUBJECT_ID,
    RAT.SCHEMA_NAME AS SCHEMA_NAME,
    RAV.BOOLEANVALUE AS BOOLEANVALUE,
    RAV.DATEVALUE AS DATEVALUE,
    RAV.DOUBLEVALUE AS DOUBLEVALUE,
    RAV.LONGVALUE AS LONGVALUE,
    RAV.STRINGVALUE AS STRINGVALUE
FROM PUBLIC.RATTRUNIQUEVALUE RAV
    /* PUBLIC.RATTRUNIQUEVALUE.tableScan */
INNER JOIN PUBLIC.RATTR RA
    /* PUBLIC.PRIMARY_KEY_4A: ID = RAV.ATTRIBUTE_ID */
    ON 1=1
    /* WHERE RAV.ATTRIBUTE_ID = RA.ID
    */
INNER JOIN PUBLIC.RATTRTEMPLATE RAT
    /* PUBLIC.PRIMARY_KEY_BB: ID = RA.TEMPLATE_ID */
    ON 1=1
WHERE (RAV.ATTRIBUTE_ID = RA.ID)
    AND (RA.TEMPLATE_ID = RAT.ID);               
CREATE FORCE VIEW PUBLIC.ROLE_SEARCH_ENTITLEMENTS(SUBJECT_ID, ENTITLEMENT_NAME) AS
SELECT
    ST.ROLE_ID AS SUBJECT_ID,
    ST.ENTITLEMENT_NAME AS ENTITLEMENT_NAME
FROM PUBLIC.SYNCOPEROLE_ENTITLEMENT ST
    /* PUBLIC.SYNCOPEROLE_ENTITLEMENT.tableScan */; 
CREATE FORCE VIEW PUBLIC.ROLE_SEARCH(SUBJECT_ID, ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, INHERITACCOUNTPOLICY, INHERITATTRS, INHERITDERATTRS, INHERITOWNER, INHERITPASSWORDPOLICY, INHERITTEMPLATES, INHERITVIRATTRS, NAME, ACCOUNTPOLICY_ID, PARENT_ID, PASSWORDPOLICY_ID, ROLEOWNER_ID, USEROWNER_ID) AS
SELECT
    R.ID AS SUBJECT_ID,
    R.ID,
    R.CREATIONDATE,
    R.CREATOR,
    R.LASTCHANGEDATE,
    R.LASTMODIFIER,
    R.INHERITACCOUNTPOLICY,
    R.INHERITATTRS,
    R.INHERITDERATTRS,
    R.INHERITOWNER,
    R.INHERITPASSWORDPOLICY,
    R.INHERITTEMPLATES,
    R.INHERITVIRATTRS,
    R.NAME,
    R.ACCOUNTPOLICY_ID,
    R.PARENT_ID,
    R.PASSWORDPOLICY_ID,
    R.ROLEOWNER_ID,
    R.USEROWNER_ID
FROM PUBLIC.SYNCOPEROLE R
    /* PUBLIC.SYNCOPEROLE.tableScan */;
CREATE FORCE VIEW PUBLIC.USER_SEARCH_UNIQUE_ATTR(SUBJECT_ID, SCHEMA_NAME, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    UA.OWNER_ID AS SUBJECT_ID,
    UA.SCHEMA_NAME AS SCHEMA_NAME,
    UAV.BOOLEANVALUE AS BOOLEANVALUE,
    UAV.DATEVALUE AS DATEVALUE,
    UAV.DOUBLEVALUE AS DOUBLEVALUE,
    UAV.LONGVALUE AS LONGVALUE,
    UAV.STRINGVALUE AS STRINGVALUE
FROM PUBLIC.UATTRUNIQUEVALUE UAV
    /* PUBLIC.UATTRUNIQUEVALUE.tableScan */
INNER JOIN PUBLIC.UATTR UA
    /* PUBLIC.PRIMARY_KEY_4C: ID = UAV.ATTRIBUTE_ID */
    ON 1=1
WHERE UAV.ATTRIBUTE_ID = UA.ID;     
CREATE FORCE VIEW PUBLIC.ROLE_SEARCH_RESOURCE(SUBJECT_ID, RESOURCE_NAME) AS
SELECT
    ST.ROLE_ID AS SUBJECT_ID,
    ST.RESOURCE_NAME AS RESOURCE_NAME
FROM PUBLIC.SYNCOPEROLE_EXTERNALRESOURCE ST
    /* PUBLIC.SYNCOPEROLE_EXTERNALRESOURCE.tableScan */;    
DROP TABLE IF EXISTS SYSTEM_LOB_STREAM;        
CALL SYSTEM_COMBINE_BLOB(-1);  
DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB;      
DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB;      
ALTER TABLE PUBLIC.REPORT ADD CONSTRAINT PUBLIC.U_REPORT_NAME UNIQUE(NAME);    
ALTER TABLE PUBLIC.RATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_RTTRQVL_STRINGVALUE UNIQUE(STRINGVALUE, SCHEMA_NAME);              
ALTER TABLE PUBLIC.ACT_HI_PROCINST ADD CONSTRAINT PUBLIC.CONSTRAINT_8D1 UNIQUE(PROC_INST_ID_); 
ALTER TABLE PUBLIC.SECURITYQUESTION ADD CONSTRAINT PUBLIC.U_SCRTSTN_CONTENT UNIQUE(CONTENT);   
ALTER TABLE PUBLIC.UATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_TTRNQVL_BOOLEANVALUE UNIQUE(BOOLEANVALUE, SCHEMA_NAME);            
ALTER TABLE PUBLIC.UATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_TTRNQVL_LONGVALUE UNIQUE(LONGVALUE, SCHEMA_NAME);  
ALTER TABLE PUBLIC.CATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_CTTRQVL_BOOLEANVALUE UNIQUE(BOOLEANVALUE, SCHEMA_NAME);            
ALTER TABLE PUBLIC.CATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_CTTRQVL_DOUBLEVALUE UNIQUE(DOUBLEVALUE, SCHEMA_NAME);              
ALTER TABLE PUBLIC.RATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_RTTRQVL_DATEVALUE UNIQUE(DATEVALUE, SCHEMA_NAME);  
ALTER TABLE PUBLIC.SYNCOPEROLE ADD CONSTRAINT PUBLIC.U_SYNCPRL_NAME UNIQUE(NAME, PARENT_ID);   
ALTER TABLE PUBLIC.MATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_MTTRQVL_STRINGVALUE UNIQUE(STRINGVALUE, SCHEMA_NAME);              
ALTER TABLE PUBLIC.CATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_CTTRQVL_STRINGVALUE UNIQUE(STRINGVALUE, SCHEMA_NAME);              
ALTER TABLE PUBLIC.CATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_CTTRQVL_DATEVALUE UNIQUE(DATEVALUE, SCHEMA_NAME);  
ALTER TABLE PUBLIC.MATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_MTTRQVL_DOUBLEVALUE UNIQUE(DOUBLEVALUE, SCHEMA_NAME);              
ALTER TABLE PUBLIC.MATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_MTTRQVL_BOOLEANVALUE UNIQUE(BOOLEANVALUE, SCHEMA_NAME);            
ALTER TABLE PUBLIC.CONNINSTANCE ADD CONSTRAINT PUBLIC.U_CNNNTNC_DISPLAYNAME UNIQUE(DISPLAYNAME);               
ALTER TABLE PUBLIC.MATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_MTTRQVL_DATEVALUE UNIQUE(DATEVALUE, SCHEMA_NAME);  
ALTER TABLE PUBLIC.RATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_RTTRQVL_BOOLEANVALUE UNIQUE(BOOLEANVALUE, SCHEMA_NAME);            
ALTER TABLE PUBLIC.SYNCOPEUSER ADD CONSTRAINT PUBLIC.U_SYNCPSR_USERNAME UNIQUE(USERNAME);      
ALTER TABLE PUBLIC.CATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_CTTRQVL_LONGVALUE UNIQUE(LONGVALUE, SCHEMA_NAME);  
ALTER TABLE PUBLIC.RATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_RTTRQVL_LONGVALUE UNIQUE(LONGVALUE, SCHEMA_NAME);  
ALTER TABLE PUBLIC.UATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_TTRNQVL_STRINGVALUE UNIQUE(STRINGVALUE, SCHEMA_NAME);              
ALTER TABLE PUBLIC.MEMBERSHIP ADD CONSTRAINT PUBLIC.U_MMBRSHP_SYNCOPEUSER_ID UNIQUE(SYNCOPEUSER_ID, SYNCOPEROLE_ID);           
ALTER TABLE PUBLIC.UATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_TTRNQVL_DATEVALUE UNIQUE(DATEVALUE, SCHEMA_NAME);  
ALTER TABLE PUBLIC.ACT_RE_PROCDEF ADD CONSTRAINT PUBLIC.ACT_UNIQ_PROCDEF UNIQUE(KEY_, VERSION_, TENANT_ID_);   
ALTER TABLE PUBLIC.MATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_MTTRQVL_LONGVALUE UNIQUE(LONGVALUE, SCHEMA_NAME);  
ALTER TABLE PUBLIC.RATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_RTTRQVL_DOUBLEVALUE UNIQUE(DOUBLEVALUE, SCHEMA_NAME);              
ALTER TABLE PUBLIC.UATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_TTRNQVL_DOUBLEVALUE UNIQUE(DOUBLEVALUE, SCHEMA_NAME);              
ALTER TABLE PUBLIC.EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_FB20CD FOREIGN KEY(SYNCPOLICY_ID) REFERENCES PUBLIC.POLICY(ID) NOCHECK;   
ALTER TABLE PUBLIC.SYNCOPEROLE ADD CONSTRAINT PUBLIC.CONSTRAINT_6FF9A1 FOREIGN KEY(PASSWORDPOLICY_ID) REFERENCES PUBLIC.POLICY(ID) NOCHECK;    
ALTER TABLE PUBLIC.UDERATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_54C5 FOREIGN KEY(DERSCHEMA_NAME) REFERENCES PUBLIC.UDERSCHEMA(NAME) NOCHECK;      
ALTER TABLE PUBLIC.MVIRATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_854 FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.MEMBERSHIP(ID) NOCHECK;               
ALTER TABLE PUBLIC.SYNCOPEROLE ADD CONSTRAINT PUBLIC.CONSTRAINT_6FF9A1FF_0 FOREIGN KEY(USEROWNER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;
ALTER TABLE PUBLIC.UATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_4CC9 FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.USCHEMA(NAME) NOCHECK;               
ALTER TABLE PUBLIC.POLICY_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_A6 FOREIGN KEY(ACCOUNT_POLICY_ID) REFERENCES PUBLIC.POLICY(ID) NOCHECK;            
ALTER TABLE PUBLIC.POLICY_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_A65 FOREIGN KEY(RESOURCE_NAME) REFERENCES PUBLIC.EXTERNALRESOURCE(NAME) NOCHECK;   
ALTER TABLE PUBLIC.TASKEXEC ADD CONSTRAINT PUBLIC.CONSTRAINT_163 FOREIGN KEY(TASK_ID) REFERENCES PUBLIC.TASK(ID) NOCHECK;      
ALTER TABLE PUBLIC.ACT_RE_MODEL ADD CONSTRAINT PUBLIC.ACT_FK_MODEL_SOURCE FOREIGN KEY(EDITOR_SOURCE_VALUE_ID_) REFERENCES PUBLIC.ACT_GE_BYTEARRAY(ID_) NOCHECK;
ALTER TABLE PUBLIC.SYNCOPEUSER ADD CONSTRAINT PUBLIC.CONSTRAINT_6FFB0 FOREIGN KEY(SECURITYQUESTION_ID) REFERENCES PUBLIC.SECURITYQUESTION(ID) NOCHECK;         
ALTER TABLE PUBLIC.RVIRATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_8CA FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;              
ALTER TABLE PUBLIC.EXTERNALRESOURCE_PROPACTIONS ADD CONSTRAINT PUBLIC.CONSTRAINT_25 FOREIGN KEY(EXTERNALRESOURCE_NAME) REFERENCES PUBLIC.EXTERNALRESOURCE(NAME) NOCHECK;       
ALTER TABLE PUBLIC.ACT_RU_EXECUTION ADD CONSTRAINT PUBLIC.ACT_FK_EXE_PARENT FOREIGN KEY(PARENT_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;           
ALTER TABLE PUBLIC.TASK ADD CONSTRAINT PUBLIC.CONSTRAINT_272 FOREIGN KEY(RESOURCE_NAME) REFERENCES PUBLIC.EXTERNALRESOURCE(NAME) NOCHECK;      
ALTER TABLE PUBLIC.RDERATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_BACB FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.RDERSCHEMA(NAME) NOCHECK; 
ALTER TABLE PUBLIC.CATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_BFA FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.CATTR(ID) NOCHECK;        
ALTER TABLE PUBLIC.UMAPPINGITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_C7F FOREIGN KEY(MAPPING_ID) REFERENCES PUBLIC.UMAPPING(ID) NOCHECK;           
ALTER TABLE PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_C7A FOREIGN KEY(USER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;           
ALTER TABLE PUBLIC.RVIRATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_93B FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;      
ALTER TABLE PUBLIC.NOTIFICATION_STATICRECIPIENTS ADD CONSTRAINT PUBLIC.CONSTRAINT_B7 FOREIGN KEY(NOTIFICATION_ID) REFERENCES PUBLIC.NOTIFICATION(ID) NOCHECK;  
ALTER TABLE PUBLIC.ACT_RU_TASK ADD CONSTRAINT PUBLIC.ACT_FK_TASK_PROCDEF FOREIGN KEY(PROC_DEF_ID_) REFERENCES PUBLIC.ACT_RE_PROCDEF(ID_) NOCHECK;              
ALTER TABLE PUBLIC.UMAPPING ADD CONSTRAINT PUBLIC.CONSTRAINT_DA7 FOREIGN KEY(RESOURCE_NAME) REFERENCES PUBLIC.EXTERNALRESOURCE(NAME) NOCHECK;  
ALTER TABLE PUBLIC.SYNCOPEROLE_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_EC6 FOREIGN KEY(RESOURCE_NAME) REFERENCES PUBLIC.EXTERNALRESOURCE(NAME) NOCHECK;              
ALTER TABLE PUBLIC.ACT_RU_VARIABLE ADD CONSTRAINT PUBLIC.ACT_FK_VAR_BYTEARRAY FOREIGN KEY(BYTEARRAY_ID_) REFERENCES PUBLIC.ACT_GE_BYTEARRAY(ID_) NOCHECK;      
ALTER TABLE PUBLIC.MDERATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_52F FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;      
ALTER TABLE PUBLIC.RATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_4A2 FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK; 
ALTER TABLE PUBLIC.NOTIFICATION_EVENTS ADD CONSTRAINT PUBLIC.CONSTRAINT_7FA FOREIGN KEY(NOTIFICATION_ID) REFERENCES PUBLIC.NOTIFICATION(ID) NOCHECK;           
ALTER TABLE PUBLIC.QRTZ_SIMPROP_TRIGGERS ADD CONSTRAINT PUBLIC.FK_QRTZ_SIMPROP_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) REFERENCES PUBLIC.QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) ON DELETE CASCADE NOCHECK; 
ALTER TABLE PUBLIC.ACT_RU_IDENTITYLINK ADD CONSTRAINT PUBLIC.ACT_FK_ATHRZ_PROCEDEF FOREIGN KEY(PROC_DEF_ID_) REFERENCES PUBLIC.ACT_RE_PROCDEF(ID_) NOCHECK;    
ALTER TABLE PUBLIC.ACT_RU_EXECUTION ADD CONSTRAINT PUBLIC.ACT_FK_EXE_PROCINST FOREIGN KEY(PROC_INST_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;      
ALTER TABLE PUBLIC.CATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_BFAB FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.CSCHEMA(NAME) NOCHECK;    
ALTER TABLE PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_C7A3 FOREIGN KEY(RESOURCE_NAME) REFERENCES PUBLIC.EXTERNALRESOURCE(NAME) NOCHECK;             
ALTER TABLE PUBLIC.EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_FB2 FOREIGN KEY(ACCOUNTPOLICY_ID) REFERENCES PUBLIC.POLICY(ID) NOCHECK;   
ALTER TABLE PUBLIC.RATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_4A25 FOREIGN KEY(TEMPLATE_ID) REFERENCES PUBLIC.RATTRTEMPLATE(ID) NOCHECK;           
ALTER TABLE PUBLIC.UATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_9BED FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.USCHEMA(NAME) NOCHECK;    
ALTER TABLE PUBLIC.MATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_8F5 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.MATTR(ID) NOCHECK;        
ALTER TABLE PUBLIC.SYNCOPEROLE ADD CONSTRAINT PUBLIC.CONSTRAINT_6FF9 FOREIGN KEY(ACCOUNTPOLICY_ID) REFERENCES PUBLIC.POLICY(ID) NOCHECK;       
ALTER TABLE PUBLIC.MATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_45B FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.MEMBERSHIP(ID) NOCHECK;  
ALTER TABLE PUBLIC.RATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_E71 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.RATTR(ID) NOCHECK;              
ALTER TABLE PUBLIC.ACT_GE_BYTEARRAY ADD CONSTRAINT PUBLIC.ACT_FK_BYTEARR_DEPL FOREIGN KEY(DEPLOYMENT_ID_) REFERENCES PUBLIC.ACT_RE_DEPLOYMENT(ID_) NOCHECK;    
ALTER TABLE PUBLIC.RATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_BB03 FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.RSCHEMA(NAME) NOCHECK;       
ALTER TABLE PUBLIC.RMAPPINGITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_B0E FOREIGN KEY(MAPPING_ID) REFERENCES PUBLIC.RMAPPING(ID) NOCHECK;           
ALTER TABLE PUBLIC.CATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_3CE FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.CSCHEMA(NAME) NOCHECK;
ALTER TABLE PUBLIC.ACT_RU_VARIABLE ADD CONSTRAINT PUBLIC.ACT_FK_VAR_PROCINST FOREIGN KEY(PROC_INST_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;       
ALTER TABLE PUBLIC.CATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_96 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.CATTR(ID) NOCHECK;               
ALTER TABLE PUBLIC.ACT_RU_JOB ADD CONSTRAINT PUBLIC.ACT_FK_JOB_EXCEPTION FOREIGN KEY(EXCEPTION_STACK_ID_) REFERENCES PUBLIC.ACT_GE_BYTEARRAY(ID_) NOCHECK;     
ALTER TABLE PUBLIC.MEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_CD07 FOREIGN KEY(SYNCOPEROLE_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;     
ALTER TABLE PUBLIC.MVIRATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_8546 FOREIGN KEY(TEMPLATE_ID) REFERENCES PUBLIC.MVIRATTRTEMPLATE(ID) NOCHECK;     
ALTER TABLE PUBLIC.RDERATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_CDA8 FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;             
ALTER TABLE PUBLIC.ACT_RU_IDENTITYLINK ADD CONSTRAINT PUBLIC.ACT_FK_TSKASS_TASK FOREIGN KEY(TASK_ID_) REFERENCES PUBLIC.ACT_RU_TASK(ID_) NOCHECK;              
ALTER TABLE PUBLIC.MATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_8F5E FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.MSCHEMA(NAME) NOCHECK;    
ALTER TABLE PUBLIC.RATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_F73 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.RATTR(ID) NOCHECK;        
ALTER TABLE PUBLIC.SYNCOPEROLE ADD CONSTRAINT PUBLIC.CONSTRAINT_6FF9A FOREIGN KEY(PARENT_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;        
ALTER TABLE PUBLIC.ACT_RU_TASK ADD CONSTRAINT PUBLIC.ACT_FK_TASK_EXE FOREIGN KEY(EXECUTION_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;               
ALTER TABLE PUBLIC.EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_FB20C FOREIGN KEY(PASSWORDPOLICY_ID) REFERENCES PUBLIC.POLICY(ID) NOCHECK;
ALTER TABLE PUBLIC.ACT_RU_EVENT_SUBSCR ADD CONSTRAINT PUBLIC.ACT_FK_EVENT_EXEC FOREIGN KEY(EXECUTION_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;     
ALTER TABLE PUBLIC.ACT_RU_VARIABLE ADD CONSTRAINT PUBLIC.ACT_FK_VAR_EXE FOREIGN KEY(EXECUTION_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;            
ALTER TABLE PUBLIC.UATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_4CC FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK; 
ALTER TABLE PUBLIC.MDERATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_C642 FOREIGN KEY(TEMPLATE_ID) REFERENCES PUBLIC.MDERATTRTEMPLATE(ID) NOCHECK;     
ALTER TABLE PUBLIC.ACT_ID_MEMBERSHIP ADD CONSTRAINT PUBLIC.ACT_FK_MEMB_GROUP FOREIGN KEY(GROUP_ID_) REFERENCES PUBLIC.ACT_ID_GROUP(ID_) NOCHECK;               
ALTER TABLE PUBLIC.QRTZ_SIMPLE_TRIGGERS ADD CONSTRAINT PUBLIC.FK_QRTZ_SIMPLE_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) REFERENCES PUBLIC.QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) ON DELETE CASCADE NOCHECK;   
ALTER TABLE PUBLIC.UDERATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_54C FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;              
ALTER TABLE PUBLIC.QRTZ_TRIGGERS ADD CONSTRAINT PUBLIC.FK_QRTZ_TRIGGERS_QRTZ_JOB_DETAILS FOREIGN KEY(SCHED_NAME, JOB_NAME, JOB_GROUP) REFERENCES PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP) NOCHECK;             
ALTER TABLE PUBLIC.CONNINSTANCE_CAPABILITIES ADD CONSTRAINT PUBLIC.CONSTRAINT_9C FOREIGN KEY(CONNINSTANCE_ID) REFERENCES PUBLIC.CONNINSTANCE(ID) NOCHECK;      
ALTER TABLE PUBLIC.ACT_ID_MEMBERSHIP ADD CONSTRAINT PUBLIC.ACT_FK_MEMB_USER FOREIGN KEY(USER_ID_) REFERENCES PUBLIC.ACT_ID_USER(ID_) NOCHECK;  
ALTER TABLE PUBLIC.MDERATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_52F2 FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.MDERSCHEMA(NAME) NOCHECK; 
ALTER TABLE PUBLIC.EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_FB20 FOREIGN KEY(CONNECTOR_ID) REFERENCES PUBLIC.CONNINSTANCE(ID) NOCHECK;
ALTER TABLE PUBLIC.ACT_RE_MODEL ADD CONSTRAINT PUBLIC.ACT_FK_MODEL_DEPLOYMENT FOREIGN KEY(DEPLOYMENT_ID_) REFERENCES PUBLIC.ACT_RE_DEPLOYMENT(ID_) NOCHECK;    
ALTER TABLE PUBLIC.ACT_RU_EXECUTION ADD CONSTRAINT PUBLIC.ACT_FK_EXE_PROCDEF FOREIGN KEY(PROC_DEF_ID_) REFERENCES PUBLIC.ACT_RE_PROCDEF(ID_) NOCHECK;          
ALTER TABLE PUBLIC.RMAPPING ADD CONSTRAINT PUBLIC.CONSTRAINT_A2D FOREIGN KEY(RESOURCE_NAME) REFERENCES PUBLIC.EXTERNALRESOURCE(NAME) NOCHECK;  
ALTER TABLE PUBLIC.RDERATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_CDA8D FOREIGN KEY(TEMPLATE_ID) REFERENCES PUBLIC.RDERATTRTEMPLATE(ID) NOCHECK;    
ALTER TABLE PUBLIC.RATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_F737 FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.RSCHEMA(NAME) NOCHECK;    
ALTER TABLE PUBLIC.NOTIFICATIONTASK_RECIPIENTS ADD CONSTRAINT PUBLIC.CONSTRAINT_E3 FOREIGN KEY(NOTIFICATIONTASK_ID) REFERENCES PUBLIC.TASK(ID) NOCHECK;        
ALTER TABLE PUBLIC.SYNCOPEUSER_PASSWORDHISTORY ADD CONSTRAINT PUBLIC.CONSTRAINT_9C3 FOREIGN KEY(SYNCOPEUSER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;     
ALTER TABLE PUBLIC.MDERATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_C64 FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.MEMBERSHIP(ID) NOCHECK;               
ALTER TABLE PUBLIC.SYNCOPEROLE_ENTITLEMENT ADD CONSTRAINT PUBLIC.CONSTRAINT_CFD FOREIGN KEY(ENTITLEMENT_NAME) REFERENCES PUBLIC.ENTITLEMENT(NAME) NOCHECK;     
ALTER TABLE PUBLIC.UATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_9BE FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.UATTR(ID) NOCHECK;        
ALTER TABLE PUBLIC.UVIRATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_C44F FOREIGN KEY(VIRSCHEMA_NAME) REFERENCES PUBLIC.UVIRSCHEMA(NAME) NOCHECK;      
ALTER TABLE PUBLIC.SYNCTASK_ACTIONSCLASSNAMES ADD CONSTRAINT PUBLIC.CONSTRAINT_129 FOREIGN KEY(SYNCTASK_ID) REFERENCES PUBLIC.TASK(ID) NOCHECK;
ALTER TABLE PUBLIC.MATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_127 FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;         
ALTER TABLE PUBLIC.QRTZ_CRON_TRIGGERS ADD CONSTRAINT PUBLIC.FK_QRTZ_CRON_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) REFERENCES PUBLIC.QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) ON DELETE CASCADE NOCHECK;       
ALTER TABLE PUBLIC.SYNCOPEROLE_ENTITLEMENT ADD CONSTRAINT PUBLIC.CONSTRAINT_CF FOREIGN KEY(ROLE_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK; 
ALTER TABLE PUBLIC.RVIRATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_93B0 FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.RVIRSCHEMA(NAME) NOCHECK; 
ALTER TABLE PUBLIC.ACT_RU_IDENTITYLINK ADD CONSTRAINT PUBLIC.ACT_FK_IDL_PROCINST FOREIGN KEY(PROC_INST_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;   
ALTER TABLE PUBLIC.MATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_1274 FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.MSCHEMA(NAME) NOCHECK;       
ALTER TABLE PUBLIC.CATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_3C FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPECONF(ID) NOCHECK;  
ALTER TABLE PUBLIC.ACT_RU_TASK ADD CONSTRAINT PUBLIC.ACT_FK_TASK_PROCINST FOREIGN KEY(PROC_INST_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;          
ALTER TABLE PUBLIC.MVIRATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_2BD7 FOREIGN KEY(SCHEMA_NAME) REFERENCES PUBLIC.MVIRSCHEMA(NAME) NOCHECK; 
ALTER TABLE PUBLIC.RVIRATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_8CAC FOREIGN KEY(TEMPLATE_ID) REFERENCES PUBLIC.RVIRATTRTEMPLATE(ID) NOCHECK;     
ALTER TABLE PUBLIC.ACT_RE_MODEL ADD CONSTRAINT PUBLIC.ACT_FK_MODEL_SOURCE_EXTRA FOREIGN KEY(EDITOR_SOURCE_EXTRA_VALUE_ID_) REFERENCES PUBLIC.ACT_GE_BYTEARRAY(ID_) NOCHECK;    
ALTER TABLE PUBLIC.UVIRATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_C44 FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;              
ALTER TABLE PUBLIC.PUSHTASK_ACTIONSCLASSNAMES ADD CONSTRAINT PUBLIC.CONSTRAINT_5B FOREIGN KEY(PUSHTASK_ID) REFERENCES PUBLIC.TASK(ID) NOCHECK; 
ALTER TABLE PUBLIC.REPORTEXEC ADD CONSTRAINT PUBLIC.CONSTRAINT_901 FOREIGN KEY(REPORT_ID) REFERENCES PUBLIC.REPORT(ID) NOCHECK;
ALTER TABLE PUBLIC.SYNCOPEROLE_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_EC FOREIGN KEY(ROLE_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;            
ALTER TABLE PUBLIC.UATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_C3F FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.UATTR(ID) NOCHECK;              
ALTER TABLE PUBLIC.ACT_RU_EXECUTION ADD CONSTRAINT PUBLIC.ACT_FK_EXE_SUPER FOREIGN KEY(SUPER_EXEC_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;           
ALTER TABLE PUBLIC.MVIRATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_2BD FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;      
ALTER TABLE PUBLIC.REPORTLETCONFINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_4FF FOREIGN KEY(REPORT_ID) REFERENCES PUBLIC.REPORT(ID) NOCHECK;     
ALTER TABLE PUBLIC.SYNCOPEROLE ADD CONSTRAINT PUBLIC.CONSTRAINT_6FF9A1F FOREIGN KEY(ROLEOWNER_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;   
ALTER TABLE PUBLIC.RATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_BB0 FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;         
ALTER TABLE PUBLIC.MEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_CD0 FOREIGN KEY(SYNCOPEUSER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;      
ALTER TABLE PUBLIC.RDERATTRTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_BAC FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;      
ALTER TABLE PUBLIC.MATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_21A FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.MATTR(ID) NOCHECK;              
ALTER TABLE PUBLIC.MATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_45BE FOREIGN KEY(TEMPLATE_ID) REFERENCES PUBLIC.MATTRTEMPLATE(ID) NOCHECK;           
