/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidator<A extends Annotation, T> implements ConstraintValidator<A, T> {

    protected static final Logger LOG = LoggerFactory.getLogger(AbstractValidator.class);

    protected static final Pattern KEY_PATTERN =
            Pattern.compile("^" + SyncopeConstants.NAME_PATTERN, Pattern.CASE_INSENSITIVE | Pattern.UNICODE_CASE);

    @Override
    public void initialize(final A annotation) {
        // no initialization
    }

    protected final String getTemplate(final EntityViolationType type, final String message) {
        return type.name() + ";" + message;
    }

    protected boolean isHtml(final String text) {
        return text != null && (text.indexOf('<') != -1 || text.indexOf('>') != -1);
    }
}
