/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.migrate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.staxutils.PrettyPrintXMLStreamWriter;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.migrate.MigrateResultManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateConf {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateConf.class);
    private static final String HELP_MESSAGE = "migrate --conf {SRC} {DST}";
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final XMLOutputFactory OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final MigrateResultManager migrateResultManager = new MigrateResultManager();
    private final Input input;

    private static void copyAttrs(XMLStreamReader streamReader, XMLStreamWriter streamWriter, String ... but) throws XMLStreamException {
        TreeSet<String> exceptions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        exceptions.addAll(Arrays.asList(but));
        exceptions.add("id");
        exceptions.add("name");
        for (int i = 0; i < streamReader.getAttributeCount(); ++i) {
            String name = streamReader.getAttributeLocalName(i);
            if (exceptions.contains(name)) continue;
            streamWriter.writeAttribute(name, streamReader.getAttributeValue(i));
        }
    }

    private static String getAttributeValue(XMLStreamReader streamReader, String key) {
        String value = null;
        for (int i = 0; i < streamReader.getAttributeCount(); ++i) {
            String attrName = streamReader.getAttributeLocalName(i);
            if (!attrName.equalsIgnoreCase(key)) continue;
            value = streamReader.getAttributeValue(i);
        }
        return value;
    }

    private static void writeIntAttrName(String intMappingType, String intAttrNameKey, String intAttrNameValue, XMLStreamWriter writer) throws XMLStreamException {
        switch (intMappingType) {
            case "UserId": 
            case "RoleId": {
                writer.writeAttribute(intAttrNameKey, "key");
                break;
            }
            case "Username": {
                writer.writeAttribute(intAttrNameKey, "username");
                break;
            }
            case "Password": {
                writer.writeAttribute(intAttrNameKey, "password");
                break;
            }
            case "RoleName": {
                writer.writeAttribute(intAttrNameKey, "name");
                break;
            }
            case "RoleOwnerSchema": {
                writer.writeAttribute(intAttrNameKey, "userOwner");
                break;
            }
            default: {
                if (!StringUtils.isNotBlank((CharSequence)intAttrNameValue)) break;
                writer.writeAttribute(intAttrNameKey, intAttrNameValue);
            }
        }
    }

    private static void exec(String src, String dst) throws XMLStreamException, IOException, TransformerException {
        PrettyPrintXMLStreamWriter writer = new PrettyPrintXMLStreamWriter(OUTPUT_FACTORY.createXMLStreamWriter(new FileWriter(dst)), 2);
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement("dataset");
        StringWriter reporterSW = new StringWriter();
        PrettyPrintXMLStreamWriter reporter = new PrettyPrintXMLStreamWriter(OUTPUT_FACTORY.createXMLStreamWriter(reporterSW), 2);
        reporter.writeStartDocument("UTF-8", "1.0");
        reporter.writeStartElement("dataset");
        InputStream inputStream = Files.newInputStream(Paths.get(src, new String[0]), new OpenOption[0]);
        XMLStreamReader reader = XML_INPUT_FACTORY.createXMLStreamReader(inputStream);
        reader.nextTag();
        reader.nextTag();
        String realmUUID = UUID.randomUUID().toString();
        writer.writeStartElement("AnyType");
        writer.writeAttribute("id", "USER");
        writer.writeAttribute("kind", "USER");
        writer.writeEndElement();
        writer.writeStartElement("AnyTypeClass");
        writer.writeAttribute("id", "BaseUser");
        writer.writeEndElement();
        writer.writeStartElement("AnyType_AnyTypeClass");
        writer.writeAttribute("anyType_id", "USER");
        writer.writeAttribute("anyTypeClass_id", "BaseUser");
        writer.writeEndElement();
        writer.writeStartElement("AnyType");
        writer.writeAttribute("id", "GROUP");
        writer.writeAttribute("kind", "GROUP");
        writer.writeEndElement();
        writer.writeStartElement("AnyTypeClass");
        writer.writeAttribute("id", "BaseGroup");
        writer.writeEndElement();
        writer.writeStartElement("AnyType_AnyTypeClass");
        writer.writeAttribute("anyType_id", "GROUP");
        writer.writeAttribute("anyTypeClass_id", "BaseGroup");
        writer.writeEndElement();
        writer.writeStartElement("AnyTypeClass");
        writer.writeAttribute("id", "BaseUMembership");
        writer.writeEndElement();
        HashSet<String> connInstanceCapabilities = new HashSet<String>();
        String syncopeConf = "cd64d66f-6fff-4008-b966-a06b1cc1436d";
        HashMap<String, String> cPlainAttrs = new HashMap<String, String>();
        HashMap<String, String> policies = new HashMap<String, String>();
        HashMap<String, String> connInstances = new HashMap<String, String>();
        HashMap<String, String> provisions = new HashMap<String, String>();
        HashMap<String, String> mappings = new HashMap<String, String>();
        HashMap<String, String> tasks = new HashMap<String, String>();
        HashMap<String, String> notifications = new HashMap<String, String>();
        HashMap<String, String> reports = new HashMap<String, String>();
        String globalAccountPolicy = null;
        String globalPasswordPolicy = null;
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                block35 : switch (reader.getLocalName().toLowerCase()) {
                    case "syncopeconf": {
                        writer.writeStartElement("SyncopeConf");
                        writer.writeAttribute("id", syncopeConf);
                        writer.writeEndElement();
                        break;
                    }
                    case "cschema": {
                        writer.writeStartElement("SyncopeSchema");
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeEndElement();
                        writer.writeStartElement("PlainSchema");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, new String[0]);
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeEndElement();
                        break;
                    }
                    case "cattr": {
                        writer.writeStartElement("CPlainAttr");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "owner_id", "schema_name");
                        String lastUUID = UUID.randomUUID().toString();
                        writer.writeAttribute("id", lastUUID);
                        writer.writeAttribute("owner_id", syncopeConf);
                        writer.writeAttribute("schema_id", MigrateConf.getAttributeValue(reader, "schema_name"));
                        writer.writeEndElement();
                        cPlainAttrs.put(MigrateConf.getAttributeValue(reader, "id"), lastUUID);
                        break;
                    }
                    case "cattrvalue": {
                        writer.writeStartElement("CPlainAttrValue");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "attribute_id");
                        writer.writeAttribute("id", UUID.randomUUID().toString());
                        writer.writeAttribute("attribute_id", (String)cPlainAttrs.get(MigrateConf.getAttributeValue(reader, "attribute_id")));
                        writer.writeEndElement();
                        break;
                    }
                    case "uschema": {
                        writer.writeStartElement("SyncopeSchema");
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeEndElement();
                        writer.writeStartElement("PlainSchema");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, new String[0]);
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeAttribute("anyTypeClass_id", "BaseUser");
                        writer.writeEndElement();
                        break;
                    }
                    case "uderschema": {
                        writer.writeStartElement("SyncopeSchema");
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeEndElement();
                        writer.writeStartElement("DerSchema");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, new String[0]);
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeAttribute("anyTypeClass_id", "BaseUser");
                        writer.writeEndElement();
                        break;
                    }
                    case "uvirschema": {
                        reporter.writeStartElement("VirSchema");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)reporter, new String[0]);
                        reporter.writeAttribute("key", MigrateConf.getAttributeValue(reader, "name"));
                        reporter.writeEndElement();
                        break;
                    }
                    case "rschema": {
                        writer.writeStartElement("SyncopeSchema");
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeEndElement();
                        writer.writeStartElement("PlainSchema");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, new String[0]);
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeAttribute("anyTypeClass_id", "BaseGroup");
                        writer.writeEndElement();
                        break;
                    }
                    case "rderschema": {
                        writer.writeStartElement("SyncopeSchema");
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeEndElement();
                        writer.writeStartElement("DerSchema");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, new String[0]);
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeAttribute("anyTypeClass_id", "BaseGroup");
                        writer.writeEndElement();
                        break;
                    }
                    case "rvirschema": {
                        reporter.writeStartElement("VirSchema");
                        reporter.writeAttribute("key", MigrateConf.getAttributeValue(reader, "name"));
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)reporter, new String[0]);
                        reporter.writeEndElement();
                        break;
                    }
                    case "mschema": {
                        writer.writeStartElement("SyncopeSchema");
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeEndElement();
                        writer.writeStartElement("PlainSchema");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, new String[0]);
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeAttribute("anyTypeClass_id", "BaseUMembership");
                        writer.writeEndElement();
                        break;
                    }
                    case "mderschema": {
                        writer.writeStartElement("SyncopeSchema");
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeEndElement();
                        writer.writeStartElement("DerSchema");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, new String[0]);
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeAttribute("anyTypeClass_id", "BaseUMembership");
                        writer.writeEndElement();
                        break;
                    }
                    case "mvirschema": {
                        reporter.writeStartElement("VirSchema");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)reporter, new String[0]);
                        reporter.writeAttribute("key", MigrateConf.getAttributeValue(reader, "name"));
                        reporter.writeEndElement();
                        break;
                    }
                    case "policy": {
                        String policyId = MigrateConf.getAttributeValue(reader, "id");
                        String lastUUID = UUID.randomUUID().toString();
                        policies.put(policyId, lastUUID);
                        ObjectNode specification = (ObjectNode)OBJECT_MAPPER.readTree(MigrateConf.getAttributeValue(reader, "specification"));
                        switch (MigrateConf.getAttributeValue(reader, "DTYPE")) {
                            case "SyncPolicy": {
                                writer.writeStartElement("PullPolicy");
                                writer.writeAttribute("id", lastUUID);
                                writer.writeAttribute("description", MigrateConf.getAttributeValue(reader, "description"));
                                String specificationAttr = MigrateConf.getAttributeValue(reader, "specification");
                                if (StringUtils.isNotBlank((CharSequence)specificationAttr)) {
                                    ObjectNode templateRead = (ObjectNode)OBJECT_MAPPER.readTree(specificationAttr);
                                    JsonNode conflictResolutionAction = templateRead.get("conflictResolutionAction");
                                    ObjectNode templateWrite = OBJECT_MAPPER.createObjectNode();
                                    templateWrite.set("conflictResolutionAction", conflictResolutionAction);
                                    writer.writeAttribute("specification", OBJECT_MAPPER.writeValueAsString((Object)templateWrite));
                                }
                                writer.writeEndElement();
                                break block35;
                            }
                            case "PasswordPolicy": {
                                JsonNode historyLength;
                                JsonNode allowNullPassword;
                                writer.writeStartElement("PasswordPolicy");
                                writer.writeAttribute("id", lastUUID);
                                writer.writeAttribute("description", MigrateConf.getAttributeValue(reader, "description"));
                                if ("GLOBAL_PASSWORD".equalsIgnoreCase(MigrateConf.getAttributeValue(reader, "type"))) {
                                    globalPasswordPolicy = lastUUID;
                                }
                                if ((allowNullPassword = specification.get("allowNullPassword")) != null) {
                                    writer.writeAttribute("allowNullPassword", allowNullPassword.asBoolean() ? "1" : "0");
                                    specification.remove("allowNullPassword");
                                }
                                if ((historyLength = specification.get("historyLength")) != null) {
                                    writer.writeAttribute("historyLength", historyLength.asText());
                                    specification.remove("historyLength");
                                }
                                specification.put("@class", "org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf");
                                writer.writeEndElement();
                                writer.writeStartElement("PasswordRuleConfInstance");
                                writer.writeAttribute("id", lastUUID);
                                writer.writeAttribute("passwordPolicy_id", lastUUID);
                                writer.writeAttribute("serializedInstance", specification.toString());
                                writer.writeEndElement();
                                break block35;
                            }
                            case "AccountPolicy": {
                                String permittedLoginRetries;
                                JsonNode propagateSuspension;
                                writer.writeStartElement("AccountPolicy");
                                writer.writeAttribute("id", lastUUID);
                                writer.writeAttribute("description", MigrateConf.getAttributeValue(reader, "description"));
                                if ("GLOBAL_ACCOUNT".equalsIgnoreCase(MigrateConf.getAttributeValue(reader, "type"))) {
                                    globalAccountPolicy = lastUUID;
                                }
                                if ((propagateSuspension = specification.get("propagateSuspension")) != null) {
                                    writer.writeAttribute("propagateSuspension", propagateSuspension.asBoolean() ? "1" : "0");
                                    specification.remove("propagateSuspension");
                                }
                                if ((permittedLoginRetries = specification.get("permittedLoginRetries")) != null) {
                                    writer.writeAttribute("maxAuthenticationAttempts", permittedLoginRetries.asText());
                                    specification.remove("permittedLoginRetries");
                                }
                                specification.put("@class", "org.apache.syncope.common.lib.policy.DefaultAccountRuleConf");
                                writer.writeEndElement();
                                writer.writeStartElement("AccountRuleConfInstance");
                                writer.writeAttribute("id", lastUUID);
                                writer.writeAttribute("accountPolicy_id", lastUUID);
                                writer.writeAttribute("serializedInstance", specification.toString());
                                writer.writeEndElement();
                                break block35;
                            }
                        }
                        break;
                    }
                    case "conninstance": {
                        String lastUUID = UUID.randomUUID().toString();
                        connInstances.put(MigrateConf.getAttributeValue(reader, "id"), lastUUID);
                        writer.writeStartElement("ConnInstance");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, new String[0]);
                        writer.writeAttribute("id", lastUUID);
                        writer.writeEndElement();
                        break;
                    }
                    case "conninstance_capabilities": {
                        String connInstanceId = MigrateConf.getAttributeValue(reader, "connInstance_id");
                        String connInstanceKey = (String)connInstances.get(connInstanceId);
                        String capabilities = MigrateConf.getAttributeValue(reader, "capabilities");
                        if (capabilities.startsWith("ONE_PHASE_")) {
                            capabilities = capabilities.substring(10);
                        } else if (capabilities.startsWith("TWO_PHASES_")) {
                            capabilities = capabilities.substring(11);
                        }
                        if (connInstanceCapabilities.contains(connInstanceId + capabilities)) break;
                        writer.writeStartElement("ConnInstance_capabilities");
                        writer.writeAttribute("connInstance_id", connInstanceKey);
                        writer.writeAttribute("capability", capabilities);
                        writer.writeEndElement();
                        connInstanceCapabilities.add(connInstanceId + capabilities);
                        break;
                    }
                    case "externalresource": {
                        String passwordPolicyKey;
                        writer.writeStartElement("ExternalResource");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "syncTraceLevel", "userializedSyncToken", "rserializedSyncToken", "propagationMode", "propagationPrimary", "connector_id", "syncPolicy_id", "passwordPolicy_id", "creator", "lastModifier", "creationDate", "lastChangeDate");
                        writer.writeAttribute("id", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeAttribute("connector_id", (String)connInstances.get(MigrateConf.getAttributeValue(reader, "connector_id")));
                        writer.writeAttribute("provisioningTraceLevel", MigrateConf.getAttributeValue(reader, "syncTraceLevel"));
                        String syncPolicyKey = (String)policies.get(MigrateConf.getAttributeValue(reader, "syncPolicy_id"));
                        if (StringUtils.isNotBlank((CharSequence)syncPolicyKey)) {
                            writer.writeAttribute("pullPolicy_id", syncPolicyKey);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(passwordPolicyKey = (String)policies.get(MigrateConf.getAttributeValue(reader, "passwordPolicy_id"))))) {
                            writer.writeAttribute("passwordPolicy_id", passwordPolicyKey);
                        }
                        writer.writeEndElement();
                        break;
                    }
                    case "externalresource_propactions": {
                        String propActionClassName;
                        writer.writeStartElement("ExternalResource_PropActions");
                        writer.writeAttribute("resource_id", MigrateConf.getAttributeValue(reader, "externalResource_name"));
                        switch (propActionClassName = MigrateConf.getAttributeValue(reader, "element")) {
                            case "org.apache.syncope.core.propagation.impl.LDAPMembershipPropagationActions": {
                                propActionClassName = "org.apache.syncope.core.provisioning.java.propagation.LDAPMembershipPropagationActions";
                                break;
                            }
                            case "org.apache.syncope.core.propagation.impl.LDAPPasswordPropagationActions": {
                                propActionClassName = "org.apache.syncope.core.provisioning.java.propagation.LDAPPasswordPropagationActions";
                                break;
                            }
                            case "org.apache.syncope.core.propagation.impl.DBPasswordPropagationActions": {
                                propActionClassName = "org.apache.syncope.core.provisioning.java.propagation.DBPasswordPropagationActions";
                                break;
                            }
                        }
                        writer.writeAttribute("actionClassName", propActionClassName);
                        writer.writeEndElement();
                        break;
                    }
                    case "policy_externalresource": {
                        writer.writeStartElement("AccountPolicy_ExternalResource");
                        writer.writeAttribute("accountPolicy_id", (String)policies.get(MigrateConf.getAttributeValue(reader, "account_policy_id")));
                        writer.writeAttribute("resource_id", MigrateConf.getAttributeValue(reader, "resource_name"));
                        writer.writeEndElement();
                        break;
                    }
                    case "umapping": {
                        String umappingId = MigrateConf.getAttributeValue(reader, "id");
                        String lastUUID = UUID.randomUUID().toString();
                        provisions.put(umappingId, lastUUID);
                        writer.writeStartElement("Provision");
                        writer.writeAttribute("id", lastUUID);
                        writer.writeAttribute("resource_id", MigrateConf.getAttributeValue(reader, "resource_name"));
                        writer.writeAttribute("anyType_id", "USER");
                        writer.writeAttribute("objectClass", "__ACCOUNT__");
                        writer.writeEndElement();
                        lastUUID = UUID.randomUUID().toString();
                        mappings.put(umappingId, lastUUID);
                        writer.writeStartElement("Mapping");
                        writer.writeAttribute("id", lastUUID);
                        writer.writeAttribute("provision_id", (String)provisions.get(umappingId));
                        String uaccountLink = MigrateConf.getAttributeValue(reader, "accountlink");
                        if (StringUtils.isNotBlank((CharSequence)uaccountLink)) {
                            writer.writeAttribute("connObjectLink", uaccountLink);
                        }
                        writer.writeEndElement();
                        break;
                    }
                    case "umappingitem": {
                        String uIntMappingType = MigrateConf.getAttributeValue(reader, "intMappingType");
                        if (uIntMappingType.endsWith("VirtualSchema")) {
                            reporter.writeStartElement("MappingItem");
                            MigrateConf.copyAttrs(reader, (XMLStreamWriter)reporter, "accountid", "intMappingType");
                            reporter.writeEndElement();
                            break;
                        }
                        writer.writeStartElement("MappingItem");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "purpose", "accountid", "intMappingType", "mapping_id", "intMappingType", "intAttrName");
                        writer.writeAttribute("id", UUID.randomUUID().toString());
                        writer.writeAttribute("mapping_id", (String)mappings.get(MigrateConf.getAttributeValue(reader, "mapping_id")));
                        writer.writeAttribute("connObjectKey", MigrateConf.getAttributeValue(reader, "accountid"));
                        MigrateConf.writeIntAttrName(uIntMappingType, "intAttrName", MigrateConf.getAttributeValue(reader, "intAttrName"), (XMLStreamWriter)writer);
                        String purposeValue = MigrateConf.getAttributeValue(reader, "purpose");
                        writer.writeAttribute("purpose", "SYNCHRONIZATION".equals(purposeValue) ? "PULL" : purposeValue);
                        writer.writeEndElement();
                        break;
                    }
                    case "rmapping": {
                        String rmappingId = "10" + MigrateConf.getAttributeValue(reader, "id");
                        String lastUUID = UUID.randomUUID().toString();
                        provisions.put(rmappingId, lastUUID);
                        writer.writeStartElement("Provision");
                        writer.writeAttribute("id", lastUUID);
                        writer.writeAttribute("resource_id", MigrateConf.getAttributeValue(reader, "resource_name"));
                        writer.writeAttribute("anyType_id", "GROUP");
                        writer.writeAttribute("objectClass", "__GROUP__");
                        writer.writeEndElement();
                        lastUUID = UUID.randomUUID().toString();
                        mappings.put(rmappingId, lastUUID);
                        writer.writeStartElement("Mapping");
                        writer.writeAttribute("id", lastUUID);
                        writer.writeAttribute("provision_id", (String)provisions.get(rmappingId));
                        String raccountLink = MigrateConf.getAttributeValue(reader, "accountlink");
                        if (StringUtils.isNotBlank((CharSequence)raccountLink)) {
                            writer.writeAttribute("connObjectLink", raccountLink);
                        }
                        writer.writeEndElement();
                        break;
                    }
                    case "rmappingitem": {
                        String rIntMappingType = MigrateConf.getAttributeValue(reader, "intMappingType");
                        if (rIntMappingType.endsWith("VirtualSchema")) {
                            reporter.writeStartElement("MappingItem");
                            MigrateConf.copyAttrs(reader, (XMLStreamWriter)reporter, "accountid", "intMappingType");
                            reporter.writeEndElement();
                            break;
                        }
                        writer.writeStartElement("MappingItem");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "accountid", "intMappingType", "mapping_id", "intAttrName");
                        writer.writeAttribute("id", UUID.randomUUID().toString());
                        writer.writeAttribute("mapping_id", (String)mappings.get("10" + MigrateConf.getAttributeValue(reader, "mapping_id")));
                        writer.writeAttribute("connObjectKey", MigrateConf.getAttributeValue(reader, "accountid"));
                        MigrateConf.writeIntAttrName(rIntMappingType, "intAttrName", (String)mappings.get(MigrateConf.getAttributeValue(reader, "intAttrName")), (XMLStreamWriter)writer);
                        writer.writeEndElement();
                        break;
                    }
                    case "task": {
                        String name;
                        writer.writeStartElement("Task");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "DTYPE", "propagationMode", "subjectType", "subjectId", "xmlAttributes", "jobClassName", "userTemplate", "roleTemplate", "userFilter", "roleFilter", "propagationOperation", "syncStatus", "fullReconciliation", "resource_name");
                        String lastUUID = UUID.randomUUID().toString();
                        tasks.put(MigrateConf.getAttributeValue(reader, "id"), lastUUID);
                        writer.writeAttribute("id", lastUUID);
                        String resourceName = MigrateConf.getAttributeValue(reader, "resource_name");
                        if (StringUtils.isNotBlank((CharSequence)resourceName)) {
                            writer.writeAttribute("resource_id", resourceName);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(name = MigrateConf.getAttributeValue(reader, "name")))) {
                            writer.writeAttribute("name", name);
                        }
                        switch (MigrateConf.getAttributeValue(reader, "DTYPE")) {
                            case "PropagationTask": {
                                writer.writeAttribute("DTYPE", "PropagationTask");
                                writer.writeAttribute("anyTypeKind", MigrateConf.getAttributeValue(reader, "subjectType"));
                                writer.writeAttribute("anyKey", MigrateConf.getAttributeValue(reader, "subjectId"));
                                writer.writeAttribute("attributes", MigrateConf.getAttributeValue(reader, "xmlAttributes"));
                                writer.writeAttribute("operation", MigrateConf.getAttributeValue(reader, "propagationOperation"));
                                writer.writeEndElement();
                                break;
                            }
                            case "SyncTask": {
                                String roleTemplate;
                                writer.writeAttribute("DTYPE", "PullTask");
                                writer.writeAttribute("syncStatus", MigrateConf.getAttributeValue(reader, "syncStatus"));
                                writer.writeAttribute("destinationRealm_id", realmUUID);
                                String fullReconciliation = MigrateConf.getAttributeValue(reader, "fullReconciliation");
                                if ("1".equals(fullReconciliation)) {
                                    writer.writeAttribute("pullMode", "FULL_RECONCILIATION");
                                } else if ("0".equals(fullReconciliation)) {
                                    writer.writeAttribute("pullMode", "INCREMENTAL");
                                }
                                writer.writeEndElement();
                                String userTemplate = MigrateConf.getAttributeValue(reader, "userTemplate");
                                if (StringUtils.isNotBlank((CharSequence)userTemplate)) {
                                    ObjectNode template = (ObjectNode)OBJECT_MAPPER.readTree(userTemplate);
                                    JsonNode plainAttrs = template.remove("attributes");
                                    template.set("plainAttrs", plainAttrs);
                                    template.remove("id");
                                    template.set("key", null);
                                    template.remove("readonly");
                                    JsonNode derAttrs = template.remove("derivedAttributes");
                                    template.set("derAttrs", derAttrs);
                                    JsonNode virAttrs = template.remove("virtualAttributes");
                                    template.set("virAttrs", virAttrs);
                                    template.remove("propagationStatuses");
                                    writer.writeStartElement("AnyTemplatePullTask");
                                    writer.writeAttribute("id", UUID.randomUUID().toString());
                                    writer.writeAttribute("pullTask_id", lastUUID);
                                    writer.writeAttribute("anyType_id", "USER");
                                    writer.writeAttribute("template", template.toString());
                                    writer.writeEndElement();
                                }
                                if (!StringUtils.isNotBlank((CharSequence)(roleTemplate = MigrateConf.getAttributeValue(reader, "roleTemplate")))) break;
                                ObjectNode template = (ObjectNode)OBJECT_MAPPER.readTree(roleTemplate);
                                JsonNode plainAttrs = template.remove("attributes");
                                template.set("plainAttrs", plainAttrs);
                                template.remove("id");
                                template.set("key", null);
                                template.remove("readonly");
                                JsonNode derAttrs = template.remove("derivedAttributes");
                                template.set("derAttrs", derAttrs);
                                JsonNode virAttrs = template.remove("virtualAttributes");
                                template.set("virAttrs", virAttrs);
                                template.remove("propagationStatuses");
                                writer.writeStartElement("AnyTemplatePullTask");
                                writer.writeAttribute("id", UUID.randomUUID().toString());
                                writer.writeAttribute("pullTask_id", lastUUID);
                                writer.writeAttribute("anyType_id", "GROUP");
                                writer.writeAttribute("template", template.toString());
                                writer.writeEndElement();
                                break;
                            }
                            case "SchedTask": {
                                writer.writeAttribute("DTYPE", "SchedTask");
                                writer.writeAttribute("jobDelegateClassName", MigrateConf.getAttributeValue(reader, "jobClassName"));
                                writer.writeEndElement();
                                break;
                            }
                            case "NotificationTask": {
                                writer.writeAttribute("DTYPE", "NotificationTask");
                                writer.writeEndElement();
                                break;
                            }
                            case "PushTask": {
                                String roleFilter;
                                writer.writeAttribute("DTYPE", "PushTask");
                                writer.writeEndElement();
                                String userFilter = MigrateConf.getAttributeValue(reader, "userFilter");
                                if (StringUtils.isNotBlank((CharSequence)userFilter)) {
                                    writer.writeStartElement("PushTaskAnyFilter");
                                    writer.writeAttribute("id", UUID.randomUUID().toString());
                                    writer.writeAttribute("pushTask_id", lastUUID);
                                    writer.writeAttribute("anyType_id", "USER");
                                    writer.writeAttribute("fiql", userFilter);
                                    writer.writeEndElement();
                                }
                                if (!StringUtils.isNotBlank((CharSequence)(roleFilter = MigrateConf.getAttributeValue(reader, "roleFilter")))) break;
                                writer.writeStartElement("PushTaskAnyFilter");
                                writer.writeAttribute("id", UUID.randomUUID().toString());
                                writer.writeAttribute("pushTask_id", lastUUID);
                                writer.writeAttribute("anyType_id", "GROUP");
                                writer.writeAttribute("fiql", roleFilter);
                                writer.writeEndElement();
                                break;
                            }
                        }
                        break;
                    }
                    case "taskexec": {
                        writer.writeStartElement("TaskExec");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "task_id");
                        writer.writeAttribute("id", UUID.randomUUID().toString());
                        writer.writeAttribute("task_id", (String)tasks.get(MigrateConf.getAttributeValue(reader, "task_id")));
                        writer.writeEndElement();
                        break;
                    }
                    case "synctask_actionsclassnames": {
                        String syncActionClassName;
                        writer.writeStartElement("PullTask_actionsClassNames");
                        writer.writeAttribute("pullTask_id", (String)tasks.get(MigrateConf.getAttributeValue(reader, "syncTask_id")));
                        switch (syncActionClassName = MigrateConf.getAttributeValue(reader, "element")) {
                            case "org.apache.syncope.core.sync.impl.LDAPMembershipSyncActions": {
                                syncActionClassName = "org.apache.syncope.core.provisioning.java.pushpull.LDAPMembershipPullActions";
                                break;
                            }
                            case "org.apache.syncope.core.sync.impl.LDAPPasswordSyncActions": {
                                syncActionClassName = "org.apache.syncope.core.provisioning.java.pushpull.LDAPPasswordPullActions";
                                break;
                            }
                            case "org.apache.syncope.core.sync.impl.DBPasswordSyncActions": {
                                syncActionClassName = "org.apache.syncope.core.provisioning.java.pushpull.DBPasswordPullActions";
                                break;
                            }
                        }
                        writer.writeAttribute("actionClassName", syncActionClassName);
                        writer.writeEndElement();
                        break;
                    }
                    case "notification": {
                        String roleAbout;
                        writer.writeStartElement("Notification");
                        String lastUUID = UUID.randomUUID().toString();
                        notifications.put(MigrateConf.getAttributeValue(reader, "id"), lastUUID);
                        writer.writeAttribute("id", lastUUID);
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "recipientAttrType", "template", "userAbout", "roleAbout", "recipients", "recipientAttrName");
                        String recipientAttrType = MigrateConf.getAttributeValue(reader, "recipientAttrType");
                        MigrateConf.writeIntAttrName(recipientAttrType, "recipientAttrName", (String)mappings.get(MigrateConf.getAttributeValue(reader, "recipientAttrName")), (XMLStreamWriter)writer);
                        String recipients = MigrateConf.getAttributeValue(reader, "recipients");
                        if (StringUtils.isNotBlank((CharSequence)recipients)) {
                            writer.writeAttribute("recipientsFIQL", MigrateConf.getAttributeValue(reader, "recipients"));
                        }
                        writer.writeAttribute("template_id", MigrateConf.getAttributeValue(reader, "template"));
                        writer.writeEndElement();
                        String userAbout = MigrateConf.getAttributeValue(reader, "userAbout");
                        if (StringUtils.isNotBlank((CharSequence)userAbout)) {
                            writer.writeStartElement("AnyAbout");
                            writer.writeAttribute("id", UUID.randomUUID().toString());
                            writer.writeAttribute("notification_id", lastUUID);
                            writer.writeAttribute("anyType_id", "USER");
                            writer.writeAttribute("filter", userAbout);
                            writer.writeEndElement();
                        }
                        if (!StringUtils.isNotBlank((CharSequence)(roleAbout = MigrateConf.getAttributeValue(reader, "roleAbout")))) break;
                        writer.writeStartElement("AnyAbout");
                        writer.writeAttribute("id", UUID.randomUUID().toString());
                        writer.writeAttribute("notification_id", lastUUID);
                        writer.writeAttribute("anyType_id", "GROUP");
                        writer.writeAttribute("filter", roleAbout);
                        writer.writeEndElement();
                        break;
                    }
                    case "notification_events": {
                        writer.writeStartElement("Notification_events");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "notification_id", "events");
                        writer.writeAttribute("notification_id", (String)notifications.get(MigrateConf.getAttributeValue(reader, "notification_id")));
                        writer.writeAttribute("event", MigrateConf.getAttributeValue(reader, "events").replaceAll("Controller", "Logic"));
                        writer.writeEndElement();
                        break;
                    }
                    case "notificationtask_recipients": {
                        writer.writeStartElement("NotificationTask_recipients");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "notificationTask_id");
                        writer.writeAttribute("notificationTask_id", (String)tasks.get(MigrateConf.getAttributeValue(reader, "notificationTask_id")));
                        writer.writeEndElement();
                        break;
                    }
                    case "report": {
                        writer.writeStartElement("Report");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, new String[0]);
                        String lastUUID = UUID.randomUUID().toString();
                        reports.put(MigrateConf.getAttributeValue(reader, "id"), lastUUID);
                        writer.writeAttribute("id", lastUUID);
                        writer.writeAttribute("name", MigrateConf.getAttributeValue(reader, "name"));
                        writer.writeEndElement();
                        break;
                    }
                    case "reportletconfinstance": {
                        writer.writeStartElement("ReportletConfInstance");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "report_id");
                        writer.writeAttribute("id", UUID.randomUUID().toString());
                        writer.writeAttribute("report_id", (String)reports.get(MigrateConf.getAttributeValue(reader, "report_id")));
                        writer.writeEndElement();
                        break;
                    }
                    case "reportexec": {
                        writer.writeStartElement("ReportExec");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, "report_id");
                        writer.writeAttribute("id", UUID.randomUUID().toString());
                        writer.writeAttribute("report_id", (String)reports.get(MigrateConf.getAttributeValue(reader, "report_id")));
                        writer.writeEndElement();
                        break;
                    }
                    case "securityquestion": {
                        writer.writeStartElement("SecurityQuestion");
                        MigrateConf.copyAttrs(reader, (XMLStreamWriter)writer, new String[0]);
                        writer.writeAttribute("id", UUID.randomUUID().toString());
                        writer.writeEndElement();
                        break;
                    }
                }
            }
            reader.next();
        }
        writer.writeStartElement("Realm");
        writer.writeAttribute("id", realmUUID);
        writer.writeAttribute("name", "/");
        if (globalAccountPolicy != null) {
            writer.writeAttribute("accountPolicy_id", globalAccountPolicy);
        }
        if (globalPasswordPolicy != null) {
            writer.writeAttribute("passwordPolicy_id", globalPasswordPolicy);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
        reporter.writeEndElement();
        reporter.writeEndDocument();
        reporter.close();
        System.out.println("\nVirtual items, require manual intervention:\n" + reporterSW.toString());
    }

    public MigrateConf(Input input) {
        this.input = input;
    }

    public void migrate() {
        if (this.input.parameterNumber() == 2) {
            try {
                MigrateConf.exec(this.input.firstParameter(), this.input.secondParameter());
                this.migrateResultManager.genericMessage("Migration completed; file successfully created under " + this.input.secondParameter());
            }
            catch (Exception e) {
                LOG.error("Error migrating configuration from {}", (Object)this.input.firstParameter(), (Object)e);
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                this.migrateResultManager.genericError("Error performing configuration migration: " + errors.toString());
            }
        } else {
            this.migrateResultManager.commandOptionError(HELP_MESSAGE);
        }
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }
}

