/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.group;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupTO;

public class GroupResultManager
extends CommonsResultManager {
    public void printGroups(List<GroupTO> groupTOs) {
        System.out.println("");
        for (GroupTO groupTO : groupTOs) {
            this.printGroup(groupTO);
        }
    }

    public void printGroup(GroupTO groupTO) {
        System.out.println(" > GROUP KEY: " + groupTO.getKey());
        System.out.println("    name: " + groupTO.getName());
        System.out.println("    type: " + groupTO.getType());
        System.out.println("    realm: " + groupTO.getRealm());
        System.out.println("    status: " + groupTO.getStatus());
        System.out.println("    user owner: " + groupTO.getUserOwner());
        System.out.println("    group owner: " + groupTO.getGroupOwner());
        System.out.println("    RESOURCES: ");
        this.printResources(groupTO.getResources());
        System.out.println("    PLAIN ATTRIBUTES: ");
        this.printAttributes(groupTO.getPlainAttrs());
        System.out.println("    DERIVED ATTRIBUTES: ");
        this.printAttributes(groupTO.getDerAttrs());
        System.out.println("    VIRTUAL ATTRIBUTES: ");
        this.printAttributes(groupTO.getVirAttrs());
        System.out.println("");
    }

    private void printResources(Set<String> resources) {
        for (String resource : resources) {
            System.out.println("      - " + resource);
        }
    }

    public void printAttributes(Set<AttrTO> attributes) {
        for (AttrTO attribute : attributes) {
            this.printAttribute(attribute);
        }
    }

    public void printAttribute(AttrTO attribute) {
        StringBuilder attributeMessageBuilder = new StringBuilder();
        attributeMessageBuilder.append("     - ").append(attribute.getSchema()).append(": ").append(attribute.getValues());
        System.out.println(attributeMessageBuilder.toString());
        System.out.println("");
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("groups details", details);
    }
}

