/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.view.Messages;
import org.apache.syncope.client.cli.view.Table;
import org.apache.syncope.common.lib.types.ConnConfProperty;

public abstract class CommonsResultManager {
    public void numberFormatException(String what, String key) {
        Messages.printIdNotNumberDeletedMessage(what, key);
    }

    public void unnecessaryParameters(List<String> parameters, String helpMessage) {
        Messages.printUnnecessaryParameters(parameters, helpMessage);
    }

    public void deletedMessage(String what, String key) {
        Messages.printDeletedMessage(what, key);
    }

    public void notFoundError(String what, String parameter) {
        Messages.printNofFoundMessage(what, parameter);
    }

    public void notBooleanDeletedError(String what, String key) {
        Messages.printNotBooleanDeletedMessage(what, key);
    }

    public void typeNotValidError(String what, String parameter, String[] options) {
        Messages.printTypeNotValidMessage(what, parameter, options);
    }

    public void commandOptionError(String message) {
        Messages.printCommandOptionMessage(message);
    }

    public void defaultOptionMessage(String option, String helpMessage) {
        Messages.printDefaultMessage(option, helpMessage);
    }

    public void genericMessage(String ... messages) {
        Messages.printMessage(messages);
    }

    public void genericError(String error) {
        Messages.printMessage("Error: " + error);
    }

    public String commandHelpMessage(Class<?> name) {
        return Messages.commandHelpMessage(name.getAnnotation(Command.class).name());
    }

    protected void printConfiguration(Collection<ConnConfProperty> configurationPropertys) {
        for (ConnConfProperty configuration : configurationPropertys) {
            System.out.println("       name: " + configuration.getSchema().getName());
            System.out.println("       values: " + configuration.getValues());
            System.out.println("       type: " + configuration.getSchema().getType());
            System.out.println("       display name: " + configuration.getSchema().getDisplayName());
            System.out.println("       help message: " + configuration.getSchema().getHelpMessage());
            System.out.println("       order: " + configuration.getSchema().getOrder());
            System.out.println("       default values: " + configuration.getSchema().getDefaultValues());
            System.out.println("       confidential: " + configuration.getSchema().isConfidential());
            System.out.println("       required: " + configuration.getSchema().isRequired());
            System.out.println("       overridable: " + configuration.isOverridable());
            System.out.println("");
        }
    }

    protected void printDetails(String title, Map<String, String> details) {
        Table.TableBuilder tableBuilder = new Table.TableBuilder(title).header("detail").header("value");
        for (Map.Entry<String, String> entrySet : details.entrySet()) {
            tableBuilder.rowValues(Arrays.asList(entrySet.getKey(), entrySet.getValue()));
        }
        tableBuilder.build().print();
    }
}

