/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ItemContainerTO;
import org.apache.syncope.common.lib.to.ItemTO;

@XmlRootElement(name="orgUnit")
@XmlType
public class OrgUnitTO
extends AbstractBaseBean
implements EntityTO,
ItemContainerTO {
    private static final long serialVersionUID = -1868877794174953177L;
    private String key;
    private String objectClass;
    private String syncToken;
    private String connObjectLink;
    private final List<ItemTO> items = new ArrayList<ItemTO>();

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public String getSyncToken() {
        return this.syncToken;
    }

    public void setSyncToken(String syncToken) {
        this.syncToken = syncToken;
    }

    public String getConnObjectLink() {
        return this.connObjectLink;
    }

    public void setConnObjectLink(String connObjectLink) {
        this.connObjectLink = connObjectLink;
    }

    @Override
    public ItemTO getConnObjectKeyItem() {
        return (ItemTO)IterableUtils.find(this.getItems(), (Predicate)new Predicate<ItemTO>(){

            public boolean evaluate(ItemTO item) {
                return item.isConnObjectKey();
            }
        });
    }

    protected boolean addConnObjectKeyItem(ItemTO connObjectItem) {
        connObjectItem.setMandatoryCondition("true");
        connObjectItem.setConnObjectKey(true);
        return this.add(connObjectItem);
    }

    @Override
    public boolean setConnObjectKeyItem(ItemTO connObjectKeyItem) {
        return connObjectKeyItem == null ? this.remove(this.getConnObjectKeyItem()) : this.addConnObjectKeyItem(connObjectKeyItem);
    }

    @Override
    @XmlElementWrapper(name="items")
    @XmlElement(name="item")
    @JsonProperty(value="items")
    public List<ItemTO> getItems() {
        return this.items;
    }

    @Override
    public boolean add(ItemTO item) {
        return item == null ? false : this.items.contains(item) || this.items.add(item);
    }

    public boolean remove(ItemTO item) {
        return this.items.remove(item);
    }
}

