/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.password;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.password.PasswordField;
import com.izforge.izpack.panels.userinput.field.password.PasswordGroupField;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import com.izforge.izpack.panels.userinput.gui.password.PasswordGroup;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPasswordField;

public class GUIPasswordGroupField
extends GUIField {
    private final List<JPasswordField> passwords = new ArrayList<JPasswordField>();

    public GUIPasswordGroupField(PasswordGroupField field) {
        super(field);
        this.addDescription();
        int id = 1;
        for (PasswordField f : field.getPasswordFields()) {
            JPasswordField component = new JPasswordField(f.getSet(), f.getSize());
            component.setName(field.getVariable() + "." + id++);
            component.setCaretPosition(0);
            this.addLabel(f.getLabel());
            this.passwords.add(component);
            this.addComponent(component, new TwoColumnConstraints(26));
        }
        this.addTooltip();
    }

    @Override
    public boolean updateField(Prompt prompt, boolean skipValidation) {
        boolean result = false;
        Field field = this.getField();
        String[] values = this.getPasswords();
        ValidationStatus status = field.validate(new PasswordGroup(values));
        if (skipValidation || status.isValid()) {
            try {
                field.setValue(values[0]);
                result = true;
            }
            catch (Throwable exception) {
                this.warning(exception.getMessage(), prompt);
            }
        } else {
            this.warning(status.getMessage(), prompt);
        }
        return result;
    }

    @Override
    public boolean updateView() {
        boolean result = super.updateView();
        String value = this.getField().getInitialValue();
        if (value != null) {
            this.passwords.get(0).setText(this.replaceVariables(value));
            result = true;
        } else {
            Field field = this.getField();
            String defaultValue = field.getDefaultValue();
            if (defaultValue != null) {
                this.passwords.get(0).setText(defaultValue);
            }
        }
        return result;
    }

    private String[] getPasswords() {
        String[] result = new String[this.passwords.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new String(this.passwords.get(i).getPassword());
        }
        return result;
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        return this.passwords.get(0);
    }
}

