/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.help;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.help.Help;
import org.apache.syncope.client.cli.commands.help.HelpResultManager;
import org.apache.syncope.client.cli.util.CommandUtils;

@Command(name="help")
public class HelpCommand
extends AbstractCommand {
    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(Options.HELP.getOptionName());
        }
        switch (Options.fromName(input.getOption())) {
            case HELP: {
                new Help().help();
                break;
            }
            default: {
                new HelpResultManager().defaultOptionMessage(input.getOption(), CommandUtils.helpMessage("info", Options.toList()));
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return CommandUtils.helpMessage("help", Options.toList());
    }

    private static enum Options {
        HELP("--print");

        private final String optionName;

        private Options(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static Options fromName(String name) {
            Options optionToReturn = HELP;
            for (Options option : Options.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (Options value : Options.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

