/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.ReportCheck;
import org.quartz.CronExpression;

public class ReportValidator
extends AbstractValidator<ReportCheck, Report> {
    public boolean isValid(Report report, ConstraintValidatorContext context) {
        Set reportletNames;
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (this.isHtml(report.getName())) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidName, "Invalid name")).addPropertyNode("name").addConstraintViolation();
            isValid = false;
        }
        if (report.getCronExpression() != null) {
            try {
                new CronExpression(report.getCronExpression());
            }
            catch (ParseException e) {
                LOG.error("Invalid cron expression '" + report.getCronExpression() + "'", (Throwable)e);
                isValid = false;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidReport, "Invalid cron expression")).addPropertyNode("cronExpression").addConstraintViolation();
            }
        }
        if ((reportletNames = (Set)CollectionUtils.collect((Iterable)report.getReportletConfs(), (Transformer)new Transformer<ReportletConf, String>(){

            public String transform(ReportletConf input) {
                return input.getName();
            }
        }, new HashSet())).size() != report.getReportletConfs().size()) {
            LOG.error("Reportlet name must be unique");
            isValid = false;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidReport, "Reportlet name must be unique")).addPropertyNode("reportletConfs").addConstraintViolation();
        }
        return isValid;
    }
}

