/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAny;

public abstract class AbstractGroupableRelatable<L extends Any<P>, M extends Membership<L>, P extends GroupablePlainAttr<L, M>, R extends Any<?>, REL extends Relationship<L, R>>
extends AbstractAny<P>
implements GroupableRelatable<L, M, P, R, REL> {
    private static final long serialVersionUID = -2269285197388729673L;

    protected abstract List<? extends P> internalGetPlainAttrs();

    public boolean remove(P attr) {
        return this.internalGetPlainAttrs().remove(attr);
    }

    public P getPlainAttr(final String plainSchemaName) {
        return (P)((GroupablePlainAttr)IterableUtils.find(this.internalGetPlainAttrs(), (Predicate)new Predicate<P>(){

            public boolean evaluate(P plainAttr) {
                return plainAttr != null && plainAttr.getSchema() != null && plainAttr.getMembership() == null && plainSchemaName.equals(plainAttr.getSchema().getKey());
            }
        }));
    }

    public P getPlainAttr(final String plainSchemaName, final Membership<?> membership) {
        return (P)((GroupablePlainAttr)IterableUtils.find(this.internalGetPlainAttrs(), (Predicate)new Predicate<P>(){

            public boolean evaluate(P plainAttr) {
                return plainAttr != null && plainAttr.getSchema() != null && plainAttr.getMembership() != null && plainAttr.getMembership().equals(membership) && plainSchemaName.equals(plainAttr.getSchema().getKey());
            }
        }));
    }

    public List<? extends P> getPlainAttrs() {
        return (List)CollectionUtils.select(this.internalGetPlainAttrs(), (Predicate)new Predicate<P>(){

            public boolean evaluate(P plainAttr) {
                return plainAttr != null && plainAttr.getSchema() != null && plainAttr.getMembership() == null;
            }
        }, new ArrayList());
    }

    public Collection<? extends P> getPlainAttrs(final String plainSchemaName) {
        return CollectionUtils.select(this.internalGetPlainAttrs(), (Predicate)new Predicate<P>(){

            public boolean evaluate(P plainAttr) {
                return plainAttr != null && plainAttr.getSchema() != null && plainSchemaName.equals(plainAttr.getSchema().getKey());
            }
        });
    }

    public Collection<? extends P> getPlainAttrs(final Membership<?> membership) {
        return CollectionUtils.select(this.internalGetPlainAttrs(), (Predicate)new Predicate<P>(){

            public boolean evaluate(P plainAttr) {
                return plainAttr != null && plainAttr.getSchema() != null && membership.equals(plainAttr.getMembership());
            }
        });
    }

    public M getMembership(final String groupKey) {
        return (M)((Membership)IterableUtils.find((Iterable)this.getMemberships(), (Predicate)new Predicate<M>(){

            public boolean evaluate(M membership) {
                return groupKey != null && groupKey.equals(((Group)membership.getRightEnd()).getKey());
            }
        }));
    }

    public Collection<? extends REL> getRelationships(final RelationshipType relationshipType) {
        return CollectionUtils.select((Iterable)this.getRelationships(), (Predicate)new Predicate<REL>(){

            public boolean evaluate(REL relationship) {
                return relationshipType != null && relationshipType.equals(relationship.getType());
            }
        });
    }

    public Collection<? extends REL> getRelationships(final String otherEndKey) {
        return CollectionUtils.select((Iterable)this.getRelationships(), (Predicate)new Predicate<REL>(){

            public boolean evaluate(REL relationship) {
                return otherEndKey != null && otherEndKey.equals(relationship.getRightEnd().getKey());
            }
        });
    }
}

