/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidEntityException;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AccountRule;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.AbstractAnyDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyUtilsFactory;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.apache.syncope.core.provisioning.api.event.AnyCreatedUpdatedEvent;
import org.apache.syncope.core.provisioning.api.event.AnyDeletedEvent;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;
import org.apache.syncope.core.provisioning.api.utils.policy.AccountPolicyException;
import org.apache.syncope.core.provisioning.api.utils.policy.PasswordPolicyException;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.apache.syncope.core.spring.security.Encryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPAUserDAO
extends AbstractAnyDAO<User>
implements UserDAO {
    private static final Pattern USERNAME_PATTERN = Pattern.compile("^[\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.]+", 66);
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private AccessTokenDAO accessTokenDAO;
    @Autowired
    private ImplementationLookup implementationLookup;
    @Resource(name="adminUser")
    private String adminUser;
    @Resource(name="anonymousUser")
    private String anonymousUser;
    private RealmDAO realmDAO;
    private GroupDAO groupDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealmDAO realmDAO() {
        JPAUserDAO jPAUserDAO = this;
        synchronized (jPAUserDAO) {
            if (this.realmDAO == null) {
                this.realmDAO = (RealmDAO)ApplicationContextProvider.getApplicationContext().getBean(RealmDAO.class);
            }
        }
        return this.realmDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupDAO groupDAO() {
        JPAUserDAO jPAUserDAO = this;
        synchronized (jPAUserDAO) {
            if (this.groupDAO == null) {
                this.groupDAO = (GroupDAO)ApplicationContextProvider.getApplicationContext().getBean(GroupDAO.class);
            }
        }
        return this.groupDAO;
    }

    @Override
    protected AnyUtils init() {
        return new JPAAnyUtilsFactory().getInstance(AnyTypeKind.USER);
    }

    @Transactional(readOnly=true)
    public String findKey(String username) {
        return this.findKey(username, "SyncopeUser");
    }

    @Transactional(readOnly=true)
    public Date findLastChange(String key) {
        return this.findLastChange(key, "SyncopeUser");
    }

    public int count() {
        Query query = this.entityManager().createQuery("SELECT COUNT(e) FROM  " + JPAUser.class.getSimpleName() + " e");
        return ((Number)query.getSingleResult()).intValue();
    }

    public Map<String, Integer> countByRealm() {
        Query query = this.entityManager().createQuery("SELECT e.realm, COUNT(e) FROM  " + JPAUser.class.getSimpleName() + " e GROUP BY e.realm");
        List results = query.getResultList();
        HashMap<String, Integer> countByRealm = new HashMap<String, Integer>(results.size());
        for (Object[] result : results) {
            countByRealm.put(((Realm)result[0]).getFullPath(), ((Number)result[1]).intValue());
        }
        return Collections.unmodifiableMap(countByRealm);
    }

    public Map<String, Integer> countByStatus() {
        Query query = this.entityManager().createQuery("SELECT e.status, COUNT(e) FROM  " + JPAUser.class.getSimpleName() + " e GROUP BY e.status");
        List results = query.getResultList();
        HashMap<String, Integer> countByStatus = new HashMap<String, Integer>(results.size());
        for (Object[] result : results) {
            countByStatus.put((String)result[0], ((Number)result[1]).intValue());
        }
        return Collections.unmodifiableMap(countByStatus);
    }

    @Override
    protected void securityChecks(final User user) {
        if (!AuthContextUtils.getUsername().equals(this.anonymousUser) && !AuthContextUtils.getUsername().equals(user.getUsername())) {
            Set authRealms = SetUtils.emptyIfNull((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_READ")));
            boolean authorized = IterableUtils.matchesAny((Iterable)authRealms, (Predicate)new Predicate<String>(){

                public boolean evaluate(String realm) {
                    return user.getRealm().getFullPath().startsWith(realm);
                }
            });
            if (!authorized) {
                boolean bl = authorized = !CollectionUtils.intersection(this.findDynRealms(user.getKey()), (Iterable)authRealms).isEmpty();
            }
            if (authRealms.isEmpty() || !authorized) {
                throw new DelegatedAdministrationException(user.getRealm().getFullPath(), AnyTypeKind.USER.name(), user.getKey());
            }
        }
    }

    public User findByUsername(String username) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAUser.class.getSimpleName() + " e WHERE e.username = :username", User.class);
        query.setParameter("username", (Object)username);
        User result = null;
        try {
            result = (User)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No user found with username {}", (Object)username, (Object)e);
        }
        return result;
    }

    public User findByToken(String token) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAUser.class.getSimpleName() + " e WHERE e.token LIKE :token", User.class);
        query.setParameter("token", (Object)token);
        User result = null;
        try {
            result = (User)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No user found with token {}", (Object)token, (Object)e);
        }
        return result;
    }

    public List<User> findBySecurityQuestion(SecurityQuestion securityQuestion) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAUser.class.getSimpleName() + " e WHERE e.securityQuestion = :securityQuestion", User.class);
        query.setParameter("securityQuestion", (Object)securityQuestion);
        return query.getResultList();
    }

    private List<PasswordPolicy> getPasswordPolicies(User user) {
        PasswordPolicy policy;
        ArrayList<PasswordPolicy> policies = new ArrayList<PasswordPolicy>();
        for (ExternalResource resource : this.findAllResources(user)) {
            policy = resource.getPasswordPolicy();
            if (policy == null) continue;
            policies.add(policy);
        }
        for (Realm realm : this.realmDAO().findAncestors(user.getRealm())) {
            policy = realm.getPasswordPolicy();
            if (policy == null) continue;
            policies.add(policy);
        }
        return policies;
    }

    public List<User> findAll(int page, int itemsPerPage) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM  " + JPAUser.class.getSimpleName() + " e ORDER BY e.id", User.class);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        query.setMaxResults(itemsPerPage);
        return query.getResultList();
    }

    private List<AccountPolicy> getAccountPolicies(User user) {
        AccountPolicy policy;
        ArrayList<AccountPolicy> policies = new ArrayList<AccountPolicy>();
        for (ExternalResource resource : this.findAllResources(user)) {
            policy = resource.getAccountPolicy();
            if (policy == null) continue;
            policies.add(policy);
        }
        for (Realm realm : this.realmDAO().findAncestors(user.getRealm())) {
            policy = realm.getAccountPolicy();
            if (policy == null) continue;
            policies.add(policy);
        }
        return policies;
    }

    @Transactional(readOnly=true)
    public Pair<Boolean, Boolean> enforcePolicies(User user) {
        LOG.debug("Password Policy enforcement");
        try {
            int maxPPSpecHistory = 0;
            for (PasswordPolicy passwordPolicy : this.getPasswordPolicies(user)) {
                if (user.getPassword() == null && !passwordPolicy.isAllowNullPassword()) {
                    throw new PasswordPolicyException("Password mandatory");
                }
                for (PasswordRuleConf ruleConf : passwordPolicy.getRuleConfs()) {
                    PasswordRule rule;
                    Class ruleClass = this.implementationLookup.getPasswordRuleClass(ruleConf.getClass());
                    if (ruleClass == null) {
                        LOG.warn("Could not find matching password rule for {}", ruleConf.getClass());
                        continue;
                    }
                    if (ApplicationContextProvider.getBeanFactory().containsSingleton(ruleClass.getName())) {
                        rule = (PasswordRule)ApplicationContextProvider.getBeanFactory().getSingleton(ruleClass.getName());
                    } else {
                        rule = (PasswordRule)ApplicationContextProvider.getBeanFactory().createBean(ruleClass, 2, false);
                        ApplicationContextProvider.getBeanFactory().registerSingleton(ruleClass.getName(), (Object)rule);
                    }
                    rule.enforce(ruleConf, user);
                }
                boolean matching = false;
                if (passwordPolicy.getHistoryLength() > 0) {
                    List pwdHistory = user.getPasswordHistory();
                    for (String oldPwdValue : pwdHistory.subList(passwordPolicy.getHistoryLength() >= pwdHistory.size() ? 0 : pwdHistory.size() - passwordPolicy.getHistoryLength(), pwdHistory.size())) {
                        matching |= ENCRYPTOR.verify(user.getClearPassword(), user.getCipherAlgorithm(), oldPwdValue);
                    }
                }
                if (matching) {
                    throw new PasswordPolicyException("Password value was used in the past: not allowed");
                }
                if (passwordPolicy.getHistoryLength() <= maxPPSpecHistory) continue;
                maxPPSpecHistory = passwordPolicy.getHistoryLength();
            }
            if (maxPPSpecHistory > 0 && user.getPassword() != null && !user.getPasswordHistory().contains(user.getPassword())) {
                user.getPasswordHistory().add(user.getPassword());
            }
            if (maxPPSpecHistory < user.getPasswordHistory().size()) {
                for (int i = 0; i < user.getPasswordHistory().size() - maxPPSpecHistory; ++i) {
                    user.getPasswordHistory().remove(i);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Invalid password for {}", (Object)user, (Object)e);
            throw new InvalidEntityException(User.class, EntityViolationType.InvalidPassword, e.getMessage());
        }
        finally {
            user.removeClearPassword();
        }
        LOG.debug("Account Policy enforcement");
        boolean suspend = false;
        boolean propagateSuspension = false;
        try {
            if (user.getUsername() == null) {
                throw new AccountPolicyException("Null username");
            }
            if (this.adminUser.equals(user.getUsername()) || this.anonymousUser.equals(user.getUsername())) {
                throw new AccountPolicyException("Not allowed: " + user.getUsername());
            }
            if (!USERNAME_PATTERN.matcher(user.getUsername()).matches()) {
                throw new AccountPolicyException("Character(s) not allowed");
            }
            for (AccountPolicy policy : this.getAccountPolicies(user)) {
                for (AccountRuleConf ruleConf : policy.getRuleConfs()) {
                    AccountRule rule;
                    Class ruleClass = this.implementationLookup.getAccountRuleClass(ruleConf.getClass());
                    if (ruleClass == null) {
                        LOG.warn("Could not find matching account rule for {}", ruleConf.getClass());
                        continue;
                    }
                    if (ApplicationContextProvider.getBeanFactory().containsSingleton(ruleClass.getName())) {
                        rule = (AccountRule)ApplicationContextProvider.getBeanFactory().getSingleton(ruleClass.getName());
                    } else {
                        rule = (AccountRule)ApplicationContextProvider.getBeanFactory().createBean(ruleClass, 2, false);
                        ApplicationContextProvider.getBeanFactory().registerSingleton(ruleClass.getName(), (Object)rule);
                    }
                    rule.enforce(ruleConf, user);
                }
                suspend |= user.getFailedLogins() != null && policy.getMaxAuthenticationAttempts() > 0 && user.getFailedLogins() > policy.getMaxAuthenticationAttempts() && user.isSuspended() == false;
                propagateSuspension |= policy.isPropagateSuspension();
            }
        }
        catch (Exception exception) {
            LOG.error("Invalid username for {}", (Object)user, (Object)exception);
            throw new InvalidEntityException(User.class, EntityViolationType.InvalidUsername, exception.getMessage());
        }
        return ImmutablePair.of((Object)suspend, (Object)propagateSuspension);
    }

    private Pair<User, Pair<Set<String>, Set<String>>> doSave(User user) {
        String clearPwd = user.getClearPassword();
        User merged = super.save(user);
        this.entityManager().flush();
        ((JPAUser)JPAUser.class.cast(merged)).setClearPassword(clearPwd);
        try {
            this.enforcePolicies(merged);
        }
        catch (InvalidEntityException e) {
            this.entityManager().remove((Object)merged);
            throw e;
        }
        this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)merged, AuthContextUtils.getDomain()));
        this.roleDAO.refreshDynMemberships(merged);
        Pair dynGroupMembs = this.groupDAO().refreshDynMemberships(merged);
        this.dynRealmDAO().refreshDynMemberships((Any)merged);
        return Pair.of((Object)merged, (Object)dynGroupMembs);
    }

    @Override
    public User save(User user) {
        return (User)this.doSave(user).getLeft();
    }

    public Pair<Set<String>, Set<String>> saveAndGetDynGroupMembs(User user) {
        return (Pair)this.doSave(user).getRight();
    }

    public void delete(User user) {
        this.roleDAO.removeDynMemberships(user.getKey());
        this.groupDAO().removeDynMemberships(user);
        this.dynRealmDAO().removeDynMemberships(user.getKey());
        AccessToken accessToken = this.accessTokenDAO.findByOwner(user.getUsername());
        if (accessToken != null) {
            this.accessTokenDAO.delete(accessToken);
        }
        this.entityManager().remove((Object)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyDeletedEvent((Object)this, AnyTypeKind.USER, user.getKey(), AuthContextUtils.getDomain()));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Role> findAllRoles(User user) {
        return CollectionUtils.union((Iterable)user.getRoles(), this.findDynRoles(user.getKey()));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<Role> findDynRoles(String key) {
        Query query = this.entityManager().createNativeQuery("SELECT role_id FROM DynRoleMembers WHERE any_id=?");
        query.setParameter(1, (Object)key);
        ArrayList<Role> result = new ArrayList<Role>();
        for (Object resultKey : query.getResultList()) {
            String actualKey = resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey;
            Role role = this.roleDAO.find(actualKey);
            if (role == null) {
                LOG.error("Could not find role with id {}, even though returned by the native query", (Object)actualKey);
                continue;
            }
            if (result.contains(role)) continue;
            result.add(role);
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<Group> findDynGroups(String key) {
        Query query = this.entityManager().createNativeQuery("SELECT group_id FROM UDynGroupMembers WHERE any_id=?");
        query.setParameter(1, (Object)key);
        ArrayList<Group> result = new ArrayList<Group>();
        for (Object resultKey : query.getResultList()) {
            String actualKey = resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey;
            Group group = (Group)this.groupDAO().find(actualKey);
            if (group == null) {
                LOG.error("Could not find group with id {}, even though returned by the native query", (Object)actualKey);
                continue;
            }
            if (result.contains(group)) continue;
            result.add(group);
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Group> findAllGroups(User user) {
        return CollectionUtils.union((Iterable)CollectionUtils.collect((Iterable)user.getMemberships(), (Transformer)new Transformer<UMembership, Group>(){

            public Group transform(UMembership input) {
                return (Group)input.getRightEnd();
            }
        }, new ArrayList()), this.findDynGroups(user.getKey()));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<String> findAllGroupKeys(User user) {
        return CollectionUtils.collect(this.findAllGroups(user), (Transformer)EntityUtils.keyTransformer());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<String> findAllGroupNames(User user) {
        return CollectionUtils.collect(this.findAllGroups(user), (Transformer)new Transformer<Group, String>(){

            public String transform(Group input) {
                return input.getName();
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<ExternalResource> findAllResources(User user) {
        HashSet<ExternalResource> result = new HashSet<ExternalResource>();
        result.addAll(user.getResources());
        for (Group group : this.findAllGroups(user)) {
            result.addAll(group.getResources());
        }
        return result;
    }

    @Transactional(readOnly=true)
    public Collection<String> findAllResourceKeys(String key) {
        return CollectionUtils.collect(this.findAllResources((User)this.authFind(key)), (Transformer)EntityUtils.keyTransformer());
    }
}

