/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collection;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAPlainAttrDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyUtilsFactory;
import org.apache.syncope.core.persistence.jpa.entity.JPAPlainSchema;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JPAPlainSchemaDAO
extends AbstractDAO<PlainSchema>
implements PlainSchemaDAO {
    @Autowired
    private PlainAttrDAO plainAttrDAO;
    private ExternalResourceDAO resourceDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalResourceDAO resourceDAO() {
        JPAPlainSchemaDAO jPAPlainSchemaDAO = this;
        synchronized (jPAPlainSchemaDAO) {
            if (this.resourceDAO == null) {
                this.resourceDAO = (ExternalResourceDAO)ApplicationContextProvider.getApplicationContext().getBean(ExternalResourceDAO.class);
            }
        }
        return this.resourceDAO;
    }

    public PlainSchema find(String key) {
        return (PlainSchema)this.entityManager().find(JPAPlainSchema.class, (Object)key);
    }

    public List<PlainSchema> findByAnyTypeClasses(Collection<AnyTypeClass> anyTypeClasses) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPAPlainSchema.class.getSimpleName()).append(" e WHERE ");
        for (AnyTypeClass anyTypeClass : anyTypeClasses) {
            queryString.append("e.anyTypeClass.id='").append(anyTypeClass.getKey()).append("' OR ");
        }
        TypedQuery query = this.entityManager().createQuery(queryString.substring(0, queryString.length() - 4), PlainSchema.class);
        return query.getResultList();
    }

    public List<PlainSchema> findByKeyword(String keyword) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPlainSchema.class.getSimpleName() + " e WHERE e.id LIKE :keyword", PlainSchema.class);
        query.setParameter("keyword", (Object)keyword);
        return query.getResultList();
    }

    public List<PlainSchema> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPlainSchema.class.getSimpleName() + " e", PlainSchema.class);
        return query.getResultList();
    }

    public <T extends PlainAttr<?>> List<T> findAttrs(PlainSchema schema, Class<T> reference) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + ((JPAPlainAttrDAO)this.plainAttrDAO).getEntityReference(reference).getSimpleName() + " e WHERE e.schema=:schema", reference);
        query.setParameter("schema", (Object)schema);
        return query.getResultList();
    }

    public PlainSchema save(PlainSchema schema) {
        return (PlainSchema)this.entityManager().merge((Object)schema);
    }

    public void delete(String key) {
        PlainSchema schema = this.find(key);
        if (schema == null) {
            return;
        }
        JPAAnyUtilsFactory anyUtilsFactory = new JPAAnyUtilsFactory();
        for (AnyTypeKind anyTypeKind : AnyTypeKind.values()) {
            AnyUtils anyUtils = anyUtilsFactory.getInstance(anyTypeKind);
            for (PlainAttr attr : this.findAttrs(schema, anyUtils.plainAttrClass())) {
                this.plainAttrDAO.delete(attr.getKey(), anyUtils.plainAttrClass());
            }
            this.resourceDAO().deleteMapping(key);
        }
        if (schema.getAnyTypeClass() != null) {
            schema.getAnyTypeClass().getPlainSchemas().remove(schema);
        }
        this.entityManager().remove((Object)schema);
    }
}

