/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.syncope.common.lib.types.LoggerType;
import org.apache.syncope.core.persistence.api.dao.LoggerDAO;
import org.apache.syncope.core.persistence.api.entity.Logger;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPALogger;
import org.springframework.stereotype.Repository;

@Repository
public class JPALoggerDAO
extends AbstractDAO<Logger>
implements LoggerDAO {
    public Logger find(String key) {
        return (Logger)this.entityManager().find(JPALogger.class, (Object)key);
    }

    public List<Logger> findAll(LoggerType type) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPALogger.class.getSimpleName() + " e WHERE e.type=:type", Logger.class);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    public Logger save(Logger logger) {
        if (LoggerType.AUDIT == logger.getType() && LoggerLevel.OFF != logger.getLevel()) {
            logger.setLevel(LoggerLevel.DEBUG);
        }
        return (Logger)this.entityManager().merge((Object)logger);
    }

    public void delete(Logger logger) {
        this.entityManager().remove((Object)logger);
    }

    public void delete(String key) {
        Logger logger = this.find(key);
        if (logger == null) {
            return;
        }
        this.delete(logger);
    }
}

