/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AssignableCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.OrderBySupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.springframework.util.ReflectionUtils;

public class JPAAnySearchDAO
extends AbstractAnySearchDAO {
    private static final String EMPTY_QUERY = "SELECT any_id FROM user_search_attr WHERE 1=2";
    private static final String[] RELATIONSHIP_FIELDS = new String[]{"realm", "userOwner", "groupOwner"};

    private Pair<String, Set<String>> getAdminRealmsFilter(Set<String> adminRealms, SearchSupport svs, List<Object> parameters) {
        HashSet realmKeys = new HashSet();
        HashSet<String> dynRealmKeys = new HashSet<String>();
        for (String realmPath : RealmUtils.normalize(adminRealms)) {
            if (realmPath.startsWith("/")) {
                Realm realm = this.realmDAO.findByFullPath(realmPath);
                if (realm == null) {
                    SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
                    noRealm.getElements().add("Invalid realm specified: " + realmPath);
                    throw noRealm;
                }
                CollectionUtils.collect((Iterable)this.realmDAO.findDescendants(realm), (Transformer)EntityUtils.keyTransformer(), realmKeys);
                continue;
            }
            DynRealm dynRealm = this.dynRealmDAO.find(realmPath);
            if (dynRealm == null) {
                LOG.warn("Ignoring invalid dynamic realm {}", (Object)realmPath);
                continue;
            }
            dynRealmKeys.add(dynRealm.getKey());
        }
        if (!dynRealmKeys.isEmpty()) {
            CollectionUtils.collect((Iterable)this.realmDAO.findAll(), (Transformer)EntityUtils.keyTransformer(), realmKeys);
        }
        StringBuilder adminRealmFilter = new StringBuilder("u.any_id IN (").append("SELECT any_id FROM ").append(svs.field().name).append(" WHERE realm_id IN (SELECT id AS realm_id FROM Realm");
        boolean firstRealm = true;
        for (String realmKey : realmKeys) {
            if (firstRealm) {
                adminRealmFilter.append(" WHERE");
                firstRealm = false;
            } else {
                adminRealmFilter.append(" OR");
            }
            adminRealmFilter.append(" id=?").append(this.setParameter(parameters, realmKey));
        }
        adminRealmFilter.append("))");
        return Pair.of((Object)adminRealmFilter.toString(), dynRealmKeys);
    }

    @Override
    protected int doCount(Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        List<Object> parameters = Collections.synchronizedList(new ArrayList());
        SearchSupport svs = new SearchSupport(kind);
        Pair<String, Set<String>> filter = this.getAdminRealmsFilter(adminRealms, svs, parameters);
        StringBuilder queryString = this.getQuery(this.buildEffectiveCond(cond, (Set)filter.getRight()), parameters, svs);
        queryString.insert(0, "SELECT u.any_id FROM (");
        queryString.append(") u WHERE ").append((String)filter.getLeft());
        queryString.insert(0, "SELECT COUNT(any_id) FROM (");
        queryString.append(") count_any_id");
        Query countQuery = this.entityManager().createNativeQuery(queryString.toString());
        this.fillWithParameters(countQuery, parameters);
        return ((Number)countQuery.getSingleResult()).intValue();
    }

    @Override
    protected <T extends Any<?>> List<T> doSearch(Set<String> adminRealms, SearchCond cond, int page, int itemsPerPage, List<OrderByClause> orderBy, AnyTypeKind kind) {
        try {
            List<Object> parameters = Collections.synchronizedList(new ArrayList());
            SearchSupport svs = new SearchSupport(kind);
            Pair<String, Set<String>> filter = this.getAdminRealmsFilter(adminRealms, svs, parameters);
            StringBuilder queryString = this.getQuery(this.buildEffectiveCond(cond, (Set)filter.getRight()), parameters, svs);
            OrderBySupport obs = this.parseOrderBy(kind, svs, orderBy);
            if (queryString.charAt(0) == '(') {
                queryString.insert(0, this.buildSelect(obs));
                queryString.append((CharSequence)this.buildWhere(svs, obs));
            } else {
                queryString.insert(0, this.buildSelect(obs).append('('));
                queryString.append(')').append((CharSequence)this.buildWhere(svs, obs));
            }
            queryString.append((String)filter.getLeft()).append((CharSequence)this.buildOrderBy(obs));
            Query query = this.entityManager().createNativeQuery(queryString.toString());
            query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
            if (itemsPerPage >= 0) {
                query.setMaxResults(itemsPerPage);
            }
            this.fillWithParameters(query, parameters);
            return this.buildResult(query.getResultList(), kind);
        }
        catch (Exception e) {
            LOG.error("While searching for {}", (Object)kind, (Object)e);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setParameter(List<Object> parameters, Object parameter) {
        int key;
        List<Object> list = parameters;
        synchronized (list) {
            parameters.add(parameter);
            key = parameters.size();
        }
        return key;
    }

    private void fillWithParameters(Query query, List<Object> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            if (parameters.get(i) instanceof Date) {
                query.setParameter(i + 1, (Date)parameters.get(i), TemporalType.TIMESTAMP);
                continue;
            }
            if (parameters.get(i) instanceof Boolean) {
                query.setParameter(i + 1, (Object)((Boolean)parameters.get(i) != false ? 1 : 0));
                continue;
            }
            query.setParameter(i + 1, parameters.get(i));
        }
    }

    private StringBuilder buildSelect(OrderBySupport obs) {
        StringBuilder select = new StringBuilder("SELECT u.any_id");
        for (OrderBySupport.Item item : obs.items) {
            select.append(',').append(item.select);
        }
        select.append(" FROM ");
        return select;
    }

    private StringBuilder buildWhere(SearchSupport svs, OrderBySupport obs) {
        StringBuilder where = new StringBuilder(" u");
        for (SearchSupport.SearchView searchView : obs.views) {
            where.append(',');
            if (searchView.name.equals(svs.attr().name)) {
                where.append(" (SELECT * FROM ").append(searchView.name);
                if (svs.nonMandatorySchemas || obs.nonMandatorySchemas) {
                    where.append(" UNION SELECT * FROM ").append(svs.nullAttr().name);
                }
                where.append(')');
            } else {
                where.append(searchView.name);
            }
            where.append(' ').append(searchView.alias);
        }
        where.append(" WHERE ");
        for (SearchSupport.SearchView searchView : obs.views) {
            where.append("u.any_id=").append(searchView.alias).append(".any_id AND ");
        }
        for (OrderBySupport.Item item : obs.items) {
            if (!StringUtils.isNotBlank((CharSequence)item.where)) continue;
            where.append(item.where).append(" AND ");
        }
        return where;
    }

    private StringBuilder buildOrderBy(OrderBySupport obs) {
        StringBuilder orderBy = new StringBuilder();
        for (OrderBySupport.Item item : obs.items) {
            orderBy.append(item.orderBy).append(',');
        }
        if (!obs.items.isEmpty()) {
            orderBy.insert(0, " ORDER BY ");
            orderBy.deleteCharAt(orderBy.length() - 1);
        }
        return orderBy;
    }

    private OrderBySupport parseOrderBy(AnyTypeKind kind, SearchSupport svs, List<OrderByClause> orderBy) {
        AnyUtils attrUtils = this.anyUtilsFactory.getInstance(kind);
        OrderBySupport obs = new OrderBySupport();
        for (OrderByClause clause : this.filterOrderBy(orderBy)) {
            String fieldName;
            OrderBySupport.Item item = new OrderBySupport.Item();
            String string = fieldName = "key".equals(clause.getField()) ? "id" : clause.getField();
            if (ReflectionUtils.findField((Class)attrUtils.anyClass(), (String)fieldName) == null) {
                PlainSchema schema = (PlainSchema)this.schemaDAO.find(fieldName);
                if (schema != null) {
                    boolean bl = obs.nonMandatorySchemas = !"true".equals(schema.getMandatoryCondition());
                    if (schema.isUniqueConstraint()) {
                        obs.views.add(svs.uniqueAttr());
                        item.select = svs.uniqueAttr().alias + '.' + svs.fieldName(schema.getType()) + " AS " + fieldName;
                        item.where = svs.uniqueAttr().alias + ".schema_id='" + fieldName + "'";
                        item.orderBy = fieldName + " " + clause.getDirection().name();
                    } else {
                        obs.views.add(svs.attr());
                        item.select = svs.attr().alias + '.' + svs.fieldName(schema.getType()) + " AS " + fieldName;
                        item.where = svs.attr().alias + ".schema_id='" + fieldName + "'";
                        item.orderBy = fieldName + " " + clause.getDirection().name();
                    }
                }
            } else {
                if (ArrayUtils.contains((Object[])RELATIONSHIP_FIELDS, (Object)fieldName)) {
                    fieldName = fieldName + "_id";
                }
                obs.views.add(svs.field());
                item.select = svs.field().alias + "." + fieldName;
                item.where = "";
                item.orderBy = svs.field().alias + "." + fieldName + " " + clause.getDirection().name();
            }
            if (item.isEmpty()) {
                LOG.warn("Cannot build any valid clause from {}", (Object)clause);
                continue;
            }
            obs.items.add(item);
        }
        return obs;
    }

    private StringBuilder getQuery(SearchCond cond, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder();
        switch (cond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                if (cond.getAnyTypeCond() != null && AnyTypeKind.ANY_OBJECT == svs.anyTypeKind) {
                    query.append(this.getQuery(cond.getAnyTypeCond(), cond.getType() == SearchCond.Type.NOT_LEAF, parameters, svs));
                    break;
                }
                if (cond.getRelationshipTypeCond() != null && (AnyTypeKind.USER == svs.anyTypeKind || AnyTypeKind.ANY_OBJECT == svs.anyTypeKind)) {
                    query.append(this.getQuery(cond.getRelationshipTypeCond(), cond.getType() == SearchCond.Type.NOT_LEAF, parameters, svs));
                    break;
                }
                if (cond.getRelationshipCond() != null && (AnyTypeKind.USER == svs.anyTypeKind || AnyTypeKind.ANY_OBJECT == svs.anyTypeKind)) {
                    query.append(this.getQuery(cond.getRelationshipCond(), cond.getType() == SearchCond.Type.NOT_LEAF, parameters, svs));
                    break;
                }
                if (cond.getMembershipCond() != null && (AnyTypeKind.USER == svs.anyTypeKind || AnyTypeKind.ANY_OBJECT == svs.anyTypeKind)) {
                    query.append(this.getQuery(cond.getMembershipCond(), cond.getType() == SearchCond.Type.NOT_LEAF, parameters, svs));
                    break;
                }
                if (cond.getAssignableCond() != null) {
                    query.append(this.getQuery(cond.getAssignableCond(), parameters, svs));
                    break;
                }
                if (cond.getRoleCond() != null && AnyTypeKind.USER == svs.anyTypeKind) {
                    query.append(this.getQuery(cond.getRoleCond(), cond.getType() == SearchCond.Type.NOT_LEAF, parameters, svs));
                    break;
                }
                if (cond.getDynRealmCond() != null) {
                    query.append(this.getQuery(cond.getDynRealmCond(), cond.getType() == SearchCond.Type.NOT_LEAF, parameters, svs));
                    break;
                }
                if (cond.getMemberCond() != null && AnyTypeKind.GROUP == svs.anyTypeKind) {
                    query.append(this.getQuery(cond.getMemberCond(), cond.getType() == SearchCond.Type.NOT_LEAF, parameters, svs));
                    break;
                }
                if (cond.getResourceCond() != null) {
                    query.append(this.getQuery(cond.getResourceCond(), cond.getType() == SearchCond.Type.NOT_LEAF, parameters, svs));
                    break;
                }
                if (cond.getAttributeCond() != null) {
                    query.append(this.getQuery(cond.getAttributeCond(), cond.getType() == SearchCond.Type.NOT_LEAF, parameters, svs));
                    break;
                }
                if (cond.getAnyCond() == null) break;
                query.append(this.getQuery(cond.getAnyCond(), cond.getType() == SearchCond.Type.NOT_LEAF, parameters, svs));
                break;
            }
            case AND: {
                String andSubQuery = this.getQuery(cond.getLeftSearchCond(), parameters, svs).toString();
                andSubQuery = andSubQuery.replaceFirst("WHERE ", "WHERE (");
                query.append(andSubQuery).append(" AND any_id IN ( ").append((CharSequence)this.getQuery(cond.getRightSearchCond(), parameters, svs)).append("))");
                break;
            }
            case OR: {
                String orSubQuery = this.getQuery(cond.getLeftSearchCond(), parameters, svs).toString();
                orSubQuery = orSubQuery.replaceFirst("WHERE ", "WHERE (");
                query.append(orSubQuery).append(" OR any_id IN ( ").append((CharSequence)this.getQuery(cond.getRightSearchCond(), parameters, svs)).append("))");
                break;
            }
        }
        return query;
    }

    private String getQuery(AnyTypeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name).append(" WHERE type_id");
        if (not) {
            query.append("<>");
        } else {
            query.append('=');
        }
        query.append('?').append(this.setParameter(parameters, cond.getAnyTypeKey()));
        return query.toString();
    }

    private String getQuery(RelationshipTypeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name).append(" WHERE ");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT any_id ").append("FROM ").append(svs.relationship().name).append(" WHERE type=?").append(this.setParameter(parameters, cond.getRelationshipTypeKey())).append(" UNION SELECT right_any_id AS any_id FROM ").append(svs.relationship().name).append(" WHERE type=?").append(this.setParameter(parameters, cond.getRelationshipTypeKey())).append(')');
        return query.toString();
    }

    private String getQuery(RelationshipCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        String rightAnyObjectKey;
        try {
            rightAnyObjectKey = this.check(cond);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY;
        }
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name).append(" WHERE ");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.relationship().name).append(" WHERE ").append("right_any_id=?").append(this.setParameter(parameters, rightAnyObjectKey)).append(')');
        return query.toString();
    }

    private String getQuery(MembershipCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        String groupKey;
        try {
            groupKey = this.check(cond);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY;
        }
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name).append(" WHERE (");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.membership().name).append(" WHERE ").append("group_id=?").append(this.setParameter(parameters, groupKey)).append(") ");
        if (not) {
            query.append("AND any_id NOT IN (");
        } else {
            query.append("OR any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.dyngroupmembership().name).append(" WHERE ").append("group_id=?").append(this.setParameter(parameters, groupKey)).append("))");
        return query.toString();
    }

    private String getQuery(RoleCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name).append(" WHERE (");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.role().name).append(" WHERE ").append("role_id=?").append(this.setParameter(parameters, cond.getRole())).append(") ");
        if (not) {
            query.append("AND any_id NOT IN (");
        } else {
            query.append("OR any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.dynrolemembership().name).append(" WHERE ").append("role_id=?").append(this.setParameter(parameters, cond.getRole())).append("))");
        return query.toString();
    }

    private String getQuery(DynRealmCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name).append(" WHERE (");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.dynrealmmembership().name).append(" WHERE ").append("dynRealm_id=?").append(this.setParameter(parameters, cond.getDynRealm())).append("))");
        return query.toString();
    }

    private String getQuery(ResourceCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name).append(" WHERE ");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.resource().name).append(" WHERE resource_id=?").append(this.setParameter(parameters, cond.getResourceKey()));
        if (svs.anyTypeKind == AnyTypeKind.USER) {
            query.append(" UNION SELECT DISTINCT any_id FROM ").append(svs.groupResource().name).append(" WHERE resource_id=?").append(this.setParameter(parameters, cond.getResourceKey()));
        }
        query.append(')');
        return query.toString();
    }

    private String getQuery(AssignableCond cond, List<Object> parameters, SearchSupport svs) {
        Realm realm;
        try {
            realm = this.check(cond);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY;
        }
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name).append(" WHERE (");
        if (cond.isFromGroup()) {
            for (Realm current : this.realmDAO.findDescendants(realm)) {
                query.append("realm_id=?").append(this.setParameter(parameters, current.getKey())).append(" OR ");
            }
            query.setLength(query.length() - 4);
        } else {
            Realm current = realm;
            while (current.getParent() != null) {
                query.append("realm_id=?").append(this.setParameter(parameters, current.getKey())).append(" OR ");
                current = current.getParent();
            }
            query.append("realm_id=?").append(this.setParameter(parameters, this.realmDAO.getRoot().getKey()));
        }
        query.append(')');
        return query.toString();
    }

    private String getQuery(MemberCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        String memberKey;
        try {
            memberKey = this.check(cond);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY;
        }
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name).append(" WHERE ");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT group_id AS any_id FROM ").append(new SearchSupport((AnyTypeKind)AnyTypeKind.USER).membership().name).append(" WHERE (").append("any_id=?").append(this.setParameter(parameters, memberKey)).append(") ");
        if (not) {
            query.append("AND any_id NOT IN (");
        } else {
            query.append("OR any_id IN (");
        }
        query.append("SELECT DISTINCT group_id AS any_id FROM ").append(new SearchSupport((AnyTypeKind)AnyTypeKind.ANY_OBJECT).membership().name).append(" WHERE ").append("any_id=?").append(this.setParameter(parameters, memberKey)).append("))");
        return query.toString();
    }

    private void fillAttrQuery(StringBuilder query, PlainAttrValue attrValue, PlainSchema schema, AttributeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        String column;
        boolean ignoreCase = AttributeCond.Type.ILIKE == cond.getType() || AttributeCond.Type.IEQ == cond.getType();
        String string = column = cond instanceof AnyCond ? cond.getSchema() : svs.fieldName(schema.getType());
        if ((schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum) && ignoreCase) {
            column = "LOWER (" + column + ")";
        }
        if (!(cond instanceof AnyCond)) {
            column = "' AND " + column;
        }
        switch (cond.getType()) {
            case ISNULL: {
                query.append(column).append(not ? " IS NOT NULL" : " IS NULL");
                break;
            }
            case ISNOTNULL: {
                query.append(column).append(not ? " IS NULL" : " IS NOT NULL");
                break;
            }
            case ILIKE: 
            case LIKE: {
                if (schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum) {
                    query.append(column);
                    if (not) {
                        query.append(" NOT ");
                    }
                    query.append(" LIKE ");
                    if (ignoreCase) {
                        query.append("LOWER(?").append(this.setParameter(parameters, cond.getExpression())).append(')');
                        break;
                    }
                    query.append('?').append(this.setParameter(parameters, cond.getExpression()));
                    break;
                }
                if (!(cond instanceof AnyCond)) {
                    query.append("' AND");
                }
                query.append(" 1=2");
                LOG.error("LIKE is only compatible with string or enum schemas");
                break;
            }
            case IEQ: 
            case EQ: {
                query.append(column);
                if (not) {
                    query.append("<>");
                } else {
                    query.append('=');
                }
                if ((schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum) && ignoreCase) {
                    query.append("LOWER(?").append(this.setParameter(parameters, attrValue.getValue())).append(')');
                    break;
                }
                query.append('?').append(this.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case GE: {
                query.append(column);
                if (not) {
                    query.append('<');
                } else {
                    query.append(">=");
                }
                query.append('?').append(this.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case GT: {
                query.append(column);
                if (not) {
                    query.append("<=");
                } else {
                    query.append('>');
                }
                query.append('?').append(this.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case LE: {
                query.append(column);
                if (not) {
                    query.append('>');
                } else {
                    query.append("<=");
                }
                query.append('?').append(this.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case LT: {
                query.append(column);
                if (not) {
                    query.append(">=");
                } else {
                    query.append('<');
                }
                query.append('?').append(this.setParameter(parameters, attrValue.getValue()));
                break;
            }
        }
    }

    private String getQuery(AttributeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Pair<PlainSchema, PlainAttrValue> checked;
        try {
            checked = this.check(cond, svs.anyTypeKind);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY;
        }
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ");
        switch (cond.getType()) {
            case ISNOTNULL: {
                query.append(svs.field().name).append(" WHERE any_id NOT IN (SELECT any_id FROM ").append(svs.nullAttr().name).append(" WHERE schema_id='").append(((PlainSchema)checked.getLeft()).getKey()).append("')");
                break;
            }
            case ISNULL: {
                query.append(svs.nullAttr().name).append(" WHERE schema_id='").append(((PlainSchema)checked.getLeft()).getKey()).append("'");
                break;
            }
            default: {
                if (((PlainSchema)checked.getLeft()).isUniqueConstraint()) {
                    query.append(svs.uniqueAttr().name);
                } else {
                    query.append(svs.attr().name);
                }
                query.append(" WHERE schema_id='").append(((PlainSchema)checked.getLeft()).getKey());
                this.fillAttrQuery(query, (PlainAttrValue)checked.getRight(), (PlainSchema)checked.getLeft(), cond, not, parameters, svs);
            }
        }
        return query.toString();
    }

    private String getQuery(AnyCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Triple<PlainSchema, PlainAttrValue, AnyCond> checked;
        try {
            checked = this.check(cond, svs.anyTypeKind);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY;
        }
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name).append(" WHERE ");
        this.fillAttrQuery(query, (PlainAttrValue)checked.getMiddle(), (PlainSchema)checked.getLeft(), (AttributeCond)checked.getRight(), not, parameters, svs);
        return query.toString();
    }
}

