/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.sql.DataSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.content.ContentExporter;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.content.AbstractContentDealer;
import org.apache.syncope.core.persistence.jpa.content.MultiParentNode;
import org.apache.syncope.core.persistence.jpa.content.MultiParentNodeOp;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Component
public class XMLContentExporter
extends AbstractContentDealer
implements ContentExporter {
    protected static final Set<String> TABLE_PREFIXES_TO_BE_EXCLUDED = new HashSet<String>(Arrays.asList("QRTZ_", "LOGGING", "ReportExec", "TaskExec", "SyncopeUser", "UPlainAttr", "UPlainAttrValue", "UPlainAttrUniqueValue", "URelationship", "UMembership", "AnyObject", "APlainAttr", "APlainAttrValue", "APlainAttrUniqueValue", "ARelationship", "AMembership", "AccessToken"));
    protected static final Map<String, String> TABLES_TO_BE_FILTERED = Collections.singletonMap("TASK", "DTYPE <> 'PropagationTask'");
    protected static final Map<String, Set<String>> COLUMNS_TO_BE_NULLIFIED = Collections.singletonMap("SYNCOPEGROUP", Collections.singleton("USEROWNER_ID"));
    @Autowired
    private RealmDAO realmDAO;

    private boolean isTableAllowed(final String tableName) {
        return IterableUtils.matchesAll(TABLE_PREFIXES_TO_BE_EXCLUDED, (Predicate)new Predicate<String>(){

            public boolean evaluate(String prefix) {
                return !tableName.toUpperCase().startsWith(prefix.toUpperCase());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> sortByForeignKeys(String dbSchema, Connection conn, Set<String> tableNames) throws SQLException {
        HashSet roots = new HashSet();
        DatabaseMetaData meta = conn.getMetaData();
        TreeMap<String, MultiParentNode<String>> exploited = new TreeMap<String, MultiParentNode<String>>(String.CASE_INSENSITIVE_ORDER);
        HashSet<String> pkTableNames = new HashSet<String>();
        for (String tableName : tableNames) {
            MultiParentNode<String> node = (MultiParentNode<String>)exploited.get(tableName);
            if (node == null) {
                node = new MultiParentNode<String>(tableName);
                roots.add(node);
                exploited.put(tableName, node);
            }
            pkTableNames.clear();
            ResultSet rs = null;
            try {
                rs = meta.getImportedKeys(conn.getCatalog(), dbSchema, tableName);
                while (rs.next()) {
                    pkTableNames.add(rs.getString("PKTABLE_NAME"));
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        LOG.error("While closing tables result set", (Throwable)e);
                    }
                }
            }
            for (String pkTableName : pkTableNames) {
                if (tableName.equalsIgnoreCase(pkTableName)) continue;
                MultiParentNode<String> pkNode = (MultiParentNode<String>)exploited.get(pkTableName);
                if (pkNode == null) {
                    pkNode = new MultiParentNode<String>(pkTableName);
                    roots.add(pkNode);
                    exploited.put(pkTableName, pkNode);
                }
                pkNode.addChild(node);
                if (!roots.contains(node)) continue;
                roots.remove(node);
            }
        }
        ArrayList<String> sortedTableNames = new ArrayList<String>(tableNames.size());
        MultiParentNodeOp.traverseTree(roots, sortedTableNames);
        sortedTableNames.retainAll(tableNames);
        LOG.debug("Tables after retainAll {}", sortedTableNames);
        Collections.reverse(sortedTableNames);
        return sortedTableNames;
    }

    private String getValues(ResultSet rs, String columnName, Integer columnType) throws SQLException {
        String res = null;
        try {
            switch (columnType) {
                case -4: 
                case -3: 
                case -2: {
                    InputStream is = rs.getBinaryStream(columnName);
                    if (is != null) {
                        res = new String(Hex.encode((byte[])IOUtils.toByteArray((InputStream)is)));
                    }
                    break;
                }
                case 2004: {
                    Blob blob = rs.getBlob(columnName);
                    if (blob != null) {
                        res = new String(Hex.encode((byte[])IOUtils.toByteArray((InputStream)blob.getBinaryStream())));
                    }
                    break;
                }
                case -7: 
                case 16: {
                    if (rs.getBoolean(columnName)) {
                        res = "1";
                        break;
                    }
                    res = "0";
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    Timestamp timestamp = rs.getTimestamp(columnName);
                    if (timestamp != null) {
                        res = FormatUtils.format((Date)new Date(timestamp.getTime()));
                    }
                    break;
                }
                default: {
                    res = rs.getString(columnName);
                    break;
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error retrieving hexadecimal string", (Throwable)e);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTable(TransformerHandler handler, Connection conn, String tableName, String whereClause) throws SQLException, SAXException {
        LOG.debug("Export table {}", (Object)tableName);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder orderBy = new StringBuilder();
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet pkeyRS = null;
            try {
                pkeyRS = meta.getPrimaryKeys(null, null, tableName);
                while (pkeyRS.next()) {
                    String columnName = pkeyRS.getString("COLUMN_NAME");
                    if (columnName == null) continue;
                    if (orderBy.length() > 0) {
                        orderBy.append(",");
                    }
                    orderBy.append(columnName);
                }
            }
            finally {
                if (pkeyRS != null) {
                    try {
                        pkeyRS.close();
                    }
                    catch (SQLException e) {
                        LOG.error("While closing result set", (Throwable)e);
                    }
                }
            }
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ").append(tableName).append(" a");
            if (StringUtils.isNotBlank((CharSequence)whereClause)) {
                query.append(" WHERE ").append(whereClause);
            }
            if (orderBy.length() > 0) {
                query.append(" ORDER BY ").append((CharSequence)orderBy);
            }
            stmt = conn.prepareStatement(query.toString());
            ArrayList<Object> rows = new ArrayList<Object>();
            rs = stmt.executeQuery();
            while (rs.next()) {
                HashMap<String, String> row = new HashMap<String, String>();
                rows.add(row);
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    Integer columnType;
                    String columnName = resultSetMetaData.getColumnName(i + 1);
                    String value = this.getValues(rs, columnName, columnType = Integer.valueOf(resultSetMetaData.getColumnType(i + 1)));
                    if (value == null || COLUMNS_TO_BE_NULLIFIED.containsKey(tableName) && COLUMNS_TO_BE_NULLIFIED.get(tableName).contains(columnName)) continue;
                    row.put(columnName, value);
                    LOG.debug("Add for table {}: {}=\"{}\"", new Object[]{tableName, columnName, value});
                }
            }
            if (tableName.equalsIgnoreCase("Realm")) {
                ArrayList realmRows = new ArrayList(rows);
                rows.clear();
                for (final Realm realm : this.realmDAO.findAll()) {
                    rows.add(IterableUtils.find(realmRows, (Predicate)new Predicate<Map<String, String>>(){

                        public boolean evaluate(Map<String, String> row) {
                            String id = row.get("ID");
                            if (id == null) {
                                id = row.get("id");
                            }
                            return realm.getKey().equals(id);
                        }
                    }));
                }
            }
            for (Map map : rows) {
                AttributesImpl attrs = new AttributesImpl();
                for (Map.Entry entry : map.entrySet()) {
                    attrs.addAttribute("", "", (String)entry.getKey(), "CDATA", (String)entry.getValue());
                }
                handler.startElement("", "", tableName, attrs);
                handler.endElement("", "", tableName);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing result set", (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing statement", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String domain, OutputStream os, String uwfPrefix, String gwfPrefix, String awfPrefix) throws SAXException, TransformerConfigurationException {
        if (StringUtils.isNotBlank((CharSequence)uwfPrefix)) {
            TABLE_PREFIXES_TO_BE_EXCLUDED.add(uwfPrefix);
        }
        if (StringUtils.isNotBlank((CharSequence)gwfPrefix)) {
            TABLE_PREFIXES_TO_BE_EXCLUDED.add(gwfPrefix);
        }
        if (StringUtils.isNotBlank((CharSequence)awfPrefix)) {
            TABLE_PREFIXES_TO_BE_EXCLUDED.add(awfPrefix);
        }
        StreamResult streamResult = new StreamResult(os);
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        TransformerHandler handler = transformerFactory.newTransformerHandler();
        Transformer serializer = handler.getTransformer();
        serializer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        serializer.setOutputProperty("indent", "yes");
        handler.setResult(streamResult);
        handler.startDocument();
        handler.startElement("", "", "dataset", new AttributesImpl());
        DataSource dataSource = (DataSource)this.domainsHolder.getDomains().get(domain);
        if (dataSource == null) {
            throw new IllegalArgumentException("Could not find DataSource for domain " + domain);
        }
        String schema = (String)ApplicationContextProvider.getBeanFactory().getBean(domain + "DatabaseSchema", String.class);
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = DataSourceUtils.getConnection((DataSource)dataSource);
            DatabaseMetaData meta = conn.getMetaData();
            rs = meta.getTables(null, StringUtils.isBlank((CharSequence)schema) ? null : schema, null, new String[]{"TABLE"});
            TreeSet<String> tableNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                LOG.debug("Found table {}", (Object)tableName);
                if (!this.isTableAllowed(tableName)) continue;
                tableNames.add(tableName);
            }
            LOG.debug("Tables to be exported {}", tableNames);
            for (String tableName : this.sortByForeignKeys(schema, conn, tableNames)) {
                try {
                    this.exportTable(handler, conn, tableName, TABLES_TO_BE_FILTERED.get(tableName.toUpperCase()));
                }
                catch (Exception e) {
                    LOG.error("Failure exporting table {}", (Object)tableName, (Object)e);
                }
            }
        }
        catch (SQLException e) {
            LOG.error("While exporting database content", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing tables result set", (Throwable)e);
                }
            }
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
            if (conn != null) {
                try {
                    if (!conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    LOG.error("While releasing connection", (Throwable)e);
                }
            }
        }
        handler.endElement("", "", "dataset");
        handler.endDocument();
    }
}

