/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.commons.SchemaUtils;
import org.apache.syncope.client.console.wicket.ajax.markup.html.LabelInfo;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.EncryptedFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.AbstractAttrs;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;

public class PlainAttrs
extends AbstractAttrs<PlainSchemaTO> {
    private static final long serialVersionUID = 552437609667518888L;
    protected final AjaxWizard.Mode mode;
    protected final AnyTO previousObject;
    protected String fileKey = "";

    public <T extends AnyTO> PlainAttrs(AnyWrapper<T> modelObject, Form<?> form, AjaxWizard.Mode mode, List<String> anyTypeClasses, List<String> whichPlainAttrs) throws IllegalArgumentException {
        super(modelObject, anyTypeClasses, whichPlainAttrs);
        this.mode = mode;
        if (modelObject.getInnerObject() instanceof UserTO) {
            this.fileKey = ((UserTO)UserTO.class.cast(modelObject.getInnerObject())).getUsername();
        } else if (modelObject.getInnerObject() instanceof GroupTO) {
            this.fileKey = ((GroupTO)GroupTO.class.cast(modelObject.getInnerObject())).getName();
        } else if (modelObject.getInnerObject() instanceof AnyObjectTO) {
            this.fileKey = ((AnyObjectTO)AnyObjectTO.class.cast(modelObject.getInnerObject())).getName();
        }
        this.previousObject = modelObject instanceof UserWrapper ? ((UserWrapper)UserWrapper.class.cast(modelObject)).getPreviousUserTO() : null;
        this.setTitleModel((IModel)new ResourceModel("attributes.plain"));
        this.add(new Component[]{new Accordion("plainSchemas", Collections.singletonList(new AbstractTab((IModel)new ResourceModel("attributes.accordion", "Plain Attributes")){
            private static final long serialVersionUID = 1037272333056449378L;

            public WebMarkupContainer getPanel(String panelId) {
                return new PlainSchemas(panelId, PlainAttrs.this.schemas, (IModel<List<AttrTO>>)PlainAttrs.this.attrTOs);
            }
        }), (IModel<Integer>)Model.of((Serializable)Integer.valueOf(0))).setOutputMarkupId(true)});
        this.add(new Component[]{new ListView<MembershipTO>("membershipsPlainSchemas", this.membershipTOs){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<MembershipTO> item) {
                final MembershipTO membershipTO = (MembershipTO)item.getModelObject();
                item.add(new Component[]{new Accordion("membershipPlainSchemas", Collections.singletonList(new AbstractTab((IModel)new StringResourceModel("attributes.membership.accordion", (Component)PlainAttrs.this, (IModel)Model.of((Serializable)membershipTO))){
                    private static final long serialVersionUID = 1037272333056449378L;

                    public WebMarkupContainer getPanel(String panelId) {
                        return new PlainSchemas(panelId, (Map)PlainAttrs.this.membershipSchemas.get(membershipTO.getGroupKey()), (IModel<List<AttrTO>>)new ListModel(PlainAttrs.this.getAttrsFromTO(membershipTO)));
                    }
                }), (IModel<Integer>)Model.of((Serializable)Integer.valueOf(-1))).setOutputMarkupId(true)});
            }
        }});
    }

    @Override
    protected SchemaType getSchemaType() {
        return SchemaType.PLAIN;
    }

    @Override
    protected boolean reoderSchemas() {
        return super.reoderSchemas() && this.mode != AjaxWizard.Mode.TEMPLATE;
    }

    @Override
    protected List<AttrTO> getAttrsFromTO() {
        ArrayList<AttrTO> res = new ArrayList<AttrTO>(this.anyTO.getPlainAttrs());
        Collections.sort(res, new AbstractAttrs.AttrComparator(this));
        return res;
    }

    @Override
    protected List<AttrTO> getAttrsFromTO(MembershipTO membershipTO) {
        ArrayList<AttrTO> res = new ArrayList<AttrTO>(membershipTO.getPlainAttrs());
        Collections.sort(res, new AbstractAttrs.AttrComparator(this));
        return res;
    }

    @Override
    protected void setAttrs() {
        ArrayList<AttrTO> attrs = new ArrayList<AttrTO>();
        Map attrMap = EntityTOUtils.buildAttrMap((Collection)this.anyTO.getPlainAttrs());
        for (PlainSchemaTO schema : this.schemas.values()) {
            AttrTO attrTO = new AttrTO();
            attrTO.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((AttrTO)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                attrTO.getValues().add("");
                attrTO.setSchemaInfo((SchemaTO)schema);
            } else {
                attrTO = (AttrTO)attrMap.get(schema.getKey());
            }
            attrs.add(attrTO);
        }
        this.anyTO.getPlainAttrs().clear();
        this.anyTO.getPlainAttrs().addAll(attrs);
    }

    @Override
    protected void setAttrs(MembershipTO membershipTO) {
        ArrayList<AttrTO> attrs = new ArrayList<AttrTO>();
        Map attrMap = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.anyTO)).getMembership(membershipTO.getGroupKey()) == null ? new HashMap() : EntityTOUtils.buildAttrMap((Collection)((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.anyTO)).getMembership(membershipTO.getGroupKey()).getPlainAttrs());
        for (PlainSchemaTO schema : ((Map)this.membershipSchemas.get(membershipTO.getGroupKey())).values()) {
            AttrTO attrTO = new AttrTO();
            attrTO.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((AttrTO)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                attrTO.getValues().add("");
                attrTO.setSchemaInfo((SchemaTO)schema);
            } else {
                attrTO.getValues().addAll(((AttrTO)attrMap.get(schema.getKey())).getValues());
            }
            attrs.add(attrTO);
        }
        membershipTO.getPlainAttrs().clear();
        membershipTO.getPlainAttrs().addAll(attrs);
    }

    protected FieldPanel getFieldPanel(final PlainSchemaTO schemaTO) {
        FieldPanel panel;
        boolean jexlHelp;
        AttrSchemaType type;
        boolean readOnly;
        boolean required;
        if (this.mode == AjaxWizard.Mode.TEMPLATE) {
            required = false;
            readOnly = false;
            type = AttrSchemaType.String;
            jexlHelp = true;
        } else {
            required = schemaTO.getMandatoryCondition().equalsIgnoreCase("true");
            readOnly = schemaTO.isReadonly();
            type = schemaTO.getType();
            jexlHelp = false;
        }
        switch (type) {
            case Boolean: {
                panel = new AjaxCheckBoxPanel("panel", schemaTO.getKey(), (IModel<Boolean>)new Model(), true);
                panel.setRequired(required);
                break;
            }
            case Date: {
                String dataPattern = schemaTO.getConversionPattern() == null ? "yyyy-MM-dd'T'HH:mm:ssZ" : schemaTO.getConversionPattern();
                panel = dataPattern.contains("H") ? new AjaxDateTimeFieldPanel("panel", schemaTO.getKey(), (IModel<Date>)new Model(), dataPattern) : new AjaxDateFieldPanel("panel", schemaTO.getKey(), (IModel<Date>)new Model(), dataPattern);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Enum: {
                panel = new AjaxDropDownChoicePanel("panel", schemaTO.getKey(), new Model(), true);
                ((AjaxDropDownChoicePanel)panel).setChoices(SchemaUtils.getEnumeratedValues(schemaTO));
                if (StringUtils.isNotBlank((CharSequence)schemaTO.getEnumerationKeys())) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer(new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -3724971416312135885L;
                        private final Map<String, String> valueMap;
                        {
                            this.valueMap = SchemaUtils.getEnumeratedKeyValues(schemaTO);
                        }

                        public String getDisplayValue(String value) {
                            return this.valueMap.get(value) == null ? value : this.valueMap.get(value);
                        }

                        public String getIdValue(String value, int i) {
                            return value;
                        }

                        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                            return id;
                        }
                    });
                }
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Long: {
                panel = new AjaxSpinnerFieldPanel.Builder().enableOnChange().build("panel", schemaTO.getKey(), Long.class, (IModel<Long>)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Double: {
                panel = new AjaxSpinnerFieldPanel.Builder().enableOnChange().step(0.1).build("panel", schemaTO.getKey(), Double.class, (IModel<Double>)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Binary: {
                final PageReference pageReference = this.getPageReference();
                panel = new BinaryFieldPanel("panel", schemaTO.getKey(), (IModel)new Model(), schemaTO.getMimeType(), this.fileKey){
                    private static final long serialVersionUID = -3268213909514986831L;

                    @Override
                    protected PageReference getPageReference() {
                        return pageReference;
                    }
                };
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Encrypted: {
                panel = new EncryptedFieldPanel("panel", schemaTO.getKey(), (IModel<String>)new Model(), true);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel("panel", schemaTO.getKey(), (IModel<String>)new Model(), true);
                if (jexlHelp) {
                    ((AjaxTextFieldPanel)AjaxTextFieldPanel.class.cast(panel)).enableJexlHelp();
                }
                if (!required) break;
                panel.addRequiredLabel();
            }
        }
        panel.setReadOnly(readOnly);
        return panel;
    }

    public class PlainSchemas
    extends AbstractAttrs.Schemas {
        private static final long serialVersionUID = -4730563859116024676L;

        public PlainSchemas(String id, final Map<String, PlainSchemaTO> availableSchemas, IModel<List<AttrTO>> attrTOs) {
            super(PlainAttrs.this, id);
            this.add(new Component[]{new ListView<AttrTO>("schemas", attrTOs){
                private static final long serialVersionUID = 9101744072914090143L;

                protected void populateItem(ListItem<AttrTO> item) {
                    AttrTO attrTO = (AttrTO)item.getModelObject();
                    AbstractFieldPanel panel = PlainAttrs.this.getFieldPanel((PlainSchemaTO)availableSchemas.get(attrTO.getSchema()));
                    if (PlainAttrs.this.mode == AjaxWizard.Mode.TEMPLATE || !((PlainSchemaTO)availableSchemas.get(attrTO.getSchema())).isMultivalue()) {
                        ((FieldPanel)FieldPanel.class.cast((Object)panel)).setNewModel(attrTO.getValues());
                    } else {
                        panel = new MultiFieldPanel.Builder(new PropertyModel((Object)attrTO, "values")).build("panel", attrTO.getSchema(), (FieldPanel)FieldPanel.class.cast((Object)panel));
                        ((MultiFieldPanel)panel).setReadOnly(((PlainSchemaTO)availableSchemas.get(attrTO.getSchema())).isReadonly());
                    }
                    item.add(new Component[]{panel});
                    if (!(PlainAttrs.this.previousObject == null || PlainAttrs.this.previousObject.getPlainAttr(attrTO.getSchema()) != null && ListUtils.isEqualList((Collection)ListUtils.select((Collection)PlainAttrs.this.previousObject.getPlainAttr(attrTO.getSchema()).getValues(), (Predicate)new Predicate<String>(){

                        public boolean evaluate(String object) {
                            return StringUtils.isNotEmpty((CharSequence)object);
                        }
                    }), (Collection)ListUtils.select((Collection)attrTO.getValues(), (Predicate)new Predicate<String>(){

                        public boolean evaluate(String object) {
                            return StringUtils.isNotEmpty((CharSequence)object);
                        }
                    })))) {
                        List oldValues = PlainAttrs.this.previousObject.getPlainAttr(attrTO.getSchema()) == null ? Collections.emptyList() : PlainAttrs.this.previousObject.getPlainAttr(attrTO.getSchema()).getValues();
                        panel.showExternAction((Component)new LabelInfo("externalAction", oldValues));
                    }
                }
            }});
        }
    }
}

