/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesomeIconTypeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.Approvals;
import org.apache.syncope.client.console.rest.UserWorkflowRestClient;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.widgets.AlertWidget;
import org.apache.syncope.common.lib.to.WorkflowFormTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.time.Duration;

public class ApprovalsWidget
extends AlertWidget<WorkflowFormTO> {
    private static final long serialVersionUID = 7667120094526529934L;
    private final UserWorkflowRestClient restClient = new UserWorkflowRestClient();
    private final List<WorkflowFormTO> lastApprovals = new ArrayList<WorkflowFormTO>();

    public ApprovalsWidget(String id, PageReference pageRef) {
        super(id);
        this.setOutputMarkupId(true);
        this.latestAlertsList.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)30)){
            private static final long serialVersionUID = 7298597675929755960L;

            protected void onTimer(AjaxRequestTarget target) {
                if (!((List)ApprovalsWidget.this.latestAlerts.getObject()).equals(ApprovalsWidget.this.lastApprovals)) {
                    ApprovalsWidget.this.refreshLatestAlerts(target);
                }
            }
        }});
    }

    public final void refreshLatestAlerts(AjaxRequestTarget target) {
        ((List)this.latestAlerts.getObject()).clear();
        ((List)this.latestAlerts.getObject()).addAll(this.lastApprovals);
        int latestAlertSize = this.getLatestAlertsSize();
        this.linkAlertsNumber.setDefaultModelObject((Object)latestAlertSize);
        target.add(new Component[]{this.linkAlertsNumber});
        this.headerAlertsNumber.setDefaultModelObject((Object)latestAlertSize);
        target.add(new Component[]{this.headerAlertsNumber});
        target.add(new Component[]{this.latestAlertsList});
        this.lastApprovals.clear();
        this.lastApprovals.addAll((Collection)this.latestAlerts.getObject());
    }

    @Override
    protected int getLatestAlertsSize() {
        return SyncopeConsoleSession.get().owns("WORKFLOW_FORM_LIST", new String[0]) && SyncopeConsoleSession.get().owns("WORKFLOW_FORM_READ", new String[0]) ? this.restClient.countForms() : 0;
    }

    @Override
    protected IModel<List<WorkflowFormTO>> getLatestAlerts() {
        return new ListModel<WorkflowFormTO>(){
            private static final long serialVersionUID = -2583290457773357445L;

            public List<WorkflowFormTO> getObject() {
                List<WorkflowFormTO> updatedApprovals = SyncopeConsoleSession.get().owns("WORKFLOW_FORM_LIST", new String[0]) && SyncopeConsoleSession.get().owns("WORKFLOW_FORM_READ", new String[0]) ? ApprovalsWidget.this.restClient.getForms(1, 5, (SortParam<String>)new SortParam((Object)"createTime", true)) : Collections.emptyList();
                return updatedApprovals;
            }
        };
    }

    @Override
    protected AbstractLink getEventsLink(String linkid) {
        BookmarkablePageLink approvals = BookmarkablePageLinkBuilder.build(linkid, Approvals.class);
        MetaDataRoleAuthorizationStrategy.authorize(approvals, (Action)WebPage.ENABLE, (String)"WORKFLOW_FORM_LIST");
        return approvals;
    }

    @Override
    protected Icon getIcon(String iconid) {
        return new Icon(iconid, (IconType)FontAwesomeIconTypeBuilder.on((FontAwesomeIconTypeBuilder.FontAwesomeGraphic)FontAwesomeIconTypeBuilder.FontAwesomeGraphic.handshake_o).build());
    }
}

