/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.log.EventCategoryTO;
import org.apache.syncope.common.lib.log.LogAppender;
import org.apache.syncope.common.lib.log.LogStatementTO;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.syncope.common.lib.types.LoggerType;
import org.apache.syncope.common.rest.api.LoggerWrapper;
import org.apache.syncope.common.rest.api.service.LoggerService;

public class LoggerRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 4579786978763032240L;

    public List<String> listMemoryAppenders() {
        return (List)CollectionUtils.collect((Iterable)LoggerRestClient.getService(LoggerService.class).memoryAppenders(), (Transformer)new Transformer<LogAppender, String>(){

            public String transform(LogAppender input) {
                return input.getName();
            }
        }, new ArrayList());
    }

    public List<LogStatementTO> getLastLogStatements(String appender, long lastStatementTime) {
        ArrayList<LogStatementTO> result = new ArrayList<LogStatementTO>();
        for (LogStatementTO statement : LoggerRestClient.getService(LoggerService.class).getLastLogStatements(appender)) {
            if (statement.getTimeMillis() <= lastStatementTime) continue;
            result.add(statement);
        }
        return result;
    }

    public List<LoggerTO> listLogs() {
        List logs = LoggerRestClient.getService(LoggerService.class).list(LoggerType.LOG);
        Collections.sort(logs, ComparatorUtils.transformedComparator((Comparator)ComparatorUtils.naturalComparator(), (Transformer)new Transformer<LoggerTO, String>(){

            public String transform(LoggerTO input) {
                return input.getKey();
            }
        }));
        return logs;
    }

    public List<AuditLoggerName> listAudits() {
        return LoggerWrapper.wrap((Collection)LoggerRestClient.getService(LoggerService.class).list(LoggerType.AUDIT));
    }

    public Map<String, Set<AuditLoggerName>> listAuditsByCategory() {
        HashMap<String, Set<AuditLoggerName>> result = new HashMap<String, Set<AuditLoggerName>>();
        for (AuditLoggerName audit : this.listAudits()) {
            if (!result.containsKey(audit.getCategory())) {
                result.put(audit.getCategory(), new HashSet());
            }
            ((Set)result.get(audit.getCategory())).add(audit);
        }
        return result;
    }

    public void setLogLevel(LoggerTO loggerTO) {
        LoggerRestClient.getService(LoggerService.class).update(LoggerType.LOG, loggerTO);
    }

    public void enableAudit(AuditLoggerName auditLoggerName) {
        LoggerTO loggerTO = new LoggerTO();
        loggerTO.setKey(auditLoggerName.toLoggerName());
        loggerTO.setLevel(LoggerLevel.DEBUG);
        LoggerRestClient.getService(LoggerService.class).update(LoggerType.AUDIT, loggerTO);
    }

    public void deleteLog(String name) {
        LoggerRestClient.getService(LoggerService.class).delete(LoggerType.LOG, name);
    }

    public void disableAudit(AuditLoggerName auditLoggerName) {
        LoggerRestClient.getService(LoggerService.class).delete(LoggerType.AUDIT, auditLoggerName.toLoggerName());
    }

    public List<EventCategoryTO> listEvents() {
        try {
            return LoggerRestClient.getService(LoggerService.class).events();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

