/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractSchemaDetailsPanel;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.ConnIdObjectClassTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class VirSchemaDetails
extends AbstractSchemaDetailsPanel {
    private static final long serialVersionUID = 5979623248182851337L;
    private final ResourceRestClient resourceRestClient = new ResourceRestClient();
    private final ConnectorRestClient connRestClient = new ConnectorRestClient();
    private final Map<String, String> anyTypes = new HashMap<String, String>();
    private final AjaxDropDownChoicePanel<String> anyType;
    private ResourceTO selectedResource;

    public VirSchemaDetails(String id, PageReference pageReference, VirSchemaTO schemaTO) {
        super(id, pageReference, (SchemaTO)schemaTO);
        AjaxCheckBoxPanel readonly = new AjaxCheckBoxPanel("readonly", this.getString("readonly"), (IModel<Boolean>)new PropertyModel((Object)schemaTO, "readonly"));
        this.schemaForm.add(new Component[]{readonly});
        final AjaxDropDownChoicePanel resource = new AjaxDropDownChoicePanel("resource", this.getString("resource"), new PropertyModel((Object)schemaTO, "resource"), false).setNullValid(false);
        resource.setChoices((List)CollectionUtils.collect(this.resourceRestClient.list(), (Transformer)EntityTOUtils.keyTransformer(), new ArrayList()));
        resource.setOutputMarkupId(true);
        resource.addRequiredLabel();
        if (resource.getModelObject() != null) {
            this.populateAnyTypes((String)resource.getModelObject());
        }
        this.schemaForm.add(new Component[]{resource});
        this.anyType = new AjaxDropDownChoicePanel("anyType", this.getString("anyType"), new PropertyModel((Object)schemaTO, "anyType"), false).setNullValid(false);
        this.anyType.setChoices(new ArrayList<String>(this.anyTypes.keySet()));
        this.anyType.setOutputMarkupId(true);
        this.anyType.setOutputMarkupPlaceholderTag(true);
        this.anyType.addRequiredLabel();
        if (resource.getModelObject() == null) {
            this.anyType.setEnabled(false);
        }
        this.schemaForm.add(new Component[]{this.anyType});
        final AjaxTextFieldPanel extAttrName = new AjaxTextFieldPanel("extAttrName", this.getString("extAttrName"), (IModel<String>)new PropertyModel((Object)schemaTO, "extAttrName"));
        extAttrName.setOutputMarkupId(true);
        extAttrName.addRequiredLabel();
        if (this.selectedResource != null) {
            extAttrName.setChoices(this.getExtAttrNames());
        }
        this.schemaForm.add(new Component[]{extAttrName});
        this.add(new Component[]{this.schemaForm});
        resource.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                VirSchemaDetails.this.anyTypes.clear();
                if (resource.getModelObject() != null) {
                    VirSchemaDetails.this.populateAnyTypes((String)resource.getModelObject());
                    VirSchemaDetails.this.anyType.setEnabled(true);
                }
                VirSchemaDetails.this.anyType.setChoices(new ArrayList(VirSchemaDetails.this.anyTypes.keySet()));
                VirSchemaDetails.this.anyType.setModelObject(null);
                target.add(new Component[]{VirSchemaDetails.this.anyType});
            }
        }});
        this.anyType.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (VirSchemaDetails.this.selectedResource != null) {
                    String adminRealm = VirSchemaDetails.this.getAdminRealm(VirSchemaDetails.this.selectedResource.getConnector());
                    if (SyncopeConsoleSession.get().owns("CONNECTOR_READ", adminRealm)) {
                        extAttrName.setChoices(VirSchemaDetails.this.getExtAttrNames());
                        target.add(new Component[]{extAttrName});
                    }
                }
            }
        }});
    }

    private String getAdminRealm(String connectorKey) {
        String adminRealm = null;
        try {
            adminRealm = new ConnectorRestClient().read(connectorKey).getAdminRealm();
        }
        catch (Exception e) {
            LOG.error("Could not read Admin Realm for External Resource {}", (Object)this.selectedResource.getKey());
        }
        return adminRealm;
    }

    private void populateAnyTypes(String resourceKey) {
        this.anyTypes.clear();
        if (resourceKey != null) {
            ResourceTO resource = this.resourceRestClient.read(resourceKey);
            String adminRealm = this.getAdminRealm(resource.getConnector());
            if (SyncopeConsoleSession.get().owns("RESOURCE_READ", adminRealm)) {
                this.selectedResource = resource;
                for (ProvisionTO provisionTO : this.selectedResource.getProvisions()) {
                    this.anyTypes.put(provisionTO.getAnyType(), provisionTO.getObjectClass());
                }
            }
        }
    }

    private List<String> getExtAttrNames() {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setKey(this.selectedResource.getConnector());
        connInstanceTO.getConf().addAll(this.selectedResource.getConfOverride());
        ConnIdObjectClassTO connIdObjectClass = (ConnIdObjectClassTO)IterableUtils.find(this.connRestClient.buildObjectClassInfo(connInstanceTO, false), (Predicate)new Predicate<ConnIdObjectClassTO>(){

            public boolean evaluate(ConnIdObjectClassTO object) {
                return object.getType().equals(VirSchemaDetails.this.anyTypes.get(VirSchemaDetails.this.anyType.getModelObject()));
            }
        });
        return connIdObjectClass == null ? Collections.emptyList() : connIdObjectClass.getAttributes();
    }
}

