/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.TogglePanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public abstract class MembersTogglePanel
extends TogglePanel<Serializable> {
    private static final long serialVersionUID = -3195479265440591519L;
    private GroupTO groupTO;
    protected final Form<?> form;
    protected final Model<String> typeModel = new Model();
    private final LoadableDetachableModel<List<String>> anyTypes = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            List<String> result = new AnyTypeRestClient().list();
            CollectionUtils.filter(result, (Predicate)new Predicate<String>(){

                public boolean evaluate(String anyType) {
                    return !AnyTypeKind.GROUP.name().equals(anyType);
                }
            });
            return result;
        }
    };

    public MembersTogglePanel(final PageReference pageRef) {
        super("outer", "groupMembers", pageRef);
        this.form = new Form("membersForm");
        this.addInnerObject(new Component[]{this.form});
        AbstractFieldPanel type = new AjaxDropDownChoicePanel<String>("type", "type", (IModel<String>)this.typeModel, false).setChoices((IModel<List<String>>)this.anyTypes).setStyleSheet("form-control").setRequired(true);
        type.hideLabel();
        this.form.add(new Component[]{type});
        this.form.add(new Component[]{new AjaxSubmitLink("changeit", this.form){
            private static final long serialVersionUID = -7978723352517770644L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    MembersTogglePanel.this.onApplyInternal(MembersTogglePanel.this.groupTO, (String)((Object)MembersTogglePanel.this.typeModel.getObject()), target);
                    MembersTogglePanel.this.toggle(target, false);
                }
                catch (SyncopeClientException e) {
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                    TogglePanel.LOG.error("While inspecting group memebers of type {}", (Object)MembersTogglePanel.this.typeModel.getObject(), (Object)e);
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }});
    }

    protected abstract Serializable onApplyInternal(GroupTO var1, String var2, AjaxRequestTarget var3);

    public void setTargetObject(GroupTO groupTO) {
        this.groupTO = groupTO;
    }
}

