/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.panels.ConnObjectDetails;
import org.apache.syncope.client.console.panels.ConnObjectListViewPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class ConnObjects
extends Panel
implements ModalPanel {
    private static final long serialVersionUID = -1143512993584984838L;
    private final AjaxDropDownChoicePanel<String> anyTypes;
    private final MultilevelPanel connObjects;

    public ConnObjects(final ResourceTO resource, final PageReference pageRef) {
        super("content");
        List availableAnyTypes = (List)CollectionUtils.collect((Iterable)resource.getProvisions(), (Transformer)new Transformer<ProvisionTO, String>(){

            public String transform(ProvisionTO provision) {
                return provision.getAnyType();
            }
        }, new ArrayList());
        Collections.sort(availableAnyTypes, new AnyTypeRestClient.AnyTypeKeyComparator());
        if (resource.getOrgUnit() != null) {
            availableAnyTypes.add(0, "REALM");
        }
        this.anyTypes = new AjaxDropDownChoicePanel("anyTypes", "anyTypes", new Model());
        this.anyTypes.setChoices(availableAnyTypes);
        this.anyTypes.hideLabel();
        this.anyTypes.setNullValid(false);
        if (availableAnyTypes.contains(AnyTypeKind.USER.name())) {
            this.anyTypes.setDefaultModelObject(AnyTypeKind.USER.name());
        } else if (availableAnyTypes.contains(AnyTypeKind.GROUP.name())) {
            this.anyTypes.setDefaultModelObject(AnyTypeKind.GROUP.name());
        } else if (!availableAnyTypes.isEmpty()) {
            this.anyTypes.setDefaultModelObject(availableAnyTypes.get(0));
        }
        this.add(new Component[]{this.anyTypes});
        this.connObjects = new MultilevelPanel("connObjects"){
            private static final long serialVersionUID = 1473786800290434002L;

            @Override
            public void prev(AjaxRequestTarget target) {
                ConnObjects.this.anyTypes.setEnabled(true);
                target.add(new Component[]{ConnObjects.this.anyTypes});
                super.prev(target);
            }
        };
        this.connObjects.setFirstLevel(new NextableConnObjectDirectoryPanel(this.connObjects, resource.getKey(), (String)this.anyTypes.getField().getModelObject(), pageRef));
        this.connObjects.setOutputMarkupId(true);
        this.add(new Component[]{this.connObjects});
        this.anyTypes.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ConnObjects.this.connObjects.setFirstLevel(new NextableConnObjectDirectoryPanel(ConnObjects.this.connObjects, resource.getKey(), (String)ConnObjects.this.anyTypes.getField().getModelObject(), pageRef));
                target.add(new Component[]{ConnObjects.this.connObjects});
            }
        }});
    }

    private class NextableConnObjectDirectoryPanel
    extends ConnObjectListViewPanel {
        private static final long serialVersionUID = 956427874406567048L;

        NextableConnObjectDirectoryPanel(MultilevelPanel multiLevelPanelRef, String resource, String anyType, PageReference pageRef) {
            super("first", resource, anyType, pageRef);
        }

        @Override
        protected void viewConnObject(ConnObjectTO connObjectTO, AjaxRequestTarget target) {
            ConnObjects.this.anyTypes.setEnabled(false);
            target.add(new Component[]{ConnObjects.this.anyTypes});
            ConnObjects.this.connObjects.next((String)new StringResourceModel("connObject.view", (Component)this, (IModel)new Model((Serializable)connObjectTO)).getObject(), new ConnObjectDetails(connObjectTO), target);
        }
    }
}

