/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.AnyDataProvider;
import org.apache.syncope.client.console.commons.SerializableTransformer;
import org.apache.syncope.client.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.DisplayAttributesModalPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.AttrColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.TokenColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.ResultPage;
import org.apache.syncope.client.console.wizards.any.StatusPanel;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.springframework.util.ReflectionUtils;

public abstract class AnyDirectoryPanel<A extends AnyTO, E extends AbstractAnyRestClient<A>>
extends DirectoryPanel<A, AnyWrapper<A>, AnyDataProvider<A>, E> {
    private static final long serialVersionUID = -1100228004207271270L;
    protected final SchemaRestClient schemaRestClient = new SchemaRestClient();
    protected final List<String> pSchemaNames;
    protected final List<String> dSchemaNames;
    protected String fiql;
    protected final String realm;
    protected final String type;
    protected final BaseModal<Serializable> utilityModal = new BaseModal("outer");

    protected AnyDirectoryPanel(String id, Builder<A, E> builder) {
        this(id, builder, true);
    }

    protected AnyDirectoryPanel(String id, Builder<A, E> builder, boolean wizardInModal) {
        super(id, builder, wizardInModal);
        if (SyncopeConsoleSession.get().owns(String.format("%s_CREATE", builder.type), builder.realm) && builder.realm.startsWith("/")) {
            MetaDataRoleAuthorizationStrategy.authorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        } else {
            MetaDataRoleAuthorizationStrategy.unauthorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        }
        if (builder.dynRealm == null) {
            this.setReadOnly(!SyncopeConsoleSession.get().owns(String.format("%s_UPDATE", builder.type), builder.realm));
        } else {
            this.setReadOnly(!SyncopeConsoleSession.get().owns(String.format("%s_UPDATE", builder.type), builder.dynRealm));
        }
        this.realm = builder.realm;
        this.type = builder.type;
        this.fiql = builder.fiql;
        this.utilityModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.utilityModal});
        this.setWindowClosedReloadCallback(this.utilityModal);
        this.modal.size(Modal.Size.Large);
        this.altDefaultModal.size(Modal.Size.Large);
        this.pSchemaNames = new ArrayList<String>();
        for (AnyTypeClassTO anyTypeClassTO : ((AnyDirectoryPanelBuilder)AnyDirectoryPanelBuilder.class.cast(builder)).getAnyTypeClassTOs()) {
            this.pSchemaNames.addAll(anyTypeClassTO.getPlainSchemas());
        }
        this.dSchemaNames = new ArrayList<String>();
        for (AnyTypeClassTO anyTypeClassTO : ((AnyDirectoryPanelBuilder)AnyDirectoryPanelBuilder.class.cast(builder)).getAnyTypeClassTOs()) {
            this.dSchemaNames.addAll(anyTypeClassTO.getDerSchemas());
        }
        this.initResultTable();
        this.modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                if (AnyDirectoryPanel.this.actionTogglePanel.isVisibleInHierarchy() && AnyDirectoryPanel.this.modal.getContent() instanceof ResultPage) {
                    AnyDirectoryPanel.this.actionTogglePanel.updateHeader(target, (Serializable)((ResultPage)ResultPage.class.cast(AnyDirectoryPanel.this.modal.getContent())).getItem());
                }
                AnyDirectoryPanel.this.modal.show(false);
            }
        });
    }

    @Override
    protected List<IColumn<A, String>> getColumns() {
        ArrayList<IColumn<A, String>> columns = new ArrayList<IColumn<A, String>>();
        ArrayList<IColumn<A, String>> prefcolumns = new ArrayList<IColumn<A, String>>();
        columns.add((IColumn<A, String>)new KeyPropertyColumn((IModel<String>)new ResourceModel("key", "key"), "key"));
        for (String name : this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefDetailView(this.type))) {
            if ("key".equalsIgnoreCase(name)) continue;
            this.addPropertyColumn(name, ReflectionUtils.findField(DisplayAttributesModalPanel.getTOClass(this.type), (String)name), prefcolumns);
        }
        for (String name : this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefPlainAttributeView(this.type))) {
            if (!this.pSchemaNames.contains(name)) continue;
            prefcolumns.add((IColumn<A, String>)new AttrColumn(name, SchemaType.PLAIN));
        }
        for (String name : this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefDerivedAttributeView(this.type))) {
            if (!this.dSchemaNames.contains(name)) continue;
            prefcolumns.add((IColumn<A, String>)new AttrColumn(name, SchemaType.DERIVED));
        }
        if (prefcolumns.isEmpty()) {
            for (String name : this.getDefaultAttributeSelection()) {
                this.addPropertyColumn(name, ReflectionUtils.findField(DisplayAttributesModalPanel.getTOClass(this.type), (String)name), prefcolumns);
            }
            this.prefMan.setList(this.getRequest(), this.getResponse(), DisplayAttributesModalPanel.getPrefDetailView(this.type), Arrays.asList(this.getDefaultAttributeSelection()));
        }
        columns.addAll(prefcolumns);
        return columns;
    }

    protected abstract String[] getDefaultAttributeSelection();

    protected void addPropertyColumn(String name, Field field, List<IColumn<A, String>> columns) {
        if ("key".equalsIgnoreCase(name)) {
            columns.add((IColumn<A, String>)new KeyPropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
        } else if ("token".equalsIgnoreCase(name)) {
            columns.add((IColumn<A, String>)new TokenColumn((IModel<String>)new ResourceModel(name, name), name));
        } else if (field != null && (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE))) {
            columns.add((IColumn<A, String>)new BooleanPropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
        } else if (field != null && field.getType().equals(Date.class)) {
            columns.add((IColumn<A, String>)new DatePropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
        } else {
            columns.add((IColumn<A, String>)new PropertyColumn((IModel)new ResourceModel(name, name), (Object)name, name));
        }
    }

    @Override
    protected AnyDataProvider<A> dataProvider() {
        return new AnyDataProvider((AbstractAnyRestClient)this.restClient, this.rows, this.filtered, this.realm, this.type, this.pageRef).setFIQL(this.fiql);
    }

    public void search(String fiql, AjaxRequestTarget target) {
        this.fiql = fiql;
        ((AnyDataProvider)this.dataProvider).setFIQL(fiql);
        super.search(target);
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        ArrayList<ActionLink.ActionType> bulkActions = new ArrayList<ActionLink.ActionType>();
        bulkActions.add(ActionLink.ActionType.DELETE);
        return bulkActions;
    }

    @Override
    protected Panel customResultBody(String panelId, AnyWrapper<A> item, final Serializable result) {
        if (!(result instanceof ProvisioningResult)) {
            throw new IllegalStateException("Unsupported result type");
        }
        return new StatusPanel(panelId, (AnyTO)((ProvisioningResult)result).getEntity(), (IModel<List<StatusBean>>)new ListModel(new ArrayList()), (List)CollectionUtils.collect((Iterable)((ProvisioningResult)result).getPropagationStatuses(), (Transformer)new SerializableTransformer<PropagationStatus, Triple<ConnObjectTO, ConnObjectWrapper, String>>(){
            private static final long serialVersionUID = -4931455531906427515L;

            public Triple<ConnObjectTO, ConnObjectWrapper, String> transform(PropagationStatus status) {
                ConnObjectTO before = status.getBeforeObj();
                ConnObjectWrapper afterObjWrapper = new ConnObjectWrapper((AnyTO)((ProvisioningResult)result).getEntity(), status.getResource(), status.getAfterObj());
                return Triple.of((Object)before, (Object)afterObjWrapper, (Object)status.getFailureReason());
            }
        }, new ArrayList()), this.pageRef);
    }

    public static abstract class Builder<A extends AnyTO, E extends AbstractAnyRestClient<A>>
    extends DirectoryPanel.Builder<A, AnyWrapper<A>, E>
    implements AnyDirectoryPanelBuilder {
        private static final long serialVersionUID = -6828423611982275640L;
        protected String realm = "/";
        protected String dynRealm = null;
        protected final String type;
        private final List<AnyTypeClassTO> anyTypeClassTOs;

        public Builder(List<AnyTypeClassTO> anyTypeClassTOs, E restClient, String type, PageReference pageRef) {
            super(restClient, pageRef);
            this.anyTypeClassTOs = anyTypeClassTOs;
            this.type = type;
        }

        public Builder<A, E> setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder<A, E> setDynRealm(String dynRealm) {
            this.dynRealm = dynRealm;
            return this;
        }

        @Override
        public List<AnyTypeClassTO> getAnyTypeClassTOs() {
            return this.anyTypeClassTOs;
        }
    }

    public static interface AnyDirectoryPanelBuilder
    extends Serializable {
        public List<AnyTypeClassTO> getAnyTypeClassTOs();
    }
}

