/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.init;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.client.console.annotations.BinaryPreview;
import org.apache.syncope.client.console.annotations.ExtPage;
import org.apache.syncope.client.console.annotations.ExtWidget;
import org.apache.syncope.client.console.pages.BaseExtPage;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.SSOLoginFormPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.preview.AbstractBinaryPreviewer;
import org.apache.syncope.client.console.widgets.BaseExtWidget;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClassPathScanImplementationLookup {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathScanImplementationLookup.class);
    private static final String DEFAULT_BASE_PACKAGE = "org.apache.syncope.client.console";
    public static final Set<String> USER_FIELD_NAMES = new HashSet<String>();
    public static final Set<String> GROUP_FIELD_NAMES = new HashSet<String>();
    public static final Set<String> ANY_OBJECT_FIELD_NAMES = new HashSet<String>();
    private List<Class<? extends BasePage>> pages;
    private List<Class<? extends AbstractBinaryPreviewer>> previewers;
    private List<Class<? extends BaseExtPage>> extPages;
    private List<Class<? extends BaseExtWidget>> extWidgets;
    private List<Class<? extends SSOLoginFormPanel>> ssoLoginFormPanels;

    private static void initFieldNames(Class<?> entityClass, Set<String> keys) {
        List classes = org.apache.commons.lang3.ClassUtils.getAllSuperclasses(entityClass);
        classes.add(entityClass);
        for (Class clazz : classes) {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) continue;
                keys.add(field.getName());
            }
        }
    }

    protected String getBasePackage() {
        return DEFAULT_BASE_PACKAGE;
    }

    public void load() {
        this.pages = new ArrayList<Class<? extends BasePage>>();
        this.previewers = new ArrayList<Class<? extends AbstractBinaryPreviewer>>();
        this.extPages = new ArrayList<Class<? extends BaseExtPage>>();
        this.extWidgets = new ArrayList<Class<? extends BaseExtWidget>>();
        this.ssoLoginFormPanels = new ArrayList<Class<? extends SSOLoginFormPanel>>();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BasePage.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractBinaryPreviewer.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BaseExtPage.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BaseExtWidget.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(SSOLoginFormPanel.class));
        for (BeanDefinition bd : scanner.findCandidateComponents(this.getBasePackage())) {
            try {
                Class clazz = ClassUtils.resolveClassName((String)bd.getBeanClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                boolean isAbsractClazz = Modifier.isAbstract(clazz.getModifiers());
                if (isAbsractClazz) continue;
                if (BaseExtPage.class.isAssignableFrom(clazz)) {
                    if (clazz.isAnnotationPresent(ExtPage.class)) {
                        this.extPages.add(clazz);
                        continue;
                    }
                    LOG.error("Could not find annotation {} in {}, ignoring", (Object)ExtPage.class.getName(), (Object)clazz.getName());
                    continue;
                }
                if (BaseExtWidget.class.isAssignableFrom(clazz)) {
                    if (clazz.isAnnotationPresent(ExtWidget.class)) {
                        this.extWidgets.add(clazz);
                        continue;
                    }
                    LOG.error("Could not find annotation {} in {}, ignoring", (Object)ExtWidget.class.getName(), (Object)clazz.getName());
                    continue;
                }
                if (BasePage.class.isAssignableFrom(clazz)) {
                    this.pages.add(clazz);
                    continue;
                }
                if (AbstractBinaryPreviewer.class.isAssignableFrom(clazz)) {
                    this.previewers.add(clazz);
                    continue;
                }
                if (!SSOLoginFormPanel.class.isAssignableFrom(clazz)) continue;
                this.ssoLoginFormPanels.add(clazz);
            }
            catch (Throwable t) {
                LOG.warn("Could not inspect class {}", (Object)bd.getBeanClassName(), (Object)t);
            }
        }
        this.pages = Collections.unmodifiableList(this.pages);
        this.previewers = Collections.unmodifiableList(this.previewers);
        Collections.sort(this.extPages, new Comparator<Class<? extends BaseExtPage>>(){

            @Override
            public int compare(Class<? extends BaseExtPage> o1, Class<? extends BaseExtPage> o2) {
                return ComparatorUtils.naturalComparator().compare(o1.getAnnotation(ExtPage.class).priority(), o2.getAnnotation(ExtPage.class).priority());
            }
        });
        this.extPages = Collections.unmodifiableList(this.extPages);
        Collections.sort(this.extWidgets, new Comparator<Class<? extends BaseExtWidget>>(){

            @Override
            public int compare(Class<? extends BaseExtWidget> o1, Class<? extends BaseExtWidget> o2) {
                return ComparatorUtils.naturalComparator().compare(o1.getAnnotation(ExtWidget.class).priority(), o2.getAnnotation(ExtWidget.class).priority());
            }
        });
        this.extWidgets = Collections.unmodifiableList(this.extWidgets);
        this.ssoLoginFormPanels = Collections.unmodifiableList(this.ssoLoginFormPanels);
        LOG.debug("Binary previewers found: {}", this.previewers);
        LOG.debug("Extension pages found: {}", this.extPages);
        LOG.debug("Extension widgets found: {}", this.extWidgets);
        LOG.debug("SSO Login pages found: {}", this.ssoLoginFormPanels);
    }

    public Class<? extends AbstractBinaryPreviewer> getPreviewerClass(String mimeType) {
        LOG.debug("Searching for previewer class for MIME type: {}", (Object)mimeType);
        Class<? extends AbstractBinaryPreviewer> previewer = null;
        for (Class<? extends AbstractBinaryPreviewer> candidate : this.previewers) {
            LOG.debug("Evaluating previewer class {} for MIME type {}", (Object)candidate.getName(), (Object)mimeType);
            if (!candidate.isAnnotationPresent(BinaryPreview.class) || !ArrayUtils.contains((Object[])candidate.getAnnotation(BinaryPreview.class).mimeTypes(), (Object)mimeType)) continue;
            LOG.debug("Found existing previewer for MIME type {}: {}", (Object)mimeType, (Object)candidate.getName());
            previewer = candidate;
        }
        return previewer;
    }

    public List<Class<? extends BasePage>> getPageClasses() {
        return this.pages;
    }

    public List<Class<? extends AbstractBinaryPreviewer>> getPreviewerClasses() {
        return this.previewers;
    }

    public List<Class<? extends BaseExtPage>> getExtPageClasses() {
        return this.extPages;
    }

    public List<Class<? extends BaseExtWidget>> getExtWidgetClasses() {
        return this.extWidgets;
    }

    public List<Class<? extends SSOLoginFormPanel>> getSSOLoginFormPanels() {
        return this.ssoLoginFormPanels;
    }

    static {
        ClassPathScanImplementationLookup.initFieldNames(UserTO.class, USER_FIELD_NAMES);
        ClassPathScanImplementationLookup.initFieldNames(GroupTO.class, GROUP_FIELD_NAMES);
        ClassPathScanImplementationLookup.initFieldNames(AnyObjectTO.class, ANY_OBJECT_FIELD_NAMES);
    }
}

