/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.commons.status.Status;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.panels.LabelPanel;
import org.apache.syncope.client.console.rest.ReconciliationRestClient;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatusUtils
implements Serializable {
    private static final long serialVersionUID = 7238009174387184309L;
    private static final Logger LOG = LoggerFactory.getLogger(StatusUtils.class);
    private static final ReconciliationRestClient RECONCILIATION_REST_CLIENT = new ReconciliationRestClient();

    public static List<Pair<String, ReconStatus>> getReconStatuses(final AnyTypeKind anyTypeKind, final String anyKey, Collection<String> resources) {
        List result = (List)CollectionUtils.collect(resources, (Transformer)new Transformer<String, Pair<String, ReconStatus>>(){

            public Pair<String, ReconStatus> transform(String resource) {
                try {
                    return Pair.of((Object)resource, (Object)RECONCILIATION_REST_CLIENT.status(anyTypeKind, anyKey, resource));
                }
                catch (Exception e) {
                    LOG.warn("Unexpected error for {} {} on {}", new Object[]{anyTypeKind, anyKey, resource, e});
                    return null;
                }
            }
        }, new ArrayList());
        CollectionUtils.filter((Iterable)result, (Predicate)PredicateUtils.notNullPredicate());
        return result;
    }

    public static StatusBean getStatusBean(AnyTO anyTO, String resource, ConnObjectTO connObjectTO, boolean notUser) {
        StatusBean statusBean = new StatusBean(anyTO, resource);
        if (connObjectTO != null) {
            Boolean enabled = StatusUtils.isEnabled(connObjectTO);
            statusBean.setStatus(enabled == null ? (notUser ? Status.ACTIVE : Status.UNDEFINED) : (enabled != false ? Status.ACTIVE : Status.SUSPENDED));
            statusBean.setConnObjectLink(StatusUtils.getConnObjectLink(connObjectTO));
        }
        return statusBean;
    }

    private static Boolean isEnabled(ConnObjectTO objectTO) {
        AttrTO status = objectTO.getAttr("__ENABLE__");
        return status != null && status.getValues() != null && !status.getValues().isEmpty() ? Boolean.valueOf((String)status.getValues().get(0)) : Boolean.FALSE;
    }

    private static String getConnObjectLink(ConnObjectTO objectTO) {
        AttrTO name = objectTO == null ? null : objectTO.getAttr("__NAME__");
        return name != null && name.getValues() != null && !name.getValues().isEmpty() ? (String)name.getValues().get(0) : null;
    }

    public static PasswordPatch buildPasswordPatch(String password, Collection<StatusBean> statuses) {
        PasswordPatch.Builder builder = new PasswordPatch.Builder();
        builder.value((Object)password);
        for (StatusBean status : statuses) {
            if ("syncope".equalsIgnoreCase(status.getResource())) {
                builder.onSyncope(true);
                continue;
            }
            builder.resource(status.getResource());
        }
        return (PasswordPatch)builder.build();
    }

    public static StatusPatch buildStatusPatch(Collection<StatusBean> statuses) {
        return StatusUtils.buildStatusPatch(statuses, null);
    }

    public static StatusPatch buildStatusPatch(Collection<StatusBean> statuses, Boolean enable) {
        StatusPatch.Builder builder = new StatusPatch.Builder();
        builder.onSyncope(false);
        for (StatusBean status : statuses) {
            if ("syncope".equalsIgnoreCase(status.getResource())) {
                builder.onSyncope(true);
                continue;
            }
            builder.resource(status.getResource());
        }
        return builder.build();
    }

    public static Panel getStatusImagePanel(String componentId, Status status) {
        return new LabelPanel(componentId, StatusUtils.getStatusImage("label", status));
    }

    public static Label getStatusImage(String componentId, Status status) {
        String clazz;
        String title;
        String alt;
        switch (status) {
            case NOT_YET_SUBMITTED: {
                alt = "undefined icon";
                title = "Not yet submitted";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case ACTIVE: {
                alt = "active icon";
                title = "Enabled";
                clazz = "glyphicon glyphicon-ok-circle";
                break;
            }
            case UNDEFINED: {
                alt = "undefined icon";
                title = "Undefined status";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case OBJECT_NOT_FOUND: {
                alt = "notfound icon";
                title = "Not found";
                clazz = "glyphicon glyphicon-remove-circle";
                break;
            }
            case CREATED: {
                alt = "created icon";
                title = "Created";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case SUSPENDED: {
                alt = "inactive icon";
                title = "Disabled";
                clazz = "glyphicon glyphicon-ban-circle";
                break;
            }
            default: {
                alt = "";
                title = "";
                clazz = "";
            }
        }
        return StatusUtils.getLabel(componentId, alt, title, clazz);
    }

    public static Panel getStatusImagePanel(String componentId, PropagationTaskExecStatus status) {
        return new LabelPanel(componentId, StatusUtils.getStatusImage("label", status));
    }

    public static Label getStatusImage(String componentId, PropagationTaskExecStatus status) {
        String clazz;
        String title;
        String alt;
        switch (status) {
            case NOT_ATTEMPTED: {
                alt = "not attempted";
                title = "Not attempted";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case CREATED: {
                alt = "created icon";
                title = "Created";
                clazz = "glyphicon glyphicon-ok-circle";
                break;
            }
            case SUCCESS: {
                alt = "success icon";
                title = "Propagation succeded";
                clazz = "glyphicon glyphicon-ok-circle";
                break;
            }
            case FAILURE: {
                alt = "failure icon";
                title = "Propagation failed";
                clazz = "glyphicon glyphicon-remove-circle";
                break;
            }
            default: {
                alt = "";
                title = "";
                clazz = "";
            }
        }
        return StatusUtils.getLabel(componentId, alt, title, clazz);
    }

    private static Label getLabel(String componentId, final String alt, final String title, final String clazz) {
        return new Label(componentId, (Serializable)((Object)"")){
            private static final long serialVersionUID = 4755868673082976208L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("alt", (CharSequence)alt);
                tag.put("title", (CharSequence)title);
                tag.put("class", (CharSequence)clazz);
            }
        };
    }

    private StatusUtils() {
    }
}

