/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.list.SetUniqueList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class SyncopeConsoleSession
extends AuthenticatedWebSession {
    private static final long serialVersionUID = 747562246415852166L;
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeConsoleSession.class);
    private final SyncopeClientFactoryBean clientFactory;
    private final SyncopeClient anonymousClient;
    private final PlatformInfo platformInfo;
    private final SystemInfo systemInfo;
    private final Map<Class<?>, Object> services = Collections.synchronizedMap(new HashMap());
    private final ThreadPoolTaskExecutor executor;
    private String domain;
    private SyncopeClient client;
    private UserTO selfTO;
    private Map<String, Set<String>> auth;
    private Roles roles;

    public static SyncopeConsoleSession get() {
        return (SyncopeConsoleSession)Session.get();
    }

    public SyncopeConsoleSession(Request request) {
        super(request);
        this.clientFactory = SyncopeConsoleApplication.get().newClientFactory();
        this.anonymousClient = this.clientFactory.create((AuthenticationHandler)new AnonymousAuthenticationHandler(SyncopeConsoleApplication.get().getAnonymousUser(), SyncopeConsoleApplication.get().getAnonymousKey()));
        this.platformInfo = ((SyncopeService)this.anonymousClient.getService(SyncopeService.class)).platform();
        this.systemInfo = ((SyncopeService)this.anonymousClient.getService(SyncopeService.class)).system();
        this.executor = new ThreadPoolTaskExecutor();
        this.executor.setWaitForTasksToCompleteOnShutdown(false);
        this.executor.setCorePoolSize(SyncopeConsoleApplication.get().getCorePoolSize().intValue());
        this.executor.setMaxPoolSize(SyncopeConsoleApplication.get().getMaxPoolSize().intValue());
        this.executor.setQueueCapacity(SyncopeConsoleApplication.get().getQueueCapacity().intValue());
        this.executor.initialize();
    }

    public MediaType getMediaType() {
        return this.clientFactory.getContentType().getMediaType();
    }

    public SyncopeClient getAnonymousClient() {
        return this.anonymousClient;
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public <T> Future<T> execute(Callable<T> command) {
        return this.executor.submit(command);
    }

    public PlatformInfo getPlatformInfo() {
        return this.platformInfo;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return StringUtils.isBlank((CharSequence)this.domain) ? "Master" : this.domain;
    }

    public String getJWT() {
        return this.client == null ? null : this.client.getJWT();
    }

    public boolean authenticate(String username, String password) {
        boolean authenticated = false;
        try {
            this.client = this.clientFactory.setDomain(this.getDomain()).create(username, password);
            this.refreshAuth(username);
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        return authenticated;
    }

    public boolean authenticate(String jwt) {
        boolean authenticated = false;
        try {
            this.client = this.clientFactory.setDomain(this.getDomain()).create(jwt);
            this.refreshAuth(null);
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        if (authenticated) {
            this.bind();
        }
        this.signIn(authenticated);
        return authenticated;
    }

    public void cleanup() {
        this.client = null;
        this.auth = null;
        this.selfTO = null;
        this.services.clear();
    }

    public void invalidate() {
        if (this.getJWT() != null) {
            if (this.client != null) {
                this.client.logout();
            }
            this.cleanup();
        }
        this.executor.shutdown();
        super.invalidate();
    }

    public UserTO getSelfTO() {
        return this.selfTO;
    }

    public List<String> getAuthRealms() {
        ArrayList<String> sortable = new ArrayList<String>();
        SetUniqueList available = SetUniqueList.setUniqueList(sortable);
        for (Map.Entry<String, Set<String>> entitlement : this.auth.entrySet()) {
            available.addAll((Collection)entitlement.getValue());
        }
        Collections.sort(sortable);
        return sortable;
    }

    public boolean owns(String entitlements, String ... realms) {
        if (StringUtils.isEmpty((CharSequence)entitlements)) {
            return true;
        }
        if (this.auth == null) {
            return false;
        }
        HashSet<String> requested = ArrayUtils.isEmpty((Object[])realms) ? Collections.singleton("/") : new HashSet<String>(Arrays.asList(realms));
        for (String entitlement : entitlements.split(",")) {
            if (!this.auth.containsKey(entitlement)) continue;
            boolean owns = false;
            Set<String> owned = this.auth.get(entitlement);
            for (final String realm : requested) {
                if (realm.startsWith("/")) {
                    owns |= IterableUtils.matchesAny(owned, (Predicate)new Predicate<String>(){

                        public boolean evaluate(String ownedRealm) {
                            return realm.startsWith(ownedRealm);
                        }
                    });
                    continue;
                }
                owns |= owned.contains(realm);
            }
            return owns;
        }
        return false;
    }

    public Roles getRoles() {
        if (this.isSignedIn() && this.roles == null && this.auth != null) {
            this.roles = new Roles(this.auth.keySet().toArray(new String[0]));
            this.roles.add((Object)"AUTHENTICATED");
        }
        return this.roles;
    }

    public void refreshAuth(String username) {
        try {
            Pair self = this.client.self();
            this.auth = (Map)self.getLeft();
            this.selfTO = (UserTO)self.getRight();
            this.roles = null;
        }
        catch (ForbiddenException e) {
            LOG.warn("Could not read self(), probably in a {} scenario", (Object)"MUST_CHANGE_PASSWORD", (Object)e);
            this.selfTO = new UserTO();
            this.selfTO.setUsername(username);
            this.selfTO.setMustChangePassword(true);
        }
    }

    private <T> T getCachedService(Class<T> serviceClass) {
        Object service;
        if (this.services.containsKey(serviceClass)) {
            service = this.services.get(serviceClass);
        } else {
            service = this.client.getService(serviceClass);
            this.services.put(serviceClass, service);
        }
        WebClient.client((Object)service).type("application/json").accept(new String[]{"application/json"});
        return (T)service;
    }

    public <T> T getService(Class<T> serviceClass) {
        return this.getCachedService(serviceClass);
    }

    public <T> T getService(String etag, Class<T> serviceClass) {
        T serviceInstance = this.getCachedService(serviceClass);
        WebClient.client(serviceInstance).match(new EntityTag(etag), false);
        return serviceInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(MediaType mediaType, Class<T> serviceClass) {
        Object service;
        SyncopeClientFactoryBean syncopeClientFactoryBean = this.clientFactory;
        synchronized (syncopeClientFactoryBean) {
            SyncopeClientFactoryBean.ContentType preType = this.clientFactory.getContentType();
            this.clientFactory.setContentType(SyncopeClientFactoryBean.ContentType.fromString((String)mediaType.toString()));
            service = this.clientFactory.create(this.getJWT()).getService(serviceClass);
            this.clientFactory.setContentType(preType);
        }
        return (T)service;
    }

    public <T> void resetClient(Class<T> service) {
        T serviceInstance = this.getCachedService(service);
        WebClient.client(serviceInstance).reset();
    }

    public FastDateFormat getDateFormat() {
        Locale locale = this.getLocale() == null ? Locale.ENGLISH : this.getLocale();
        return FastDateFormat.getDateTimeInstance((int)3, (int)3, (Locale)locale);
    }
}

