/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.repeater.dataview;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.jquery.core.renderer.JsonRenderer;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.kendo.ui.KendoBehaviorFactory;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.datatable.behavior.DataBoundBehavior;
import com.googlecode.wicket.kendo.ui.repeater.DataProviderBehavior;
import com.googlecode.wicket.kendo.ui.repeater.listview.IListViewListener;
import com.googlecode.wicket.kendo.ui.repeater.listview.ListViewBehavior;
import com.googlecode.wicket.kendo.ui.template.KendoTemplateBehavior;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.data.IDataProvider;

public class DataView<T>
extends WebMarkupContainer
implements IJQueryWidget,
IListViewListener {
    private static final long serialVersionUID = 1L;
    private static final long ROWS = 127L;
    private final IDataProvider<T> provider;
    private AbstractAjaxBehavior providerBehavior;
    private final ITextRenderer<? super T> renderer;
    private KendoTemplateBehavior templateBehavior = null;
    protected final Options options;

    public DataView(String id, IDataProvider<T> provider) {
        this(id, provider, (ITextRenderer<T>)new JsonRenderer(), new Options());
    }

    public DataView(String id, IDataProvider<T> provider, Options options) {
        this(id, provider, (ITextRenderer<T>)new JsonRenderer(), options);
    }

    public DataView(String id, IDataProvider<T> provider, ITextRenderer<? super T> renderer) {
        this(id, provider, renderer, new Options());
    }

    public DataView(String id, IDataProvider<T> provider, ITextRenderer<? super T> renderer, Options options) {
        super(id);
        this.options = options;
        this.provider = provider;
        this.renderer = renderer;
    }

    public String widget() {
        return KendoUIBehavior.widget((Component)this, "kendoListView");
    }

    public final void show(IPartialPageRequestHandler handler) {
        this.onShow(handler);
        KendoBehaviorFactory.show(handler, (Component)this);
    }

    public final void hide(IPartialPageRequestHandler handler) {
        KendoBehaviorFactory.hide(handler, (Component)this);
        this.onHide(handler);
    }

    public void reload(IPartialPageRequestHandler handler) {
        handler.add(new Component[]{this});
    }

    public void refresh(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("var $w = %s; if ($w) { $w.dataSource.read(); }", this.widget()));
    }

    public IDataProvider<T> getDataProvider() {
        return this.provider;
    }

    protected long getRowCount() {
        return 127L;
    }

    protected final CharSequence getCallbackUrl() {
        return this.providerBehavior.getCallbackUrl();
    }

    public String getTemplateToken() {
        if (this.templateBehavior != null) {
            return this.templateBehavior.getToken();
        }
        return null;
    }

    @Override
    public boolean isSelectable() {
        return this.options.get("selectable") != null;
    }

    protected void onInitialize() {
        super.onInitialize();
        IJQueryTemplate template = this.newTemplate();
        this.providerBehavior = this.newDataProviderBehavior(this.getDataProvider(), this.renderer, template);
        this.add(new Behavior[]{this.providerBehavior});
        if (template != null) {
            this.templateBehavior = new KendoTemplateBehavior(template);
            this.add(new Behavior[]{this.templateBehavior});
        }
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("autoBind", (Object)this.getBehaviors(DataBoundBehavior.class).isEmpty());
        if (this.templateBehavior != null) {
            behavior.setOption("template", (Object)String.format("jQuery('#%s').html()", this.getTemplateToken()));
        }
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public void onShow(IPartialPageRequestHandler handler) {
    }

    public void onHide(IPartialPageRequestHandler handler) {
    }

    @Override
    public void onCreate(AjaxRequestTarget target, JSONObject object) {
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, JSONObject object) {
    }

    @Override
    public void onDelete(AjaxRequestTarget target, JSONObject object) {
    }

    @Override
    public void onChange(AjaxRequestTarget target, List<JSONObject> objects) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new ListViewBehavior(selector, this.newDataSource(), this, this.options){
            private static final long serialVersionUID = 1L;

            @Override
            protected long getRowCount() {
                return DataView.this.getRowCount();
            }

            @Override
            protected CharSequence getProviderUrl() {
                return DataView.this.getCallbackUrl();
            }

            @Override
            protected void onConfigure(KendoDataSource dataSource) {
                DataView.this.onConfigure(dataSource);
            }
        };
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }

    protected KendoDataSource newDataSource() {
        return new KendoDataSource((Component)this);
    }

    protected AbstractAjaxBehavior newDataProviderBehavior(IDataProvider<T> provider, ITextRenderer<? super T> renderer, IJQueryTemplate template) {
        return new DataProviderBehavior<T>(provider, renderer, template);
    }
}

