/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer.xml;

import java.lang.reflect.Array;
import java.util.Stack;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.Base64;
import org.identityconnectors.common.XmlUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.serializer.ObjectEncoder;
import org.identityconnectors.framework.impl.serializer.ObjectSerializationHandler;
import org.identityconnectors.framework.impl.serializer.ObjectSerializerRegistry;
import org.identityconnectors.framework.impl.serializer.ObjectTypeMapper;

public class XmlObjectEncoder
implements ObjectEncoder {
    private Stack<OutputElement> outputStack = new Stack();
    private StringBuilder rootBuilder;

    public XmlObjectEncoder(StringBuilder builder) {
        Assertions.nullCheck((Object)builder, (String)"builder");
        this.rootBuilder = builder;
    }

    public String writeObject(Object o) {
        return this.writeObjectInternal(o, false);
    }

    @Override
    public void writeBooleanContents(boolean v) {
        this.writeStringContentsInternal(XmlObjectEncoder.encodeBoolean(v));
    }

    @Override
    public void writeBooleanField(String fieldName, boolean v) {
        this.writeAttributeInternal(fieldName, XmlObjectEncoder.encodeBoolean(v));
    }

    @Override
    public void writeByteContents(byte v) {
        this.writeStringContentsInternal(XmlObjectEncoder.encodeByte(v));
    }

    @Override
    public void writeByteArrayContents(byte[] v) {
        this.writeStringContentsInternal(XmlObjectEncoder.encodeByteArray(v));
    }

    @Override
    public void writeClassContents(Class<?> v) {
        this.writeStringContentsInternal(XmlObjectEncoder.encodeClass(v));
    }

    @Override
    public void writeClassField(String name, Class<?> v) {
        if (v != null) {
            this.writeAttributeInternal(name, XmlObjectEncoder.encodeClass(v));
        }
    }

    @Override
    public void writeDoubleContents(double v) {
        this.writeStringContentsInternal(XmlObjectEncoder.encodeDouble(v));
    }

    @Override
    public void writeDoubleField(String fieldName, double v) {
        this.writeAttributeInternal(fieldName, XmlObjectEncoder.encodeDouble(v));
    }

    @Override
    public void writeFloatContents(float v) {
        this.writeStringContentsInternal(XmlObjectEncoder.encodeFloat(v));
    }

    @Override
    public void writeFloatField(String fieldName, float v) {
        this.writeAttributeInternal(fieldName, XmlObjectEncoder.encodeFloat(v));
    }

    @Override
    public void writeIntContents(int v) {
        this.writeStringContentsInternal(XmlObjectEncoder.encodeInt(v));
    }

    @Override
    public void writeIntField(String fieldName, int v) {
        this.writeAttributeInternal(fieldName, XmlObjectEncoder.encodeInt(v));
    }

    @Override
    public void writeLongContents(long v) {
        this.writeStringContentsInternal(XmlObjectEncoder.encodeLong(v));
    }

    @Override
    public void writeLongField(String fieldName, long v) {
        this.writeAttributeInternal(fieldName, XmlObjectEncoder.encodeLong(v));
    }

    @Override
    public void writeObjectContents(Object o) {
        if (this.outputStack.size() == 0) {
            throw new IllegalStateException("May not write contents on top-level object");
        }
        this.writeObjectInternal(o, false);
    }

    @Override
    public void writeObjectField(String fieldName, Object object, boolean inline) {
        if (this.outputStack.size() == 0) {
            throw new IllegalStateException("May not write field on top-level object");
        }
        if (inline && object == null) {
            return;
        }
        this.beginElement(fieldName);
        this.writeObjectInternal(object, inline);
        this.endElement();
    }

    @Override
    public void writeStringContents(String str) {
        this.writeStringContentsInternal(str);
    }

    @Override
    public void writeStringField(String fieldName, String str) {
        if (str != null) {
            this.writeAttributeInternal(fieldName, str);
        }
    }

    static String encodeBoolean(boolean b) {
        return String.valueOf(b);
    }

    static String encodeByte(byte singleByte) {
        return Byte.toString(singleByte);
    }

    private static String encodeByteArray(byte[] bytes) {
        return Base64.encode((byte[])bytes);
    }

    private static String encodeClass(Class<?> clazz) {
        ObjectSerializationHandler handler = ObjectSerializerRegistry.getHandlerByObjectType(clazz);
        ObjectTypeMapper mapper = ObjectSerializerRegistry.getMapperByObjectType(clazz);
        if (handler == null && clazz.isArray()) {
            return XmlObjectEncoder.encodeClass(clazz.getComponentType()) + "[]";
        }
        if (mapper == null) {
            throw new ConnectorException("No serializer for class: " + clazz);
        }
        String typeName = mapper.getHandledSerialType();
        return typeName;
    }

    static String encodeDouble(double d) {
        return String.valueOf(d);
    }

    static String encodeFloat(float d) {
        return String.valueOf(d);
    }

    static String encodeInt(int d) {
        return String.valueOf(d);
    }

    static String encodeLong(long d) {
        return String.valueOf(d);
    }

    String writeObjectInternal(Object object, boolean inline) {
        if (object == null) {
            if (inline) {
                throw new IllegalArgumentException("null cannot be inlined");
            }
            this.beginElement("null");
            this.endElement();
            return "null";
        }
        Class<?> clazz = object.getClass();
        ObjectSerializationHandler handler = ObjectSerializerRegistry.getHandlerByObjectType(clazz);
        if (handler == null) {
            if (clazz.isArray()) {
                if (!inline) {
                    String componentTypeName = XmlObjectEncoder.encodeClass(clazz.getComponentType());
                    this.beginElement("Array");
                    this.writeAttributeInternal("componentType", componentTypeName);
                }
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    Object val = Array.get(object, i);
                    this.writeObjectInternal(val, false);
                }
                if (!inline) {
                    this.endElement();
                }
                return "Array";
            }
            throw new ConnectorException("No serializer for class: " + clazz);
        }
        String typeName = XmlObjectEncoder.encodeClass(clazz);
        if (!inline) {
            this.beginElement(typeName);
        }
        handler.serialize(object, this);
        if (!inline) {
            this.endElement();
        }
        return typeName;
    }

    private OutputElement getCurrentElement() {
        if (this.outputStack.size() == 0) {
            return null;
        }
        return this.outputStack.peek();
    }

    private StringBuilder getCurrentBuilder() {
        if (this.outputStack.size() == 0) {
            return this.rootBuilder;
        }
        return this.getCurrentElement().contents;
    }

    private StringBuilder getPreviousBuilder() {
        if (this.outputStack.size() == 0) {
            return null;
        }
        if (this.outputStack.size() == 1) {
            return this.rootBuilder;
        }
        return ((OutputElement)this.outputStack.get(this.outputStack.size() - 2)).contents;
    }

    private void beginElement(String name) {
        this.indent(this.getCurrentBuilder(), this.outputStack.size());
        OutputElement current = this.getCurrentElement();
        if (current != null) {
            current.elementData = true;
        }
        this.getCurrentBuilder().append("<" + name);
        this.outputStack.push(new OutputElement(name));
    }

    private void endElement() {
        OutputElement endedElement = this.outputStack.pop();
        String contents = endedElement.contents.toString();
        StringBuilder currentBuilder = this.getCurrentBuilder();
        if (contents.length() == 0) {
            currentBuilder.append("/>\n");
        } else {
            currentBuilder.append(">");
            if (endedElement.elementData) {
                currentBuilder.append("\n");
            }
            this.getCurrentBuilder().append(contents);
            if (endedElement.elementData) {
                this.indent(currentBuilder, this.outputStack.size());
            }
            currentBuilder.append("</").append(endedElement.name).append(">\n");
        }
    }

    private void writeAttributeInternal(String fieldName, String str) {
        StringBuilder previousBuilder = this.getPreviousBuilder();
        previousBuilder.append(" ").append(fieldName).append("='");
        XmlUtil.escape((StringBuilder)previousBuilder, (String)str, (char)'\'');
        previousBuilder.append("'");
    }

    private void writeStringContentsInternal(String str) {
        StringBuilder builder = this.getCurrentBuilder();
        XmlUtil.escape((StringBuilder)builder, (String)str, (char)'\u0000');
    }

    private void indent(StringBuilder builder, int level) {
        for (int i = 0; i < level * 2; ++i) {
            builder.append(" ");
        }
    }

    private static class OutputElement {
        private final String name;
        private final StringBuilder contents = new StringBuilder();
        private boolean elementData = false;

        public OutputElement(String name) {
            this.name = name;
        }
    }
}

