/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.operations.UpdateDeltaApiOp;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.GetImpl;
import org.identityconnectors.framework.impl.api.local.operations.ObjectNormalizerFacade;
import org.identityconnectors.framework.impl.api.local.operations.SearchImpl;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;
import org.identityconnectors.framework.spi.operations.UpdateDeltaOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

public class UpdateDeltaImpl
extends ConnectorAPIOperationRunner
implements UpdateDeltaApiOp {
    private static final Log OP_LOG = Log.getLog(UpdateDeltaOp.class);
    static final Set<String> OPERATIONAL_ATTRIBUTE_NAMES = new HashSet<String>();
    private static final String OPERATIONAL_ATTRIBUTE_ERR = "Operational attribute '%s' can not be added or removed.";

    public UpdateDeltaImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public Set<AttributeDelta> updateDelta(ObjectClass objclass, Uid uid, Set<AttributeDelta> modifications, OperationOptions options) {
        Uid ret;
        UpdateOp op;
        Assertions.nullCheck((Object)uid, (String)"uid");
        Assertions.nullCheck((Object)objclass, (String)"objectClass");
        if (ObjectClass.ALL.equals((Object)objclass)) {
            throw new UnsupportedOperationException("Operation is not allowed on __ALL__ object class");
        }
        Assertions.nullCheck(modifications, (String)"modifications");
        for (AttributeDelta attrDelta : modifications) {
            if (!attrDelta.is(Uid.NAME)) continue;
            throw new InvalidAttributeValueException("Parameter 'modifications' contains a uid.");
        }
        for (AttributeDelta attrDelta : modifications) {
            String name;
            Assertions.nullCheck((Object)attrDelta, (String)"attrDelta from modifications");
            if (attrDelta.getValuesToAdd() == null && attrDelta.getValuesToRemove() == null && attrDelta.getValuesToReplace() == null) {
                throw new IllegalArgumentException("Lists of added, removed and replaced values can not be 'null'.");
            }
            if (attrDelta.getValuesToReplace() != null || !OPERATIONAL_ATTRIBUTE_NAMES.contains(name = attrDelta.getName())) continue;
            String msg = String.format(OPERATIONAL_ATTRIBUTE_ERR, name);
            throw new IllegalArgumentException(msg);
        }
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        ObjectNormalizerFacade normalizer = this.getNormalizer(objclass);
        uid = (Uid)normalizer.normalizeAttribute((Attribute)uid);
        modifications = this.normalizeSetAttributesDelta(normalizer, modifications);
        Connector conector = this.getConnector();
        if (conector instanceof UpdateDeltaOp) {
            Set attrsDelta;
            UpdateDeltaOp deltaOp = (UpdateDeltaOp)conector;
            UpdateDeltaImpl.logDeltaOpEntry("updateDelta", objclass, uid, modifications, options);
            try {
                attrsDelta = deltaOp.updateDelta(objclass, uid, modifications, options);
            }
            catch (RuntimeException e) {
                SpiOperationLoggingUtil.logOpException(OP_LOG, UpdateDeltaOp.class, "updateDelta", e);
                throw e;
            }
            UpdateDeltaImpl.logDeltaOpExit("updateDelta", attrsDelta);
            return this.normalizeSetAttributesDelta(normalizer, attrsDelta);
        }
        if (conector instanceof UpdateAttributeValuesOp) {
            op = (UpdateOp)conector;
            UpdateAttributeValuesOp valueOp = (UpdateAttributeValuesOp)conector;
            HashSet<Attribute> valuesToRemove = new HashSet<Attribute>();
            HashSet<Attribute> valuesToAdd = new HashSet<Attribute>();
            HashSet<Attribute> valuesToReplace = new HashSet<Attribute>();
            for (AttributeDelta attrDelta : modifications) {
                if (attrDelta.getValuesToReplace() != null) {
                    valuesToReplace.add(AttributeBuilder.build((String)attrDelta.getName(), (Collection)attrDelta.getValuesToReplace()));
                    continue;
                }
                if (attrDelta.getValuesToAdd() != null) {
                    valuesToAdd.add(AttributeBuilder.build((String)attrDelta.getName(), (Collection)attrDelta.getValuesToAdd()));
                }
                if (attrDelta.getValuesToRemove() == null) continue;
                valuesToRemove.add(AttributeBuilder.build((String)attrDelta.getName(), (Collection)attrDelta.getValuesToRemove()));
            }
            Uid newUid = uid;
            if (!valuesToReplace.isEmpty()) {
                try {
                    newUid = op.update(objclass, uid, valuesToReplace, options);
                }
                catch (RuntimeException e) {
                    SpiOperationLoggingUtil.logOpException(OP_LOG, UpdateOp.class, "update", e);
                    throw e;
                }
                if (newUid == null) {
                    OP_LOG.warn("Return value from update is 'null'.", new Object[0]);
                }
            }
            if (!valuesToAdd.isEmpty() && (newUid = this.executeUpdateAttributeValues(valueOp, "addAttributeValues", objclass, newUid, valuesToAdd, options, true)) == null) {
                OP_LOG.warn("Return value from addAttributeValues is 'null'.", new Object[0]);
            }
            if (!valuesToRemove.isEmpty() && (newUid = this.executeUpdateAttributeValues(valueOp, "removeAttributeValues", objclass, newUid, valuesToRemove, options, false)) == null) {
                OP_LOG.warn("Return value from removeAttributeValues is 'null'.", new Object[0]);
            }
            HashSet<AttributeDelta> sideEffectAttributesDelta = new HashSet<AttributeDelta>();
            if (newUid != null && !uid.getUidValue().equals(newUid.getUidValue())) {
                sideEffectAttributesDelta.add(AttributeDeltaBuilder.build((String)Uid.NAME, (Object[])new Object[]{newUid.getUidValue()}));
            }
            return sideEffectAttributesDelta;
        }
        op = (UpdateOp)conector;
        if (!(this.getConnector() instanceof SearchOp)) {
            throw new UnsupportedOperationException("Connector must support: " + SearchOp.class);
        }
        OperationOptionsBuilder builder = new OperationOptionsBuilder(options);
        HashSet<String> attrNames = new HashSet<String>();
        for (AttributeDelta attributeDelta : modifications) {
            attrNames.add(attributeDelta.getName());
        }
        builder.setAttributesToGet(attrNames);
        options = builder.build();
        ConnectorObject o = this.getConnectorObject(objclass, uid, options);
        if (o == null) {
            throw new UnknownUidException(uid, objclass);
        }
        Set attrsFromSearch = o.getAttributes();
        HashSet<Attribute> attributesForUpdate = new HashSet<Attribute>();
        Map attrsFromSearchMap = AttributeUtil.toMap((Collection)attrsFromSearch);
        for (AttributeDelta attrFromModification : modifications) {
            Attribute attrForUpdate;
            String name = attrFromModification.getName();
            if (attrFromModification.getValuesToReplace() != null) {
                attributesForUpdate.add(AttributeBuilder.build((String)name, (Collection)attrFromModification.getValuesToReplace()));
                continue;
            }
            Attribute attrFromSearch = (Attribute)attrsFromSearchMap.get(name);
            if (attrFromSearch == null && attrFromModification.getValuesToAdd() != null) {
                attrForUpdate = AttributeBuilder.build((String)name, (Collection)attrFromModification.getValuesToAdd());
            } else {
                if (attrFromSearch == null) continue;
                List values = CollectionUtil.newList((Collection)attrFromSearch.getValue());
                if (attrFromModification.getValuesToAdd() != null) {
                    values.addAll(attrFromModification.getValuesToAdd());
                }
                if (attrFromModification.getValuesToRemove() != null) {
                    for (Object val : attrFromModification.getValuesToRemove()) {
                        values.remove(val);
                    }
                }
                attrForUpdate = AttributeBuilder.build((String)name, (Collection)values);
            }
            attributesForUpdate.add(attrForUpdate);
        }
        UpdateDeltaImpl.logOpEntry("update", objclass, uid, attributesForUpdate, options);
        try {
            ret = op.update(objclass, uid, attributesForUpdate, options);
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(OP_LOG, UpdateOp.class, "update", e);
            throw e;
        }
        UpdateDeltaImpl.logOpExit("update", ret);
        if (ret == null) {
            return null;
        }
        HashSet<AttributeDelta> sideEffectAttributesDelta = new HashSet<AttributeDelta>();
        if (!uid.equals((Object)ret)) {
            sideEffectAttributesDelta.add(AttributeDeltaBuilder.build((String)Uid.NAME, (Collection)ret.getValue()));
        }
        return sideEffectAttributesDelta;
    }

    private Uid executeUpdateAttributeValues(UpdateAttributeValuesOp valueOp, String method, ObjectClass objclass, Uid uid, Set<Attribute> valuesToUpdate, OperationOptions options, boolean add) {
        UpdateDeltaImpl.logOpEntry(method, objclass, uid, valuesToUpdate, options);
        Uid ret = null;
        try {
            ret = !valuesToUpdate.isEmpty() && !add ? valueOp.removeAttributeValues(objclass, uid, valuesToUpdate, options) : valueOp.addAttributeValues(objclass, uid, valuesToUpdate, options);
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(OP_LOG, UpdateOp.class, method, e);
            throw e;
        }
        UpdateDeltaImpl.logOpExit(method, ret);
        return ret;
    }

    private Set<AttributeDelta> normalizeSetAttributesDelta(ObjectNormalizerFacade normalizer, Set<AttributeDelta> attrsDelta) {
        if (attrsDelta == null) {
            return null;
        }
        HashSet<AttributeDelta> normalizeModifications = new HashSet<AttributeDelta>();
        List<Object> addValues = null;
        List<Object> removeValues = null;
        for (AttributeDelta attrDelta : attrsDelta) {
            AttributeDelta tempAttrDelta;
            if (attrDelta.getValuesToReplace() != null) {
                List<Object> replaceValues = this.normalizeListAttributesValues(normalizer, attrDelta.getName(), attrDelta.getValuesToReplace());
                tempAttrDelta = AttributeDeltaBuilder.build((String)attrDelta.getName(), replaceValues);
            } else {
                addValues = null;
                removeValues = null;
                if (attrDelta.getValuesToAdd() != null) {
                    addValues = this.normalizeListAttributesValues(normalizer, attrDelta.getName(), attrDelta.getValuesToAdd());
                }
                if (attrDelta.getValuesToRemove() != null) {
                    removeValues = this.normalizeListAttributesValues(normalizer, attrDelta.getName(), attrDelta.getValuesToRemove());
                }
                tempAttrDelta = AttributeDeltaBuilder.build((String)attrDelta.getName(), addValues, removeValues);
            }
            normalizeModifications.add(tempAttrDelta);
        }
        return Collections.unmodifiableSet(normalizeModifications);
    }

    private List<Object> normalizeListAttributesValues(ObjectNormalizerFacade normalizer, String name, List<Object> values) {
        ArrayList<Object> resultsValues = new ArrayList<Object>();
        for (Object value : values) {
            Attribute normalizeAttr = normalizer.normalizeAttribute(AttributeBuilder.build((String)name, (Object[])new Object[]{value}));
            resultsValues.add(normalizeAttr.getValue().get(0));
        }
        return resultsValues;
    }

    private ConnectorObject getConnectorObject(ObjectClass oclass, Uid uid, OperationOptions options) {
        GetImpl get = new GetImpl(new SearchImpl(this.getOperationalContext(), this.getConnector()));
        return get.getObject(oclass, uid, options);
    }

    private static void logOpEntry(String opName, ObjectClass objectClass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        if (!UpdateDeltaImpl.isLoggable()) {
            return;
        }
        StringBuilder bld = new StringBuilder();
        bld.append("Enter: ").append(opName).append("(");
        bld.append(objectClass).append(", ");
        bld.append(uid).append(", ");
        bld.append(attrs).append(", ");
        bld.append(options).append(")");
        String msg = bld.toString();
        OP_LOG.log(UpdateOp.class, opName, SpiOperationLoggingUtil.LOG_LEVEL, msg, null);
    }

    private static void logOpExit(String opName, Uid uid) {
        if (!UpdateDeltaImpl.isLoggable()) {
            return;
        }
        OP_LOG.log(UpdateOp.class, opName, SpiOperationLoggingUtil.LOG_LEVEL, "Return: " + uid, null);
    }

    private static void logDeltaOpEntry(String opName, ObjectClass objectClass, Uid uid, Set<AttributeDelta> attrsDelta, OperationOptions options) {
        if (!UpdateDeltaImpl.isLoggable()) {
            return;
        }
        StringBuilder bld = new StringBuilder();
        bld.append("Enter: ").append(opName).append("(");
        bld.append(objectClass).append(", ");
        bld.append(uid).append(", ");
        bld.append(attrsDelta).append(", ");
        bld.append(options).append(")");
        String msg = bld.toString();
        OP_LOG.log(UpdateDeltaOp.class, opName, SpiOperationLoggingUtil.LOG_LEVEL, msg, null);
    }

    private static void logDeltaOpExit(String opName, Set<AttributeDelta> attrsDelta) {
        if (!UpdateDeltaImpl.isLoggable()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Return: ").append(attrsDelta);
        OP_LOG.log(UpdateDeltaOp.class, opName, SpiOperationLoggingUtil.LOG_LEVEL, sb.toString(), null);
    }

    private static boolean isLoggable() {
        return OP_LOG.isLoggable(SpiOperationLoggingUtil.LOG_LEVEL);
    }

    static {
        OPERATIONAL_ATTRIBUTE_NAMES.addAll(OperationalAttributes.getOperationalAttributeNames());
        OPERATIONAL_ATTRIBUTE_NAMES.add(Name.NAME);
    }
}

