/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import org.identityconnectors.common.Pair;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.local.ConnectorPoolManager;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.local.ObjectPool;
import org.identityconnectors.framework.impl.api.local.operations.OperationalContext;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.PoolableConnector;

public class ConnectorOperationalContext
extends OperationalContext {
    private ConnectorPoolManager.ConnectorPoolKey connectorPoolKey;

    public ConnectorOperationalContext(LocalConnectorInfoImpl connectorInfo, APIConfigurationImpl apiConfiguration) {
        super(connectorInfo, apiConfiguration);
    }

    public ObjectPool<PoolableConnector> getPool() {
        if (this.apiConfiguration.isConnectorPoolingSupported()) {
            if (null == this.connectorPoolKey) {
                Pair<ConnectorPoolManager.ConnectorPoolKey, ObjectPool<PoolableConnector>> pool = ConnectorPoolManager.getPool(this.apiConfiguration, this.connectorInfo);
                this.connectorPoolKey = (ConnectorPoolManager.ConnectorPoolKey)pool.getKey();
                return (ObjectPool)pool.getValue();
            }
            ObjectPool pool = ConnectorPoolManager.getPool(this.connectorPoolKey);
            if (null == pool) {
                Pair<ConnectorPoolManager.ConnectorPoolKey, ObjectPool<PoolableConnector>> poolPair = ConnectorPoolManager.getPool(this.apiConfiguration, this.connectorInfo);
                this.connectorPoolKey = (ConnectorPoolManager.ConnectorPoolKey)poolPair.getKey();
                pool = (ObjectPool)poolPair.getValue();
            }
            return pool;
        }
        return null;
    }

    public Class<? extends Connector> getConnectorClass() {
        return this.getConnectorInfo().getConnectorClass();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (null != this.connectorPoolKey) {
            ConnectorPoolManager.dispose(this.connectorPoolKey);
            this.connectorPoolKey = null;
        }
    }
}

